/*
 * Ct6811.cpp                     2001/09/05
 *
 * Ctload para Windows
 *
 * Copyright (C) 2001 Javier de Lope Asian <jdlope@eui.upm.es>
 *
 *
 * ctserver.asm
 *
 * Copyright (C) 1997-2001 Microbtica S.L <info@microbotica.es>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Ct6811.h"
#include "Ctload.h"
#include "Errors.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
#define PAUSA  Sleep(2)
//---------------------------------------------------------------------------
// ctserver.asm

const unsigned char ctserver[256] = {
    0x20 , 0x05 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0xCE ,
    0x10 , 0x00 , 0x1F , 0x2E , 0x40 , 0xFC , 0x86 , 0x30 ,
    0xA7 , 0x2B , 0xCE , 0x10 , 0x00 , 0x8D , 0x66 , 0x97 ,
    0x06 , 0x81 , 0x44 , 0x27 , 0x13 , 0x81 , 0x43 , 0x27 ,
    0x54 , 0x81 , 0x41 , 0x27 , 0x17 , 0x81 , 0x42 , 0x27 ,
    0x0E , 0x81 , 0x45 , 0x27 , 0x6A , 0x7E , 0x00 , 0x12 ,
    0x86 , 0x4A , 0x8D , 0x50 , 0x7E , 0x00 , 0x12 , 0x7C ,
    0x00 , 0x06 , 0x20 , 0x03 , 0x7F , 0x00 , 0x06 , 0x8D ,
    0x4A , 0x18 , 0xDF , 0x02 , 0x8D , 0x45 , 0x18 , 0xDF ,
    0x04 , 0x18 , 0x8C , 0x00 , 0x00 , 0x27 , 0x23 , 0x18 ,
    0xDE , 0x02 , 0x96 , 0x06 , 0x4D , 0x26 , 0x07 , 0x18 ,
    0xA6 , 0x00 , 0x8D , 0x28 , 0x20 , 0x05 , 0x8D , 0x1D ,
    0x18 , 0xA7 , 0x00 , 0x18 , 0x08 , 0x18 , 0xDF , 0x02 ,
    0x18 , 0xDE , 0x04 , 0x18 , 0x09 , 0x18 , 0xDF , 0x04 ,
    0x20 , 0xD7 , 0x7E , 0x00 , 0x12 , 0x8D , 0x14 , 0x18 ,
    0xDF , 0x02 , 0x18 , 0x6E , 0x00 , 0x1F , 0x2E , 0x20 ,
    0xFC , 0xA6 , 0x2F , 0x39 , 0x1F , 0x2E , 0x80 , 0xFC ,
    0xA7 , 0x2F , 0x39 , 0x36 , 0x37 , 0x8D , 0xEE , 0x16 ,
    0x8D , 0xEB , 0x18 , 0x8F , 0x33 , 0x32 , 0x39 , 0x8D ,
    0xF2 , 0x18 , 0xDF , 0x02 , 0x8D , 0xED , 0x18 , 0xDF ,
    0x04 , 0x18 , 0x8C , 0x00 , 0x00 , 0x27 , 0x34 , 0x18 ,
    0xDE , 0x02 , 0xC6 , 0x16 , 0xF7 , 0x10 , 0x3B , 0x18 ,
    0xE7 , 0x00 , 0xC6 , 0x17 , 0xF7 , 0x10 , 0x3B , 0x8D ,
    0x28 , 0xC6 , 0x02 , 0xF7 , 0x10 , 0x3B , 0x8D , 0xBD ,
    0x8D , 0xC2 , 0x18 , 0xA7 , 0x00 , 0xC6 , 0x03 , 0xF7 ,
    0x10 , 0x3B , 0x8D , 0x15 , 0x18 , 0x08 , 0x18 , 0xDF ,
    0x02 , 0x18 , 0xDE , 0x04 , 0x18 , 0x09 , 0x18 , 0xDF ,
    0x04 , 0x20 , 0xC6 , 0x7F , 0x10 , 0x3B , 0x7E , 0x00 ,
    0x12 , 0x18 , 0x3C , 0x18 , 0xCE , 0x0D , 0x10 , 0x18 ,
    0x09 , 0x18 , 0x8C , 0x00 , 0x00 , 0x26 , 0xF8 , 0x18 ,
    0x38 , 0x39 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,
    0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 };
//---------------------------------------------------------------------------
TCT6811::TCT6811() : TComm()
{
}
//---------------------------------------------------------------------------
int TCT6811::Reset()
{
  if (hComm != NULL) {
    SendDTR();
    return 1;
  }

  if (! Open())
    return 0;

  SendDTR();
  Close();
  return 1;
}
//---------------------------------------------------------------------------
int TCT6811::Load(int addr, unsigned char *value)
{
  WriteChar('A'); PAUSA;
  WriteChar((char)(addr & 0x00FF)); PAUSA;         // addr low
  WriteChar((char)((addr >> 8) & 0x00FF)); PAUSA;  // addr high
  WriteChar(0x01); PAUSA;  // size low
  WriteChar(0x00); PAUSA;  // size high
  return ReadChar((char *)value);
}
//---------------------------------------------------------------------------
int TCT6811::Load(int addr, unsigned char *buffer, unsigned int size)
{
  int error = NO_ERROR;

  WriteChar('A'); PAUSA;
  WriteChar((char)(addr & 0x00FF)); PAUSA;         // addr low
  WriteChar((char)((addr >> 8) & 0x00FF)); PAUSA;  // addr high
  WriteChar((char)(size & 0x00FF)); PAUSA;         // size low
  WriteChar((char)((size >> 8) & 0x00FF)); PAUSA;  // size high
  for (unsigned int i = 0; (! error) && (i < size); i++)
     if (! ReadChar((char *)&buffer[i]) )
       error = NO_ECHO;
  return error;
}
//---------------------------------------------------------------------------
int TCT6811::Store(int addr, unsigned char value)
{
  WriteChar('B'); PAUSA;
  WriteChar((char)(addr & 0x00FF)); PAUSA;         // addr low
  WriteChar((char)((addr >> 8) & 0x00FF)); PAUSA;  // addr high
  WriteChar(0x01); PAUSA;  // size low
  WriteChar(0x00); PAUSA;  // size high
  return WriteChar(value);
}
//---------------------------------------------------------------------------
int TCT6811::Store(int addr, unsigned char *buffer, unsigned int size, void (*BarPos)(int))
{
  WriteChar('B'); PAUSA;
  WriteChar((char)(addr & 0x00FF)); PAUSA;         // addr low
  WriteChar((char)((addr >> 8) & 0x00FF)); PAUSA;  // addr high
  WriteChar((char)(size & 0x00FF)); PAUSA;         // size low
  WriteChar((char)((size >> 8) & 0x00FF)); PAUSA;  // size high

  for (unsigned int i = 0; i < size; i++) {
    if (! WriteChar(buffer[i]))
      return 0;
    PAUSA;
    if (BarPos != NULL)
      BarPos(1);
  }
  return 1;
}
//---------------------------------------------------------------------------
int TCT6811::StoreEEPROM(int addr, unsigned char *buffer, unsigned int size, void (*BarPos)(int))
{
  WriteChar('E'); PAUSA;
  WriteChar((char)(addr & 0x00FF)); PAUSA;         // addr low
  WriteChar((char)((addr >> 8) & 0x00FF)); PAUSA;  // addr high
  WriteChar((char)(size & 0x00FF)); PAUSA;         // size low
  WriteChar((char)((size >> 8) & 0x00FF)); PAUSA;  // size high

  for (unsigned int i = 0; i < size; i++) {
    if (! WriteCharEcho(buffer[i]))
      return 0;
    PAUSA;
    if (BarPos != NULL)
      BarPos(1);
  }
  return 1;
}
//---------------------------------------------------------------------------
int TCT6811::Alive()
{
  char c;
  WriteChar('D');
  return ReadChar(&c) && c == 'J';
}
//---------------------------------------------------------------------------
int TCT6811::Execute(int addr)
{
  WriteChar('C'); PAUSA;
  WriteChar((char)(addr & 0x00FF)); PAUSA;        // addr low
  return WriteChar((char)((addr >> 8) & 0x00FF)); // addr high
}
//---------------------------------------------------------------------------
int TCT6811::InitComm(char *port)
{
  SetPort(port);
  SetBaud(B_7680);
  if (! Reset())
    return NO_RESET;
  else {
    if (! Open())
      return NO_OPEN;
    else
      return NO_ERR;
  }
}
//---------------------------------------------------------------------------
void TCT6811::CloseComm()
{
  Close();
}
//---------------------------------------------------------------------------
int TCT6811::SendServer(void (*BarPos)(int))
{
  if (! WriteChar(0xFF))
    return NO_ANSWER;

  for (int i = 0; i < 256; i++) {
    if (! WriteCharEcho(ctserver[i]))
      return NO_ECHO;
    if (BarPos != NULL)
      BarPos(1);
  }
  return NO_ERR;
}
//---------------------------------------------------------------------------
int TCT6811::SendToRAM(FILE *fd, void (*BarPos)(int))
{
  char c, buffer[1024];
  unsigned int memopos, linepos, linelen, lineptr;
  int error = NO_ERR;

  if (! WriteChar(0xFF))
    error = NO_ANSWER;

  memopos = 0;
  fscanf(fd, "%s", buffer);
  while ((! error) && (! feof(fd)) && (buffer[1] != '9') ) {
    // Longitud de la lnea S1 incluida direccin y checksum
    linelen = 0x10 * tonum(buffer[2]) + tonum(buffer[3]);
    // Posicin de inicio de la lnea en memoria
    linepos = 0x1000 * tonum(buffer[4]) + 0x100 * tonum(buffer[5]) +
              0x0010 * tonum(buffer[6]) + tonum(buffer[7]);
    // Rellena la memoria con 0x00 hasta que se alcanza el inicio de la lnea
    while (memopos < linepos) {
      if (! WriteCharEcho(0x00)) {
        error = NO_ECHO;
        break;
      }
      memopos++;
      if (BarPos != NULL)
        BarPos(1);
    }
    if (! error) {
      // Enva la lnea
      for (lineptr = 4; lineptr <= linelen; lineptr++) {
        c = (char)(0x10 * tonum(buffer[2*lineptr]) + tonum(buffer[2*lineptr+1]));
        if (! WriteCharEcho(c)) {
          error = NO_ECHO;
          break;
        }
        memopos++;
        if (BarPos != NULL)
          BarPos(1);
      }
    }
    fscanf(fd, "%s", buffer);
  }
  if (! error) {
    // Rellena la memoria con 0x00 hasta los 256 bytes
    while (memopos < 256) {
      if (! WriteCharEcho(0x00)) {
        error = NO_ERR;
        break;
      }
      memopos++;
      if (BarPos != NULL)
        BarPos(1);
    }
  }
  return error;
}
//---------------------------------------------------------------------------
int TCT6811::SendToExt(FILE *fd, unsigned int memoini, void (*BarPos)(int))
{
  char buffer[1024];
  unsigned int  linepos, linelen, lineptr;
  unsigned char linebuf[1024];
  int error = NO_ERR;

  Store(0x103C, 0xF5);  // Pasa a modo expandido (HPRIO)

  fscanf(fd, "%s", buffer);
  while ((! error) && (! feof(fd)) && (buffer[1] != '9') ) {
    if (buffer[1] != '0') {
      // Longitud de la lnea S1 incluida direccin y checksum
      linelen = 0x10 * tonum(buffer[2]) + tonum(buffer[3]);
      // Posicin de inicio de la lnea en memoria
      linepos = 0x1000 * tonum(buffer[4]) + 0x0100 * tonum(buffer[5]) +
                0x0010 * tonum(buffer[6]) + tonum(buffer[7]);
      // Convierte la lnea de caracteres a bytes
      for (lineptr = 4; lineptr <= linelen; lineptr++)
        linebuf[lineptr-4] = (unsigned char)(0x10 * tonum(buffer[2*lineptr]) +
                                             tonum(buffer[2*lineptr+1]));
      // Enva la lnea completa
      if (! Store(linepos, linebuf, linelen-3, BarPos))
        error = NO_ECHO;
      // El servicio Store no hace comprobacin de conexin, se fuerza con Alive
      if (! Alive())
        error = NO_ECHO;
    }
    fscanf(fd, "%s", buffer);
  }
  if (! error)
    Execute(memoini);

  return error;
}
//---------------------------------------------------------------------------
int TCT6811::SendToEEPROM(FILE *fd, void (*BarPos)(int))
{
  char buffer[1024];
  unsigned int  linepos, linelen, lineptr;
  unsigned char linebuf[1024];
  int error = NO_ERR;

  fscanf(fd, "%s", buffer);
  while ((! error) && (! feof(fd)) && (buffer[1] != '9') ) {
    if (buffer[1] != '0') {
      // Longitud de la lnea S1 incluida direccin y checksum
      linelen = 0x10 * tonum(buffer[2]) + tonum(buffer[3]);
      // Posicin de inicio de la lnea en memoria
      linepos = 0x1000 * tonum(buffer[4]) + 0x0100 * tonum(buffer[5]) +
                0x0010 * tonum(buffer[6]) + tonum(buffer[7]);
      // Convierte la lnea de caracteres a bytes
      for (lineptr = 4; lineptr <= linelen; lineptr++)
        linebuf[lineptr-4] = (unsigned char)(0x10 * tonum(buffer[2*lineptr]) +
                                             tonum(buffer[2*lineptr+1]));
      // Enva la lnea completa
      if (! StoreEEPROM(linepos, linebuf, linelen-3, BarPos))
        error = NO_ECHO;
    }
    fscanf(fd, "%s", buffer);
  }

  return error;
}
//---------------------------------------------------------------------------

