/*
 * Ct294.cpp                      2001/09/05
 *
 * Ctload para Windows
 *
 * Copyright (C) 2001 Javier de Lope Asian <jdlope@eui.upm.es>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Ctload.h"
#include "Ct294.h"
#include "Main.h"
#include "Sending.h"
#include "Errors.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormCT294 *FormCT294;
//---------------------------------------------------------------------------
__fastcall TFormCT294::TFormCT294(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::FormShow(TObject *Sender)
{
  error = 0;

  FormMain->ct6811.Store(0x1026, 0x08);  // Activar puerto A (PACTL)
  FormMain->ct6811.Store(0x1039, 0x80);  // Activar conversores (OPTION)
  FormMain->ct6811.Store(0x1030, 0x10);  // Activar conversores (ADCTL)

  turno = 1;
  portA = 0x00;
  ShowData();
  Timer->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::FormHide(TObject *Sender)
{
  if (error)
    Application->MessageBox("Se ha perdido la comunicacin",
                            APPNAME, MB_OK | MB_ICONERROR);
  Timer->Enabled = false;
  FormMain->ct6811.CloseComm();
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::PA3Click(TObject *Sender)
{
  portA = (unsigned char)(portA ^ 0x08);
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::PA4Click(TObject *Sender)
{
  portA = (unsigned char)(portA ^ 0x10);
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::PA5Click(TObject *Sender)
{
  portA = (unsigned char)(portA ^ 0x20);
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::PA6Click(TObject *Sender)
{
  portA = (unsigned char)(portA ^ 0x40);
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::SPA3MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  PA3Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::SPA4MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  PA4Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::SPA5MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  PA5Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::SPA6MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  PA6Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  switch (Key) {
    case VK_ESCAPE :
               Close();
               break;
    case '3' : PA3Click(Sender);
               break;
    case '4' : PA4Click(Sender);
               break;
    case '5' : PA5Click(Sender);
               break;
    case '6' : PA6Click(Sender);
               break;
    default  : break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TFormCT294::OnTimer(TObject *Sender)
{
  WriteData();
  if (! ShowData()) {
    error = NO_ECHO;
    Timer->Enabled = false;
    Close();
  }
}
//---------------------------------------------------------------------------
int TFormCT294::WriteData()
{
  return FormMain->ct6811.Store(0x1000, portA);  // PORTA
}
//---------------------------------------------------------------------------
int TFormCT294::ShowData()
{
  char buffer[512];
  unsigned char c;
  int done;

  if (! FormMain->ct6811.Alive())
    return 0;
  if (! FormMain->ct6811.Load(0x1000, &portA))
    return 0;
  FormMain->ct6811.Load(0x100A, &portE);

  if (turno) {
    do {
      done = FormMain->ct6811.Load(0x1030, &c);  // ADCTL
    } while ( (! (c & 0x80)) && done);
    FormMain->ct6811.Load(0x1031, &ch[0], 4);  // ADR1-ADR4
    FormMain->ct6811.Store(0x1030, 0x14);      // ADCTL (baja la bandera y segundo bloque)
  }
  else {
    do {
      done = FormMain->ct6811.Load(0x1030, &c);  // ADCTL
    } while ( (! (c & 0x80)) && done);
    FormMain->ct6811.Load(0x1031, &ch[4], 4);  // ADR1-ADR4
    FormMain->ct6811.Store(0x1030, 0x10);      // ADCTL (baja la bandera y primer bloque)
  }
  turno = ! turno;

  // SPE0->Brush->Color = (portE & 0x01) ? clLime : clGreen;
  // SPE1->Brush->Color = (portE & 0x02) ? clRed : clMaroon;
  // SPE0->Brush->Color = (portE & 0x01) ? clYellow : clOlive;

  sprintf(buffer, "0x%02X", portA);
  LabelPortA->Caption = buffer;
  SPA0->Brush->Color = (portA & 0x01) ? clLime : clGreen;
  SPA1->Brush->Color = (portA & 0x02) ? clLime : clGreen;
  SPA2->Brush->Color = (portA & 0x04) ? clLime : clGreen;
  SPA3->Brush->Color = (portA & 0x08) ? clRed : clMaroon;
  SPA4->Brush->Color = (portA & 0x10) ? clRed : clMaroon;
  SPA5->Brush->Color = (portA & 0x20) ? clRed : clMaroon;
  SPA6->Brush->Color = (portA & 0x40) ? clRed : clMaroon;
  SPA7->Brush->Color = (portA & 0x80) ? clLime : clGreen;

  sprintf(buffer, "0x%02X", portE);
  LabelPortE->Caption = buffer;
  SPE0->Brush->Color = (portE & 0x01) ? clLime : clGreen;
  SPE1->Brush->Color = (portE & 0x02) ? clLime : clGreen;
  SPE2->Brush->Color = (portE & 0x04) ? clLime : clGreen;
  SPE3->Brush->Color = (portE & 0x08) ? clLime : clGreen;
  SPE4->Brush->Color = (portE & 0x10) ? clLime : clGreen;
  SPE5->Brush->Color = (portE & 0x20) ? clLime : clGreen;
  SPE6->Brush->Color = (portE & 0x40) ? clLime : clGreen;
  SPE7->Brush->Color = (portE & 0x80) ? clLime : clGreen;

  sprintf(buffer, "0x%02X", ch[0]);
  LabelCh1->Caption = buffer;
  Shape1->Width = 299 * ch[0] / 255 + 1;

  sprintf(buffer, "0x%02X", ch[1]);
  LabelCh2->Caption = buffer;
  Shape2->Width = 299 * ch[1] / 255 + 1;

  sprintf(buffer, "0x%02X", ch[2]);
  LabelCh3->Caption = buffer;
  Shape3->Width = 299 * ch[2] / 255 + 1;

  sprintf(buffer, "0x%02X", ch[3]);
  LabelCh4->Caption = buffer;
  Shape4->Width = 299 * ch[3] / 255 +1;

  sprintf(buffer, "0x%02X", ch[4]);
  LabelCh5->Caption = buffer;
  Shape5->Width = 299 * ch[4] / 255 + 1;

  sprintf(buffer, "0x%02X", ch[5]);
  LabelCh6->Caption = buffer;
  Shape6->Width = 299 * ch[5] / 255 + 1;

  sprintf(buffer, "0x%02X", ch[6]);
  LabelCh7->Caption = buffer;
  Shape7->Width = 299 * ch[6] / 255 + 1;

  sprintf(buffer, "0x%02X", ch[7]);
  LabelCh8->Caption = buffer;
  Shape8->Width = 299 * ch[7] / 255 + 1;

  return 1;
}
//---------------------------------------------------------------------------

