/*
 * Comm.h                         2001/09/05
 *
 * Ctload para Windows
 *
 * Copyright (C) 2001 Javier de Lope Asian <jdlope@eui.upm.es>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//---------------------------------------------------------------------------
#ifndef CommH
#define CommH
//---------------------------------------------------------------------------
#include <windows.h>
//---------------------------------------------------------------------------
#define P_COM1  "COM1"
#define P_COM2  "COM2"
#define P_COM3  "COM3"
#define P_COM4  "COM4"

#define B_1200  1200
#define B_7680  7680
#define B_9600  9600
//---------------------------------------------------------------------------
class TComm
{
  public:
    TComm();
    ~TComm();

    int  Open(char *port, DWORD baud);
    int  Open();
    void Close();

    void SetPort(char *port);
    void SetBaud(DWORD baud);

    void SendDTR();
    void SendBreak();

    int  BytesAvailable();
    int  WaitForBreak();

    int  ReadChar  (char *c);
    int  ReadString(char *s, DWORD maxBytes, DWORD *bytesRead);

    int  WriteChar(char c);
    int  WriteCharEcho(char c);

  protected:
    HANDLE hComm;
    COMMTIMEOUTS ctmoOld;
    char commport[5];
    DWORD baudrate;
};
//---------------------------------------------------------------------------
#endif
