/*
 * Comm.cpp                       2001/09/05
 *
 * Ctload para Windows
 *
 * Copyright (C) 2001 Javier de Lope Asian <jdlope@eui.upm.es>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Comm.h"
#include "string.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
TComm::TComm()
{
  hComm = NULL;
  strcpy(commport, P_COM1);
  baudrate = B_9600;
}
//---------------------------------------------------------------------------
TComm::~TComm()
{
  if (hComm != NULL)
    Close();
}
//---------------------------------------------------------------------------
int TComm::Open(char *port, DWORD baud)
{
  COMMTIMEOUTS ctmoNew = {0};
  DCB dcb;

  hComm = CreateFile(port, GENERIC_READ | GENERIC_WRITE, 0, NULL,
                     OPEN_EXISTING, 0, NULL);
  if (hComm == INVALID_HANDLE_VALUE) {
    hComm = NULL;
    return 0;
  }

  GetCommTimeouts(hComm, &ctmoOld);
  ctmoNew.ReadTotalTimeoutConstant = 1000;
  ctmoNew.ReadTotalTimeoutMultiplier = 0;
  ctmoNew.WriteTotalTimeoutConstant = 0;
  ctmoNew.WriteTotalTimeoutMultiplier = 0;
  SetCommTimeouts(hComm, &ctmoNew);

  SetupComm(hComm, 128, 128);

  dcb.DCBlength = sizeof(DCB);
  GetCommState(hComm, &dcb);
  // BuildCommDCB("9600,N,8,1", &dcb);
  dcb.BaudRate = baud;
  dcb.ByteSize = 8;
  dcb.Parity = NOPARITY;
  dcb.StopBits = ONESTOPBIT;
  dcb.fDtrControl = DTR_CONTROL_DISABLE;
  SetCommState(hComm, &dcb);

  return 1;
}
//---------------------------------------------------------------------------
int TComm::Open()
{
  return Open(commport, baudrate);
}
//---------------------------------------------------------------------------
void TComm::Close()
{
  PurgeComm(hComm, PURGE_RXABORT | PURGE_TXABORT);
  SetCommTimeouts(hComm, &ctmoOld),
  CloseHandle(hComm);
  hComm = NULL;
}
//---------------------------------------------------------------------------
void TComm::SetPort(char *port)
{
  if (hComm == NULL)
    strcpy(commport, port);
}
//---------------------------------------------------------------------------
void TComm::SetBaud(DWORD b)
{
  DCB dcb;
  baudrate = b;
  if (hComm != NULL) {
    dcb.DCBlength = sizeof(DCB);
    GetCommState(hComm, &dcb);
    dcb.BaudRate = baudrate;
    SetCommState(hComm, &dcb);
  }
}
//---------------------------------------------------------------------------
void TComm::SendDTR()
{
  EscapeCommFunction(hComm, SETDTR);
  Sleep(300);
  EscapeCommFunction(hComm, CLRDTR);
}
//---------------------------------------------------------------------------
void TComm::SendBreak()
{
  EscapeCommFunction(hComm, SETBREAK);
  Sleep(300);
  EscapeCommFunction(hComm, CLRBREAK);
}
//---------------------------------------------------------------------------
int TComm::BytesAvailable()
{
  COMSTAT comstat;
  DWORD errors;

  ClearCommError(hComm, &errors, &comstat);
  return comstat.cbInQue;
}
//---------------------------------------------------------------------------
int TComm::WaitForBreak()
{
  DWORD dwEvtMask;

  SetCommMask(hComm, EV_BREAK);
  WaitCommEvent(hComm, &dwEvtMask, NULL);
  SetCommMask(hComm, 0);

  return dwEvtMask & EV_BREAK;
}
//---------------------------------------------------------------------------
int TComm::ReadChar(char *c)
{
  DWORD bytesRead;

  ReadFile(hComm, c, 1, &bytesRead, NULL);
  return bytesRead == 1;
}
//---------------------------------------------------------------------------
int TComm::ReadString(char *s, DWORD maxBytes, DWORD *bytesRead)
{
  // ReadFile(hComm, s, maxBytes, bytesRead, NULL);
  ReadFile(hComm, s, 1, bytesRead, NULL);
  s[*bytesRead] = '\0';
  return bytesRead > 0;
}
//---------------------------------------------------------------------------
int TComm::WriteChar(char c)
{
  return TransmitCommChar(hComm, c);
}
//---------------------------------------------------------------------------
int TComm::WriteCharEcho(char c)
{
  char e;

  WriteChar(c);
  ReadChar(&e);
  return c == e;
}
//---------------------------------------------------------------------------
