// ctdownDlg.cpp : implementation file
//


#include "stdafx.h"
#include "ctdown.h"
#include "ctdownDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define COLARX 128
#define COLATX 128

#define CBR_7680 7680



/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCtdownDlg dialog

CCtdownDlg::CCtdownDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCtdownDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCtdownDlg)
		// NOTE: the ClassWizard will add member initialization here
		m_bHiloActivo=FALSE;
		m_ConexionEstablecida=FALSE;
		m_hDisComm = NULL;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCtdownDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCtdownDlg)
	DDX_Control(pDX, IDC_SPIN2, m_spin);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCtdownDlg, CDialog)
	//{{AFX_MSG_MAP(CCtdownDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	ON_BN_CLICKED(IDC_DTR, OnDtr)
	ON_BN_CLICKED(IDC_ENVIAR, OnEnviar)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN2, OnDeltaposSpin2)
	ON_BN_CLICKED(IDC_BAUD, OnBaud)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_EVENTO_COM,OnEventoCom)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCtdownDlg message handlers

BOOL CCtdownDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_idtr=0;
	SetDlgItemText(IDC_DTR,"DTR ON");
	SetDlgItemText(IDC_MTX,"");
	SetDlgItemText(IDC_MRX,"");

	m_ibaud=1;
	SetDlgItemText(IDC_BAUD,"7680");

	lpBuf[0]=CHAR(65);
	lpBuf[1]='\0';
	SetDlgItemText(IDC_LETRA,lpBuf);
	
	m_spin.SetRange(122,65);  // Set range for spin control
	m_spin.SetPos(65);        // Set default position for the spin, letter 'a' 

	// Start serial port COM1
	EstablecerConexion(1);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCtdownDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCtdownDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCtdownDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CCtdownDlg::OnExit() 
{
	// Finish the application
	CortarConexion(1);
	PostQuitMessage(0);
}


void CCtdownDlg::OnDtr() 
{
	// TODO: Add your control notification handler code here
	
	switch (m_idtr) {
		case 0: SetDlgItemText(IDC_DTR,"DTR OFF");
				EscapeCommFunction( m_hDisComm, CLRDTR);
				m_idtr=1;
				break;
		case 1: SetDlgItemText(IDC_DTR,"DTR ON");
				EscapeCommFunction( m_hDisComm, SETDTR);
				m_idtr=0;
				break;
	}
}

BOOL CCtdownDlg::EstablecerConexion(int m_indPuerto)
{
	char szPuerto[10];
	BOOL bExito=FALSE;
	

	// Formar la cadena "COM" mas el nmero de dispositivo
	wsprintf(szPuerto, "COM%d",m_indPuerto);

	// Cerrar el puerto si estuviera abierto
	if (m_hDisComm) CloseHandle(m_hDisComm);

	// Abrir el puerto serie
	m_hDisComm = CreateFile( szPuerto,
							 GENERIC_READ | GENERIC_WRITE,
						     0,    // acceso exclusivo
							 NULL, // sin atributos de seguridad
							 OPEN_EXISTING,
							 FILE_FLAG_OVERLAPPED,
							 NULL);

	if (m_hDisComm == INVALID_HANDLE_VALUE) {
		// Visualizar error ocurrido
		MensajeDeError( GetLastError() );
		MessageBeep( 0xFFFFFFFF );
		return FALSE;
	}

	// Especificar los eventos que sern atendidos
	SetCommMask( m_hDisComm, EV_RXCHAR | EV_TXEMPTY | EV_RX80FULL | EV_ERR);

	// Establecer el tamao de las colas de recepcin y de transmisin
	SetupComm(m_hDisComm, COLARX, COLATX);

	// Terminar las operaciones de lectura y escritura pendientes y limpiar
	// las colas Rx y Tx
	PurgeComm( m_hDisComm, PURGE_TXABORT | PURGE_RXABORT | 
				             PURGE_TXCLEAR | PURGE_RXCLEAR );

	// establecer los parmetros de la comunicacin
	bExito = ConfigurarDisCom();

	if (bExito) {
		m_ConexionEstablecida = TRUE;
	
		// Crear un hilo secundario para ver que evento ocurre
		if ( AfxBeginThread( ControlarEventos,this) == NULL ) {
			AfxMessageBox("Error: No se puede iniciar el hilo",
						   MB_OK | MB_ICONEXCLAMATION);
			m_ConexionEstablecida = FALSE;
			CloseHandle(m_hDisComm);
			return FALSE;
		}
		m_bHiloActivo=TRUE;
		
		// Enviar la seal DTR
		EscapeCommFunction(m_hDisComm, SETDTR);
	}
	else {
		AfxMessageBox("Error : No se puede configurar el dispositivo",
						MB_OK | MB_ICONEXCLAMATION);
		m_ConexionEstablecida = FALSE;
		CloseHandle(m_hDisComm);
	}
	return bExito;
}


void CCtdownDlg::MensajeDeError(DWORD nError)
{
	LPVOID lpMsg;

	// Funcin de la API que localiza el error obtenido del sistema
	// El mensaje lo deja en un buffer temporal lpMsg
	::FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		nError,
		MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT),
		( LPSTR ) &lpMsg,
		0,
		NULL );

	// Mostrar el mensaje
	AfxMessageBox( (LPCTSTR) lpMsg, MB_OK | MB_ICONEXCLAMATION );

	// Liberar el buffer
	::LocalFree( lpMsg );
}




BOOL CCtdownDlg::ConfigurarDisCom()
{
	DCB dcb;  // variable del tipo DEVICE CONTROL BLOCK

	dcb.DCBlength = sizeof (DCB);    
	GetCommState( m_hDisComm, &dcb);   // Lee la configuracin del Puerto

	//dcb.BaudRate = CBR_9600;
	dcb.BaudRate = CBR_7680;
	dcb.Parity   = NOPARITY;
	dcb.ByteSize = (BYTE) 8;
	dcb.StopBits = ONESTOPBIT;

	// Establecer el control de flujo Xon/Xoff
	dcb.fInX = dcb.fOutX = 1;
	dcb.XonChar=0x11;  // ASCII_XON
	dcb.XoffChar=0x13; // ASCII_XOFF
	dcb.XonLim  = 100;  
	dcb.XoffLim = 100;

	// Establecer el control de flujo hardware
	// Es muy importante poner DTR_CONTROL_DISABLE para que 
	// no se resetee el puerto al cambiar los baudios
		
	dcb.fOutxDsrFlow = 0;  // Control por DTR
	dcb.fDtrControl = DTR_CONTROL_DISABLE;

	dcb.fOutxCtsFlow = 0;  // CTS desactivado
	dcb.fRtsControl = RTS_CONTROL_DISABLE;

	// Otras especificaciones

	dcb.fBinary = TRUE;
	dcb.fParity = TRUE;

	if (SetCommState(m_hDisComm, &dcb) == 0) {
		// visualizar el error ocurrido
		MensajeDeError( GetLastError() );
		MessageBeep( 0XFFFFFFFF);
		return FALSE;
	}

	// Establecer los tiempo lmites para las operaciones de E/S
	COMMTIMEOUTS CommTimeOuts;

	CommTimeOuts.ReadIntervalTimeout= MAXWORD;
	CommTimeOuts.ReadTotalTimeoutMultiplier=0;
	CommTimeOuts.ReadTotalTimeoutConstant = 1000;
	
	// CBR_9600 es aproximadamente 1 byte/ms. Para nuestros propsitos permitiremos 
	// un tiempo de espera por caracter doble al necesario.
	CommTimeOuts.WriteTotalTimeoutMultiplier= 2*CBR_9600/dcb.BaudRate;
	CommTimeOuts.WriteTotalTimeoutConstant=0;

	SetCommTimeouts( m_hDisComm, &CommTimeOuts);

	return TRUE;
}



UINT ControlarEventos(LPVOID  p)
{
	DWORD dwMascEvt;
	CCtdownDlg *const pDlg = ( CCtdownDlg *) p;

	OVERLAPPED sOver= {0, 0, 0, 0, 0};

	// Crear un evento de E/S utilizado para lecturas solapadas
	sOver.hEvent = CreateEvent( NULL,   // sin seguridad
								TRUE,   // iniciacin manual
								FALSE,  // inicialmente ocupado
								NULL ); // sin nombre

	if (sOver.hEvent == NULL) {
		AfxMessageBox("Fallo al crear el evento para el hilo",
					  MB_OK | MB_ICONEXCLAMATION);
		return 0;
	}
	
	// Restablecer los eventos por si hubieran cambiado
	if (!SetCommMask( pDlg->m_hDisComm, EV_RXCHAR | EV_TXEMPTY | 
		                        EV_RX80FULL | EV_ERR ))
		return 0;

	// El hilo se ejecuta hasta que la aplicacin principal le indique que
	// debe terminar

	while (pDlg->m_ConexionEstablecida) {
		dwMascEvt=0;
		WaitCommEvent( pDlg->m_hDisComm, &dwMascEvt, &sOver);
		if (( dwMascEvt & EV_RXCHAR) == EV_RXCHAR)
			::PostMessage(pDlg->m_hWnd, WM_EVENTO_COM, EV_RXCHAR,0);
		else if ((dwMascEvt & EV_TXEMPTY) == EV_TXEMPTY)
			::PostMessage(pDlg->m_hWnd, WM_EVENTO_COM, EV_TXEMPTY,0);
		else if ((dwMascEvt & EV_RX80FULL) == EV_RX80FULL)
			::PostMessage(pDlg->m_hWnd, WM_EVENTO_COM, EV_RX80FULL,0);
		else if ((dwMascEvt & EV_ERR) == EV_ERR)
			::PostMessage(pDlg->m_hWnd, WM_EVENTO_COM, EV_ERR,0);
	}
	// Indico que el hilo se va a desactivar
	pDlg->m_bHiloActivo = FALSE;
	// liberar el manipulador del evento
	CloseHandle(sOver.hEvent);
	return 1;
}



long CCtdownDlg::OnEventoCom(UINT wParam, long lParam)
{

	// Mensajes recibidos desde el hilo
	switch (wParam) {
		case EV_RXCHAR:  LeerCar(); break;
		case EV_TXEMPTY: SetDlgItemText(IDC_MTX,"Evento TX empty");break;
		case EV_RX80FULL:SetDlgItemText(IDC_MRX,"RX buffer 80%"); break;
		case EV_ERR:     SetDlgItemText(IDC_MTX,"Error");break;
		default: SetDlgItemText(IDC_MTX,""); SetDlgItemText(IDC_MRX,""); break;
	}
	return 0;
}



BOOL CCtdownDlg::CortarConexion(int m_indPuerto)
{
	m_ConexionEstablecida=FALSE; // finaliza el hilo

	// Inhabilitar todos los eventos
	SetCommMask( m_hDisComm, 0);

	// Esperar a que el hilo finalice
	while (m_bHiloActivo);

	// Desactivar DTR
	EscapeCommFunction( m_hDisComm, CLRDTR);

	// Terminar las operaciones de lectura y escritura pendientes y
	// limpiar las colas Rx y Tx
	PurgeComm(m_hDisComm, PURGE_TXABORT | PURGE_TXCLEAR |
						  PURGE_RXABORT | PURGE_RXCLEAR );
	CloseHandle( m_hDisComm );
	m_hDisComm = NULL;

	return TRUE;
}



void CCtdownDlg::OnEnviar() 
{

	DWORD  dwWritten;

	m_sOverWrite.hEvent=CreateEvent(NULL,TRUE,FALSE,NULL);
	WriteFile(m_hDisComm, lpBuf, 1, &dwWritten, &m_sOverWrite);
	CloseHandle(m_sOverWrite.hEvent);

	SetDlgItemText(IDC_MTX,"");
	SetDlgItemText(IDC_MRX,"");

}


void CCtdownDlg::LeerCar()
{
	DWORD dwRead;
	CHAR  cadena[16];

	m_sOverRead.hEvent=CreateEvent(NULL,TRUE,FALSE,NULL);
	ReadFile(m_hDisComm, lpBuf, 1, &dwRead, &m_sOverRead);
	CloseHandle(m_sOverRead.hEvent);

	sprintf(cadena,"He recibido: %c",lpBuf[0]);
	SetDlgItemText(IDC_MRX,cadena);
}

void CCtdownDlg::OnDeltaposSpin2(NMHDR* pNMHDR, LRESULT* pResult) 
{
	static int current;
	
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;

	// TODO: Add your control notification handler code here
	current=m_spin.GetPos();
	lpBuf[0]=CHAR(current);
	SetDlgItemText(IDC_LETRA,lpBuf);

	*pResult = 0;
}

void CCtdownDlg::OnBaud() 
{
	// Para que al cambiar los baudios no cambie la linea DTR hay que
	// poner DTR_CONTROL_DISABLE en la inicializacin del puerto. Es
	// decir en ConfigurarDisCom()

	DCB dcb={0};

	GetCommState(m_hDisComm, &dcb);
	// TODO: Add your control notification handler code here
	switch (m_ibaud) {
		case 0: SetDlgItemText(IDC_BAUD,"7680");
				dcb.BaudRate=CBR_7680;
				m_ibaud=1;
				break;
		case 1: SetDlgItemText(IDC_BAUD,"9600");
				dcb.BaudRate=CBR_9600;
				m_ibaud=0;
				break;
	}
	SetCommState(m_hDisComm, &dcb);
	// limpiamos las operaciones pendientes y la cola
	PurgeComm( m_hDisComm, PURGE_TXABORT | PURGE_RXABORT | 
	     	               PURGE_TXCLEAR | PURGE_RXCLEAR );
}
