
/*
 ͻ
  GRUPO J&J. Mayo 1996.                                          
 ͹
                                                                 
  VIDEO.C                                                        
                                                                 
  Manipulacin de atributos en modo texto.                       
                                                                 
  NOTAS INTERNAS :                                               
                                                                 
   pant y cfondo son 'extern' en menus.c                         
                                                                 
 ͼ
*/

/*
  Ŀ
   VARIABLES (EXTERNAS) Y PROTOTIPOS 
  
*/

char far *pant=(char far *)0xB8000000;     // Memoria de pantalla
char cfondo=0;                             // Color del fondo.
char x=0,y=0;                              // Coordenadas del cursor

void set_pantalla(int modo);
void fondo(int color);
void lineah(int x,int y,int longitud,int color,char car,char cari,char carf);
void lineav(int x,int y,int longitud,int color,char car,char cari,char carf);
void marco(int x,int y,int anch,int alt,int color,int tipo);
void print(int x,int y,char cad[]);
void cambiar_atributos(int x,int y,int anch,int alt,int color);
void guardar_region(int x,int y,int anch,int alt,char *region);
void reponer_region(int x,int y,int anch,int alt,char *region);
int  toma_numero2(char cad[],int *nd);
int  es_numero(char car);



/*
  Ŀ
       INTERFAZ        
  
*/

/*
Ŀ
 void set_pantalla(modo)     
 int modo;                     Establecer el modo pantalla utilizado.
  modo=0 --> Monocromo.
				 modo=1 --> Color.
   Por defecto se toma la configuracin de color.
   Antes de utilizar cualquier rutina de esta librera, es necesario
   ejecutar primero esta rutina.

Ŀ
 void fondo(color)        
 int color;               

  Establecer el color del fondo. Lo siguiente que se dibuje tendr el
  fondo del color indicado.


Ŀ
 void lineav(x,y,long,color,car,cari,carf)   
 int x,y,long,color;                         

  Dibujar una linea vertical con el carcter car. La posicin inicial est
  determinada por x,y. La lnea tiene una longitud long. Se dibuja de
  "arriba hacia abajo" con el color de fondo por defecto y el color del
  primer plano especificado.
    Cari indica el carcter inicial de la lnea. Carf es el carcter final.
  Si alguno de los dos es 0 se utiliza car en su lugar.

Ŀ
 void lineah(x,y,long,color,car,cari,carf) 
 int x,y,long,color;                       

  Dibujar una linea horizontal con el carcter car. La posicin inicial est
  determinada por x,y. La lnea tiene una longitud long. Se dibuja de
  "izquierda a derecha" con el color de fondo por defecto y el color del
  primer plano especificado.
    Cari indica el carcter inicial de la lnea. Carf es el carcter final.
  Si alguno de los dos es 0 se utiliza car en su lugar.

*/



/* Ŀ
                                   
                                   
     I M P L E M E N T A C I O N   
                                   
                                   
   
*/

void set_pantalla(int modo)
/*
Ŀ
 Modo = 0 --> Monocromo. Se toma la direccin B000:0000  
 Modo = 1 --> Color.     Se toma la direccion B800:0000  
 */
{
  if (modo==0) pant=(char far *)0xB0000000;
  else pant=(char far *)0xB8000000;
  x=0;
  y=0;
  cfondo=0;
}

void fondo(int cf)
/*
Ŀ
 Establecer color del fondo   
 */
{
  cfondo=cf << 4;
}

void lineah(int x,int y,int longitud,int color,char car,char cari,char carf)
/*
Ŀ
                                                                      
  Dibujar una lnea horizontal. x,y son las coordenadas de la parte   
   izquierda de la lnea. La lnea se dibuja de izquierda a derecha.  
                                                                      
                                                                      
   car  --> Es el carcter con el que se dibuja la lnea.             
   cari --> Carcter inicial de la lnea. Si se pone  0 se tomar car. 
   carf --> Carcter final de la lnea. Si se pone a 0 se toma car.   
                                                                      
 */
{
  int i;

  if (x>80 || y>25) return;   /* Si fuera de limites no se dibuja nada */

  x--;
  y--;

  color=cfondo | color;
  for (i=x; i<(x+longitud) && i<80; i++) {
    *(pant+i*2+160*y)=car;
    *(pant+i*2+160*y+1)=color;
  }
  if (cari) {
    *(pant+x*2+160*y)=cari;
    *(pant+x*2+160*y+1)=color;
  }
  if (carf) {
     *(pant+(x+longitud-1)*2+160*y)=carf;
     *(pant+(x+longitud-1)*2+160*y+1)=color;
  }

}

void lineav(int x,int y,int longitud,int color,char car,char cari,char carf)
/*
Ŀ
                                                                      
  Dibujar una lnea vertical. x,y son las coordenadas de la parte     
   superior de la lnea. La lnea se dibuja de "arriba abajo"         
                                                                      
                                                                      
   car  --> Es el carcter con el que se dibuja la lnea.             
   cari --> Carcter inicial de la lnea. Si se pone  0 se tomar car. 
   carf --> Carcter final de la lnea. Si se pone a 0 se toma car.   
                                                                      
 */
{
  int i;

  if (x>80 || y>25) return;   /* Si fuera de limites no se dibuja nada */

  x--;
  y--;

  color=cfondo | color;
  for (i=y; i<(y+longitud) && i<25; i++) {
    *(pant+x*2+160*i)=car;
    *(pant+x*2+160*i+1)=color;
  }
  if (cari) {
    *(pant+x*2+160*y)=cari;
    *(pant+x*2+160*y+1)=color;
  }
  if (carf) {
     *(pant+x*2+160*(y+longitud-1))=carf;
     *(pant+x*2+160*(y+longitud-1)+1)=color;
  }
}

void marco(int x,int y,int anch,int alt,int color,int tipo)
/*
Ŀ
                                                                      
  Dibujar un marco situando la esquina superior izquierda en las coor-
   denadas x,y. El marco puede ser de dos tipos diferentes:           
                                                                      
     - tipo=0 --> Se dibuja un marco con lneas simples.              
     - tipo=1 --> Se dibuja un marco con lneas dobles.               
                                                                      
 */
{
 static char cmarco[2][6] = {
   {'','','','','',''},
   {'','','','','',''}
 };

 if (tipo>1) return;  /* Tipo incorrecto de marco */

 lineah(x,y,anch,color,cmarco[tipo][5],cmarco[tipo][0],cmarco[tipo][1]);
 lineah(x,y+alt-1,anch,color,cmarco[tipo][5],cmarco[tipo][2],cmarco[tipo][3]);
 lineav(x,y,alt,color,cmarco[tipo][4],cmarco[tipo][0],cmarco[tipo][2]);
 lineav(x+anch-1,y,alt,color,cmarco[tipo][4],cmarco[tipo][1],cmarco[tipo][3]);
}


int es_numero(char car)
/*
 Ŀ
  Devuelve TRUE si el carcter es un nmero  
 
*/
{
  return (car<='9' && car>='0') ? 1 : 0;
}


int toma_numero2(char cad[],int *nd)
/* Ŀ
     Tomar el siguiente nmero de 2 dgitos decimales que haya en la cadena
    cad. Se devuelve el valor entero. Si no haba ningn nmero se         
    se devuelve -1                                                         
     En nd se devuelve el nmero de dgitos que formaban el nmero, que    
    pueden ser 1  2.		                                            
   
*/
{
  if (!es_numero(cad[0])) return -1;

  if (es_numero(cad[1])) {
    *nd=2;
    return (cad[0]-'0')*10 + (cad[1]-'0');
  }
  else {
    *nd=1;
    return (cad[0]-'0');
  }
}


void print(int x,int y,char cad[])
/*
Ŀ
                                                                      
  Imprimir una cadena en las coordenadas indicadas                    
                                                                      
  Existen una serie de parmetros de control que se pueden invocar    
   desde dentro de la propia cadena a imprimir, que son :             
                                                                      
                                                                      
   /f  --> Cambiar el color del fondo. Justo a continuacin de la     
           f se debe especificar un nmero entre 0-7.                 
   /c  --> Cambiar el color de las letras. El nmero esperado debe    
           estar comprendido en el intervalo 0-15                     
                                                                      
   Ejemplo:  print(1,1,"/f4/c15 Un color. /f1/c11 otro color");       
                                                                      
                                                                      
 */
{
  int xini;
  int tinta=7;
  int color;
  int i=0;
  int nd;

  x--;
  y--;
  color=cfondo | tinta;

  while (cad[i]) {
    if (cad[i]!='/') {
      if (x<79) {
	*(pant+x*2+160*y)=cad[i];
	*(pant+x*2+160*y+1)=color;
	x++;
	i++;
      }
      else return;   /**********/

    }
    else {
      switch(cad[++i]) {
	case 'f' : i++;
		   cfondo=toma_numero2(&cad[i],&nd);
		   if (cfondo!=-1) {
                     color=color & 0x0F;
		     color=(cfondo<<4) | tinta;
		     i=i+nd;
		   }
		   break;
	case 'c' : i++;
		   tinta=toma_numero2(&cad[i],&nd);
		   if (tinta!=-1) {
                     color=color & 0xF0;
		     color=color | tinta;
		     i=i+nd;
		   }
		   break;
      }
    }
  }
}


void cambiar_atributos(int x,int y,int anch,int alt,int color)
/*
Ŀ
                                                                      
  Cambiar atributos de una zona de la pantalla delimitada por las     
   coordenadas x,y,alt,anch.                                          
                                                                      
                                                                      
  Segn el color empleado se pueden lograr diferentes "efectos", como 
  por ejemplo borrar una zona de la pantalla, cambiar el color etc..  
                                                                      
 */
{
  int i,j;
  char far *temp;

  temp=pant + 2*(x-1) + 160*(y-1) + 1;
  for (j=0; j<alt; j++) {
    for (i=0; i<anch; i++) {
      *temp=color;
      temp+=2;
    }
    temp+=160-anch*2;
  }
}

void guardar_region(int x,int y,int anch,int alt,char *region)
/*
Ŀ
                                                                      
  Almacenar la regin especificada en la zona de memoria apuntada por 
  el puntero regin.                                                  
                                                                      
    Regin debe apuntar a una zona de memoria que debe tener por lo   
  menos alt*anch*2 bytes libres.                                      
                                                                      
 */
{
  int i,j,k;
  char far *temp;

  temp=pant + 2*(x-1) + 160*(y-1);
  for (j=0; j<alt; j++) {
    for (i=0; i<anch; i++) {
      k=anch*2*j+2*i;
      region[k]=*temp;
      region[k+1]=*(temp+1);
      temp+=2;
    }
    temp+=160-anch*2;
  }
}


void reponer_region(int x,int y,int anch,int alt,char *region)
/*
Ŀ
                                                                      
  Situar la regin especificada en la zona de la pantalla indicada    
                                                                      
 */
{
  int i,j,k;
  char far *temp;

  temp=pant + 2*(x-1) + 160*(y-1);
  for (j=0; j<alt; j++) {
    for (i=0; i<anch; i++) {
      k=anch*2*j+2*i;
      *temp=region[k];
      *(temp+1)=region[k+1];
      temp+=2;
    }
    temp+=160-anch*2;
  }
}

/*************************************************************************/
