/*
ͻ
  GRUPO J&J.          	                        					        
Ķ
                                                                          
 TOWERBOOT.CPP   The software for the machines of the future.             
                                                                          
                                                           
                                                                           
                                                                           
ͼ
*/

#include "dos.h"
#include "jj.h"
#include "cfgmenus.h"
#include <process.h>
#include <conio.h>
#include <stdio.h>


#define XCOM  60
#define XBAUD 70
#define XDTR  52

/* Ŀ
    VARIABLES GLOBALES  
   
*/

// variables en MENUS.C, inicializadas all

extern struct TIPO_VENTANA vent[NUMVENT];  // Array de ventanas
extern int a;                              // Indice de ventana activa

// vars de TMCBOOT2.C
//extern int err;

static int dtr=1;
extern int oldbaud;

// vars de TFINDA.C

char lista[30][13];


int eleccion=1;         // por defecto, eleccion = la 1 del men
int puerto=1;           // Puerto por defecto = COM1
int baud=9600;          // Baudios por defecto = 9600
int terminal=OFF;       // Indicador de terminal abierto o cerrado



/* Ŀ
     P R O T O T I P O S     
   
*/

// de VIDEO.C
void set_pantalla(int modo);
void fondo(int color);
void lineah(int x,int y,int longitud,int color,char car,char cari,char carf);
void marco(int x,int y,int anch,int alt,int color,int tipo);
void print(int x,int y,char cad[]);
void cambiar_atributos(int x,int y,int anch,int alt,int color);
void guardar_region(int x,int y,int anch,int alt,char *region);
void reponer_region(int x,int y,int anch,int alt,char *region);


// de MENUS.C
int abre(int x,int y,int longx,int longy,int color,int tipomarco,int sombra);
int cierra(void);
int cierra_todo(void);
void pantalla_cursor(int color);
int escribe_vent_menu(struct TIPO_VENTANA *ventana);
int escribe_vent(struct TIPO_VENTANA *ventana,int x0,int y0,int col,int colf,
		 char cadena[]);

int agregar_opcion(struct TIPO_VENTANA *ventana,char cad[]);
void situa_menu(struct TIPO_VENTANA *ventana,int x,int y);
void separacion_menu(struct TIPO_VENTANA *ventana,int incx,int incy);
void color_menu(struct TIPO_VENTANA *ventana,int colbarra,int colletra);

int agregar_opcion_horiz(struct TIPO_VENTANA *ventana,char cad[]);
int activar_opcion_vert(struct TIPO_VENTANA *ventana,int k,int col,int colf);
int activar_opcion_horiz(struct TIPO_VENTANA *ventana,int k,int col,int colf);
int menu_vertical(struct TIPO_VENTANA *ventana);
int menu_horizontal(struct TIPO_VENTANA *ventana,int eleccion);


// de SERIE.C
void baudios(int baud);
void configurar_puerto(int com);
int  car_waiting();
char leer_car();
void enviar (char car);
void activar_dtr();
void desactivar_dtr();
void cerrar_puerto_serie();
/*
void interrupt serie()
int listo_enviar()
void enviar_cad(cad,nbytes,punto)
int okbreak()
int wait_break()
void vaciar_buffer()
void eco(b)
void enviar_cad_eco(cad,nbytes,punto)
*/

// de DOWNLCA.C
void Down(void);

// de RBT2ASM.C
void Rbt2Asm(void);

// de TFINDA.C
int busca(char nombre[13]);

// de TMCBOOT2.C
int modo_boot();
int modo_expanded();



/*
ͻ
                                                                           
			I M P L E M E N T A C I O N                         
                                                                           
ͼ
*/


/* Ŀ
   VENTANA RESERVADA (ERRORES Y MENSAJES) 
   
*/


void cierra_vent_menos1()
/*
 Ŀ
 Cierra la ventana menos1 reservada para mensajes
 internos del tower-boot y libera la memoria ocu-
 pada por ella.                                  
 
*/
{
 reponer_region(vent[-1].x,vent[-1].y,(vent[-1].anch)+ASH,(vent[-1].alt)+ASV,
		vent[-1].debajo);
 free(vent[-1].debajo);
}


void abre_vent_menos1(int x,int y,int anch,int alt,int colvent,int colmarco)
/*
 Ŀ
  La ventana menos1 est reservada para los mensajes
  El usuario no puede acceder a ella.               
 
*/
{
 //variable global vent.
 vent[-1].x=x;
 vent[-1].y=y;
 vent[-1].anch=anch;
 vent[-1].alt=alt;

 //reserva memoria
 // para C++
 //vent[-1].debajo=new char[((vent[-1].anch)+ASH)*((vent[-1].alt)+ASV)*2];
 // para Cpp
 vent[-1].debajo=(char * )malloc(((vent[-1].anch)+ASH)*((vent[-1].alt)+ASV)*2);

 //creacion ventana
 guardar_region(vent[-1].x,vent[-1].y,(vent[-1].anch)+ASH,(vent[-1].alt)+ASV,
		vent[-1].debajo);
 cambiar_atributos(vent[-1].x,vent[-1].y,vent[-1].anch,vent[-1].alt,colvent);

 //marco
 fondo(colvent);                   // color del fondo del marco
 marco(vent[-1].x,vent[-1].y,vent[-1].anch,vent[-1].alt,colmarco,0);

 //sombras
 cambiar_atributos((vent[-1].x)+ASH,vent[-1].y+vent[-1].alt,vent[-1].anch,ASV,
		    PENUMBRA);
 cambiar_atributos(vent[-1].x+vent[-1].anch,(vent[-1].y)+ASV,ASH,vent[-1].alt,
		   PENUMBRA);
 
}



void abre_vent_error()
/*
 Ŀ
  La ventana menos1 est reservada para los mensajes
  El usuario no puede acceder a ella.               
  En este caso,se utiliza para los mensajes de error
 
*/
{
 abre_vent_menos1(22,11,38,6,COL_VENT_ERROR,CLM_ERROR);
 lineah((vent[-1].x)+1,(vent[-1].y)+(vent[-1].alt)-3,(vent[-1].anch)-2,
	 0,'',0,0);
 print((vent[-1].x)+2,(vent[-1].y)+(vent[-1].alt)-2,"/c7 Pulsar 'ESC' ");
}


void abre_vent_mens()
/*
 Ŀ
  La ventana menos1 est reservada para los mensajes
  El usuario no puede acceder a ella.               
  En este caso, se utiliza para imprimir distintos  
  mensajes (creditos..).                            
 
*/
{
 abre_vent_menos1(22,6,30,12,COL_VENT_MENS,CLM_MENS);
 lineah((vent[-1].x)+1,(vent[-1].y)+(vent[-1].alt)-3,(vent[-1].anch)-2,
	 7,'',0,0);
 print((vent[-1].x)+2,(vent[-1].y)+(vent[-1].alt)-2,"/c7 Pulsar 'ESC' ");
}


void cierra_vent_error_mens()
/*
 Ŀ
 Cierra la ventana menos1 reservada para mensajes
 internos del tower-boot y libera la memoria ocu-
 pada por ella.                                  
 
*/

{
 char tecla;
 do                      // Evitar error con teclas especiales de 2 car
 {
  tecla=getch();
 }
 while (tecla!=ESC);     // 'esc' para cerrar vent menos1

 cierra_vent_menos1();
 return;
}


/* Ŀ
    MENSAJES POR PANTALLA    
   
*/

void error_tow(int k)
/* Ŀ
    Imprime distintos mensajes de error detectados en 
   distintos puntos del programa. Para ello:          
    -Abre la ventana menos1 reservada para estos casos
    -Imprime el mensaje q corresponde al parmetro 'k'
    -Cierra la vent menos1 y libera la memoria ocupada
   
*/
{
 abre_vent_error();

 switch(k)
  {
   case 1:print((vent[-1].x)+2,(vent[-1].y)+1,"/c15 No se pueden abrir ms ventanas");
	  break;
   case 2:print((vent[-1].x)+2,(vent[-1].y)+1,"/c15 No hay ninguna ventana abierta");
	  print((vent[-1].x)+3,(vent[-1].y)+2,"/c15para cerrar");
	  break;
   case 3:print((vent[-1].x)+2,(vent[-1].y)+1,"/c15 No hay ninguna ventana abierta");
	  print((vent[-1].x)+3,(vent[-1].y)+2,"/c15para escribir en ella");
	  break;
   case 4:print((vent[-1].x)+2,(vent[-1].y)+1,"/c15 No se pueden aadir ms opciones");
	  print((vent[-1].x)+3,(vent[-1].y)+2,"/c15al men");
	  break;
   case 5:print((vent[-1].x)+2,(vent[-1].y)+1,"/c7 Error: ");
	  print((vent[-1].x)+2,(vent[-1].y)+2,"/c0 El terminal ya est abierto");
	  break;
   case 6:print((vent[-1].x)+2,(vent[-1].y)+1,"/c7 Error: ");
	  print((vent[-1].x)+2,(vent[-1].y)+2,"/c0 El terminal ya est cerrado");
	  break;

   default:break;
  }
  cierra_vent_error_mens();
}


void mensaje_creditos()
/* Ŀ
    Imprimir en pantalla a los genios 
    */
{
 print((vent[-1].x)+7,(vent[-1].y)+1 ,"/c10   MICROBOTICA       ");
 print((vent[-1].x)+3,(vent[-1].y)+3 ,"/c11 Juan Gonzlez Gmez ");
 print((vent[-1].x)+3,(vent[-1].y)+4 ,"/c11 Cristina Doblado    ");
 print((vent[-1].x)+3,(vent[-1].y)+5 ,"/c11 Andrs Prieto-Moreno");
 print((vent[-1].x)+3,(vent[-1].y)+6 ,"/c11 Juan Jos San Martn");
 print((vent[-1].x)+3,(vent[-1].y)+7 ,"/c11 Santiago San Martn");
}


void display_baud(int baud)
/* Ŀ
    Imprimir en pantalla la velocidad indicada 
    */
{
  switch(baud) {   
    case 1200 : print (XBAUD,1,"/f1/c111200"); break;
    case 7680 : print (XBAUD,1,"/f1/c117680"); break;
    case 9600 : print (XBAUD,1,"/f1/c119600"); break;
  }
}

void display_com(int com)
/* Ŀ
    Imprimir en pantalla el puerto indicado   
    */
{
  switch(com) {
    case 1 : print(XCOM,1,"/f1/c11  COM1"); break;
    case 2 : print(XCOM,1,"/f1/c11  COM2"); break;
    case 3 : print(XCOM,1,"/f1/c11  COM3"); break;
    case 4 : print(XCOM,1,"/f1/c11  COM4"); break;
  }
}

void display_dtr(int dtr)
/* Ŀ
    Imprimir en pantalla el estado del dtr    
    */
{
  switch(dtr) {
    case 0 : print(XDTR,1,"/f1/c11DTR OFF"); break;
    case 1 : print(XDTR,1,"/f1/c11DTR ON "); break;
  }
}



/* Ŀ
    DISEO DE LOS MENUS (PRINCIPAL Y SECUNDARIOS)     
    */


void menu()
/* Ŀ
    Definicin de las partes fijas de la pantalla de  
   presentacin.                                      
   
*/
{
 unsigned short int x0=5;

 clrscr();
 set_pantalla(1);             // Pantalla color (no monocroma)
 pantalla_cursor(0x11);       // Color fondo pantalla y cursor

 fondo(1);                    // Color fondo del marco
 marco(2,2,78,19,0xF,1);      // Dibujo del marco
 lineah(3,4,76,0xF,'',0,0);

 print(2,1,"/f1/c10 TOWER-BOOT 3.1  /c14 GRUPO J&J.  MICROBOTICA");
 display_com(puerto);
 display_baud(baud);
 display_dtr(dtr);

 fondo(1);                    // Color fondo del marco
 marco(2,21,78,5,0xF,0);      // Dibujo del marco

 print(x0   ,22,"/f1/c15F1-/c11Menu Mcu  ");
 print(x0   ,23,"/f1/c15F2-/c11Menu Fpga ");
 print(x0   ,24,"/f1/c15F3-/c11Menu Utl  ");

 print(x0+14,23,"/f1/c15F4-/c11Menu Tx       ");
 print(x0+14,24,"/f1/c15F5-/c11Limpiar term  ");

 print(x0+31,22,"/f1/c15F6-/c11Canal I       ");
 print(x0+31,23,"/f1/c15F7-/c11Canal II      ");
 print(x0+31,24,"/f1/c15F8-/c11Canal III     ");

 print(x0+45,23,"/f1/c15F9--/c11DTR ON-OFF");
 print(x0+45,24,"/f1/c15F10-/c11COM 1-2  ");

 print(x0+61,23,"/f1/c15ALTA-/c11Autores");
 print(x0+61,24,"/f1/c15ALTX-/c11SALIR  ");

}


void define_menu_ppal()
/*Ŀ
   Definimos el men principal (horizontal) del TOWER BOOT en la ventana 0 
  
*/
{  //  En la ventana privada 0 definimos el men principal

  agregar_opcion_horiz(&vent[0],"/f0/c12     Mcu     ");
  agregar_opcion_horiz(&vent[0],"/f0/c13     Fpga    ");
  agregar_opcion_horiz(&vent[0],"/f0/c14     Utl     ");
  agregar_opcion_horiz(&vent[0],"/f0/c10     Tx      ");

  situa_menu(&vent[0],5,2);
  separacion_menu(&vent[0],6,0); // Men horiz para el men ppal
  color_menu(&vent[0],COLOR_BARRAH,COLOR_LETRAH);
}




int modo_terminal(int color)
/*
Ŀ
 Borra slo la parte del terminal (ventana
de texto abierta con 'window'.            
 Se recupera llamando a cerrar_terminal   

*/
{
 int i;

 for (i=a; i>0; i--) {  // cerramos las ventanas abiertas
  cierra();
 }

 if (terminal==ON) return 0;

 window(3,5,78,19);
 textcolor(7);
 textbackground(color);
 clrscr();
 terminal=ON;
 return 1;
}


int cerrar_terminal()
/*
Ŀ
 Para cerrar una 'window' pequea abrimos 
una 'window' que abarca toda la pantalla y
volvemos a escribir el men principal de  
towerboot, poniendo en OFF la variable    
global 'terminal'.                        

*/
{
 if (terminal==OFF) return 0;

 window(1,1,80,25);  // para que se cierre la window del terminal
 menu();
 define_menu_ppal();
 escribe_vent_menu(&vent[0]);
 terminal=OFF;
 return 1;
}


void borrar_pantalla()
/*
Ŀ
 Borra toda la pantalla                   
 Si est en modo terminal, se borra slo  
el terminal puesto que ya se ha llamado a 
'window'                                  
 Se recupera llamando a restaurar_towboot:
(ver nota importante en restaurar_towboot)

*/
{
 int i;

 for (i=a; i>0; i--) {  // cerramos las ventanas abiertas
  cierra();
 }
 clrscr();
}


void restaurar_towboot()
/*
Ŀ
 Restaura el men principal de towerboot, 
en caso de que se haya borrado la pantalla
 IMPORTANTE : despus de llamarlo hay que 
poner 'return' si se est dentro de un    
bucle que llama a menu_horiz pq se pierde 

*/
{
 menu();
 define_menu_ppal();
 escribe_vent_menu(&vent[0]);

 if (terminal==ON) {   // si el terminal estaba abierto cuando borramos la
  textbackground(0);   // pantalla, lo restauramos en negro
  clrscr();
 }
}


int enter_tow()
/*
Ŀ
 Aumenta una linea el cursor dentro de la 
ventana del terminal para hacer el efecto 
de un retorno de carro (muy utilizado en  
el mcboot p.ej. para probar Gaia).        
                                          

*/
{
 int x,y;

 x=wherex();
 y=wherey();
 gotoxy(x,y+1);
 return y;
}

int avanza_cursor()
/*
Ŀ
 Aumenta una posicin el cursor dentro de 
la vent del terminal.                     

*/
{
 int x,y;

 x=wherex();
 y=wherey();
 gotoxy(x+1,y);
 return x;
}


void prueba()
/*************/  /*** no va ***/
{
 int x=5,y=6;
 char c;

 do{
 c=getch();
 x=avanza_cursor();
 y=wherey();
 if (x>=8) {
  x=0;
  y=y+1;
 }
 print(x,y,"/c12*");
 delay(4);
 }while (c!=ESC);
}


/*

   Ŀ
    PROCESADO DE LAS OPCIONES Y DE LOS MENUS  
   


*/


int menu_mcu()
/*Ŀ
   Menu del micro del TOWER BOOT.  
   */
{
  int archivo=0;
  int puls;
  char *nombre;
  int eleccion;
  char nom[15];

  if (abre(6,5,15,6,0x4F,1,1)==0)  error_tow(1);
  if(agregar_opcion(&vent[a],"/f4/c15 Downmcu     ")==0) error_tow(4);
  if(agregar_opcion(&vent[a],"/f4/c15 CTdialog    ")==0) error_tow(4);
  if(agregar_opcion(&vent[a],"/f4/c15 CT294       ")==0) error_tow(4);
  if(agregar_opcion(&vent[a],"/f4/c15 Mcboot2     ")==0) error_tow(4);


  //OPCIONAL
  color_menu(&vent[a],COLOR_BARRA,COLOR_LETRA);

  if (escribe_vent_menu(&vent[a])==0) error_tow(3);

  while((eleccion=menu_vertical(&vent[a]))!=-1) {

    switch(eleccion)
     {
      case 1: //DOWNMCU archivo [-com2]
	      
	      cierra();
	      if (terminal==1) clrscr();
	      abre(9,14,34,3,0x50,0,1);
	      escribe_vent(&vent[a],2,1,15,5,"Nombre archivo: *.s19 ");
	      gotoxy(25,11);       // situamos el cursor en la ventana
	      nombre=NULL;
	      strcpy(nom,"0000000000000");
	      nom[0]=13;                   // para que limite a 13 car.
	      nombre=cgets(nom);
	      gotoxy(1,1);                 // 'ocultar' cursor
	      if (nom[1]==0) {       // ningun car. leido (ENTER)
		if((archivo=busca("*.s19"))!=0) {
		  escribe_vent(&vent[a],18,1,15,5,lista[archivo]);
		  nombre=lista[archivo];
		 }
	      }
	      else if (nom[2]=='\x1B') {  // ESCAPE
		cierra();
		gotoxy(1,1);
		return 1;
	      }

	      cierra();
	      clrscr();
	      system("cls");

	      // %%%%
	      //cerrar_puerto_serie();       // quitar interrupciones

	      if (puerto==2) {
	       spawnlpe(P_WAIT,"downmcu.exe","downmcu.exe",nombre,"-com2",NULL);
	       getch();    // %%%%
	      }
	      else if (puerto==1) {
	       spawnlpe(P_WAIT,"downmcu.exe","downmcu.exe",nombre,NULL);
	       getch();      // %%%%
	      }

	      clrscr();
	      restaurar_towboot();


	      // %%%%
	      /*
	      // Volvemos a abrir puerto_serie
	      configurar_puerto(puerto);
	      baudios(baud);
	      display_dtr(dtr);
	      */

	      return 1;


      case 2: // ctdialog

	      // %%%%
	      cerrar_puerto_serie();       // quitar interrupciones

	      cierra();
	      if (terminal==1) clrscr();

	      system("cls");
	      if (puerto==2) {
	       spawnlpe(P_WAIT,"downmcu.exe","downmcu.exe","ctserver.s19",
	       "-com2",NULL);
	       spawnlpe(P_WAIT,"ctdialog.exe","ctdialog.exe","-com2",NULL);
	      }
	      else if (puerto==1) {
	       spawnlpe(P_WAIT,"downmcu.exe","downmcu.exe","ctserver.s19",NULL);
	       spawnlpe(P_WAIT,"ctdialog.exe","ctdialog.exe",NULL);
	      }
	      clrscr();
	      restaurar_towboot();


	      // Volvemos a abrir puerto_serie
	      configurar_puerto(puerto);
	      baudios(baud);
	      display_dtr(dtr);

	      return 1;

	  case 3: // CT294
	      cierra();
	      if (terminal==1) clrscr();

	      system("cls");
	      if (puerto==2) {
		   spawnlpe(P_WAIT,"ct294.exe","ct294.exe","-2",NULL);
		   getch();
		  }
		  else if (puerto==1) {
		   spawnlpe(P_WAIT,"ct294.exe","ct294.exe","-1",NULL);
		   getch();
		  }
		  clrscr();
		  restaurar_towboot();
		  return 1;


      case 4: // Mcboot2

	      // %%%%
	      //cerrar_puerto_serie();       // quitar interrupciones

	      cierra();
	      if (terminal==1) clrscr();

	      system("cls");
	      system("mcboot2");

	      clrscr();
	      restaurar_towboot();

	      // %%%%
	      /*
	      // Volvemos a abrir puerto_serie
	      configurar_puerto(puerto);
	      baudios(baud);
	      display_dtr(dtr);
	      */

	      return 1;


      case -2: cierra();
	       return -2;
      case -3: cierra();
	       return -3;
      default:  //apaga la opcion elegida (iluminada la 1 por defecto)
		activar_opcion_vert(&vent[a],eleccion,0,0);
		break;
     }

   if (hay_error()) {
       display_error();  // Si hay error imprimirlo
      }
  }
  cierra();
  return -1;
}




menu_mod_fpga()
/*Ŀ
   Menu de los modelos de la  FPGA 
   */
{
  int eleccion;

  if (abre(18,10,14,5,0x4F,1,1)==0)  error_tow(1);
  agregar_opcion(&vent[a],"/f4/c15 LCA 3020       ");
  agregar_opcion(&vent[a],"/f4/c15 LCA 3030       ");
  agregar_opcion(&vent[a],"/f4/c15 LCA 3040       ");
  if (escribe_vent_menu(&vent[a])==0) error_tow(3);

  while((eleccion=menu_vertical(&vent[a]))!=-1) {
    switch(eleccion)
     {
      case 1 : // 3020
	       cierra();
	       print (45,1,"/f1/c113020");
	       return 1;

      case 2 : // 3030
	       cierra();
	       print (45,1,"/f1/c113030");
	       return 1;

      case 3 : // 3040
	       cierra();
	       print (45,1,"/f1/c113040");
	       return 1;

      case -2: cierra();
	       return -2;

      case -3: cierra();
	       return -3;

      default: activar_opcion_vert(&vent[a],eleccion,0,0);
	       break;
     }
   }
  cierra();
  return -1;
}


int menu_fpga()
/*Ŀ
   Menu de la FPGA del TOWER BOOT. 
   */
{
  int eleccion;

  if (abre(25,5,14,8,0x4F,1,1)==0)  error_tow(1);

  agregar_opcion(&vent[a],"/f4/c07 Rbt2Asm    ");
  agregar_opcion(&vent[a],"/f4/c07 Test       ");
  agregar_opcion(&vent[a],"/f4/c07 Downlca   ");
  agregar_opcion(&vent[a],"/f4/c07 Downspi    ");
  agregar_opcion(&vent[a],"/f4/c15 Modelo    ");
  agregar_opcion(&vent[a],"/f4/c07 Cargar fichero");
  

  if (escribe_vent_menu(&vent[a])==0) error_tow(3);

  while((eleccion=menu_vertical(&vent[a]))!=-1) {
    switch(eleccion)
     {
      case  1: // RBT2ASM
	       //cierra();
	       //system("rbt2asm.exe");
	       //return 1;
	       break;

      case  3: //Downlca
	       //cierra();
	       //Down();
	       //getch();
	       //clrscr();
	       //return 1;
	       break;


      case  5: menu_mod_fpga();
	       break;

      case -2: cierra();
	       return -2;
      case -3: cierra();
	       return -3;
      default: activar_opcion_vert(&vent[a],eleccion,0,0);
	       break;
     }
   activar_opcion_vert(&vent[a],eleccion,0,0);
   }
  cierra();
  return -1;
}


int menu_canales()
/*Ŀ
   Menu de los canales del TOWER BOOT.  
   */
{
  int eleccion;

  if (abre(40,7,14,5,0x4F,1,1)==0)  error_tow(1);
  agregar_opcion(&vent[a],"/f4/c15 Canal I        ");
  agregar_opcion(&vent[a],"/f4/c15 Canal II       ");
  agregar_opcion(&vent[a],"/f4/c15 Canal III      ");
  if (escribe_vent_menu(&vent[a])==0) error_tow(3);

  while((eleccion=menu_vertical(&vent[a]))!=-1) {
    switch(eleccion)
     {
      case 1 : // Canal1
	       cierra();
	       cierra();
	       system("cls");
	       system("canal1.bat");
	       restaurar_towboot();
	       return 1;

      case 2 : // Canal2
	       cierra();
	       cierra();
	       system("cls");
	       system("canal2.bat");
	       restaurar_towboot();
	       return 1;

      case 3 : // Canal3
	       cierra();
	       cierra();
	       system("cls");
	       system("canal3.bat");
	       restaurar_towboot();
	       return 1;

      case -2: cierra();
	       return -2;

      case -3: cierra();
	       return -3;

      default: activar_opcion_vert(&vent[a],eleccion,0,0);
	       break;
     }
   }
  cierra();
  return -1;
}



int menu_mem()
/*Ŀ
   Menu de las UTL del TOWER BOOT. 
   */
{
  int eleccion;
  char *nombre;
  char nom[15];
  int archivo=0;

  nom[0]=13;  // Max num de caracteres que lee

  if (abre(44,5,14,6,0x4F,1,1)==0)  error_tow(1);
  agregar_opcion(&vent[a],"/f4/c15 Canales        ");
  agregar_opcion(&vent[a],"/f4/c15 Buscar         ");
  agregar_opcion(&vent[a],"/f4/c15 Editor         ");
  agregar_opcion(&vent[a],"/f4/c15 As11           ");
  if (escribe_vent_menu(&vent[a])==0) error_tow(3);

  while((eleccion=menu_vertical(&vent[a]))!=-1) {
    switch(eleccion)
     {
      case  1: // Canales
	       menu_canales();
	       cierra();
	       return 1;

      case 2 : // Buscar archivos
	       cierra();
	       if (terminal==1) clrscr();
	       abre(9,16,34,3,0x50,0,1);
	       escribe_vent(&vent[a],2,1,15,5,"Buscar archivo: *.* ");
	       gotoxy(25,13);       // situamos el cursor en la ventana
	       nombre=NULL;
	       strcpy(nom,"0000000000000");
	       nom[0]=13;  // Max num de caracteres que lee
	       nombre=cgets(nom);	       
	       gotoxy(1,1);
	       if (nom[1]==0) busca("*.*");  // ningun car leido
	       else busca(nombre);
	       cierra();
	       /*
	       if((archivo=busca(nombre))!=0)
	       {
		abre(21,9,34,3,0x64,1,1);
		escribe_vent(&vent[a],2,1,15,4,lista[archivo]);
		getch();
		cierra();
	       }
	       */
	       restaurar_towboot();
	       return 1;             /*' '->1*/

      case  3: // editor
	       cierra();
	       system("edit");
	       return 1;

      case  4: // AS11
	       cierra();
	       if (terminal==1) clrscr();
	       abre(9,15,34,3,0x50,0,1);
	       escribe_vent(&vent[a],2,1,15,5,"Compilar archivo: *.asm ");
	       gotoxy(27,12);       // situamos el cursor en la ventana
	       nombre=NULL;
	       strcpy(nom,"0000000000000");
	       nom[0]=13;  // Max num de caracteres que lee
	       nombre=cgets(nom);
	       gotoxy(1,1);       // 'ocultar' cursor
	       //cierra();
	       if (nom[1]==0) {       // ningun car. leido (ENTER)
		if((archivo=busca("*.asm"))!=0) {
		  cierra();
		  cierra();
		  system("cls");
		  spawnlpe(P_WAIT,"as11.exe","as11.exe",lista[archivo],NULL);
		 }
	       }
	       else if (nom[2]=='\x1B') {  // ESCAPE
		cierra();
		cierra();
		clrscr();
	       }
	       else {
		cierra();
		cierra();
                system("cls");
		gotoxy(1,2);
		spawnlpe(P_WAIT,"as11.exe","as11.exe",nombre,NULL);
	       }
	       getch();
	       restaurar_towboot();
	       return 1;

      case -2: cierra();
	       return -2;

      case -3: cierra();
	       return -3;

      default: activar_opcion_vert(&vent[a],eleccion,0,0);
	       break;
     }
   }
  cierra();
  return -1;
}




void cambiar_baudios()
/*Ŀ
   Menu de cambio de baudios ,que es submenu de menu_tx 
   */
{
  int eleccion;

  if (abre(60,7,8,5,0x4F,1,1)==0) error_tow(1);   // Abrir ventana baudios
  agregar_opcion(&vent[a],"/f4/c15 1200     ");
  agregar_opcion(&vent[a],"/f4/c15 7680     ");
  agregar_opcion(&vent[a],"/f4/c15 9600     ");
  escribe_vent_menu(&vent[a]);
  eleccion=menu_vertical(&vent[a]);
  switch(eleccion) {
    case 1 : baudios(1200);
	     baud=1200;
	     display_baud(1200); break;
    case 2 : baudios(7680);
	     baud=7680;
	     display_baud(7680); break;
    case 3 : baudios(9600);
	     baud=9600;
	     display_baud(9600); break;
  }
  cierra();
}



void cambiar_com()
/*Ŀ
   Cambiar puerto serie ,que es submenu de menu_tx 
   */
{
  int eleccion;
  if (abre(60,7,8,6,0x4F,1,1)==0) error_tow(1);   // Abrir ventana tx
  agregar_opcion(&vent[a],"/f4/c15 COM1 ");
  agregar_opcion(&vent[a],"/f4/c15 COM2 ");
  agregar_opcion(&vent[a],"/f4/c15 COM3 ");
  agregar_opcion(&vent[a],"/f4/c15 COM4 ");
  escribe_vent_menu(&vent[a]);
  eleccion=menu_vertical(&vent[a]);

  if (eleccion<=4 && eleccion>=0) {
    configurar_puerto(eleccion);
    baudios(baud);
    puerto=eleccion;
    display_com(eleccion);
  }
  cierra();
}



int menu_tx()
/*Ŀ
   Menu de transmisiones del TOWER BOOT.  
   */
{
  int eleccion;

  if (abre(62,5,15,5,0x4F,1,1)==0) error_tow(1);   // Abrir ventana tx

  // Indicar las opciones de la nueva ventana abierta
  agregar_opcion(&vent[a],"/f4/c15 Reset ON\\OFF");
  agregar_opcion(&vent[a],"/f4/c15 Baudios      ");
  agregar_opcion(&vent[a],"/f4/c15 Com          ");
  //agregar_opcion(&vent[a],"/f4/c07 Send Break   ");


  escribe_vent_menu(&vent[a]);         // Sacar el menu
  while((eleccion=menu_vertical(&vent[a]))!=-1) {
    switch(eleccion) {
      case 2 : cambiar_baudios(); break;
      case 3 : cambiar_com(); break;
      case 1 : if (dtr) {
		dtr=0;
		desactivar_dtr();
		display_dtr(dtr);
	       }else {
		dtr=1;
		activar_dtr();
		display_dtr(dtr);
	       }
	       break;
      case -2: cierra();
	       return -2;
      case -3: cierra();
	       return -3;
      default: activar_opcion_vert(&vent[a],eleccion,0,0);
	       break;
    }
    activar_opcion_vert(&vent[a],eleccion,0,0);
  }
  cierra();
  return -1;
}





int comprobar_salir()
/* Ŀ
    Pide confirmacion para salir del programa 
   
*/
{
 char c;

 abre_vent_menos1(24,10,30,3,COL_VENT_MENS,CLM_MENS);
 print((vent[-1].x)+2,(vent[-1].y)+(vent[-1].alt)-2,
	"/c15 Salir de tower_boot? S\\N");

  while ((c!='n')&&(c!='s')) {
  switch(c=getch()) {

    case 'N':
    case 'n': return 0;
    case ESC:
    case 'S':
    case 's': return 1;
    default : break;
   }
  }
 return 1;    /*' '->1*/
}



void gestiona_menu_horiz(int iluminada)
/*
Ŀ
   Nos movemos en las opciones del men horizontal (barra sup) 
  hasta que se pulsa ESCAPE y entonces devuelve iluminada=0 y  
  si elegimos alguna opcin, pasamos al men vertical correspon
  diente con dicha opcin.Las variables 'control' e 'iluminada'
  sirven para el movimiento continuo por la barra horizontal.  

*/
{
  int control; // variable que devuelve cada men indicando la tecla de
	       // control (cursores) pulsada : -2=flecharight,-3=flechaleft,
	       // -1=ninguna opcion elegida en el menu particular (vertical)


  //  Si le pasamos un cero, al subir a la barra de mens, no se abren las
  // ventanas hasta que pulsamos 'enter', es decir, le pasamos el control a
  // menu_horizontal de la librera mens

  if (iluminada==0) {
   iluminada=menu_horizontal(&vent[0],1);  // iluminada opcion 1 por defecto
  }


  // %%%%
  // cerrar_puerto_serie();       // quitar interrupciones

  do {
   switch(iluminada) {

    case 0 : // ninguna opcin elegida en el men principal (horizontal)
	     return;
    case 1 : // men MCU
	     control=menu_mcu();
	     activar_opcion_horiz(&vent[0],iluminada,0,0); // apagar opcin
	     if (control==-2) iluminada=2;
	     if (control==-3) iluminada=4;
	     break;
    case 2 : // men FPGA
	     control=menu_fpga();
	     activar_opcion_horiz(&vent[0],iluminada,0,0); // apagar opcin
	     if (control==-2) iluminada=3;
	     if (control==-3) iluminada=1;
	     break;
    case 3 : // men MEM
	     control=menu_mem();
	     activar_opcion_horiz(&vent[0],iluminada,0,0); // apagar opcin
	     if (control==-2) iluminada=4;
	     if (control==-3) iluminada=2;
	     break;
    case 4 : // men de transmisiones
	     control=menu_tx();
	     activar_opcion_horiz(&vent[0],iluminada,0,0); // apagar opcin
	     if (control==-2) iluminada=1;
	     if (control==-3) iluminada=3;
	     break;
   }
  activar_opcion_horiz(&vent[0],iluminada,COLOR_BARRAH,COLOR_LETRAH);
  } while (control!=-1);

  /*
  // %%%%
	      // Volvemos a abrir puerto_serie
	      configurar_puerto(puerto);
	      baudios(baud);
	      display_dtr(dtr);
  */

  activar_opcion_horiz(&vent[0],iluminada,0,0);
  iluminada=1;   // restauramos la opcin por defecto
}



void especial(char c)
/* Ŀ
    Procesar una tecla especial                       
    */
{
 //int cterm=0;

  switch(c)
   {
    case  ALTA :  // ventana del mensaje de los crditos
	       if (terminal==OFF) break;
	       abre_vent_mens();
	       mensaje_creditos();
	       cierra_vent_error_mens();
	       break;

    case F6 : // Canal I
	      system("cls");
	      system("canal1.bat");
	      restaurar_towboot();
	      break;

    case F7 : // Canal II
	      system("cls");
	      system("canal2.bat");
	      restaurar_towboot();
	      break;

    case F8 : // Canal III
	      system("cls");
	      system("canal3.bat");
	      restaurar_towboot();
	      break;


    case F9 : // DTR ON/OFF
	      if (dtr) {
		dtr=0;
		desactivar_dtr();
		display_dtr(dtr);
	       }else {
		dtr=1;
		activar_dtr();
		display_dtr(dtr);
	       }
	      break;

    case F10 : // com 1/2
	      if (puerto==1) {
	       configurar_puerto(2);
	       puerto=2;
	       display_com(2);
	      }
	      else if (puerto==2) {
	       configurar_puerto(1);
	       puerto=1;
	       display_com(1);
	      }
	      break;

    case F5 : // limpiar terminal
	      if (terminal==ON)      // si no se borra la vent 0 (todo)
	       clrscr();
	      break;

    case F1 :
    case ALTM: // MCU	       
	       activar_opcion_horiz(&vent[0],1,COLOR_BARRAH,COLOR_LETRAH);
	       gestiona_menu_horiz(1);
	       break;
    case F2 :
    case ALTF: // FPGA
	       activar_opcion_horiz(&vent[0],2,COLOR_BARRAH,COLOR_LETRAH);
	       gestiona_menu_horiz(2);
	       break;
    case F3 :
    case ALTU: // MEM
	       activar_opcion_horiz(&vent[0],3,COLOR_BARRAH,COLOR_LETRAH);
	       gestiona_menu_horiz(3);
	       break;

    case F4 :
    case ALTT: // TX
	       activar_opcion_horiz(&vent[0],4,COLOR_BARRAH,COLOR_LETRAH);
	       gestiona_menu_horiz(4);
	       break;

    case  'a':  // modo terminal
	       /*
	       abre (20,8,35,5,0x6F,0,0);
	       escribe_vent(&vent[a],2,2,15,6,"color terminal(2-8):");
	       gotoxy(42,6);
	       cterm=getche();
	       if (cterm==ENTER) cterm=8;                  // negro por defecto
	       cierra();
	       gotoxy(1,1);
	       if (modo_terminal(cterm)==0) error_tow(5);  // fondo negro para el terminal
	       */
	       break;


    case  'e':  // volver del modo terminal
	       /*
	       if (cerrar_terminal()==0) error_tow(6);
	       */
	       break;

    case  'c':   if (cierra()==0) error_tow(2); // puerta trasera para casos en que
	       break;             // haya que cerrar las ventanas manualmente

    case  'b':   borrar_pantalla();      //puerta trasera
	       restaurar_towboot();
	       return;

    default  : break;
   }
}



int opcion()
/* Ŀ
    Procesa la opcin elegida por el usuario.         
    Define las teclas de funcin, siendo una de ellas 
   la que pasa al men por cursores (men_ppal)       
   
*/
{
 char c=0,d;
 do {
   if (kbhit()) {             // Si se pulsa una tecla...
      c=getch();
      if (c==0) {             // Si se pulsa una tecla especial
	c=getch();            // Leer cdigo extendido
	especial(c);          // Actuar en consecuencia
      }
      else {
	if (c!=ESC) {                  // si no es tecla especial
	   enviar(c);                  // y es distinta de ESC se enva
	   if (c==ENTER) enter_tow();
	}
      }
    }

 //Si se recibe un carcter y el terminal est activado, se lee y se imprime
   if ( (car_waiting())&&(terminal==ON) ) {
      d=leer_car();
      cprintf ("%c",d);
    }
 } while ((c!=ALTX)&&(c!=ESC));

 if (c==ALTX) {
   cierra_todo();
   return 1;
  }

 if (c==ESC) {
  if ( (comprobar_salir())==0) {      // no queremos salir
   cierra_vent_menos1();
   return 0;
  }
  else{
   cierra_vent_menos1();
   return 1;
  }
 }
 return 1;  /*' '->1*/
}


main()
{
 clrscr();

 puerto=2 ;          // Por defecto pongo COM2
 baud=9600;

 configurar_puerto(puerto);
 baudios(baud);
 dtr=0;
 desactivar_dtr();
 display_dtr(dtr);
 gotoxy(5,6);

 outportb(0x3d9,4);

 // Partes fijas de la pantalla
 menu();

 // Definimos y escribimos (en horizontal) el men principal (a=0)
 define_menu_ppal();
 escribe_vent_menu(&vent[a]);

 // Arranca en modo terminal con fondo negro
 modo_terminal(0);

 // Damos paso al usuario y procesamos sus elecciones
 while (opcion()!=1);    // si opcion=1 queremos salir

 // Finalizacin
 cerrar_puerto_serie();
 system("cls");
 return(1);
}



/************************************************************************/
// repasar devoluciones de cosas
// revisar todos los int->short o unsigned
/**************************************************************************/









