/*
 ͻ
  GRUPO J&J. Mayo 1996.                                  
 ͹
                                                         
  MENUS.C                                                
                                                         
   Librera general de creacin de mens y ventanas como 
  interfaz de programas de aplicaciones.                 
                                                         
                                                         
 ͼ
*/

#include "jj.h"
#include "cfgmenus.h"


/* Ŀ
      V A R I A B L E S      
   
*/


// de VIDEO.C
extern char far *pant;  // Memoria de pantalla
extern char cfondo;     // Color del fondo.

// de TWB.C
struct TIPO_VENTANA vent[NUMVENT];        // Array de ventanas
int a=0;                                  // CONTADOR DE VENTANA ABIERTA

// OJO! 'a' no tiene por qu coincidir con la numeracin dada por el
// usuario a sus ventanas :la vent '2' del usuario puede ser la 4 abierta



/*
 Ŀ
  P R O T O T I P O S  
 
*/

// de VIDEO.C
void fondo(int color);
void marco(int x,int y,int anch,int alt,int color,int tipo);
void cambiar_atributos(int x,int y,int anch,int alt,int color);
void guardar_region(int x,int y,int anch,int alt,char *region);
void reponer_region(int x,int y,int anch,int alt,char *region);
void print(int x,int y,char cad[]);
int  toma_numero2(char cad[],int *nd);


// de MENUS.C
char lee_tecla(void);
int abre(int x,int y,int longx,int longy,int color,int tipomarco,int sombra);
int cierra(void);
int cierra_todo(void);
void pantalla_cursor(int color);

int calcula_long_cad(char cad[]);
int escribe_vent_menu(struct TIPO_VENTANA *ventana);
void print_vent(int x,int y,int tope,int colf,int col,char cad[]);
int escribe_vent(struct TIPO_VENTANA *ventana,int x0,int y0,int colf,int col,
		 char cadena[]);

int agregar_opcion(struct TIPO_VENTANA *ventana,char cad[]);
void situa_menu(struct TIPO_VENTANA *ventana,int x,int y);
void separacion_menu(struct TIPO_VENTANA *ventana,int incx,int incy);
void color_menu(struct TIPO_VENTANA *ventana,int colbarra,int colletra);

int activar_opcion_vert(struct TIPO_VENTANA *ventana,int k,int colf,int col);
int activar_opcion_horiz(struct TIPO_VENTANA *ventana,int k,int colf,int col);
int menu_vertical(struct TIPO_VENTANA *ventana);
int menu_horizontal(struct TIPO_VENTANA *ventana,int eleccion);



/*
 Ŀ
                                                
                                                
      I    N    T    E    R    F    A    Z      
                                                
                                                
 


char lee_tecla()
 Ŀ
   Procedimiento para leer del teclado extendido.   
   Al pulsar una tecla del teclado extendido, se    
  devuelve 1 un cero y luego el ASCII del caracter.
 


void pantalla_cursor(int color)
Ŀ
  Establece los colores del fondo de la pantalla y del cursor. Estos  
 datos se reciben de un argumento hexadecimal donde el primer digito  
 indica el color del fondo y el segundo el del cursor (ej 0x17 indi-  
 ca fondo azul(1) y cursor gris(7)).                                  



Ŀ
                                                         
     CREACION, DESTRUCCION Y ESCRITURA DE VENTANAS       
                                                         



int abre(int x,int y,int longx,int longy,int color,int tipomarco,int sombra)

Ŀ
 Abre una ventana. Para ello, hace lo siguiente:                      
                                                                      
 -Incrementa el contador de ventanas abtas y comprueba que no supera  
  el maximo permitido, en cuyo caso,no se ejecuta y devuelve un cero. 
  NOTA: La ventana 0 esta reservada para los mensajes de error.       
                                                                      
 -Reserva memoria del doble del tamanyo del area de la ventana; doble 
  porque se guarda para cada caracter,el par (localizacion,atributo). 
                                                                      
 -Guarda la region de debajo ((loc,atrib) de todo lo de debajo).      
                                                                      
 -Escribe un rectangulo de otro color (la ventana).                   
                                                                      
 -Dibuja un marco simple o doble (se especifica en el argumento marc).
  El fondo del marco se ha dejado del mismo color que el fondo de la  
  ventana pero se podria cambiar en la llamada a fondo().             
 -Dibuja sombras o no, segun se especifique en los argumentos.        
  La sombra no es opaca sino q se ve lo que hay debajo => 0x07 (no 0).
                                                                      
 -Finalmente, asigna a la variable global vent. las dimensiones de la 
  ventana creada y devuelve un uno (no ha habido ningn problema).    




int cierra()

Ŀ
 -Cierra la ventana que este activa, volviendo a escribir lo que esta- 
  ba debajo de ella y que esta guardado en el puntero "debajo".        
 -Libera la memoria que se habia reservado para guardar la region.     
 -Si no hay ventana abierta (a<=0) devuelve un cero y no se ejecuta.   
  Ademas, solo se puede cerrar la ultima ventana abierta(a).           




int cierra_todo()

 Ŀ
   Por seguridad, cierra todas las ventanas que  
  pudieran estar abiertas liberando la memoria   
  ocupada por ellas.                             
                                                 
   Sirve por ejemplo para el caso de salir del   
  programa bruscamente sin cerrar las ventanas.  
 



int escribe_vent(struct TIPO_VENTANA *ventana,int x0,int y0,int colf,int col,
		 char cadena[])

Ŀ
  Escribe en la ventana especificada el mensaje especificado, en las  
 coordenadas (x0,y0) que empiezan en la esquina superior izquierda de 
 la ventana.(recordar que 'a' indica el orden de ventanas abiertas)   
                                                                      
  Comprueba si el mensaje supera el margen derecho de la ventana, en  
 cuyo caso trunca el mensaje al tamao de la misma.                   
                                                                      
  La cadena se pasa como parmetro en CAD[].                          
  Existen una serie de parmetros de control que se pueden invocar    
 desde dentro de la propia cadena a imprimir, que son :               
  /f  --> Cambiar el color del fondo. Justo a continuacin de la      
          f se debe especificar un nmero entre 0-7.                  
  /c  --> Cambiar el color de las letras. El nmero esperado debe     
                                                                      
  Si los parmetros COL,COLF son (0,0) se har caso de dichos par-   
 metros de control '/c /f' pero sin alguno es distinto de cero, in-   
 dicarn el color con que se quiere imprimir la cadena (col=color de  
 las letras y colf=color del fondo de las mismas), de manera que los  
 parmetros de color sern leidos y absorbidos.                       
                                                                      
  Si no hay ninguna ventana abierta (a=0), devuelve un cero y no se   
 ejecuta. Ademas,si las coordenadas superan el marco vertical izquier 
 do o los marcos superior o inferior, devuelve un 'menos uno'         
 y tampoco se ejecuta.                                                
                                                                      






Ŀ
                                                                
       C R E A C I O N    D E     M E N U S                     
                                                                



int agregar_opcion(struct TIPO_VENTANA *ventana,char cad[])
   Ŀ
    Realiza la asignacin automtica de las opciones de
   un men definidas como cadenas constantes y q estn 
   asociadas a una ventana que se pasa como parmetro. 
    En num_opciones se lleva la cuenta de las opciones 
   de que consta un men de una ventana lo cual es ne- 
   cesario a la hora de moverse luego por el men.     
    Si el num. opciones supera el definido en el mdulo
   cfgmenus.h, devuelve un cero y no se aade la opcin
   



int agregar_opcion_horiz(struct TIPO_VENTANA *ventana,char cad[])
   Ŀ
    Realiza la asignacin automtica de las opciones de
   un men definidas como cadenas constantes y q estn 
   asociadas a una ventana que se pasa como parmetro. 
    En num_opciones se lleva la cuenta de las opciones 
   de que consta un men de una ventana lo cual es ne- 
   cesario a la hora de moverse luego por el men.     
    Si el num. opciones supera el definido en el mdulo
   cfgmenus.h, devuelve un cero y no se aade la opcin
   



void situa_menu(struct TIPO_VENTANA *ventana,int x,int y)
   Ŀ
    Realiza la asignacin automtica de la coordenada  
   donde queremos situar el men, estando el orgen en 
   la esquina superior de la ventana indicada.         
    Es opcional y si no se lo llama,se toma por defecto
   la coordenada (1,1), asignada en abre(..).          
   



void separacion_menu(struct TIPO_VENTANA *ventana,int incx,int incy)
   Ŀ
    Realiza la asignacin automtica de la separacin  
   bien horizontal bien vertical de las opciones de un 
   men asociado a una ventana.                        
    Es opcional y si no se lo llama,se toma por defecto
   men vert con separ de 1 lnea, asignada en abre(..)
   



void color_menu(struct TIPO_VENTANA *ventana,int colbarra,int colletra)
   Ŀ
    Realiza la asignacin automtica de los colores de 
   la barra y de la letra utilizados para resaltar la  
   opcin activa de un men asociado a una ventana.    
    Es opcional y si no se lo llama,se toma por defecto
   los col indicados en cfgmenus.h asignados en abre(.)
   



int escribe_vent_menu(struct TIPO_VENTANA *ventana)

Ŀ
  Escribe en la ventana especificada un men de opciones dis-
 puesto de la forma indicada al definir la ventana,o vertical
 por defecto, y empezando en la coordenada (xm,ym) definida  
 tambin con la ventana y que empieza en la esquina superior 
 izquierda de la misma.                                      
                                                             
  El men consta de num_opciones opciones, nmero definido   
 al definir cada men asociado a una ventana                 
  Las opciones y los colores de las mismas, se definen en el 
 programa principal creando un void 'define_men'.           
                                                             
  Si no hay ventana abierta (a<0) devuelve un cero y no se   
 ejecuta. Adems, si las coordenadas superan el marco        
 vertical izquierdo o los marcos superior o inferior,devuelve
 un 'menos uno' y tampoco se ejecuta.                        







Ŀ
                                                                
 T R A T A M I E N T O  D E  M E N U S  C O N  C U R S O R E S  
                                                                



int activar_opcion_vert(struct TIPO_VENTANA *ventana,int k,int colf,int col)

 Ŀ
   Resalta la opcin indicada k-1 de la ventana indicada 
  coloreando el fondo de la misma de color colf y las    
  letras de color col.                                   
   Si col y colf son '0', se escribe la opcin en los    
  colores con que fue definida (se 'apaga')              
                                                         
   Si no se puede escribir en la ventana (porque no est 
  abierta), se devuelve un cero.                         
                                                         
   El parmetro k-1 indica el nmero de opcin que se    
  quiere resaltar.                                       
                                                         
 



int activar_opcion_horiz(struct TIPO_VENTANA *ventana,int k,int colf,int col)

 Ŀ
   Resalta la opcin indicada k-1 de la ventana indicada 
  coloreando el fondo de la misma de color colf y las    
  letras de color col.                                   
   Si col y colf son '0', se escribe la opcin en los    
  colores con que fue definida (se 'apaga')              
                                                         
   Si no se puede escribir en la ventana (porque no est 
  abierta), se devuelve un cero.                         
                                                         
   El parmetro k-1 indica el nmero de opcin que se    
  quiere resaltar.                                       
                                                         
 



int menu_vertical(struct TIPO_VENTANA *ventana)

 Ŀ
   Gestiona el movimiento por las opciones de un men dispuesto 
  de forma vertical.                                            
   Lee una tecla en un bucle hasta que se pulsa una tecla de sa-
  lida, definida en CFGMENUS.H. Procesa la  tecla si es que es  
  alguno de los cursores o 'enter'.                             
                                                                
   Si es 'enter',devuelve un entero de valor el nmero de opcin
  que se ha seleccionado. Si se devuelve -1, ninguna opcion ha  
  sido elegida.                                                 
 



int menu_horizontal(struct TIPO_VENTANA *ventana,int eleccion)

 Ŀ
   Gestiona el movimiento por las opciones de un men dispuesto 
  de forma horizontal.                                          
   Lee una tecla en un bucle hasta que se pulsa una tecla de sa-
  lida, definida en CFGMENUS.H. Procesa la  tecla si es que es  
  alguno de los cursores o 'enter'.                             
                                                                
   Si es 'enter',devuelve un entero de valor el nmero de opcin
  que se ha seleccionado. Si se devuelve 0, ninguna opcion ha   
  sido elegida.                                                 
 

*/



/*
 Ŀ
                                                
                                                
    I  M  P  L  E  M  E  N  T  A  C  I  O  N    
                                                
                                                
 
*/


char lee_tecla()
/*
 Ŀ
   Procedimiento para leer del teclado extendido.   
   Al pulsar una tecla del teclado extendido, se    
  devuelve 1 un cero y luego el ASCII del caracter.
 
*/
{
 char c,car;

 c=getch();
 if (c==0) car=getch();
 else car=c;
 return car;
}


int abre(int x,int y,int longx,int longy,int color,int tipomarco,int sombra)
/*
Ŀ
 Abre una ventana. Para ello, hace lo siguiente:                      
                                                                      
 -Incrementa el contador de ventanas abtas y comprueba que no supera  
  el maximo permitido, en cuyo caso,no se ejecuta y devuelve un cero. 
  NOTA: La ventana 0 esta reservada para los mensajes de error.       
                                                                      
 -Reserva memoria del doble del tamanyo del area de la ventana; doble 
  porque se guarda para cada caracter,el par (localizacion,atributo). 
                                                                      
 -Guarda la region de debajo ((loc,atrib) de todo lo de debajo).      
                                                                      
 -Escribe un rectangulo de otro color (la ventana).                   
                                                                      
 -Dibuja un marco simple o doble (se especifica en el argumento marc).
  El fondo del marco se ha dejado del mismo color que el fondo de la  
  ventana pero se podria cambiar en la llamada a fondo().             
 -Dibuja sombras o no, segun se especifique en los argumentos.        
  La sombra no es opaca sino q se ve lo que hay debajo => 0x07 (no 0).
                                                                      
 -Finalmente, asigna a la variable global vent. las dimensiones de la 
  ventana creada y devuelve un uno (no ha habido ningn problema).    

*/
{
  //contador de ventanas
  a+=1;                     // empezamos por la uno pq cero esta reservada
  if (a>=NUMVENT)
    {
     a=NUMVENT-1;
     return 0;
    }

  //reserva memoria
    // para C++
       //vent[a].debajo=new char[(longx+ASH)*(longy+ASV)*2];
    // para Cpp
       vent[a].debajo=(char *) malloc ((longx+ASH)*(longy+ASV)*2);

  //verificacin de memoria para el puntero
  if (vent[a].debajo==NULL)
  {
   cierra_todo();
   clrscr();
   print(2,3," Falta memoria!!! ");
   exit(1);
  }

  //creacion ventana
  guardar_region(x,y,longx+ASH,longy+ASV,vent[a].debajo);
  cambiar_atributos(x,y,longx,longy,color);

  //marco
  fondo((color >> 4) & 0x0F);                 // color fondo marco
  marco(x,y,longx,longy,(color & 0x0F),tipomarco);

  //sombras
  if (sombra==1)
   {
    cambiar_atributos(x+ASH,y+longy,longx,ASV,PENUMBRA); //horizontal
    cambiar_atributos(x+longx,y+1,ASH,longy,PENUMBRA);   //vertical
   }

  //variable global vent.
  vent[a].x=x;
  vent[a].y=y;
  vent[a].anch=longx;
  vent[a].alt=longy;

  // Inicializaciones por defecto (men vert)
  if (a>0) {                                 // vent[0] se trata aparte
   vent[a].menu.xm=1;
   vent[a].menu.ym=1;
   vent[a].menu.incx=0;
   vent[a].menu.incy=1;
   vent[a].menu.long_cad=0;
   vent[a].menu.num_opciones=0;
   vent[a].menu.cbarra=COLOR_BARRA;
   vent[a].menu.cletra=COLOR_LETRA;
  }

  return 1;
}


int cierra()
/*
Ŀ
 -Cierra la ventana que este activa, volviendo a escribir lo que esta- 
  ba debajo de ella y que esta guardado en el puntero "debajo".        
 -Libera la memoria que se habia reservado para guardar la region.     
 -Si no hay ventana abierta (a<=0) devuelve un cero y no se ejecuta.   
  Ademas, solo se puede cerrar la ultima ventana abierta(a).           
 */
{
 if (a<=0) {
    return 0;
   }
 else
 {
  reponer_region(vent[a].x,vent[a].y,(vent[a].anch)+ASH,(vent[a].alt)+ASV,
		vent[a].debajo);
  free(vent[a].debajo);
  a-=1;
  return 1;
 }
}


int cierra_todo()
{
/*
 Ŀ
   Por seguridad, cierra todas las ventanas que  
  pudieran estar abiertas liberando la memoria   
  ocupada por ellas.                             
                                                 
   Sirve por ejemplo para el caso de salir del   
  programa bruscamente sin cerrar las ventanas.  
 
*/
 int i=0;

 if (a<=0) {
   return 0;
  }
 else {
  for (i=a; i>0; i--)
   {
    reponer_region(vent[i].x,vent[i].y,(vent[i].anch)+ASH,(vent[i].alt)+ASV,
		   vent[i].debajo);
    free(vent[i].debajo);
   }
  return 1;
 }
}



int calcula_long_cad(char cad[])
/*
Ŀ
 Calcula la longitud de la cadena enviada como parmetro, teniendo
en cuenta que en la cadena se pueden especificar parmetros de con
trol [/f(num) /c(num)] que hay que absorber.                      
 Es una variacin de print(..) implementado en el mdulo Video.c  

*/
{
  unsigned short int longitud=0,i=0;
  int nd;

  while (cad[i]) {
    if (cad[i]!='/')
    {
     i++;
     longitud+=1;
    }
    else
     {
      switch(cad[++i]) {
	case 'f' : i++;
		   if (toma_numero2(&cad[i],&nd)!=-1)
		    {
		     i=i+nd;
		    }
		   break;
	case 'c' : i++;
		   if (toma_numero2(&cad[i],&nd)!=-1)
		    {
		     i=i+nd;
		    }
		   break;
       } //switch
      }  //if
     }   //while

  return longitud;
}



void print_vent(int x,int y,int tope,int colf,int col,char cad[])
/*
Ŀ
                                                                      
  Variacin de print(...) de VIDEO.C.                                 
                                                                      
   Imprimir una cadena en las coordenadas indicadas de una ventana    
  q le indica escribe_vent() llegando como mucho al punto de abscisas 
  llamado 'TOPE' que es el borde vertical derecho de la ventana.      
                                                                      
   La cadena se pasa como parmetro en CAD[].                         
   Existen una serie de parmetros de control que se pueden invocar   
  desde dentro de la propia cadena a imprimir, que son :              
                                                                      
   /f  --> Cambiar el color del fondo. Justo a continuacin de la     
           f se debe especificar un nmero entre 0-7.                 
   /c  --> Cambiar el color de las letras. El nmero esperado debe    
                                                                      
                                                                      
  Si los parmetros COL,COLF son (0,0) se har caso de dichos par-   
 metros de control '/c /f' pero sin alguno es distinto de cero, in-   
 dicarn el color con que se quiere imprimir la cadena (col=color de  
 las letras y colf=color del fondo de las mismas), de manera que los  
 parmetros de color sern leidos y absorbidos.                       

*/
{
  int xini;
  int tinta=7;
  int color,color_det;
  int i=0;
  int nd;

  x--;
  y--;
  color=color | tinta;
  color_det=colf | (col<<4);     // solo si col=0 y colf=0, color_det=0

  while (cad[i]) {
    if (cad[i]!='/') {
      if (x<tope) {
	*(pant+x*2+160*y)=cad[i];

	if (color_det==0)                 // si color_det=0,funcionan '/c/f'
	 {*(pant+x*2+160*y+1)=color;}
	else                              // si color_det!=0, vale color_det
	 {*(pant+x*2+160*y+1)=color_det;}
	x++;
	i++;
      }
      else return;
    }
    else {
      switch(cad[++i]) {
	case 'f' : i++;
		   cfondo=toma_numero2(&cad[i],&nd);
		   if (cfondo!=-1) {
		     color=color & 0x0F;
		     color=(cfondo<<4) | tinta;
		     i=i+nd;
		   }
		   break;
	case 'c' : i++;
		   tinta=toma_numero2(&cad[i],&nd);
		   if (tinta!=-1) {
		     color=color & 0xF0;
		     color=color | tinta;
		     i=i+nd;
		   }
		   break;
      }
    }
  }
}



int escribe_vent(struct TIPO_VENTANA *ventana,int x0,int y0,int colf,int col,
		 char cadena[])
/*
Ŀ
  Escribe en la ventana especificada el mensaje especificado, en las  
 coordenadas (x0,y0) que empiezan en la esquina superior izquierda de 
 la ventana.(recordar que 'a' indica el orden de ventanas abiertas)   
                                                                      
  Comprueba si el mensaje supera el margen derecho de la ventana, en  
 cuyo caso trunca el mensaje al tamao de la misma.                   
                                                                      
  La cadena se pasa como parmetro en CAD[].                          
  Existen una serie de parmetros de control que se pueden invocar    
 desde dentro de la propia cadena a imprimir, que son :               
  /f  --> Cambiar el color del fondo. Justo a continuacin de la      
          f se debe especificar un nmero entre 0-7.                  
  /c  --> Cambiar el color de las letras. El nmero esperado debe     
                                                                      
  Si los parmetros COL,COLF son (0,0) se har caso de dichos par-   
 metros de control '/c /f' pero sin alguno es distinto de cero, in-   
 dicarn el color con que se quiere imprimir la cadena (col=color de  
 las letras y colf=color del fondo de las mismas), de manera que los  
 parmetros de color sern leidos y absorbidos.                       
                                                                      
  Si no hay ninguna ventana abierta (a=0), devuelve un cero y no se   
 ejecuta. Ademas,si las coordenadas superan el marco vertical izquier 
 do o los marcos superior o inferior, devuelve un 'menos uno'         
 y tampoco se ejecuta.                                                
                                                                      

*/
{
 int tope;
 tope=(ventana->x)+(ventana->anch)-2;       // detecta el margen derecho

 if (a<0) {
   return 0;
  }
 if( (x0<1)||(y0<1)||(y0>=(ventana->alt)-1) ) // error de coord (no se avisa
  {                                           //                 en towboot)
   return -1;
  }
 else
  {
   print_vent((ventana->x)+x0,(ventana->y)+y0,tope,colf,col,cadena);
  }
 return 1;
}

int escribe_vent_menu(struct TIPO_VENTANA *ventana)
/*
Ŀ
  Escribe en la ventana especificada un men de opciones dis-
 puesto de la forma indicada al definir la ventana,o vertical
 por defecto, y empezando en la coordenada (xm,ym) definida  
 tambin con la ventana y que empieza en la esquina superior 
 izquierda de la misma.                                      
                                                             
  El men consta de num_opciones opciones, nmero definido   
 al definir cada men asociado a una ventana                 
  Las opciones y los colores de las mismas, se definen en el 
 programa principal creando un void 'define_men'.           
                                                             
  Si no hay ventana abierta (a<0) devuelve un cero y no se   
 ejecuta. Adems, si las coordenadas superan el marco        
 vertical izquierdo o los marcos superior o inferior,devuelve
 un 'menos uno' y tampoco se ejecuta.                        

*/
    // devuelve 2 tipos de valores => 2 errores dif

{
 short int tope,i,xini,yini,x0,y0;

 // Por si se quiere escribir un men en la ventana cero,esto es necesario
  vent[0].x=1;
  vent[0].y=1;
  vent[0].anch=80;
  vent[0].alt=25;


 tope=(ventana->x)+(ventana->anch)-2;        // detecta margen derecho

 xini=(ventana->x)+(ventana->menu.xm);      // nos situamos al ppio del men
 yini=(ventana->y)+(ventana->menu.ym);

 x0=ventana->menu.xm;                       // coord dentro de la ventana
 y0=ventana->menu.ym;                       // (0,0)=esquina sup.izda.

 if (a<0) {
   return 0;}
 if( (x0<1)||(y0<1)||(y0>(ventana->alt)) )   // error de coord (no se avisa
  {                                          //                 en towboot)
   return -1;
  }
 else
  {
   for (i=0; i<(ventana->menu.num_opciones); i++)
   {
    print_vent(xini,yini,tope,0,0,ventana->menu.opcion[i]);

    // si el men es horizontal,long_cad no es cero,sino q la calculamos
    if( (ventana->menu.incx)!=0)
    ventana->menu.long_cad=calcula_long_cad(ventana->menu.opcion[i]);

    //calculamos los incrementos 'x' o 'y' segn el tipo de men
    xini=xini+(ventana->menu.incx)+(ventana->menu.long_cad);
    yini=yini+(ventana->menu.incy);
   }
  }
 return 1;
}



int agregar_opcion(struct TIPO_VENTANA *ventana,char cad[])
/* Ŀ
    Realiza la asignacin automtica de las opciones de
   un men definidas como cadenas constantes y q estn 
   asociadas a una ventana que se pasa como parmetro. 
    En num_opciones se lleva la cuenta de las opciones 
   de que consta un men de una ventana lo cual es ne- 
   cesario a la hora de moverse luego por el men.     
    Si el num. opciones supera el definido en el mdulo
   cfgmenus.h, devuelve un cero y no se aade la opcin
   
*/
{
 if (ventana->menu.num_opciones>=NUM_OPCV) {
   return 0;
  }
 ventana->menu.opcion[ventana->menu.num_opciones]=cad;
 ventana->menu.num_opciones+=1;
 return 1;
}


int agregar_opcion_horiz(struct TIPO_VENTANA *ventana,char cad[])
/* Ŀ
    Realiza la asignacin automtica de las opciones de
   un men definidas como cadenas constantes y q estn 
   asociadas a una ventana que se pasa como parmetro. 
    En num_opciones se lleva la cuenta de las opciones 
   de que consta un men de una ventana lo cual es ne- 
   cesario a la hora de moverse luego por el men.     
    Si el num. opciones supera el definido en el mdulo
   cfgmenus.h, devuelve un cero y no se aade la opcin
   
*/
{
 if (ventana->menu.num_opciones>=NUM_OPCH) {
   return 0;
  }
 ventana->menu.opcion[ventana->menu.num_opciones]=cad;
 ventana->menu.num_opciones+=1;
 return 1;
}



void situa_menu(struct TIPO_VENTANA *ventana,int x,int y)
/* Ŀ
    Realiza la asignacin automtica de la coordenada  
   donde queremos situar el men, estando el orgen en 
   la esquina superior de la ventana indicada.         
    Es opcional y si no se lo llama,se toma por defecto
   la coordenada (1,1), asignada en abre(..).          
   
*/
{
 ventana->menu.xm=x;
 ventana->menu.ym=y;
}


void separacion_menu(struct TIPO_VENTANA *ventana,int incx,int incy)
/* Ŀ
    Realiza la asignacin automtica de la separacin  
   bien horizontal bien vertical de las opciones de un 
   men asociado a una ventana.                        
    Es opcional y si no se lo llama,se toma por defecto
   men vert con separ de 1 lnea, asignada en abre(..)
   
*/
{
 ventana->menu.incx=incx;
 ventana->menu.incy=incy;
}


void color_menu(struct TIPO_VENTANA *ventana,int colbarra,int colletra)
/* Ŀ
    Realiza la asignacin automtica de los colores de 
   la barra y de la letra utilizados para resaltar la  
   opcin activa de un men asociado a una ventana.    
    Es opcional y si no se lo llama,se toma por defecto
   los col indicados en cfgmenus.h asignados en abre(.)
   
*/
{
 ventana->menu.cbarra=colbarra;
 ventana->menu.cletra=colletra;
}



void pantalla_cursor(int color)
/*
Ŀ
  Establece los colores del fondo de la pantalla y del cursor. Estos  
 datos se reciben de un argumento hexadecimal donde el primer digito  
 indica el color del fondo y el segundo el del cursor (ej 0x17 indi-  
 ca fondo azul(1) y cursor gris(7)).                                  

*/
{
 cambiar_atributos(1,1,80,25,color);
}



/*
Ŀ
                                                                
 T R A T A M I E N T O  D E  M E N U S  C O N  C U R S O R E S  
                                                                

*/


int activar_opcion_vert(struct TIPO_VENTANA *ventana,int k,int colf,int col)
/*
 Ŀ
   Resalta la opcin indicada k-1 de la ventana indicada 
  coloreando el fondo de la misma de color colf y las    
  letras de color col.                                   
   Si col y colf son '0', se escribe la opcin en los    
  colores con que fue definida (se 'apaga')              
                                                         
   Si no se puede escribir en la ventana (porque no est 
  abierta), se devuelve un cero.                         
                                                         
   El parmetro k-1 indica el nmero de opcin que se    
  quiere resaltar.                                       
                                                         
 
*/
{
 if (escribe_vent(ventana,(ventana->menu.xm),(ventana->menu.ym)+(k-1),
		  col,colf,ventana->menu.opcion[k-1])==0)
   {
   return 0;
   }
 return 1;
}


int activar_opcion_horiz(struct TIPO_VENTANA *ventana,int k,int colf,int col)
/*
 Ŀ
   Resalta la opcin indicada k-1 de la ventana indicada 
  coloreando el fondo de la misma de color colf y las    
  letras de color col.                                   
   Si col y colf son '0', se escribe la opcin en los    
  colores con que fue definida (se 'apaga')              
                                                         
   Si no se puede escribir en la ventana (porque no est 
  abierta), se devuelve un cero.                         
                                                         
   El parmetro k-1 indica el nmero de opcin que se    
  quiere resaltar.                                       
                                                         
 
*/
{
 short int newx=0;    //var auxiliar para legibilidad

 newx=(ventana->menu.xm)+(k-1)*((ventana->menu.incx)+(ventana->menu.long_cad));

 if (escribe_vent(ventana,newx,ventana->menu.ym,col,colf,
		  ventana->menu.opcion[k-1])==0)
   {
    return 0;
   }
 return 1;
}


int menu_vertical(struct TIPO_VENTANA *ventana)
/*
 Ŀ
   Gestiona el movimiento por las opciones de un men dispuesto 
  de forma vertical.                                            
   Lee una tecla en un bucle hasta que se pulsa una tecla de sa-
  lida, definida en CFGMENUS.H. Procesa la  tecla si es que es  
  alguno de los cursores o 'enter'.                             
                                                                
   Si es 'enter',devuelve un entero de valor el nmero de opcin
  que se ha seleccionado y si se devuelve :                     
  -1=>ninguna opcion elegida,-2=>flecharight, -3=>flechaleft    
 
*/
{
 int tecla;
 int n=1;    // opcin que queremos iluminar (activa,seleccionada)
 int m=1;    // opcin anterior (si FLECHADOWN) o posterior (si FLECHAUP)


 activar_opcion_vert(ventana,n,ventana->menu.cbarra,ventana->menu.cletra);
 do
 {
  switch(tecla=lee_tecla())
  {
   case FLECHADOWN: n+=1; m=n-1;
		    if (n>(ventana->menu.num_opciones))
		     {
		      n=1;m=(ventana->menu.num_opciones);
		     }
		    activar_opcion_vert(ventana,m,0,0);
		    activar_opcion_vert(ventana,n,ventana->menu.cbarra,
					ventana->menu.cletra);
		    
		    break;

   case FLECHAUP: if (n==1)
		   {
		    n=(ventana->menu.num_opciones);
		    m=1;
		   }
		  else
		   {
		    n-=1;
		    m=n+1;
		   }

		  activar_opcion_vert(ventana,m,0,0);
		  activar_opcion_vert(ventana,n,ventana->menu.cbarra,
				       ventana->menu.cletra);
		  break;

   case FLECHARIGHT: return -2;
   case FLECHALEFT : return -3;

   case ENTER : //cierra();
		return n;          //  opcin seleccionada
   default    : break;
  }

 } while (tecla!=TSMV);            // tecla salida definida en cfgmenus.h

 return -1; 			   // ninguna opcion elegida
}



int menu_horizontal(struct TIPO_VENTANA *ventana,int eleccion)
/*
 Ŀ
   Gestiona el movimiento por las opciones de un men dispuesto 
  de forma horizontal.                                          
   Lee una tecla en un bucle hasta que se pulsa una tecla de sa-
  lida, definida en CFGMENUS.H. Procesa la  tecla si es que es  
  alguno de los cursores o 'enter'.                             
                                                                
   Si es 'enter',devuelve un entero de valor el nmero de opcin
  que se ha seleccionado. Si se devuelve 0, ninguna opcion ha   
  sido elegida.                                                 
 
*/
{
 unsigned short int n=eleccion;  // opcin iluminada (elegida) del men
 unsigned short int m=1;         // opcin apagada del men ppal

 int tecla;

 activar_opcion_horiz(ventana,n,ventana->menu.cbarra,ventana->menu.cletra);

 do
 {
  switch(tecla=lee_tecla())
  {
   case FLECHARIGHT: n+=1; m=n-1;
		     if (n>=(ventana->menu.num_opciones)+1)
		       {n=1;
			m=ventana->menu.num_opciones;
		       }
		     activar_opcion_horiz(ventana,n,ventana->menu.cbarra,
					  ventana->menu.cletra);
		     activar_opcion_horiz(ventana,m,0,0);
		     break;

   case FLECHALEFT:  if (n==1) { n=ventana->menu.num_opciones; m=1; }
		     else { n-=1; m=n+1; }
		     activar_opcion_horiz(ventana,n,ventana->menu.cbarra,
					  ventana->menu.cletra);
		     activar_opcion_horiz(ventana,m,0,0);
		     break;


   case ENTER: // hemos elegido una ventana y vamos a su interior
	       return n;             // opcin elegida 'n'

   default : break;
  }
 } while (tecla!=TSMH);                    // definida en cfgmenus.h

 activar_opcion_horiz(ventana,n,0,0);      // apagamos al salir
 return 0; 		                   // ninguna opcion elegida
}




































































