/*
 ͻ
  S19UTIL.C       (c) GRUPO J&J. Agosto 1997.                              
 ͹
                                                                           
  Versin 1.0.                                                             
                                                                           
    Utilidades para archivos .S19.                                         
    Se utiliza la libreria S19.C y ASCBIN.C                                
                                                                           
 ͼ
*/

#include "s19.h"

typedef unsigned short int byte;

/*			 ͻ
			                         
ĺ   I N T E R F A Z      
			                         
			 ͼ                      */

void s19toramint(S19 f,byte *ramint, byte *ramintoc);
/* Ŀ
    Quedarse con la parte del programa .S19 comprendido entre las        
    direccion 0-255. El resto se desprecia.                              
                                                                         
    Estas posiciones se introducen en la matriz ramint que debe tener    
    una capacidad minima de 256 posiciones.                              
                                                                         
    En la matriz de ocupacin se indica con 0 las posiciones dentro de   
    la matriz ramint que no tienen codigo. Con 1 las posiciones que si   
    lo tienen.                                                           
   */


void s19toeeprom(S19 f,byte *eeprom, byte *eepromoc);
/* Ŀ
    Quedarse con la parte del programa .S19 comprendido entre las        
    direccion $B600-$B7FF. El resto del programa se desprecia.           
                                                                         
    Estas posiciones se introducen en la matriz eeprom que debe tener    
    una capacidad minima de 512 posiciones.                              
                                                                         
    En la matriz de ocupacin se indica con 0 las posiciones dentro de   
    la matriz eeprom que no tienen codigo. Con 1 las posiciones que si   
    lo tienen.                                                           
   */


int situacion_progs19(S19 fs19, int *ov);
/* Ŀ
    Comprobar la situacin del programa: RAM interna, EEPROM o RAM       
    externa.                                                             
    En ov se devuelve si ha habido desbordamiento de la eeprom o ram     
    interna.                                                             
                                                                         
     La funcin devuelve 1 : Programa para RAM interna                   
                         2 : Programa para EEPROM                        
                         3 : Programa para RAM externa.                  
   */

void raminttoc(byte *ramint, char *cadc);
/* Ŀ
    Tomar la matriz ramint que contiene un programa para la RAM interna  
    y devolver en el array cadc la cadena que representa la misma        
    matriz pero definida en C.                                           
      La cadena cadc debe tener el tamao especificado por la constante  
    MAXCADC especificada en el fichero S19UTIL.H                         
   */


/*		   ͻ
		                                 
ĺ I M P L E M E N T A C I O N  
		                                 
		   ͼ                        */


void s19toramint(S19 f,byte *ramint, byte *ramintoc)
/* Ŀ
    Quedarse con la parte del programa .S19 comprendido entre las        
    direccion 0-255. El resto se desprecia.                              
                                                                         
    Estas posiciones se introducen en la matriz ramint que debe tener    
    una capacidad minima de 256 posiciones.                              
                                                                         
    En la matriz de ocupacin se indica con 0 las posiciones dentro de   
    la matriz ramint que no tienen codigo. Con 1 las posiciones que si   
    lo tienen.                                                           
   */
{
  unsigned int i,n;
  unsigned int dir;
  unsigned int nreg;
  unsigned short int codigo[37];
  unsigned short int tam;

  nreg=getnregs19(f);

  for (i=0; i<=255; i++) {
    ramint[i]=0;
    ramintoc[i]=0;	      /* Inicialmente todas las posiciones vacias */
  }

  for (i=1; i<=nreg; i++) {
    leerdir_s19(f,i,&dir);
    leercod_s19(f,i,codigo,&tam);
    for (n=0; n<tam; n++) {
      if ((dir+n)<=0xFF) {
	ramint[dir+n]=codigo[n];    /* Guardar valor          */
	ramintoc[dir+n]=1;          /* Indicar posicin llena */
      }
    }
  }
}

void s19toeeprom(S19 f,byte *eeprom, byte *eepromoc)
/* Ŀ
    Quedarse con la parte del programa .S19 comprendido entre las        
    direccion $B600-$B7FF. El resto del programa se desprecia.           
                                                                         
    Estas posiciones se introducen en la matriz eeprom que debe tener    
    una capacidad minima de 512 posiciones.                              
                                                                         
    En la matriz de ocupacin se indica con 0 las posiciones dentro de   
    la matriz eeprom que no tienen codigo. Con 1 las posiciones que si   
    lo tienen.                                                           
   */
{
  unsigned int i,n;
  unsigned int dir;
  unsigned int ind;
  unsigned int nreg;
  unsigned short int codigo[37];
  unsigned short int tam;

  nreg=getnregs19(f);

  for (i=0; i<=511; i++)
    eepromoc[i]=0;         /* Inicialmente matriz eeprom desocupada */

  for (i=1; i<=nreg; i++) {
    leerdir_s19(f,i,&dir);
    leercod_s19(f,i,codigo,&tam);
    for (n=0; n<tam; n++) {
      if ((dir+n)<=0xB7FF) {
	ind=dir-0xB600;
	eeprom[ind+n]=codigo[n];    /* Guardar valor     */
	eepromoc[ind+n]=1;	    /* Indicar ocupacin */
      }
    }
  }
}

int check_eeprom(S19 fs19, int *ov)
/* Ŀ
    Comprobar si el archivo S19 especificado tiene todas sus direcciones 
    dentro de los 512 bytes de la EEPROM.                                
                                                                         
     Se devuelve 1 en caso de que sea programa para la EEPROM            
     Se devuelve 0 en caso contrario.                                    
                                                                         
      Si es un programa para la EEPROM pero la desborda se indica con    
      un 1 en ov. 0 en caso de no desbordamiento.                        
   */
{
  unsigned int i;
  unsigned int dir;
  unsigned int nreg;
  unsigned short int codigo[37];
  unsigned short int tam;

  nreg=getnregs19(fs19);

  if (nreg==0) {   /* Fichero S19 sin registros? */
    *ov=0;
    return 1;
  }

  leerdir_s19(fs19,1,&dir);
  if (dir<0xB600 || dir>0xB7FF) {  /* Programa NO es para la EEPROM */
    return 0;
  }

  for (i=2; i<=nreg; i++) {
    leerdir_s19(fs19,i,&dir);
    leercod_s19(fs19,i,codigo,&tam);
    if ( (dir+tam)>0xB7FF) {
      *ov=1;                /* Programa desborda la EEPROM */
      return 1;
    }
  }
  *ov=0;
  return 1;                 /* Programa es para la EEPROM */
}


int check_ramint(S19 fs19, int *ov)
/* Ŀ
    Comprobar si el archivo S19 especificado tiene todas sus direcciones 
    dentro de los 256 bytes de la RAM interna.                           
                                                                         
     Se devuelve 1 en caso de que sea programa para la RAM interna       
     Se devuelve 0 en caso contrario.                                    
                                                                         
      Si es un programa para la RAM interna pero la desborda se indica   
     con un 1 en ov. 0 en caso de no desbordamiento.                     
   */
{
  int i;
  unsigned int dir;
  unsigned int nreg;
  unsigned short int codigo[35];
  unsigned short int tam;

  nreg=getnregs19(fs19);

  if (nreg==0) {   /* Fichero S19 sin registros? */
    *ov=0;
    return 1;
  }

  leerdir_s19(fs19,1,&dir);
  if (dir>0xFF) {           /* Programa NO es para la RAM interna */
    return 0;
  }

  for (i=2; i<=nreg; i++) {
    leerdir_s19(fs19,i,&dir);
    leercod_s19(fs19,i,codigo,&tam);
    if ( (dir+tam)>0xFF) {
      *ov=1;                /* Programa desborda la ram interna */
      return 1;
    }
  }
  *ov=0;
  return 1;                 /* Programa es para la RAM interna */
}

int situacion_progs19(S19 fs19, int *ov)
/* Ŀ
    Comprobar la situacin del programa: RAM interna, EEPROM o RAM       
    externa.                                                             
    En ov se devuelve si ha habido desbordamiento de la eeprom o ram     
    interna.                                                             
                                                                         
     La funcin devuelve 1 : Programa para RAM interna                   
                         2 : Programa para EEPROM                        
                         3 : Programa para RAM externa.                  
   */
{
  if (check_ramint(fs19,ov)==1) return 1;  /* Programa para RAM interna */
  if (check_eeprom(fs19,ov)==1) return 2;  /* Programa para EEPROM      */

  return 3;   /* Programa para RAM externa */
}

void raminttoc(byte *ramint, char *cadc)
/* Ŀ
    Tomar la matriz ramint que contiene un programa para la RAM interna  
    y devolver en el array cadc la cadena que representa la misma        
    matriz pero definida en C.                                           
   */
{
  char cad[3];
  int i;
  int n;

  strcpy(cadc,"unsigned short int programint[256]={\n");

  n=1;
  for (i=0; i<=255; i++) {
    strcat(cadc,"0x");
    bytetochar2(ramint[i],cad);
    cad[2]=0;
    strcat(cadc,cad);
    strcat(cadc,",");
    n++;
    if (n==16) {
      strcat(cadc,"\n");
      n=1;
    }
  }

  strcat(cadc,"};");


}

