/*
 ͻ
  S19TOC.C    (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Versin 1.0.                                                             
                                                                           
    Programa para conversir archivos .S19 para la RAM interna en un        
  fichero de texto en lenguaje .C. Lo que se graba en el archivo en .C es  
  una matriz que contiene el codigo del programa a cargar.                 
                                                                           
 ͼ
*/

#include "s19util.h"
#include "s19.h"
#include "sys\stat.h"


const float version = 1.0;

main(argc,argv)
int argc;
char *argv[];
{
  char fichs19[80];
  char fichc[80];
  S19 mi_s19;
  int fo;
  char *caderror;
  byte ramint[256];
  byte ramintoc[256];
  char cadc[MAXCADC];


  printf ("\nVersion %.1f  (C) Grupo J&J. Agosto 1996\n",version);
  printf ("Conversin de archivos .S19 para la RAM interna en ficheros en C\n");


  if (argc<2) {
    printf ("\nFichero .S19: ");
    gets(fichs19);
    if (fichs19[0]==0) {
      printf ("Abortado\n");
      return;
    }
  }
  else strcpy(fichs19,argv[1]);

  if (abrir_s19(fichs19,&mi_s19,1)==0) {
    caderror=(char *)geterrors19();
    printf ("Error en fichero %s:\n---> %s\n",fichs19,caderror);
    return;
  }


  if (argc<3) {
    printf ("Fichero destino: ");
    gets(fichc);
    if (fichc[0]==0) {
      printf("Abortado");
      return;
    }
  }
  else strcpy(fichc,argv[2]);

  printf ("\n");

  if ((fo=creat(fichc,S_IWRITE))==-1) {
    printf("Error al crear fichero %s",fichc);
    cerrar_s19(mi_s19);
    return;
  }

  printf ("Generando fichero %s..",fichc);

  s19toramint(mi_s19,ramint,ramintoc);
  raminttoc(ramint,cadc);

  if (write(fo,cadc,strlen(cadc))==-1) {
    printf ("Error al escribir en fichero %s",fichc);
  };

  close(fo);
  cerrar_s19(mi_s19);
  printf ("OK\n");
  return;
}

