;**********************************************************************
;*   J&J Soft-Hard Company. Investigacin y desarrollo. Mayo, 1995    *
;**********************************************************************
;*                      G   A    I    A                               *
;*--------------------------------------------------------------------*
;*  GAIA, Sistema operativo programado especialmente para funcionar   *
;*  en la tarjeta TERMINUS,  desarrolada por J&J Soft-Hard Company.   *
;**********************************************************************

;**********************************************************************
;* INFORMACION SOBRE EL ESTADO DE GAIA:                               *
;*--------------------------------------------------------------------*
;*    <> En el procedimiento load_block hay que comprobar que no se   *
;*       supera la memoria $FFFF porque de lo contrario los datos     *
;*       se comenzaran a escribir a partir de la dir $0000 con lo    *
;*       que se machararan las variables del sistema                 *
;*                                                                    *
;*    <> En el procedimiento volcar, Comprobamos que no se sobre-    *
;*       pase la direccin de memoria $FFFF?                          *
;**********************************************************************

; ------ REGISTROS DEL SCI ------------
BAUD    EQU  $2B        ; Registro de velocidad de transmisin
SCCR1   EQU  $2C        ; Registro de control 1
SCCR2   EQU  $2D        ; Registro de control 2
SCSR    EQU  $2E        ; Registro de estado del SCI
SCDR    EQU  $2F        ; Registro de datos del SCI

; ------ CONSTANTES DEL PROGRAMA ------
TAM_BUF_REC     EQU 10;      ; Tamao del buffer de recepcin serie.
BEGIN_GAIA      EQU $8000    ; Direccin comienzo de GAIA

; ------ CONTROL DE LA VIA -----
VIA     EQU $7FF0       ; Direccin BASE de la va
PORTB   EQU VIA         ; Puerto B de la va
PORTA   EQU VIA+1       ; Puerto A de la va
DDRB    EQU VIA+2
DDRA    EQU VIA+3
T1CL    EQU VIA+4       ; Contador del temporizador 1
T1CH    EQU VIA+5
T1LL    EQU VIA+6       ; Latch del temporizador 1
T1LH    EQU VIA+7
T2CL    EQU VIA+8       ; Contador del temporizador 2
T2CH    EQU VIA+9
SR      EQU VIA+10
ACR     EQU VIA+11
PCR     EQU VIA+12
IFR     EQU VIA+13
IMR     EQU VIA+14

; ------ VARIABLES DEL SISTEMA --------
; Las variables del sistema se sitan al comienzo de la memoria RAM
        ORG $0000
        JMP BEGIN_GAIA

        DW  1           ; Registro X
        DW  1           ; Registro Y
        DW  1           ; Registro PC
reg_SP  DW  1           ; Puntero de pila
progp   DB  1           ; Numero de programas pendientes

; ************************
; *   COMIENZO DE GAIA   *
; ************************
        ORG BEGIN_GAIA

; ---------- INICIALIZACION -----------
        SEI             ; Deshabilitar las interrupciones
        LDS #$00FF      ; Inicializar la Pila el final de la RAM interna

;        ** Hay que inicializar los registros ***

; * Configuracin del SCI:
        LDX #$1000
        CLRA
        STAA SCCR1,X     ; Configurar SCI para 8 bits de datos
        LDAA #$2C        ; Activar transmisior y receptor del SCI
        STAA SCCR2,X     ; Activar la interrupcin de dato recibido

;        LDAA #$30
;        STAA BAUD,X      ; Configurar velocidad transmisin a 9600 baudios

; * Inicializacin VARIABLES rutinas de servicio
        LDD #BUF_REC
        STD CBR         ; Inicializar cabeza del buffer
        STD TBR         ; Inicializar cola del buffer
        CLR CARW        ; Hay 0 caracteres en el buffer

; * Inicializacin de las VARIABLES DEL SISTEMA
        CLR progp       ; No hay programas pendientes

; * Inicializacin de la VIA
        LDAA #$FF
        STAA DDRB         ; Puerto B --> Salida
        CLRA
        STAA ACR
        STAA DDRA         ; Puerto A --> Entrada
        LDAA #$AF         ; CA2 --> Salida de impulso
        STAA PCR          ; CB2 --> Salida manual

; * Inicializacion del DISPLAY

        LDAA #$38          ;  Activar las 2 lneas del display
        JSR control_display
        JSR presenta       ; Sacar mensaje de presentacion


; * Cambio de los vectores de interrupcin
        LDY #RSI_recibir  ; Rutina de servicio de la int. del SCI
        STY $FFD6
        LDY #RSI_soft     ; Rutina de servicio de la int. software.
        STY $FFF6

        CLI             ; Permitir las interrupciones

; **************************************
; *  MODO DE ESPERA DE COMANDOS: MEC   *
; **************************************
; Este es el bucle principal de GAIA. Se espera a recibir comandos del
; programa maestro.

;---------- COMIENZO BUCLE PRINCIPAL -------------

mec
        JSR leer_dato   ; Esperar un carcter por el SCI

        CMPA #01        ; Codigo=1--> Cargar bloque en memoria
        BNE cod2
        JMP load_block  ; Cargar bloque en memoria
        BRA mec         ; Esperar ms comandos
cod2
        CMPA #02        ; Codigo=2--> Ejecutar programa en memoria
        BNE cod3
        JMP exec
        BRA mec
cod3
        CMPA #03        ; Codigo=3--> Volcar memoria
        BNE cod4
        JMP volcar
        BRA mec
cod4
        CMPA #04        ; Codigo=4-->Continuar ejecucin programa
        BNE cod5
        JMP kor         ; KOR = Keep on running (Contina ejecutando)
        BRA mec
cod5
        CMPA #05        ; Codigo=5--> Sincronizacion. (Estas ah?).
        BNE cod6
        JMP sinc
        BRA mec
cod6
        BRA mec

;------------- FIN BUCLE PRINCPAL ----------------------

; *************************************************
; *   S E R V I C I O S    D E    U S U A R I O   *
; *************************************************
; Los servicios de usuario son los servicios que realiza GAIA para el
; programa maestro. Son:
;       ---> Cargar un bloque en la memoria del MCU
;       ---> Ejecutar un programa
;       ---> Volcar memoria del MCU al "exterior"
;       ---> Continuar con la ejecucin de un programa parado
;       ---> Estas ah?. Servicio para sincronizacion.

; ******************************************************************
; * LOAD_BLOCK. Cargar un bloque de datos en la memoria del MCU    *
; ******************************************************************
; El dilogo programa maestro-GAIA es el siguiente:
; El maestro manda los siguientes datos a GAIA:
;       --> Direccin comienzo del bloque de datos en memoria
;       --> Numero de bytes a transferir (Mximo 256)
;       --> Transferir el bloque de datos

load_block
        JSR leer_dir    ; Y contiene direccin donde situar programa
        JSR leer_dato
        TAB             ; B contiene nmero de bytes a transferir
load_next
        CMPB #0               ; Quedan bytes por transferir?
        BEQ fin_load_block    ; No--> Volver al MEC
        BSR leer_dato         ; Leer dato a meter en memoria
        DECB                  ; Queda un carcter menos por meter en memoria
        STAA 0,Y        ; Almacenar dato en memoria
        INY             ; Apuntar a la siguiente posicin de memoria
        BRA load_next   ; Cargar siguiente dato y lo hubiese

fin_load_block
        JMP mec         ; Volver el MEC

; ******************************************************************
; * EXEC. Ejecutar un programa de la memoria                       *
; ******************************************************************
; El Maestro manda los siguientes comandos a GAIA:
;       --> Direccin donde est el programa a ejecutar
;  GAIA ejecuta el programa indicado
exec
        INC progp
        JSR leer_dir    ; Leer direccin comienzo ejecucin programa
        JMP 0,Y         ;  Ejecuta programa !

;*******************************************************************
;* VOLCAR. Volcar contenido de la memoria al "exterior"            *
;*******************************************************************
; El dilogo MAESTRO-GAIA es el siguiente:
;       --> MAESTRO: Enva direccin que se quiere volcar
;       --> MAESTRO: Enva nmero de bytes a volcar (MAX. 256)
;       --> GAIA:    Vuelca la memoria
volcar
        JSR leer_dir    ; Y contiene direccin a volcar
        JSR leer_dato   ;
        TAB             ; B contiene nmero de bytes a volcar
volcar_sig
        CMPB #0         ; Quedan datos por volcar?
        BEQ fin_volcar  ; No--> Volver al MEC
        LDAA 0,Y
        JSR enviar_dato ; Enviar byte de la memoria
        DECB            ; Un dato menos por enviar
        INY             ; Apuntar a la sig. posicin de memoria
        BRA volcar_sig  ; Volcar sig. dato
fin_volcar
        JMP mec         ; Volcer al MEC

; **********************************************************************
; * KOR (Keep On Running). Continuar con la ejecucin de un programa   *
; **********************************************************************
; No hay dilogo MAESTRO-GAIA. Si no hay programas pendientes se vuelve
; al MEC. El programa MAESTRO "debe" saber si existen o no programas pendientes
kor
        LDAA progp
        CMPA #0
        BEQ fin_kor     ; Si no hay prog. pendientes se vuelve al mec.
        LDX #0          ; Mover bloque de mem. de registros
        TSY             ; a la pila.
        LDAB #$7
        JSR mover_bloque
        RTI             ; Continuar con programa interrumpido
fin_kor
        LDX #$1000       ; Mandar seal de break para informar al prog.
        BSET SCCR2,X $01 ; Maestro que no se ha eje. el prog.
        BCLR SCCR2,X $01 ; Quitar seal break.
        JMP mec         ; Volver al MEC.

; *********************************************************************
; * SINC.  Comunicar al exterior que GAIA vive.                       *
; *********************************************************************
; Este peculiar servicio permite al programa maestro saber si GAIA
; est en el modo mec, o por el contrario se encuentra perdida en otros
; modos o est colgada. Nada ms cargar a GAIA el programa maestro puede
; utilizar este servicio para confirmar que GAIA se ha cargado correctamente
;  Es conveniente que el programa maestro llame cada cierto tiempo a este
; servicio para asegurarse que la sincronizacion con GAIA es buena.
;
; El dilogo MAESTRO-GAIA es el siguiente:
;       ---> MAESTRO: GAIA ests ah? (Maestro ha mandado numero 5)
;       ---> GAIA: Sigo viva. GAIA devuelve las iniciales de sus Creadores: J&J

ident   FCC "J&J"
        FCB 0
sinc
        LDY #ident
        JSR enviar_cad
        JMP mec

;----------------- FINAL SERVICIOS DE USUARIO --------------------------

;********************************************************************
;*            S U B R U T I N A S   D E   G A I A                   *
;********************************************************************

; ************
; * LEER_DIR *
; ************
; Leer una direccin por el SCI y devolverla en el registro Y
; ** ENTRADAS: Ninguna
; ** SALIDAS: El registro Y contiene la direccin leida
leer_dir
        PSHA            ; Salvar registros utilizados
        PSHB

        JSR leer_dato   ; Leer byte bajo de la direccin
        TAB             ; B contiene byte bajo direccin
        JSR leer_dato   ; A contiene byte alto de la direccin
        XGDY            ; Ahora Y contiene la direccin leida

        PULB            ; Recuperar registros utilizados
        PULA
        RTS

;*******************
;*  MOVER_BLOQUE   *
;*******************
; Mover un bloque de memoria de una posicn a otra.
; ** ENTRADAS:  X --> Direccin bloque origen
;               Y --> Direccin bloque destino
;               B --> Numero de Bytes a mover
mover_bloque
        PSHA
sig_byte
        CMPB #0     ; Se han transferido todos los bytes?
        BEQ fin_mover_bloque
        LDAA 0,X    ; Mover byte
        INX
        STAA 0,Y
        INY
        DECB        ; Un byte menos por mover
        BRA sig_byte; Mover siguiente byte
fin_mover_bloque
        PULA
        RTS

;*************
;* LEER_DATO *
;*************
; Subrutina para leer un dato del buffer de recepcin.
; Si el buffer de recepcin contiene un dato se devuelve. Si est vaco se
; espera hasta que se llegue uno.
; *** ENTRADAS: Ninguna.
; *** SALIDAS: Registro A contiene dato leido

leer_dato
        PSHY
        CLRA
wait_car
        CMPA CARW       ; Buffer recepcin vaco?
        BEQ wait_car    ; Si--> Esperar hasta que llegue uno

        LDY CBR
        LDAA 0,Y        ; Meter en A el contenido de la cabeza del buffer
        DEC CARW        ; Hay un carcter menos en el buffer

; * Incrementar puntero de cabeza del buffer
        INY
        CPY #FIN_BUF    ; Cabeza ha llega a fin de buffer?
        BNE almac_y     ; No--> Almacenar cabeza
        LDY #BUF_REC    ; Si--> Cabeza apunta al comienzo del buffer
almac_y
        STY CBR         ; Almacenar cabeza del buffer

        PULY            ; Recuperar valor antiguao de Y
        RTS             ; Fin de la subrutina

; ****************
; * ENVIAR_DATO  *
; ****************
; Mandar un dato por el SCI.
; ** ENTRADAS: Acumulador A contiene el byte a enviar
; ** SALIDAS: Ninguna
; El envo se realiza mendiante "espera activa"
enviar_dato
        LDX #$1000
        BRCLR SCSR,X $80 enviar_dato    ; Esperar hasta que se pueda enviar
        STAA SCDR,X                     ; Mandar dato
        RTS

;**************
;* EVIAR_CAD  *
;**************
; Mandar una cadena por el SCI. La cadena debe finalizar con un 0.
; ENTRADAS:  Y apunta a la cadena a enviar
; SALIDAS:  Ninguna
enviar_cad
        PSHA
next_car
        LDAA 0,Y        ; Meter en A carcter a enviar
        CMPA #0         ; Fin de la cadena?
        BEQ fin_enviar_cad      ; Si--> retornar
        JSR enviar_dato         ; Mandar carcter
        INY
        BRA next_car
fin_enviar_cad
        PULA
        RTS

;**************************************************
;* PRESENTA. Presentacin de la tarjeta trminus  *
;**************************************************
terminus FCC "TERMINUS"
         FCB 0
jj       FCC "J&J Soft-Hard(c)"
         FCB 0
presenta
        LDAA #$0C
        JSR control_display   ; Activar el display
        JSR cls               ; Borrar el display
        LDAA #$04
        LDAB #$01
        JSR locate
        LDY #terminus
        JSR print_cad

        LDAA #$01
        LDAB #$02
        JSR locate
        LDY #jj
        JSR print_cad
        RTS


;****************************************************************************
;*  CONTROL_DISPLAY. Mandar caracteres especiales de control al display     *
;*  ENTRADAS:    A=Carcter de control                                      *
;****************************************************************************
control_display
        PSHB

        LDAB PCR        ; RS=0;
        ANDB #$FD
        STAB PCR

        STAA PORTB      ; Mandar carcter de control.
        LDD #$000B
        JSR wait        ; Esperar hasta que display listo.
        PULB
        RTS

;******************************************************************************
; LOCATE. Situar el "cursor" del display en una posicin determinada.         *
;  ENTRADAS:   Acumulador A: Posicin X  (1-40)                               *
;              Acumualdor B: Posicin Y  (1-2)                                *
;******************************************************************************
; La frmula para calcular la direccin a partir de las coordenadas es:
; Direccin display= $80+(x-1)+$28*(y-1)
locate
        DECB
        DECA
        ADDA #$80
        CMPB #0
        BEQ actualiza
        ADDA #$28
actualiza
        ;TAB
        JSR control_display
        RTS

;******************************************************************************
; PRINT_CAD. Rutina para imprimir una cadena en el display.                   *
;       ENTRADAS:  Y --> Apunta a la cadena a imprimir. Debe acabar con cero. *
;******************************************************************************
print_cad
        LDAA 0,Y
        CMPA #0
        BEQ fin_print
        JSR print_car
        INY
        BRA print_cad
fin_print
        RTS

;*************************************************************************
;* PRINT_CAR. Rutina para imprimir un carcter en el display             *
;*      ENTRADAS:  Registro A --> Carcter a imprimir.                   *
;*************************************************************************
print_car
        PSHB
        LDAB PCR        ; RS=1
        ORB #$02
        STAB PCR

        STAA PORTB      ; Mandar carcter.
        LDD #$000B
        JSR wait        ; Esperar hasta que display listo para sacar el
        PULB
        RTS             ; siguiente caracter
;*****************************************************************************
;* PRINT_NUM.  Imprimir un nmero de tres dgitos decimales en el display    *
;*  El nmero mximo que se puede imprimir es 999.                           *
;*      ENTRADAS: El registro D contiene el nmero a imprimir.               *
;*****************************************************************************
print_num
        PSHX
        CLRA
        LDX #100
        IDIV         ; X=D/100, resto en D
        PSHB
        XGDX
        CMPB #0
        BEQ sacar_decenas   ; Si no hay centenas no se imprime nada
        ADDB #'0'
        LDAA #10     ; Imprimir las centenas
        SWI
sacar_decenas
        PULB
        LDX #10
        IDIV
        PSHB
        XGDX
        ADDB #'0'
        LDAA #10     ; Imprimir las decenas
        SWI
        PULB
        ADDB #'0'
        LDAA #10     ; Imprimir las unidades
        SWI
        PULX
        RTS
        
;****************************
;* CLS. Limpiar el display. *
;****************************
cls
        LDAA #$01
        JSR control_display

        LDD #$01D0
        JSR wait
        RTS

;*****************************************************************************
;*  Realizar temporizacin para el teclado y el display                      *
;*  ENTRADAS: Registro D es el registro que sirve para temporizar.           *
;*****************************************************************************
wait
        SUBD #1
        BNE wait
        RTS

;**************************************************************************
;*  GET. Esperar hasta que se pulse una tecla en el teclado de TERMINUS y *
;*  devolver su cdigo de tecla                                           *
;*  El cdigo de tecla de devuelve a travs del acumulador                *
;*  Se devuelve el valor $FF cuando el cdigo leido en el teclado no      *
;*    se encuentra en el cdigo de las teclas, es decir, que se ha leido  *
;*    un "rebote"                                                         *
;**************************************************************************
teclas DB $57,$BC,$BD,$BE,$BB,$B8,$B9,$7F,$77,$67,$BF,$BA,$CF,$47,$5F,$4F
;codigo:   0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15

get     LDAA PORTA             ; Mira el valor del puerto
	CMPA #$FF              ; Si se presiono una tecla...
        BEQ  get
        ;-- Buscar la tecla pulsada en la tabla y devolver el cdigo de tecla
        TAB
        CLRA
        LDY #teclas     ; Y puntero a la tabla de teclas
sig_tecla
        CMPB 0,Y            ; Cdigo devuelto igual al actual?
        BEQ fin_sig_tecla   ; Si --> devolver tecla
        INCA
        INY
        CMPA #16
        BNE sig_tecla
        LDAA #$FF
fin_sig_tecla
        PSHA
        LDD #$FFFF
        JSR wait            ; Eliminar rebotes
        PULA
	RTS

; **********************************************************************
; *   S E R V I C I O S    P A R A   L A S   A P L I C A C I O N E S   *
; **********************************************************************
; Los servicios de aplicacion son los servicios que realiza GAIA para
; los programas de aplicacin. Estos son:
;       --> Terminar programa
;       --> Punto de ruptura (BREAK-POINT)
;       --> leer un byte del SCI
;       --> mandar un byte por el SCI
;       --> Mandar una cadena por el SCI

;********************************
;*  RUTINA DE SERVICIO DEL SCI  *
;********************************
; Slo est activada la interrupcin de datos recibidos, por lo que si se
; produce una interrupcin del SCI slo es debida a que ha llegado un
; carcter.

; ----- VARIABLES
BUF_REC         RMB TAM_BUF_REC     ; Buffer de recepcin de datos
FIN_BUF         FCB  0              ; Final buffer de recepcin
CBR             DW  1               ; Cabeza buffer de recepcin
TBR             DW  1               ; Cola buffer de recepcin
CARW            DB  1               ; Caracteres recebidos en el buffer

; ----- RUTINA DE SERVICIO
RSI_recibir
; *** Con las 2 sig. instrucciones se pone el flag de int. a cero
        LDX  #$1000
        LDAA SCSR,X     ; Leer registro de estado
        LDAB SCDR,X     ; Leer dato recibido

        LDY TBR             ; Y apunta a la cola del buffer.
        LDAA CARW
        CMPA #TAM_BUF_REC   ;  Buffer lleno ?
        BEQ Fin_recibir     ; Si--> No se almacena carcter recibido
        STAB 0,Y            ; No--> Almacenar carcter recibido

        INC CARW            ; Hay un carcter ms en el buffer
        INY
        CPY #FIN_BUF        ; Cola al final del buffer?
        BNE alm_Y           ; No--> Almacenar cola actual
        LDY #BUF_REC        ; Si--> La cola apunta al comienzo del buffer

alm_Y   STY TBR             ; Actualizar puntero de cola
Fin_recibir
        RTI                 ; Fin rutina de servicio

; ******************************************************
; *  RUTINA DE SERVICIO DE LA INTERRUPCION SOFTWARE    *
; ******************************************************
; Por el acumulador A se solicita un servicio determinado. Esta rutina
; bifurca a la subrutina adecuada segn el valor del acumulador A

;** Tabla con las direcciones de los servicios
;           -- Servicios de control y de comunicaciones serie (0-4)
tabla_serv  DW end_prog,break_point,leer_byte,enviar_byte,enviar_string

;           -- Servicios no utilizados (5-9)
            DW no_serv,no_serv,no_serv,no_serv,no_serv

;           -- Servicios para el display (10-15)
            DW sacar_car,print,control_disp,cls_disp,locate_disp,print_num_disp

;           -- Servicios no utilizados (16-19)
            DW no_serv,no_serv,no_serv,no_serv

;           -- Servicios para el teclado (20)
            DW get_tec

RSI_soft
        CLI             ; Activar las interrupciones

        PSHB
        ; -- Meter en X la direccin de la rutina de servicio
        LDX #tabla_serv ;
        ASLA
        TAB             ;
        ABX             ;  X = #tabla_serv + 2*A


        LDX 0,X         ; Cargar en X la direccin de la rutina de servicio
        PULB
        JMP 0,X         ; Saltar a la rutina de servicio correspondiente

no_serv RTI             ; Terminar. Se ha solicitado un servicio que no existe

;**********************************************************************
;* END_PROG.  Terminar un programa. Numero de servicio: 0             *
;**********************************************************************
; Se sacan los registros de la pila. La pila queda igual que estaba antes
; de que se ejecutase el programa.
end_prog
;****** Sacar todos los registros de la pila ****

        DEC progp        ; Un programa pendiente menos.
        PSHA
        PSHB
        LDD #$FFFF       ; Hacer una pequea pausa antes de devolver control
        JSR wait
        PULB
        PULA
        LDX #$1000       ; Mandar seal de break.
        BSET SCCR2,X $01 ;
        BCLR SCCR2,X $01 ; Quitar seal break.

        TSX
        LDAB #9          ; De la pila hay que sacar 9 bytes
        LDY #0           ; a partir de la direccion $0000
        JSR mover_bloque

        TSX              ; Actualizar la pila
        XGDX
        ADDD #8
        XGDX
        STX reg_SP       ; Almacenar el valor de SP actualizado

        JMP mec

;**********************************************************************
;* BREAK_POINT.  Punto de ruptura en un programa. Servicio: 1         *
;**********************************************************************
; Se salvan todos los registros de la pila en memoria y se pasa el control
; al mec. Para que el programa interrumpido se vuelva a ejecutar se tiene
; que recibir la orden "continuar ejecutando programa" procedente del
; programa maestro.

break_point
;****** Se "copia" la pila a partir de la direccin $0000 *****
        PSHA
        PSHB
        LDD #$FFFF       ; Hacer una pequea pausa antes de devolver control
        JSR wait
        PULB
        PULA
        LDX #$1000       ; Mandar seal de break.
        BSET SCCR2,X $01 ;
        BCLR SCCR2,X $01 ; Quitar seal break.
        TSX
        LDAB #9          ; De la pila hay que sacar 9 bytes
        LDY #0           ; a partir de la direccion $0000
        JSR mover_bloque
        STS reg_SP
        JMP mec

;**********************************************************
;* LEER_BYTE. Leer un byte por el SCI. Servicio: 2        *
;*  SALIDAS: El byte leido se devuelve en el acumulador A *
;**********************************************************
; Se lee un byte procedente del SCI.
leer_byte
        JSR leer_dato   ; Leer dato del SCI
        TSX
        STAA 2,X        ; Guardar byte leido en la pila
        RTI             ; Volver al programa de aplicacin

;*****************************************************************
;* ENVIAR_BYTE. Mandar un byte por el SCI. Servicio: 3           *
;*   ENTRADAS:  Acumulador B: byte a enviar                      *
;*****************************************************************
enviar_byte
        TBA             ; Meter dato a enviar en el registro A
        JSR enviar_dato ; Mandar dato
        RTI             ; Volver al programa de aplicacin

;******************************************************************
;* ENVIAR_STRING. Mandar una cadena por el SCI. Servicio: 4       *
;*  ENTRADAS: Registro Y: Apunta a la cadena a enviar. La cadena  *
;*            debe acabar con el carcter 0                       *
;******************************************************************
; Se enva una cadena por el SCI. La cadena debe terminar con el carcter 0.
enviar_string
        JSR enviar_cad
        RTI

;******************************************************************
;*     S E R V I C I O S   P A R A   E L   D I S P L A Y          *
;******************************************************************

;****************************************************************
;* SACAR_CAR. Imprimir un carcter en el display. Servicio 10   *
;*  ENTRADAS: Acumulador B: Carcter a imprimir.                *
;****************************************************************
sacar_car
        TBA
        JSR print_car
        RTI

;******************************************************************************
; PRINT. Rutina para imprimir una cadena en el display. Servicio 11           *
;       ENTRADAS:  Y --> Apunta a la cadena a imprimir. Debe acabar con cero. *
;******************************************************************************
print
        JSR print_cad
        RTI

;*************************************************************************
;* CONTROL_DISP. Enviar un cdigo de control al display. Servicio 12     *
;*   ENTRADAS: B cdigo de control.                                      *
;*************************************************************************
control_disp
        TBA
        JSR control_display
        RTI

;**********************************************
;* CLS_DISP. Limpiar el display. Servicio 13  *
;**********************************************
cls_disp
        JSR cls
        RTI
;***************************************************************************
;* LOCATE_DISP. Situar el cursor en una posicin del display. Servicio 14  *
;*  ENTRADAS: Byte alto registro Y : Posicin X (1-40)                     *
;*            Byte bajo registro Y : Posicin Y (1-2)                      *
;***************************************************************************
locate_disp
        XGDY
        JSR locate
        RTI
;****************************************************************************
;* Print_num_disp. Imprimir un nmero de 3 dgitos decimales. Servicio 15   *
;*  ENTRADAS: Y nmero a imprimir                                           *
;****************************************************************************
print_num_disp
        XGDY
        JSR print_num
        RTI

;*****************************************************************************
;*        S E R V I C I O S   P A R A   E L   T E C L A D O                  *
;*****************************************************************************

;*****************************************************************************
;*  GET_TEC.  Esperar hasta que se pulse una tecla en el teclado de TERMINUS.*
;*  SERVICIO 20                                                              *
;*  SALIDAS: Se devuelve en el acumulador el cdigo de la tecla pulsada      *
;*****************************************************************************
get_tec
        JSR get
        TSX
        STAA 2,X        ; Guardar byte leido en la pila
        RTI             ; Volver al programa de aplicacin

        END


