/************************************************************************/
/*  MICROBOTICA S.L.                                   SEPTIEMBRE 1999  */
/************************************************************************/
/*                                                                      */
/*   MCBSTRAP. Rutinas para "dialogar" con el programa BOOTSTRAP que    */
/*             se ejecuta en el microcontrolador al arrancar.           */
/*-----------------------------------------------------------------------/
/*                                                                      */
/************************************************************************/

#include "fcntl.h"


int wait_reset()
/*********************************************************************/
/*  Esperar a que se pulse el boton de RESET en la placa con el MCU. */
/*  SALIDAS:                                                         */
/*             Se devuelve TRUE si se ha pulsado reset.              */
/*             Se devuelve FALSE si se ha abortado.                  */
/*********************************************************************/
{
  textcolor(10);
  cprintf ("\r\nPulse RESET en el microcontrolador....");
  if (!wait_break()) {
    textcolor(12);
    cprintf("\n\r   ---> ABORTADO <---\n\r");
    textcolor(7);
    return 0;
  }
  vaciar_buffer();
  return 1;
}

void completar(num)
int num;
/*************************************/
/*  Mandar al MCU num caracteres 0.  */
/*************************************/
{
  while (num) {
    enviar(0);
    eco(0);
    cprintf (".");
    num--;
    if (hay_error()) return;
  }
}

void informe_transmision(nbytes)
unsigned int nbytes;
/***************************************************/
/*  Sacar un informe del estado de la transmisin  */
/***************************************************/
{
  textcolor(10);
  cprintf ("\n\rTamao del programa: ");
  textcolor(15);
  cprintf ("%d Bytes",nbytes);
  textcolor(10);
  cprintf ("\n\rEstado transmisin : ");
  textcolor(15);
  cprintf ("ENVIO CORRECTO");
  textcolor(10);
  cprintf ("\n\rMicrocontrolador   : ");
  textcolor(15);
  cprintf ("EJECUTANDO PROGRAMA\r\n\n");
  textcolor(7);
}

unsigned int mandar_programa(f)
int f;
/********************************************************************/
/*  Mandar un programa al MCU. El fichero debe poseer el handle f.  */
/*  El MCU debe estar en modo BOOTSTRAP y el programa se carga      */
/*  en la memoria RAM interna                                       */
/*  	Se devuelve el nmero de bytes transferidos en caso de que  */
/*  el envo haya sido correcto.                                    */
/********************************************************************/
{
  unsigned short int tam;
  unsigned short int datos[40];
  unsigned int   direccion=0;
  unsigned int   dirini=0;
  unsigned int   totalb=0;
  unsigned short int dir[3];
  int  tipo;


  enviar(0xff);        /* Enviar carcter $FF         */

  do {
    tipo=leer_bloque_s19(f,&tam,datos,dir);  /* Leer un bloque */

    if (tipo==0) {  /* Si hay un error en la transmisin del bloque se  */
      return 0;     /* aborta el programa                               */
    }

 /***** Enviar bloque del tipo 1 *****/

    if (tipo==1) {
      direccion=256*dir[1]+dir[0];       /* Calcular direccin */
	  if (direccion>0x01FF || (direccion+tam)>0x01FF) {
		set_error(7);              /* Desbordamos la RAM interna  */
		return 0;
	  }
	  if (direccion<dirini) {
		set_error(6);              /* Hay un conflicto en directivas. ORG */
		return 0;
	  }
	  if (direccion>dirini) {
		completar(direccion-dirini);
		dirini=direccion;
	  }

      enviar_cad_eco(datos,tam,1); /* Enviar los datos por el puerto serie */
	  dirini=direccion+tam;        /* Dirini apunta a la direccin siguiente   */
								   /* al bloque que se acaba de introducir     */
	  totalb+=(unsigned int)tam;   /* Incrementar n totales de bytes mandados */
	}
  } while(tipo==1); /* Mientras haya bloques de tipo S1 seguir mandando */

  if (dirini<512)
	completar(512-dirini);  /* Completar con ceros lo que falta    */

  return totalb;
}

int modo_boot()
/***************************************************************************/
/*  Cargar un programa en la RAM interna del MCU                           */
/*  Se devuelve TRUE si el programa se ha cargado, FALSE en caso contrario */
/***************************************************************************/
{
   int f;
   unsigned int nbytes; /* Nmero de bytes transferidos */

   textcolor(10);
   cprintf("\n\rCargar programa en RAM ");
   textcolor(14);
   cprintf("INTERNA");
   if ( (f=abrir_fichero_s19())==0 ){
     textcolor(12);
     cprintf ("   ---> ABORTADO <---\n\r");
     textcolor(7);
     return 0;
   }

   if (!wait_reset())  /* Esperar hasta que se pulse RESET */
    return 0;          /* Si se pulsa ENTER se aborta      */

  cprintf ("\n\rTransmitiendo: ");
  nbytes=mandar_programa(f);
  close(f);
  if (!hay_error()) {                 /* Si no ha habido errores...  */
    informe_transmision(nbytes);
    textcolor(7);
    return 1;
  } else {
    textcolor(7);
    return 0;
  }
}

int cargar_loader()
/**************************************************/
/*  Cargar el loader en la memoria RAM interna    */
/**************************************************/
{
  int f;

  if ((f=open("LOADER.S19",O_RDONLY))==-1) {
     set_error(8);
     return 0;
   }

   if (!wait_reset())  /* Esperar hasta que se pulse RESET */
    return 0;          /* Si se pulsa ENTER se aborta      */

  mandar_programa(f);   /* Cargar el LOADER        */
  if (hay_error()) {
    return 0;
  }
  close(f);
  return 1;
}

int modo_expanded()
/******************************************************/
/*  Cargar un programa en la RAM externa              */
/*  Primero se carga el LOADER en el MCU              */
/*  Despus se "dialoga" con el y se carga el         */
/*  programa seleccionado en la memoria externa       */
/*  Se devuelve FALSE si no se ha cargado programa.   */
/*  TRUE en caso contrario.                           */
/******************************************************/
{
   int f2;
   int f;
   unsigned int nbytes; /* Nmero de bytes transferidos */

   textcolor(10);
   cprintf("\n\rCargar programa en RAM ");
   textcolor(14);
   cprintf("EXTERNA");
   if ( (f=abrir_fichero_s19())==0 ) {
     textcolor(12);
     cprintf ("   ---> ABORTADO <---\n\r");
     textcolor(7);
     return 0;
   }

  if (!cargar_loader()) {   /* Cargar el loader */
    if (hay_error()) {
      return 0;
    }
    else return 0;
  }

  baudios(9600);
  textcolor(10);
  cprintf("\n\rBloques transferidos:    ");
  nbytes=load_expanded(f);     /* Cargar fichero f1 en modo RAM externa */
  close(f);
  if (!hay_error()) {
     delay(1000);
     informe_transmision(nbytes);
     return 1;
  }
  textcolor(7);
  return 0;
}

