/*************************************************************************/
/*                                                                       */
/* J&J Soft-Hard Company. ETSI Telecomunicacin. Mayo 1995               */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/*  MCBS19. Mdulo que se encarga de procesar ficheros en el formato     */
/*          .S19 de Motorola.                                            */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  FORMATO .S19 DE MOTOROLA:                                            */
/*                                                                       */
/*     Los formatos .Sxx de Motorola sirven para codificar programas     */
/*  en cdigo mquina de forma que se puedan editar mediante un editor   */
/*  ASCII estndar. Est compuesto por lneas que cominezan con el       */
/*  carcter S. Los bytes se representan mediante 2 dgitos hexadecima-  */
/*  les. Cada lnea, denominada bloque, contiene una serie de campos.    */
/*                                                                       */
/*     El primer campo est formado por el carcter S y un byte (2 carac-*/
/*  teres) que indican el tipo de bloque. Hay dos tipos de bloque, el    */
/*  S1 y el S9.                                                          */
/*                                                                       */
/*     Bloque S1:                                                        */
/*                                                                       */
/*     Contiene los siguientes campos: N de bytes, Direccin, Datos y   */
/*  un byte de checksum. El campo N de bytes indica la cantidad de      */
/*  bytes que componen el bloque. Est formado por 1 byte.               */
/*	El campo Direccin contiene la direccin de memoria donde situar */
/*  los datos. Est formado por 2 bytes (4 caracteres)                   */
/*	El campo Datos contiene una cantidad de datos que nunca es mayor */
/*  de 32 bytes (64 caracteres).                                         */
/*  	El campo checksum es un byte que sirve para comprobar si el      */
/*  bloque se ha transferido correctamente.                              */
/*                                                                       */
/*     Bloque S9:                                                        */
/*                                                                       */
/*  	Contiene los bloques: N de bytes, Direccin y checksum. El      */
/*  n de bytes indica los bytes del bloque, que en total ser 2 bytes   */
/*  para la direccin y 1 para el checksum.                              */
/*      El campo Direccin contiene una direccin (2 bytes) de comienzo  */
/*  del programa.                                                        */
/*      El checksum funciona igual que en los bloques S1.                */
/*                                                                       */
/*     En el MC-BOOT los bloques S9 se tomarn como final del fichero.   */
/*  La direccin de arranque del programa no se toma de este bloque sino */
/*  que se toma de direccin del primer bloque S1.                       */
/*                                                                       */
/*     Las direcciones, que son de 2 bytes, se guardan con el byte       */
/*  ms significativo primero y con el menos despus.                    */
/*                                                                       */
/*                                                                       */
/*************************************************************************/

#include "fcntl.h"


/************************************/
/*  RUTINAS DE CONVERSION DE DATOS  */
/************************************/


int hextoint(car,dec)
char car;
unsigned short int *dec;
/**********************************************************************/
/*  Esta funcin toma un carcter hexadecimal en ASCII y lo convierte */
/*  a un nmero entero.                                               */
/*                                                                    */
/*     La funcin devuelve 0 si el carcter no es un dgita en hexa-  */
/*  decimal. Devuelve un 1 en caso contrario.                         */
/**********************************************************************/
{
  if (car>='0' && car<='9')
      *dec=car-'0';
  else if (car<='F' && car>='A')
      *dec=car-'A'+10;
    else return 0;        /*  El dgito no est en hexadecimal  */

  return 1;	      	      /*  No ha habido errores              */
}


int cadtoint(cad,dec)
char *cad;
unsigned short int *dec;
/***********************************************************************/
/*  Toma una cadena de 2 dgitos en hexadecimal y los convierte en un  */
/*  nmero entero.                                                     */
/*                                                                     */
/*    La funcin devuelve 0 si existe algn dgito en la caden que no  */
/*  es hexadecimal. Se devuelve 1 en caso contrario.                   */
/***********************************************************************/
{
  unsigned short num1,num2;

  if (hextoint(cad[0],&num1))	 /* Si se convierte bien el primer digito.. */
    if (hextoint(cad[1],&num2)){ /* y se convierte bien el segundo...       */
      *dec=num1*16+num2;         /* Se calcula en numero en decimal         */
      return 1;
    }
  return 0;           /* Ha habido algn error en la conversin */
}


void getch2(f,cad)
int  f;
char *cad;
/**************************************************************/
/*  Se leen 2 caracteres del fichero de Handle f y se meten   */
/*  en la cadena cad.                                         */
/**************************************************************/
{
  if (read(f,cad,2)==-1)
	set_error(5);             /* Error leyendo el fichero */
  cad[2]='\0';
}

unsigned short int getbyte(f)
int f;
/************************************************************************/
/*  Leer un entero del fichero de handle f. Se leen 2 digitos ascii en  */
/*  hexadecimal y se devuelve su valor entero                           */
/*   Si se leyeron dgitos incorrectos se produce un mensaje de error   */
/************************************************************************/
{
  char cad[3];
  unsigned short int num=0;

  getch2(f,cad);
  if (!cadtoint(cad,&num)) {
       set_error(1);        /* Si se produce error en la conversin se aborta */
       return 0;
  }

  return num;
}

void extension(fich)
char *fich;
/**************************************************************************/
/*  Comprobar la extension del fichero. Si no tiene extensin por defecto */
/*  se aade .S19                                                         */
/**************************************************************************/
{
  int i;

  i=0;
  while (fich[i]!='.' && fich[i]!=0)  /* Recorrer la cadena buscando un . */
    i++;

  if (fich[i]==0) {     /* no tiene extensin. Hay que aadirla  */
    fich[i]='.';
    fich[i+1]='S';
    fich[i+2]='1';
    fich[i+3]='9';
    fich[i+4]=0;
  }

}

int abrir_fichero_s19()
/***********************************************************************/
/*  Se abre un fichero y se devuelve su handle correspondiente.        */
/*  Se pide constantemente hasta que el nombre sea correcto o se       */
/*  pulse la tecla enter para abortar. Si no se introduce extensin    */
/*  por defecto se toma .S19.                                          */
/***********************************************************************/
{
  char cad[511];
  int f;

  do {
    textcolor(11);
    cprintf ("\n\rNombre del fichero: ");
    textcolor(7);
    gets(cad);
    if (cad[0]=='\0') return 0;
    extension(cad);              /* Comprobar la extensin del fichero */
    if ((f=open(cad,O_RDONLY))==-1) {
      textcolor(12);
      cprintf ("   ---> Fichero no encontrado <---\n\r");
      textcolor(7);
    }
  } while (f==-1);
  return f;

}

int leer_bloque_s19(f,ndatos,buf_datos,dir)
int f;
unsigned short int *ndatos;
unsigned short int *buf_datos;
unsigned short int *dir;
/*********************************************************************/
/*  Leer un bloque del fichero de handle f, que est formato .S19    */
/*                                                                   */
/*  ENTRADAS:   f --> Handle del fichero del que leer el bloque      */
/*                                                                   */
/*  SALIDAS:  La funcin devuelve los siguientes valores:            */
/*            0 --> No se ha leido un fichero en formato .S19        */
/*            1 --> Se ha leido un bloque tipo S1                    */
/*            9 --> Se ha leido un bloque tipo S9                    */
/*                                                                   */
/*     Si el bloque que se ha leido es del tipo S1 se devuelve       */
/*  adems lo siguiente:                                             */
/*                                                                   */
/*         ndatos--> Numero bytes contenidos en el campo de datos    */
/*         buf_datos --> Array de bytes que contiene los bytes del   */
/*                       campo datos.                                */
/*         dir--> Array de bytes, cuyos dos primeros bytes son el    */
/*                byte bajo y alto de la direccin en la que se van  */
/*                a situar los datos                                 */
/*                                                                   */
/*     Si el bloque leido es del tipo S9 se devuelve:                */
/*                                                                   */
/*        ndatos=0; buf_dato=cadena vacia; dir=cadena vacia          */
/*                                                                   */
/*********************************************************************/
{
  char cad[3];
  unsigned short int tam;
  char i=0;

  *ndatos=0;
  buf_datos[0]=0;
  dir[0]=0;

  getch2(f,cad);       /* Leer tipo de bloque: S1  S9     */
  if (cad[0]!='S') {
    set_error(2);      /* No es formato .S19 de motorola   */
    return 0;
  }

  if (cad[1]=='9')     /* Si se trata de un bloque tipo S9 */
    return 9;

  if (cad[1]!='1') {   /* No se trata de un bloque tipo S9  S1 */
    set_error(2);      /*  No es formato .S19 de motorola!!   */
    return 0;
  }

  /* Se trata de un bloque tipo S1 */


  tam=getbyte(f);      /* Leer tamao en bytes del bloque completo       */
  *ndatos=tam-3;       /* Bytes del campo datos=Bytes totales-2 bytes de */
		       /*  la direccin y 1 byte del checksum            */

  tam=tam-3;

  dir[1]=getbyte(f);   /* Leer byte alto direccin   */
  dir[0]=getbyte(f);   /* Leer byte bajo direccin   */
  dir[2]=0;            /* Delimitar fin de la cadena */

  while (tam) {                 /* Mientras haya caracteres en el bloque */
    buf_datos[i++]=getbyte(f);  /* Almacenar dato del bloque             */
    tam--;
  }
  buf_datos[i]=0;      /* Delimitar fin cadena de datos          */
  getbyte(f);          /* Leer byte de checksum que se desprecia */
  getch2(f,cad);       /* Leer carcter CR y LF                  */

  return 1;

}

