; ************************************************************************
; *  J&J Sorf-Hard company. Comenzando una nueva era... Mayo 1995        *
; ************************************************************************
; *   LOADER  para TERMINUS                                              *
; ------------------------------------------------------------------------
; *  Este programa se carga en el MCU en la RAM interna. Mediante un     *
; *  determinado protocolo se comunica con el programa MC-BOOT,          *
; *  tambin desarrollado por ingenieros de J&J. El MC-BOOT le trans-    *
; *  mite el programa a cargar al MCU.                                   *
; ************************************************************************

; ****** Registros del SCI *******
BAUD    equ  $2B
SCCR1   equ  $2C
SCCR2   equ  $2D
SCSR    equ  $2E
SCDR    equ  $2F

HPRIO   equ $3c           ; Para configurar modo funcionamiento MCU
PORTA   equ  $00          ; Puerto de datos A
TMSK2   EQU  $24

        ORG 0             ; El LOADER comienza en la RAM interna

; ***** INICIALIZACION *****
        LDX #$1000         ; Para acceder a los registros de control

        LDY #$FFFF         ; Bucle de esperar antes de cambiar la
espera  DEY                ; velocidad de transmisin a 9600 baudios.
        CPY #0
        BNE espera

        LDAA #$30
        STAA BAUD,X        ; Velocidad transmisin: 9600 Baudios.

        LDAA #'#'
        BSR enviar

;       BSET TMSK2,X $03   ; @ -Prueba-

        BCLR HPRIO,X $80   ; Desactivar el Bootstrap del mapa de memoria
        BSET HPRIO,X $20   ; Pasar a modo expandido
        BCLR HPRIO,X $40   ; Ya no estamos en un modo especial.

wait    BSR leer
        CMPA #$FF         ; Esperar hasta recibir carcter $FF del
        BNE wait          ; MC-BOOT
        BSR enviar        ; Hacer eco del carcter $FF

; ***** BUCLE PRINCIPAL *********
sig     BSR eco           ; Esperar un byte por el SCI
        CMPA #1           ; Si byte recibido = 1 ...
        BEQ bloque        ; ... ejecutar programa
        CMPA #2           ; Si byte recibido = 2 se carga un bloque
        BEQ run
        BNE error         ;  Hay un error !!

; ***** RECIBIR UN BLOQUE *******
bloque  BSR leer_dir      ; Leer direccin de memoria. Se mete en Y
        BSR eco           ; Leer n bytes del bloque
        TAB               ; B=n bytes a meter en memoria
bucle   CMPB #0           ; Se han recibido todos los bytes?
        BEQ sig           ; Si--> leer el siguiente bloque
        BSR eco           ; NO-->....leer dato
        STAA 0,Y          ; Almacenar dato en memoria
        INY               ; Apuntar sig. posicion de memoria
        DECB              ; Queda un byte menos por recibir
        BRA bucle

; ***** EJECUTAR PROGRAMA *******
run     BSR leer_dir      ; Leer direccin donde comienza programa

        PSHY
        LDY #$FFFF         ; Bucle de esperar antes de ejecutar el programa
espera1 DEY
        CPY #0
        BNE espera1
        PULY

        JMP 0,Y           ; Ejecutar programa

;*******************************************************************
;*  Subrutina para leer una direccin por el puerto serie (SCI).   *
;*    ENTRADAS:  NINGUNA                                           *
;*    SALIDAS:  Registro Y contiene la direccin leida             *
;*******************************************************************
leer_dir  BSR eco         ; Leer byte bajo direccin.
          TAB             ; B = Byte bajo de la direccin.
          BSR eco         ; A = Byte alto de la direccin.
                          ; D = direccin recibida
          XGDY            ; Intercambiar D con Y
          RTS             ; Ahora Y contiene direccin leida

; *********************************************************************
; *  Se ha producido un error. El MCU esperaba un 1  un 2 y  se ha   *
; *  recibido otro carcter: ---> El MC-BOOT tiene un error           *
; *  Este procedimiento se utiliza para depuracin.                   *
; *********************************************************************
error     LDY #mens
          BSR send_cad
inf       BRA inf

; **********************************************************************
; * Rutinas de comunicaciones a travs del SCI. Para ms informacin   *
; *  ver el programa SCI.ASM tambin desarrollado por J&J company      *
; **********************************************************************

; ***********************************************************
; *  Rutina para leer un carcter del puerto serie (SCI)    *
; *  La rutina espera hasta que llega algn carcter        *
; *  ENTRADAS: Ninguna                                      *
; *  SALIDAS: El acumulador A contiene el carcter recibido *
; ***********************************************************

leer    BRCLR SCSR,X $10 leer   ; Esperar hasta que llegue un carcter
        LDAA SCDR,X
        RTS

; **********************************************************
; *  Esperar hasta que se reciba un carcter y hacer eco   *
; **********************************************************
eco     BSR leer
        BSR enviar
        RTS

; ******************************************************************
; *  Enviar un carcter por el puerto serie (SCI).                 *
; *  ENTRADAS: El acumulador A contiene el carcter a enviar       *
; *  SALIDAS: Ninguna                                              *
; ******************************************************************
enviar  BRCLR SCSR,X $80 enviar
        STAA SCDR,X
        RTS

; *********** Enviar una cadena ***************************
send_cad LDAA 0,Y        ; Meter en A el carcter a enviar
         CMPA #0         ; Fin de la cadena?
         BEQ fin         ; Si--> retornar
         BSR enviar      ; NO--> enviar carcter.
         INY             ; Apuntar a la sig. posicin de memoria
         BRA send_cad    ; Repetir todo
fin      RTS

mens     FCC "  LOADER:  Se ha producido un ERROR !!"
         DB 0

        END

