/*
   ͻ
                                                                           
    DOWN-MCU. (C) GRUPO J&J. Noviembre 1996                                
                                                                           
   ͹
                                                                           
     Rutinas de comunicaciones serie mediante ESPERA ACTIVA.               
                                                                           
     Las comunicaciones se pueden realizar a 1200, 7680  9600 BAUDIOS     
    que son las nicas compatibles con el 68HC11 con un cristal de cuarzo  
    de 8MHZ. El formato serie es: 8bits de datos, 1 bit de STOP y ningn   
    bit de paridad.                                                        
                                                                           
   ͼ
									   */
#define COM1  0x3f8   /* Direccin base de la Uart para com1  */
#define COM2  0x2f8   /* Direccin base de la Uart para com2  */
#define COM3  0x3e8   /* Direccin base de la Uart para com3  */
#define COM4  0x2e8   /* Direccin base de la Uart para com4  */


/***************************************************************************/
/*                                                                         */
/*      Breve descripcion de los registros de la UART                      */
/*   Para mas informacion:                                                 */
/*                                                                         */
/*       - Pag 256, "COMUNICACIONES SERIE". Joe Campbell. Ed. Anaya        */
/*                                                                         */
/***************************************************************************/
/*                                                                         */
/*    1.- Registro de DATOS: Utilizado para Leer-mandar BYTES              */
/*         (Offset 0) (Lectura-escritura)                                  */
/*                                                                         */
/*    2.- Registro de ACTIVACION DE INTERRUPCIONES (Offset 1)              */
/*        * Se produce interrupcin cuando se activen los bits:            */
/*            -0 : Dato recibido.                                          */
/*            -1 : Buffer transmision vacio. (listo para enviar)           */
/*            -2 : Seal de BREAK detectada.                               */
/*            -3 : Entrada RS-232-> se genera una interrupcin cuando      */
/*                 cambia el estado de cualquiera de los estados del RS-232*/
/*            -4-7: Siempre a cero.                                        */
/*                                                                         */
/*    3.- IDENTIFICACION DE INTERRUPCION: Indican la interrupcin que est */
/*         pendiente: (Offset 2)                                           */
/*             Bit 2    Bit 1   Bit 0                                      */
/*               0        0       1    => No hay interrupcion pendiente    */
/*               0        1       0    => Buffer transmision vacio         */
/*               1        0       0    => Dato recibido                    */
/*               1        1       0    => BREAK                            */
/*               0        0       0    => Entrada RS-232                   */
/*                                                                         */
/*                                                                         */
/*    4.- Registro CONTROL DE LINEA: Formato de datos: (offset 3)          */
/*                                                                         */
/*          Numero de bits de datos:                                       */
/*           Bits 1  Bit 0                                                 */
/*             0       0     ==> 5 bits de datos                           */
/*             0       1     ==> 6  "       "                              */
/*             1       0     ==> 7  "       "                              */
/*             1       1     ==> 8  "       "                              */
/*                                                                         */
/*          Numero de Bits de STOP:                                        */
/*           Bit 2                                                         */
/*            0              ==> 1 Bit de STOP                             */
/*            1              ==> 2 Bits de STOP                            */
/*                                                                         */
/*          Paridad:                                                       */
/*            Bit 5   Bit 4   Bit 3                                        */
/*              0       0       0   ===> NINGUNA PARIDAD                   */
/*              0       0       1   ===> PARIDAD IMPAR                     */
/*              0       1       1   ===> PARIDAD PAR                       */
/*              1       0       1   ===> MARCA                             */
/*              1       1       1   ===> ESPACIO                           */
/*                                                                         */
/*          Control BREAK:                                                 */
/*            Bit 6                                                        */
/*              0        ==> BREAK Off                                     */
/*              1        ==> BREAK ON                                      */
/*                                                                         */
/*          DLAB  --> Es un truco para utilizar los registros 1 y 2 para   */
/*                    (Datos y activacion interrupciones) para seleccionar */
/*                    la velocidad, cuando este bit esta activo.           */
/*                                                                         */
/*                                                                         */
/*    5.- Registro CONTROL DEL MODEM: Control salida RS-232  (offset 4)    */
/*                                                                         */
/*          Bit 0: Al activarse se activa Data Terminal Ready (DTR)        */
/*          Bit 1: Se activa Request To Send (RTS)                         */
/*          Bit 2: Definible por el usuario                                */
/*          Bit 3: Definible por el usuario                                */
/*          Bit 4: Test local.                                             */
/*          Bits 5-7: Siempre a cero.                                      */
/*                                                                         */
/*    6.- Registro ESTADO DE LINEA: Control estado Serializacin (offset 5)*/
/*                                                                         */
/*          Bit 0: Dato listo. (esperando a ser leido)                     */
/*          Bit 1: Error de sobreescritura.                                */
/*          Bit 2: Error de Paridad                                        */
/*          Bit 3: Error de Trama                                          */
/*          Bit 4: Deteccin de BREAK                                      */
/*          Bit 5: Buffer transmisin vacio                                */
/*          Bit 6: Transmisor vacio                                        */
/*          Bit 7: Siempre a cero                                          */
/*                                                                         */
/*    7.- Registro ESTADO DEL MODEM: (entrada RS-232)                      */
/*                                                                         */
/*          Bit 0: Delta CTS: Clear To Send.                               */
/*          Bit 1: Delta DSR: Data Set Ready                               */
/*          Bit 2: Delta RI : Ring Indicator.                              */
/*          Bit 3: Delta DCD: Data Carrier Detect.                         */
/*                                                                         */
/*          Bit 4: CTS                                                     */
/*          Bit 5: DSR                                                     */
/*          Bit 6: RI                                                      */
/*          Bit 7: DCD                                                     */
/*                                                                         */
/*          Los bits donde pone delta indican que se ha producido un       */
/*        desde la ultima vez que se leyo el registro. (0-3). Los bits 4-7 */
/*        indican el estado "absoluto" de las lineas RS-232.               */
/*                                                                         */
/***************************************************************************/


/*
Ŀ
                                                                          

*/

/*		 Ŀ
 Ĵ DEFINICIONES   
		                */



#define COM1  0x3f8   /* Direccin base de la Uart para com1  */
#define COM2  0x2f8   /* Direccin base de la Uart para com2  */
#define COM3  0x3e8   /* Direccin base de la Uart para com3  */
#define COM4  0x2e8   /* Direccin base de la Uart para com4  */

/*    OFFSET de los registros UART:  */

#define datos            0   /* Registro de datos                        */
#define act_interrup     1   /* Registro activacion interrupciones       */
#define ident_interrup   2   /* Registro indentificacin interrupciones  */
#define control_linea    3   /* Registro Control de linea                */
#define control_modem    4   /* Registro Control de modem                */
#define estado_linea     5   /* Registro Estado de Linea                 */
#define estado_modem     6   /* Registro Estado del Modem                */

#define N81     0x03     /* Mscara para configurar la UART con el       */
			 /* formato: 8bits de datos, 1 STOP y no paridad */

/*		 Ŀ
 Ĵ VARIABLES GLOBALES 
		                */


int puerto_actual=COM1;  /* Puerto Actual. Por defecto COM1 */


void baudios(baud)
int baud;
/*
Ŀ
                                                                          
 Establecer la velocidad de transmision de datos. Las velocidades que se  
 pueden seleccionar son 1200, 7680 y 9600.                                
                                                                          
  En caso de que baud no sea ningn valor de los anteriores se toma el    
 valor por defecto de 7680                                                
                                                                          

*/

{
  unsigned char ba=0,bb=0x60;  /*  Byte alto y byte bajo  */
  unsigned char control;

  switch(baud){
    case 1200 : ba=0x00; bb=0x60; break;
    case 9600 : ba=0x00; bb=0x0f; break;
    case 7680 : ba=0x00; bb=0x0c; break;

    default   : ba=0x00; bb=0x0f; break;
  }

  /* Activar bit 7 del registro de control de linea  */
  outportb(puerto_actual+control_linea,0x80);

  /*  Situar los divisores de velocidad en los registros 0 y 1 de la Uart */
  outportb(puerto_actual+datos,bb);
  outportb(puerto_actual+act_interrup,ba);

  /* Establecer configuracin N81  */
  outportb(puerto_actual+control_linea,N81);

}

void configurar_puerto(puerto)
int puerto;
/*
Ŀ
                                                                          
 Configurar el puerto serie para trabajar con 8 bits de datos, 1 bit de   
 STOP y ningn bit de paridad. La velocidad configurada por defecto es    
 de 7680.                                                                 
                                                                          

*/
{
  /* Por defecto se toma el COM1 */
  switch (puerto) {
    case 1 : puerto_actual=COM1; break;
    case 2 : puerto_actual=COM2; break;
    case 3 : puerto_actual=COM3; break;
    case 4 : puerto_actual=COM4; break;

    default: puerto_actual=COM1;
  }

  /* Activar bit 7 del registro de control de linea */
  outportb(puerto_actual+3,0x80);

  /* Situar en los registros 0 y 1 los divisores de velocidad */
  outportb(puerto_actual+0,0x0F);
  outportb(puerto_actual+1,0x00);   /* 7680 baudios  */

  /* Configuracin para N81 */
  outportb(puerto_actual+3,0x03);

  outportb(puerto_actual+4,0x01);  /* Activar DTR */
}


int listo_enviar()
/*Ŀ
                                                           
   Devuelve TRUE cuando est listo para enviar datos.      
   Para ello se comprueba el bit 0 del registro de estado  
   de linea de la UART.                                    
   */
{
  return inportb(puerto_actual+estado_linea) & 0x20;
}


int car_waiting()
/*Ŀ
                                                           
   Devuelve TRUE si hay un carcter esperando para ser     
   ledo. Para ello se comprueba el bit 0 del registro de  
   estado de linea de la UART.                             
   */
{
  return inportb(puerto_actual+estado_linea) & 0x01;
}

char leer_car()
/*Ŀ
                                                           
   Leer un carcter por el puerto serie. Si no hay ningn  
   caracter esperando se espera hasta que se introduzca    
   alguno.                                                 
   */
{
  while (!car_waiting())  /*  Esperar hasta que se reciba un byte  */
   ;
  return inportb(puerto_actual+datos);
}


void eco(b)
unsigned char b;
/*Ŀ
                                                           
   Comprobar si se recibe el byte b por la lnea serie.    
   Tango si se recibe un byte distinto de b como si pasa   
   un tiempo y no se recibe nada se produce un error.      
   */
{
  unsigned int i=0;
  unsigned char c;

  i=0;    /* contador. Cuando i llegue a 0xffff se produce un error */

  while (!car_waiting()) {
    if (i==0xffff) {
       set_error(3);   /* Error de timeout: no se ha recibido nada */
       return;
    }
    i++;
  }

  c=leer_car();       /* Leer carcter proveniente del eco               */
  if (c!=b) {         /* Si caracter enviado es distinto del recibido:   */
       set_error(4);  /* Error en la transmisin!!!!                     */
  }
}

void enviar(car)
char car;
/*Ŀ
   Enviar un caracter por el puerto serie actual.          
   */
{
  while (!listo_enviar()) /* Esperar hasta que el registro de transmisin  */
  ;                       /*   est vacio                                  */

  outportb(puerto_actual+datos,car);
}

void enviar_cad_eco(cad,nbytes,punto)
unsigned short int *cad;
char nbytes;
int punto;
/*Ŀ
   Enviar nbytes de la cadena cad por el puerto serie.     
   Se espera un "eco" por el puerto serie.                 
   Si punto=0, no se escribe nada en pantalla.             
   Si punto=1 se escribe un carcter por cada byte enviado.
   */
{
  char i=0;

  while (nbytes) {
    enviar(cad[i]);
    eco(cad[i]);

    if (punto) {
      printf (">");
    }

    if (hay_error()) return;   /* Si hay error se aborta */
    i++;
    nbytes--;
  }
}

void enviar_cad(cad,nbytes,punto)
unsigned short int *cad;
char nbytes;
int punto;
/*Ŀ
   Enviar nbytes de la cadena cad por el puerto serie.     
   Se espera un "eco" por el puerto serie.                 
   Si punto=0, no se escribe nada en pantalla.             
   Si punto=1 se escribe un carcter por cada byte enviado.
   */
{
  char i=0;

  while (nbytes) {
    enviar(cad[i]);

    if (punto) {
      textcolor(9);
      cprintf (">");
      textcolor(7);
    }

    if (hay_error()) return;   /* Si hay error se aborta */
    i++;
    nbytes--;
  }
}



int okbreak()
/*Ŀ
   Devuelve TRUE si se detecta la llegada del carcter BREAK 
   */
{
  return inportb(puerto_actual+estado_linea) & 0x10;
}

int wait_break()
/*Ŀ
   Esperar hasta que llegue la seal de BREAK.             
   Se devuelve TRUE si ha llegado BREAK. FALSE si se ha    
   pulsado una tecla                                       
   */
{
  char c;

  while (!okbreak())   /* Si se pulsa una tecla se termina */
    if (kbhit()) {
      getch();
      return 0;
    }
  return 1;
}

void vaciar_buffer()
/*Ŀ
   Limpiar cualquier carcter que pudiese estar pendiente  
   de ser leido.                                           
   */
{
  if (car_waiting())
    leer_car();
}

void dtron()
{
  outportb(puerto_actual+4,0x01);  /* Activar DTR */
}

void dtroff()
{
  outportb(puerto_actual+4,0x00);  /* Desactivar DTR */
}
