/***********************************************************************/
/*                                                                     */
/*  Grupo J&J. Creacin y desarrollo. Noviembre 1996                   */
/*                                                                     */
/***********************************************************************/
/*                                                                     */
/*  ERROR.  Mdulo de gestin de errores del programa DOWNMCU          */
/*                                                                     */
/*---------------------------------------------------------------------*/
/*                                                                     */
/*  Conjunto de procedimientos que permiten al DOWNMCU gestionar los   */
/*  distintos errores que se han producido.                            */
/*                                                                     */
/***********************************************************************/

static unsigned short int nerror=0;    /* Contiene el nmeo de error */

 /*  Tabla con los mensajes de error  */

char num_error[10][255] = {
  {"Digito en hexadecimal incorrecto"},
  {"El fichero no est en el formato .S19 de Motorola"},
  {"El Microcontrolador no hace eco de los bytes enviados"},
  {"Error en la transmisin!!!"},
  {"Error leyendo el fichero"},
  {"Conflicto con las directivas ORG del programa en ensamblador"},
  {"El programa enviado desborda los 256 bytes de RAM del MCU"},
  {"Fichero LOADER.S19 no encontrado"},
};

/**************************************************************************/
/*                                                                        */
/*  Explicacin de los errores:                                           */
/*                                                                        */
/*   1.- Al leer un fichero en formato .S19 se ha encontrado un carcter  */
/*       que no corresponde a ningn dgito exadecimal.                   */
/*                                                                        */
/*   2.- Al leer un fichero en formato .S19 de motorola el comienzo de    */
/*       un bloque es incorrecto. (Un bloque tiene que comenzar con S)    */
/*                                                                        */
/*   3.- En el proceso de carga en el modo bootstrap el MCU ha dejado de  */
/*       hacer eco de los caracteres.                                     */
/*                                                                        */
/*   4.- Se ha mandado un byte al MCU y ste ha hecho un eco de un        */
/*       carcter diferente.                                              */
/*                                                                        */
/*   5.- Se ha producido un error al leer del fichero actual              */
/*                                                                        */
/*   6.- Este error slo se produce en el modo bootstrap. Se ha encontra- */
/*       do una directiva ORG en el fichero en formato .S19 que tiene un  */
/*       valor de direccin menor que la direccin en curso. Por ejemplo  */
/*       el sig. programa cargado en modo BOOTSTRAP en la memoria interna */
/*       del MCU producir error:                                         */
/*                                                                        */
/*         ORG $0050                                                      */
/*         Instrucciones...                                               */
/*         ORG $0020        ---> Error! La direccin tiene que ser       */
/*                               superior a la dir de la ltima instruc.  */
/*                                                                        */
/*   7.- Se ha intentado cargar un programa en la RAM interna de ms de   */
/*       256 bytes, que es el tamao mximo de la RAM. Este error slo se */
/*       produce en el modo BOOTSTRAP.                                    */
/*                                                                        */
/*   8.- Fichero LOADER.S19 no encontrado. No se puede cargar ningn      */
/*       programa en la memoria externa si no se carga primero el progra- */
/*       ma loader que se tiene que encontrar en el mismo directorio que  */
/*       el MCBOOT                                                        */
/*                                                                        */
/*                                                                        */
/**************************************************************************/

void set_error(nerr)
/*********************************************************************/
/*  Establecer nmero de error actual. El error se almacena en la    */
/*  variable global nerror.                                          */
/*********************************************************************/
{
  nerror=nerr;
}

void display_error()
/*************************************************************/
/*  Sacar por pantalla el mensaje de error correspondiente   */
/*  El error activo se desactiva.                            */
/*  Si no hay error no se saca nada.                         */
/*************************************************************/
{
  if (nerror) {
    printf ("\n  ---> ERROR %d: %s\n\r",nerror,num_error[nerror-1]);
    nerror=0;    /* Se desactiva el error */
  }

}

int hay_error()
/********************************************************************/
/*  Si hay un error activo se devuelve true. En caso contrario se   */
/*  devuelve FALSE                                                  */
/********************************************************************/
{
  return (nerror) ? 1 : 0;
}

void clear_error()
/******************************/
/* "Eliminar" error actual    */
/******************************/
{
  nerror=0;
}
