/*
   ͻ
                                                                           
    DOWN-MCU. (C) GRUPO J&J. Noviembre 1996                                
                                                                           
   ͹
                                                                           
     Enviar un programa en formato .S19 a una tarjeta entrenadora basada   
    en el microcontrolador 68HC11 de motorola. Esta estrenadora debe       
    estar configura para poder arrancar en modo bootstrap.                 
                                                                           
       El programa se ha diseado especialmente para trabajar con la       
    entrenadora CT6811 del grupo J&J                                       
                                                                           
   ͼ
									   */

#include "fcntl.h"


const float VERSION = 1.0;
static int puerto=1;
char nomfich[13];	/* Nombre del fichero .S19 a enviar       */
char path[200];		/* Ruta donde encontrar los ficheros .S19 */
char fullfich[213];     /* Nombre fichero + ruta de acceso        */


void presenta()
{
  printf ("\n");
  printf ("DOWN-MCU. V%0.1f (C) GRUPO J&J. Noviembre-1996. \n",VERSION);
  printf ("Envo de programas a la entrenadora\n\n");
}

void display_help()
{
  printf ("Sintaxis: downmcu fich [opciones]\n\n");
  printf ("El fichero a enviar debe estar en formato .S19 de motorola\n");
  printf ("Opciones disponibles:\n");
  printf ("     -h     :  Esta ayuda\n");
  printf ("     -comx  :  siendo x un nmero entre 1,2,3  4. Utilizar el\n");
  printf ("               puerto x. (com1, com2, com3  com4\n");
  printf ("               POR DEFECTO SE TOMA EL PUERTO COM1\n");
  printf ("     -d     : Establecer directorio de bsqueda de los ficheros\n");
  printf ("              .S19. Si no se especifica se toma por defecto el\n");
  printf ("              directorio actual.\n");
  printf ("\n\n");
  printf ("Ejemplo:  downmcu prueba -com2 -dc:\\68hc11\\s19 \n\n");
  printf ("Este ejemplo carga en la entrenadora el programa downmcu.s19 que\n");
  printf ("se encuentra en el directorio c:\\68hc11\\s19. La entrenadora est \n");
  printf ("conectada en el COM2\n\n");
}


int es_puerto(arg)
char *arg;
/* Ŀ
    Comprobar si el parmetro arg es un parmetro que especifica         
    un puerto serie. En caso de ser as se actualiza la variable global  
    puerto que especifica el puerto de comunicaciones actual.            
                                                                         
    SALIDAS:                                                             
              0 --> El parmetro no especificaba un puerto serie valido  
              1 --> Era un puerto serie (com1, com2, com3  com4)        
   */
{
  if (strcmp(arg,"-com1")==0) {
    puerto=1;
    return 1;
  }
  if (strcmp(arg,"-com2")==0) {
    puerto=2;
    return 1;
  }
  if (strcmp(arg,"-com3")==0) {
    puerto=3;
    return 1;
  }
  if (strcmp(arg,"-com4")==0) {
    puerto=4;
    return 1;
  }
  return 0;
}

int es_dir(arg)
char *arg;
/* Ŀ
    Comprobar si el parmetro arg especifica un directorio para ficheros 
    .s19. En caso de ser as se guarda el directorio en la variable      
    global path. NO SE COMPRUEBA SI EL DIRECTORIO ESPECIFICADO EXISTE    
                                                                         
    SALIDAS:                                                             
              0 --> El parmetro no especificaba un directorio.          
              1 --> Se especificaba un directorio.                       
   */
{
  char temp[3];
  int i;

  if (strlen(arg)<3) return 0;
  strncpy(temp,arg,2);
  temp[2]='\0';
  if (strcmp(temp,"-d")!=0) return 0;

  for (i=2; i<=strlen(arg); i++) {
    path[i-2]=arg[i];
  }
  return 1;
}

void analiza_parametros(na,arg)
int na;
char *arg[];
/* Ŀ
    Analizar los parmetros de la lnea de argumentos. Si se encuentran  
    errores se aborta el programa. Se actualizan las siguientes varia-   
    bles:                                                                
                                                                         
    nomfich --> Nombre del fichero .S19 a cargar                         
    path --> Directorio donde encontrar el fichero .S19                  
    puerto --> Numero del puerto especificado.                           
   */
{
  int i;
  char temp[10];

  if (strcmp(arg[1],"-h")==0) {   /* Parmetro -h --> Sacar ayuda */
    display_help();
    exit(0);
  }

  if (strlen(arg[1])>12) {
    printf ("%s : fichero incorrecto\n",arg[1]);
    exit(0);
  }
  strcpy(nomfich,arg[1]);     /* Obtener el nombre del fichero .S19 */

  for (i=2; i<na; i++) {      /* Procesar todos los parmetros */

    if (!es_puerto(arg[i])) {
      if (!es_dir(arg[i])) {
	printf ("Parmetro %s no reconocido\n",arg[i]);
	exit(0);
      }
    }
  }
}


/*            Ŀ
  Ĵ Programa PRINCIPAL  
	                   */
main(argc,argv)
int argc;
char *argv[];
{
  int f;
  unsigned int nbytes;

  presenta();

  if (argc==1) {
    printf ("Utilice el parmetro -h para obtener ayuda\n\n");
    exit(0);
  }

  /* Establecer los parmetros por defecto */

  puerto=1;            /* Por defecto com1                 */
  strcpy(path,".");    /* Por defecto el directorio actual */

  analiza_parametros(argc,argv);

  extension(nomfich);  /* Si no se ha especificado extension .S19 se aade */

  strcat(fullfich,path);   /* Fullfich contiene la ruta de acceso completa */
  strcat(fullfich,"\\");   /* al fichero .S19                              */
  strcat(fullfich,nomfich);

  if ((f=open(fullfich,O_RDONLY))==-1) {
      printf ("%s : Fichero no encontrado\n",fullfich);
      exit(0);
  }
  else {
    printf ("Fichero a enviar: %s\n",fullfich);
    printf ("Puerto serie: COM%i\n",puerto);
  }

  configurar_puerto(puerto);
  vaciar_buffer();
  delay(200);
  dtroff();                   /* Desactivar DTR para hacer reset soft */

  printf ("\nPulse reset en la entrenadora...");
  if (!wait_break()) {
    printf ("\nABORTADO\n\n");
    exit(0);
  }
  vaciar_buffer();
  printf ("\nTransmitiendo: ");
  nbytes=mandar_programa(f);
  close(f);
  if (!hay_error()) {                /* Si no ha habido errores...  */
    printf ("OK!\n");
    printf ("Envo correcto\n");
    printf ("Tamao del programa: %u bytes\n",nbytes);
  }
  else {
    display_error();
    printf ("Envo abortado\n");
  }

}