/************************************************************************/
/*  Grupo J&J. Noviembre 1996.                                          */
/************************************************************************/
/*                                                                      */
/*     BSTRAP. Rutinas para "dialogar" con el programa BOOTSTRAP que    */
/*             se ejecuta en el microcontrolador al arrancar.           */
/*-----------------------------------------------------------------------/
/*                                                                      */
/************************************************************************/

#include "fcntl.h"


void completar(num)
int num;
/*************************************/
/*  Mandar al MCU num caracteres 0.  */
/*************************************/
{
  while (num) {
    enviar(0);
    eco(0);
    cprintf (".");
    num--;
    if (hay_error()) return;
  }
}

unsigned int mandar_programa(f)
int f;
/********************************************************************/
/*  Mandar un programa al MCU. El fichero debe poseer el handle f.  */
/*  El MCU debe estar en modo BOOTSTRAP y el programa se carga      */
/*  en la memoria RAM interna                                       */
/*  	Se devuelve el nmero de bytes transferidos en caso de que  */
/*  el envo haya sido correcto.                                    */
/********************************************************************/
{
  unsigned short int tam;
  unsigned short int datos[40];
  unsigned int   direccion=0;
  unsigned int   dirini=0;
  unsigned int   totalb=0;
  unsigned short int dir[3];
  int  tipo;


  enviar(0xff);        /* Enviar carcter $FF         */

  do {
    tipo=leer_bloque_s19(f,&tam,datos,dir);  /* Leer un bloque */

    if (tipo==0) {  /* Si hay un error en la transmisin del bloque se  */
      return 0;     /* aborta el programa                               */
    }

 /***** Enviar bloque del tipo 1 *****/
    if (tipo==1) {
      direccion=256*dir[1]+dir[0];       /* Calcular direccin */
      if (direccion>0x00FF || (direccion+tam)>0x00FF) {
	set_error(7);              /* Desbordamos la RAM interna  */
	return 0;
      }
      if (direccion<dirini) {
	set_error(6);              /* Hay un conflicto en directivas. ORG */
	return 0;
      }
      if (direccion>dirini) {
	completar(direccion-dirini);
	dirini=direccion;
      }

      enviar_cad_eco(datos,tam,1); /* Enviar los datos por el puerto serie */
      dirini=direccion+tam;   /* Dirini apunta a la direccin siguiente   */
			      /* al bloque que se acaba de introducir     */
      totalb+=(unsigned int)tam;  /* Incrementar n totales de bytes mandados */
    }
  } while(tipo==1); /* Mientras haya bloques de tipo S1 seguir mandando */
  if (dirini<256)
    completar(256-dirini);  /* Completar con ceros lo que falta    */

  return totalb;
}

int cargar_loader()
/**************************************************/
/*  Cargar el loader en la memoria RAM interna    */
/**************************************************/
{
  int f;

  if ((f=open("LOADER.S19",O_RDONLY))==-1) {
     set_error(8);
     return 0;
   }

 /*if (!wait_reset())   Esperar hasta que se pulse RESET */
    return 0;          /* Si se pulsa ENTER se aborta      */

  mandar_programa(f);   /* Cargar el LOADER        */
  if (hay_error()) {
    return 0;
  }
  close(f);
  return 1;
}

