; ͻ
;  CTSERVER. v2.0                         Microbtica S.L.  Octubre 1999  
; ͹
;   Programa servidor para la conexin de tarjetas entrenadoras basadas   
;   en el 68HC11 con el PC.                                               
;                                                                         
;     El servidor ofrece una serie de servicios a un programa cliente     
;   que se encuentra en el PC y que se comunica con el servidor a travs  
;   del puerto serie.                                                     
;                                                                         
;     Los servicios que ofrece el servidor son los siguientes:            
;     - Transferencia de bloques de hasta 64K del micro al PC             
;     - Transferencia de bloques de hasta 64K del PC al micro             
;     - Grabacin de datos en la memoria EEPROM                           
;     - Grabacin de datos en la memoria EPROM del E9                     
;     - Ejecucin de programas. (JUMP & EXECUTE)                          
;     - Control de supervivencia                                          
;                                                                         
;    Para la solicitud de estos servicios existe un protocolo. En primer  
;   lugar el cliente (programa en el PC) debe enviar un cdigo que        
;   identifique el servicio que quiere obtener del servidor. Segn el     
;   servicio solicitado, el intercambio de datos entre cliente y servidor 
;   sera de una forma u otra.                                             
;                                                                         
; ͼ

; ͻ
;  DESCRIPCION DETALLADA DE LOS SERVICIOS DEL SERVIDOR                    
; ͹
;    CONTROL DE SUPERVIVENCIA:                                            
;                                                                         
;    Este servicio lo utiliza el cliente para saber si el servidor        
;   se est ejecutando en el micro o no. Si el servidor no responde se    
;   puede deber a una de las siguientes causas:                           
;        * Placa entrenadora no alimentada                                
;        * Placa entrenadora no conectada al PC                           
;        * El micro est ejecutando un programa que no es el CTSERVER     
;        * Se ha 'reseteado' el micro                                     
;                                                                         
;   El protocolo entre cliente y servidor es el siguiente:                
;                                                                         
;   Cliente:  Enva cdigo 68 para solicitar control de supervivencia     
;   Servidor: Responde enviando el carcter 'J'                           
; Ķ
;   TRANSFERENCIA DE BLOQUES DEL MICRO AL PC                              
;                                                                         
;     Con este servicio se pueden volcar bloques de longitud comprendida  
;  entre 1 y 65535 bytes desde el micro al PC.                            
;                                                                         
;   Protocolo entre cliente y servidor:                                   
;                                                                         
;   Cliente: enva cdigo 65 para solicitar servicio de transferencia     
;   Cliente: Enva la direccin de comienzo del bloque que se quiere      
;            Transferir.  Las direcciones ocupan 2 bytes. Primero se      
;            envia el byte de menor peso y luego el de mayor peso.        
;   Cliente: Enva la longitud del bloque a transferir. Este valor es de  
;            2 bytes. Primero se enva el de menor peso y luego el de     
;            mayor peso.                                                  
;   Servidor: Enva el bloque de memoria solicitado. Se envan tantos     
;             bytes como sea el tamao del bloque solicitado (entre 1 y   
;             65535 bytes)                                                
; Ķ
;   TRANSFERENCIA DE BLOQUES DEL PC AL MICRO                              
;                                                                         
;     Con este servicio se pueden volcar bloques de longitud comprendida  
;   entre 1 y 65535 bytes desde el PC al micro.                           
;                                                                         
;   Protocolo entre cliente y servidor:                                   
;                                                                         
;    Cliente: Enva cdigo 66 para solicitar servico de transferencia     
;    Cliente: Enva la direccin de comienzo donde situar el bloque. Las  
;             direcciones ocupan 2 bytes. Primero se enva el byte de     
;             menor peso y luego el de mayor peso.                        
;    Cliente: Enva la longitud del bloque a transferir. Este valor es de 
;             2 bytes. Primero se enva el de menor peso y luego el de    
;             mayor peso.                                                 
;    Cliente: Comienza a enviar el bloque de datos. El servidor ir       
;             leyendo los bytes y los ir colocando a partir de la        
;             direccin de memoria indicada.                              
; Ķ
;   GRABACION DE UN BLOQUE EN LA MEMORIA EEPROM                           
;                                                                         
;      Con este servicio se pueden grabar datos en la memoria EEPROM      
;   interna del micro.  Antes de grabar un dato en una direccin de la    
;   memoria EEPROM se borra primero dicha posicin y despus se escribe   
;   el dato.                                                              
;                                                                         
;    Protocolo entre cliente y servidor:                                  
;                                                                         
;    Cliente: Enva cdigo 69 para solicitar servicio de grabacin EEPROM 
;    Cliente: Enva la direccin de comienzo donde grabar el bloque. Es   
;             responsabilidad del programa cliente enviar una direccin   
;             que se corresponda con la EEPROM. Primero se enva el       
;             byte de menor peso y luego el de mayor peso.                
;    Cliente: Enva la longitud del bloque a grabar. Primero se enva el  
;             byte de menor peso y luego el de mayor peso.                
;    Cliente: Comienza a enviar el bloque de datos. El cliente debe tener 
;             en cuenta que grabar un byte en la eeprom lleva ms tiempo  
;             que guardarlo en RAM. Por ello el SERVIDOR HACE ECO de      
;             cada byte enviado una vez grabado.                          
; Ķ
;   GRABACION DE UN BLOQUE EN LA MEMORIA EPROM                            
;                                                                         
;      Con este servicio se pueden grabar datos en la memoria EPROM       
;   del micro E9.  Para que la grabacin sea correcta el micro debe       
;   tener borrada dicha memoria.                                          
;                                                                         
;    Protocolo entre cliente y servidor:                                  
;                                                                         
;    Cliente: Enva cdigo 70 para solicitar servicio de grabacin EPROM  
;    Cliente: Enva la direccin de comienzo donde grabar el bloque. Es   
;             responsabilidad del programa cliente enviar una direccin   
;             que se corresponda con la EPROM. Primero se enva el        
;             byte de menor peso y luego el de mayor peso.                
;    Cliente: Enva la longitud del bloque a grabar. Primero se enva el  
;             byte de menor peso y luego el de mayor peso.                
;    Cliente: Comienza a enviar el bloque de datos. El cliente debe tener 
;             en cuenta que grabar un byte en la eprom lleva ms tiempo   
;             que guardarlo en RAM. Por ello el SERVIDOR HACE ECO de      
;             cada byte enviado una vez grabado.                          
; Ķ
;    EJECUCION DE PROGRAMAS                                               
;                                                                         
;      Con este servicio se salta a programas que se encuentren en otras  
;   direcciones de memoria. Hay que tener en cuenta que cuando se ejecute 
;   otro programa, el servidor se deja de ejecutar y por tanto el programa
;   cliente perder la conexin con el servidor.                          
;                                                                         
;    Protocolo entre cliente y servidor:                                  
;                                                                         
;    Cliente: Enva cdigo 67 para solicitar servicio de ejecucin        
;    Cliente: Enva la direccin a la que saltar. Primero se enva el     
;             byte de menor peso y luego el de mayor peso.                
;                                                                         
; ͼ


        ORG $0000

;---- Definicin de los servicios
TMPC    EQU 65         ; Transferencia de bloques del micro al PC
TPCM    EQU 66         ; Transferencia de bloques del PC al micro
JEXE    EQU 67         ; Servicio JUMP & EXECUTE
ALIVE   EQU 68         ; Servicio de supervivencia
GBEE    EQU 69         ; Grabar un bloque en la EEPROM
GBE9    EQU 70         ; Grabar un bloque en la EPROM del E9
OKALIVE EQU 'J'

; --- Registros del SCI

BAUD    equ  $2B
SCCR1   equ  $2C
SCCR2   equ  $2D
SCSR    equ  $2E
SCDR    equ  $2F

; ---- REGISTROS DE LA EEPROM  -----

PPROG   equ $103b       ; Control de programacion de la EEPROM
CONFIG  equ $103f       ; Registro de Configuracin del MICRO


        BRA inicializar

dirini   DW  0   ; Direccin inicio
longbloq DW  0   ; Tamao bloque
codigo   DB  0   ; Cdigo de servicio solicitado

inicializar
        LDX #$1000

espera  BRCLR SCSR,X $40 espera  ; espero a que se estabilice el SCI

        LDAA #$30
        STAA BAUD,X      ; Configurar velocidad transmisin a 9600 baudios

begin_server            ; Comienzo del servidor

        LDX  #$1000
        BSR  leer_car   ; Esperar a que el PC solicite un servicio
        STAA codigo     ; Almacenar temporalmente el cdigo
        CMPA #ALIVE     ; Servicio de supervivencia?
        BEQ  serv_alive
        CMPA #JEXE      ; Servicio JUMP & EXECUTE?
        BEQ  serv_jexec
        CMPA #TMPC      ; Servicio Transmisin micro-PC?
        BEQ  serv_tmpc
        CMPA #TPCM      ; Servicio Transmision PC-micro?
        BEQ  serv_tpcm
        CMPA #GBEE      ;  Servicio Grabacion de EEPROM?
        BEQ  serv_gbee
        CMPA #GBE9      ; Servicio grabacin de la eprom del E9 ?
        BEQ  iserv_gbe9
        JMP begin_server

iserv_gbe9
        JMP  serv_gbe9


serv_alive              ; Servicio de supervivencia
        LDAA #OKALIVE
        BSR enviar
        JMP begin_server

serv_tpcm
        INC codigo
        BRA comun
serv_tmpc
        CLR codigo
comun
        BSR leer_dir
        STY dirini
        BSR leer_dir    ; Leer tamao del bloque
        STY longbloq    ; Almacenar tamao bloque
bucle_tmpc
        CPY #0                  ; Bloque transferido?
        BEQ fin_ser_tmpc        ; si -> fin
        LDY dirini
        LDAA codigo
        TSTA
        BNE tpcm
                                ; Transferencia micro->pc
        LDAA 0,Y                ; Leer un byte
        BSR enviar              ; Enviar byte
        BRA sigue
                                ; Transferencia pc->micro
tpcm    BSR leer_car            ; Leer un byte
        STAA 0,Y                ; Almacenar byte

sigue   INY
        STY dirini              ; Apuntar siguiente direccin
        LDY longbloq
        DEY
        STY longbloq            ; Un byte menos queda por enviar
        BRA bucle_tmpc
fin_ser_tmpc
        JMP begin_server

serv_jexec
        BSR leer_dir    ; Leer direccin de inicio
        STY dirini      ; Almacenar direccin inicio
        JMP 0,Y

; ***********************************************************
; *  Rutina para leer un carcter del puerto serie (SCI)    *
; *  La rutina espera hasta que llega algn carcter        *
; *  ENTRADAS: Ninguna                                      *
; *  SALIDAS: El acumulador A contiene el carcter recibido *
; ***********************************************************

leer_car BRCLR SCSR,X $20 leer_car   ; Esperar hasta que llegue un carcter
        LDAA SCDR,X
        RTS

; ******************************************************************
; *  Enviar un carcter por el puerto serie (SCI).                 *
; *  ENTRADAS: El acumulador A contiene el carcter a enviar       *
; *  SALIDAS: Ninguna                                              *
; ******************************************************************

enviar  BRCLR SCSR,X $80 enviar
        STAA SCDR,X
        RTS

; ************
; * LEER_DIR *
; ************
; Leer una direccin por el SCI y devolverla en el registro Y
; ** ENTRADAS: Ninguna
; ** SALIDAS: El registro Y contiene la direccin leida
leer_dir
        PSHA            ; Salvar registros utilizados
        PSHB

        BSR leer_car    ; Leer byte bajo de la direccin
        TAB             ; B contiene byte bajo direccin
        BSR leer_car    ; A contiene byte alto de la direccin
        XGDY            ; Ahora Y contiene la direccin leida

        PULB            ; Recuperar registros utilizados
        PULA
        RTS


;****************************************************
;* serv_gbee: grabacin de un bloque en la eeprom   *
;****************************************************

serv_gbee
        BSR leer_dir
        STY dirini
        BSR leer_dir    ; Leer tamao del bloque
        STY longbloq    ; Almacenar tamao bloque
bucle_gbee
        CPY #0                  ; Bloque transferido?
        BEQ fin_ser_gbee        ; si -> fin
        LDY dirini

        LDAB #$16
        STAB PPROG    ; ponemos modo borrar BYTE
        STAB $0,Y
        LDAB #$17
        STAB PPROG    ; Activo programacin
        BSR  PAUSA10  ; Realizo la pausa de 10ms

        LDAB #$02
        STAB PPROG    ; ponemos EELAT=1 (EEPGM=0)
        BSR  leer_car
        BSR  enviar
        STAA $0,Y
        LDAB #$03
        STAB PPROG    ; Activo programacin EEPGM=1  (EELAT=1)
        BSR  PAUSA10  ; Realizo la pausa de 10ms

        INY
        STY dirini              ; Apuntar siguiente direccin
        LDY longbloq
        DEY
        STY longbloq            ; Un byte menos queda por enviar
        BRA bucle_gbee
fin_ser_gbee
        CLR  PPROG  ; Desactivo programacion y pongo modo READ
        JMP begin_server

;****************************************************
;* serv_gbe9: grabacin de un bloque en la eprom    *
;****************************************************

serv_gbe9
        BSR leer_dir
        STY dirini
        BSR leer_dir    ; Leer tamao del bloque
        STY longbloq    ; Almacenar tamao bloque
bucle_gbe9
        CPY #0                  ; Bloque transferido?
        BEQ fin_ser_gbe9        ; si -> fin
        LDY dirini

        LDAB #$20
        STAB PPROG   ; ponemos ELAT=1 (EEPGM=0)
        BSR  leer_car
        BSR  enviar
        STAA $0,Y    ; ponemos dato en la direccin de la eprom
        LDAB #$21
        STAB PPROG   ; Activo programacin EPGM=1  (ELAT=1)
        BSR  PAUSA4  ; Realizo la pausa de 4ms
        CLR  PPROG   ; termino grabar byte

        INY
        STY dirini         ; Apuntar siguiente direccin
        LDY longbloq
        DEY
        STY longbloq       ; Un byte menos queda por enviar
        BRA bucle_gbe9
fin_ser_gbe9
        CLR  PPROG         ; Desactivo programacion y pongo modo READ
        JMP begin_server

 
;*************************************************
;*   Realizar una pausa prefijada 10ms           *
;*************************************************

PAUSA10
        PSHY
        LDY  #$0D10
        BRA  SIGUE

PAUSA4  PSHY
        LDY  #$500

SIGUE   DEY
        CPY  #$00
        BNE  SIGUE
        PULY
        RTS

        END
