/*
 ͻ
  CTMAP       (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Versin 1.0.  Mostrar el mapa de memoria de los archivos S19             
                                                                           
                                                                           
 ͼ
*/

const float VERSION = 1.0;

#include "s19.h"

unsigned short int ramint[256][2];  /* Representacin de la RAM interna */
unsigned short int eeprom[512][2];  /* Representacin de la eeprom      */
S19 fs19;                           /* Fichero S19                      */
unsigned int nreg;		    /* Numero de registros              */
unsigned int nbytes;                /* Nmero de bytes                  */
char fich[80];


/*
   ͻ
                                                                           
            RUTINAS DE DIBUJO DE VENTANAS Y LINEAS                         
                                                                           
   ͼ
									   */

void lineav(x,y,longi,carini,carfin,carlin)
int x,y,longi;
char carini,carfin,carlin;
/* Ŀ
    Dibujar una linea vertical a partir de la coordenada x,y, comenzando 
    con el carcter carini, finalizando con el caracter carfin y la lnea
    formada por caracteres del tipo carlin.                              
   */
{
  int i;


  if (longi<3) return;
  gotoxy(x,y);
  cprintf ("%c",carini);
  for (i=y+1; i<y+longi-1; i++) {
    gotoxy(x,i);
    cprintf ("%c",carlin);
  }
  gotoxy(x,y+longi-1); cprintf ("%c",carfin);
}

void lineah(x,y,longi,carini,carfin,carlin)
int x,y,longi;
char carini,carfin,carlin;
/* Ŀ
    Dibujar una linea horizontal a partir de la coordenada x,y, comenzando 
    con el carcter carini, finalizando con el caracter carfin y la lnea  
    formada por caracteres del tipo carlin.                                
   */
{
  int i;


  if (longi<3) return;
  gotoxy(x,y);
  cprintf ("%c",carini);
  for (i=x+1; i<x+longi-1; i++) {
    gotoxy(i,y);
    cprintf ("%c",carlin);
  }
  gotoxy(x+longi-1,y); cprintf ("%c",carfin);
}

void ventanas(x,y,alt,anch)
int x,y,alt,anch;
/* Ŀ
    Dibujar una ventana simple  
   */
{
  int i;

  lineah(x,y,anch,'','','');
  lineah(x,y+alt-1,anch,'','','');

  lineav(x,y,alt,'','','');
  lineav(x+anch-1,y,alt,'','','');
}

void ventanad(x,y,alt,anch)
int x,y,alt,anch;
/* Ŀ
    Dibujar una ventana doble   
   */
{
  int i;

  lineah(x,y,anch,'','','');
  lineah(x,y+alt-1,anch,'','','');

  lineav(x,y,alt,'','','');
  lineav(x+anch-1,y,alt,'','','');
}


void llenar(int xi,int yi,int alt,int anch,char car)
/*
Ŀ
  Llenar una ventana solida con el caracter especificado.             
*/
{
  int x,y;

  for (y=yi; y<yi+alt; y++) {
    for (x=xi; x<xi+anch; x++) {
      cprintf ("%c",car);
    }
    gotoxy(xi,y);
  }
}

void upper_cad(char *cad)
{
  int i;

  i=0;
  while (cad[i]!=0) {
    cad[i]=toupper(cad[i]);
    i++;
  }
}

void input(cad,max)
char *cad;
unsigned short int max;
/* Ŀ
    Leer una cadena desde el teclado. Max indica el nmero mximo de     
    caracteres que se pueden leer.                                       
   */
{
  char c;
  char i=0;

  do {
    c=getch();
    switch(c) {
      case 8 : if (i>0) {  /* TECLA DEL */
		 i--;
		 cprintf ("\b \b");
	       }
	       break;
      case 13: cad[i]=0;  /* ENTER = fin */
	       return;
      case 0:  getch();    /* cargarse las "teclas" especiales */
	       break;
      case 27: cad[0]=0;   /* ESC = Abortar */
	       return;

      default : if (i<max) {
		  cprintf ("%c",c);
		  cad[i]=c;
		  i++;
		}
    }
  }while (1);
}


void iniramint()
/*
Ŀ
  Inicializar la matriz de la memoria interna. Todas las posiciones   
  se inicializan a vacio y se activan los bits de vector de interrup. 
*/
{
  unsigned int pm=0;


  for (pm=0; pm<=255; pm++) {
    if (pm<0xC4) ramint[pm][0]=0x00;  /* Antes de llegar a los vectores */
    else ramint[pm][0]=0x02;          /* Sealizar vector               */
  }
}

void inieeprom()
/*
Ŀ
  Inicializar la matriz de la memoria eeprom . Todas las posiciones   
  se inicializan a vacio.                                             
*/
{
  unsigned int pm=0;


  for (pm=0xB600; pm<=0xB7FF; pm++) {
    eeprom[pm-0xB600][0]=0x00;            /* Sealizar posicin vacia */
  }
}

void llenar_ramint()
/*
Ŀ
  Cargar el codigo del fichero S19 en la matriz de la RAM interna.    
*/
{
  unsigned int i,n;
  unsigned int dir;
  unsigned short int codigo[37];
  unsigned short int tam;



  for (i=1; i<=nreg; i++) {
    leerdir_s19(fs19,i,&dir);
    leercod_s19(fs19,i,codigo,&tam);
    for (n=0; n<tam; n++) {
      if ((dir+n)<=0xFF) {
	ramint[dir+n][1]=codigo[n];    /* Guardar valor   */
	ramint[dir+n][0]|=0x01;        /* Sealizar lleno */
      }
    }
  }
}

void llenar_eeprom()
/*
Ŀ
  Cargar el codigo del fichero S19 en la matriz de la eeprom.         
*/
{
  unsigned int i,n;
  unsigned int dir;
  unsigned int ind;
  unsigned short int codigo[37];
  unsigned short int tam;



  for (i=1; i<=nreg; i++) {
    leerdir_s19(fs19,i,&dir);
    leercod_s19(fs19,i,codigo,&tam);
    for (n=0; n<tam; n++) {
      if ((dir+n)<=0xB7FF) {
	ind=dir-0xB600;
	eeprom[ind+n][1]=codigo[n];    /* Guardar valor   */
	eeprom[ind+n][0]|=0x01;        /* Sealizar lleno */
      }
    }
  }
}


void mostrar_ram_color(unsigned int xi,unsigned int yi)
{
  unsigned int i;
  unsigned int x,y;


  x=xi; y=yi;

  for (i=0; i<=255; i++) {
    gotoxy(x,y);
    if ((ramint[i][0] & 0x02)==0x02) {    /* Vectores de interrupcin */
      if ((ramint[i][0] & 0x01)==0x01){   /* Ocupados                 */
	textcolor(3);
	cprintf ("");
      }
      else {            /* Vectores int. desocupados */
	textcolor(3);
	cprintf ("");
      }
    }
    else {                               /* Memoria ram normal */
      if ((ramint[i][0] & 0x01)==0x01) { /* Ocupada            */
	textcolor(2);
	cprintf("");
      }
      else {                             /* Desocupada         */
	textcolor(2);
	cprintf ("");
      }
    }

    if (x==xi+15) {
      x=xi;
      y++;
    }
    else x++;
  }
}

void mostrar_eeprom_color(unsigned int xi,unsigned int yi)
{
  unsigned int i;
  unsigned int x,y;
  unsigned int ind;


  x=xi; y=yi;

  for (i=0xB600; i<=0xB7FF; i++) {
    gotoxy(x,y);
    ind=i-0xB600;
    if ((eeprom[ind][0] & 0x01)==0x01) { /* Ocupada            */
      textcolor(2);
      cprintf("");
    }
    else {                             /* Desocupada         */
      textcolor(2);
      cprintf ("");
    }

    if (x==xi+31) {
      x=xi;
      y++;
    }
    else x++;
  }
}

void mostrar_ram_ascii(unsigned int xi,unsigned int yi)
{
  unsigned int i;
  unsigned int x,y;

  x=xi; y=yi;

  for (i=0; i<=255; i++) {
    gotoxy(x,y);
    if ((ramint[i][0] & 0x02)==0x02) {    /* Vectores de interrupcin */
      if ((ramint[i][0] & 0x01)==0x01){   /* Ocupados                 */
	textcolor(11);
	if (ramint[i][1]>=32 && ramint[i][1]<=122) cprintf ("%c",ramint[i][1]);
	else cprintf (".");
      }
      else {            /* Vectores int. desocupados */
	textcolor(3);
	cprintf ("");
      }
    }
    else {
      if ((ramint[i][0] & 0x01)==0x01) { /* Ocupada            */
	if (ramint[i][1]>=32 && ramint[i][1]<=122) cprintf ("%c",ramint[i][1]);
	else cprintf (".");
      }
      else {
	textcolor(2);
	cprintf ("");
      }
    }

    if (x==xi+15) {
      x=xi;
      y++;
    }
    else x++;
  }
}

void mostrar_eeprom_ascii(unsigned int xi,unsigned int yi)
{
  unsigned int i;
  unsigned int x,y;
  unsigned int ind;

  x=xi; y=yi;

  for (i=0xB600; i<=0xB7FF; i++) {
    gotoxy(x,y);
    ind=i-0xB600;
    if ((eeprom[ind][0] & 0x01)==0x01) { /* Ocupada            */
      textcolor(2);
      if (eeprom[ind][1]>=32 && eeprom[ind][1]<=122) cprintf ("%c",eeprom[ind][1]);

      else cprintf (".");
    }
    else {
      textcolor(2);
      cprintf ("");
    }

    if (x==xi+31) {
      x=xi;
      y++;
    }
    else x++;
  }

}



void marco_ram(unsigned int x,unsigned int y)
{
  unsigned int i;
  char cad[5];

  textcolor(14);
  ventanad(x,y,18,18);
  gotoxy(x+1,y-1);
  textcolor(7);
  cprintf ("0123456789ABCDEF");
  for (i=0; i<=255; i=i+16) {
    gotoxy(x-4,y+1);
    inttochar4(i,cad);
    cprintf ("%s",cad);
    y++;
  }
  gotoxy(x+1,y+2);
  cprintf ("0123456789ABCDEF");
}

void marco_eeprom(unsigned int x,unsigned int y)
{
  unsigned int i;
  char cad[5];

  textcolor(14);
  ventanad(x,y,18,34);
  gotoxy(x+1,y-1);
  textcolor(7);
  cprintf ("0123456789ABCDEF0123456789ABCDEF");
  for (i=0xB600; i<=0xB7FF; i=i+32) {
    gotoxy(x-4,y+1);
    inttochar4(i,cad);
    cprintf ("%s",cad);
    y++;
  }
  gotoxy(x+1,y+2);
  cprintf ("0123456789ABCDEF0123456789ABCDEF");
}


void sacar_eeprom_color(x,y)
{
  marco_eeprom(x+4,y+1);
  mostrar_eeprom_color(x+5,y+2);
}

void sacar_ram_color(x,y)
{
    marco_ram(x+4,y+1);
    mostrar_ram_color(x+5,y+2);
}

void sacar_ram_ascii(x,y)
{
  marco_ram(x+4,y+1);
  mostrar_ram_ascii(x+5,y+2);
}

int check_eeprom(S19 fs19, int *ov)
/* Ŀ
    Comprobar si el archivo S19 especificado tiene todas sus direcciones 
    dentro de los 512 bytes de la EEPROM.                                
                                                                         
     Se devuelve 1 en caso de que sea programa para la EEPROM            
     Se devuelve 0 en caso contrario.                                    
                                                                         
      Si es un programa para la EEPROM pero la desborda se indica con    
      un 1 en ov. 0 en caso de no desbordamiento.                        
   */
{
  int i;
  unsigned int dir;
  unsigned short int codigo[35];
  unsigned int tam;

  if (nreg==0) {   /* Fichero S19 sin registros? */
    *ov=0;
    return 1;
  }

  leerdir_s19(fs19,1,&dir);
  if (dir<0xB600 || dir>0xB7FF) {  /* Programa NO es para la EEPROM */
    return 0;
  }

  for (i=2; i<=nreg; i++) {
    leerdir_s19(fs19,i,&dir);
    leercod_s19(fs19,i,codigo,&tam);
    if ( (dir+tam)>0xB7FF) {
      *ov=1;                /* Programa desborda la EEPROM */
      return 1;
    }
  }
  *ov=0;
  return 1;                 /* Programa es para la EEPROM */
}


int check_ramint(S19 fs19, int *ov)
/* Ŀ
    Comprobar si el archivo S19 especificado tiene todas sus direcciones 
    dentro de los 256 bytes de la RAM interna.                           
                                                                         
     Se devuelve 1 en caso de que sea programa para la RAM interna       
     Se devuelve 0 en caso contrario.                                    
                                                                         
      Si es un programa para la RAM interna pero la desborda se indica   
     con un 1 en ov. 0 en caso de no desbordamiento.                     
   */
{
  int i;
  unsigned int dir;
  unsigned short int codigo[35];
  unsigned int tam;

  if (nreg==0) {   /* Fichero S19 sin registros? */
    *ov=0;
    return 1;
  }

  leerdir_s19(fs19,1,&dir);
  if (dir>0xFF) {           /* Programa NO es para la RAM interna */
    return 0;
  }

  for (i=2; i<=nreg; i++) {
    leerdir_s19(fs19,i,&dir);
    leercod_s19(fs19,i,codigo,&tam);
    if ( (dir+tam)>0xFF) {
      *ov=1;                /* Programa desborda la ram interna */
      return 1;
    }
  }
  *ov=0;
  return 1;                 /* Programa es para la RAM interna */
}

int tipoprograma(S19 fs19, int *ov)
/* Ŀ
    Comprobar el tipo de programa: RAM interna, EEPROM o RAM externa.    
    En ov se devuelve si ha habido desbordamiento de la eeprom o ram     
    interna.                                                             
                                                                         
     La funcin devuelve 1 : Programa para RAM interna                   
                         2 : Programa para EEPROM                        
                         3 : Programa para RAM externa.                  
   */
{
  if (check_ramint(fs19,ov)==1) return 1;  /* Programa para RAM interna */
  if (check_eeprom(fs19,ov)==1) return 2;  /* Programa para EEPROM      */

  return 3;   /* Programa para RAM externa */
}



void ram_externa()
{
  textcolor(7);
  lineah(1,24,80,' ',' ',' ');
  gotoxy(2,24);
  textcolor(12);
  cprintf ("Programa para la RAM externa ");
  getch();
}

void leyenda()
{
  textcolor(15); gotoxy(60,12);
  cprintf ("LEYENDA");

  textcolor(2); gotoxy(51,14);
  cprintf ("");
  textcolor(7); cprintf ("  Posicin de memoria libre");
  textcolor(2); gotoxy(51,16);
  cprintf ("");
  textcolor(7); cprintf ("  Posicin de memoria ocupada");
  textcolor(3); gotoxy(51,18);
  cprintf ("");
  textcolor(7), cprintf ("  Vector interrupcin libre");
  textcolor(3); gotoxy(51,20);
  cprintf ("");
  textcolor(7); cprintf ("  Vector interrupcin ocupado");
}

void veeprom(int ov)
{

  llenar(1,3,21,48,' ');   /* Borrar pantalla */

  inieeprom();
  llenar_eeprom();

  sacar_eeprom_color(1,3);

  gotoxy(51,4); textcolor(15);
  cprintf ("Programa      :             ");
  upper_cad(fich);
  gotoxy(67,4);
  textcolor(9); cprintf ("%s",fich);


  gotoxy(51,5); textcolor(15);
  cprintf ("Situacin     : ");
  textcolor(11); cprintf ("EEPROM        ");
  gotoxy(51,6); textcolor(15);
  cprintf ("Tamao        : ");
  textcolor(10); cprintf ("%3u bytes",nbytes);
  gotoxy(51,7); textcolor(15);
  cprintf ("Ocupacin     : ");
  textcolor(14); cprintf ("%3u%%",(100*nbytes)>>9);
  gotoxy(51,8); textcolor(15);
  cprintf ("Espacio libre : ");
  if (ov==0) {
    textcolor(12);
    cprintf ("%3u bytes     ",512-nbytes);
  }
  else {
   textcolor(12);
   cprintf ("DESBORDAMIENTO");
  }

  leyenda();

  textcolor(7);
  lineah(1,24,80,' ',' ',' ');
  gotoxy(2,24);
  textcolor(11);
  cprintf ("Pulse una tecla para ver el contenido ASCII");
  getch();

  mostrar_eeprom_ascii(6,5);

}

void ram_interna(int ov)
{
  llenar(1,3,21,48,' ');   /* Borrar pantalla */

  iniramint();      /* Inicializar los atributos de la ram interna */
  llenar_ramint();  /* Cargar programa en la matriz de ram interna */


  sacar_ram_color(1,3);
  sacar_ram_ascii(25,3);

  gotoxy(51,4); textcolor(15);
  cprintf ("Programa      :             ");
  upper_cad(fich);
  gotoxy(67,4); textcolor(9);
  cprintf ("%s",fich);


  gotoxy(51,5); textcolor(15);
  cprintf ("Situacin     : ");
  textcolor(11);  cprintf ("RAM interna");
  gotoxy(51,6); textcolor(15);
  cprintf ("Tamao        : ");
  textcolor(10);  cprintf ("%3u bytes",nbytes);
  gotoxy(51,7); textcolor(15);
  cprintf ("Ocupacin     : ");
  textcolor(14); cprintf ("%3u%%",(100*nbytes)>>8);
  gotoxy(51,8); textcolor(15);
  cprintf ("Espacio libre : ");
  if (ov==0) {
    textcolor(12);
    cprintf ("%3u bytes     ",256-nbytes);
  }
  else {
   textcolor(12);
   cprintf ("DESBORDAMIENTO");
  }

  leyenda();
}

void presenta()
{
  clrscr();
  textcolor(14); cprintf("CT-MAP ");
  textcolor(12); cprintf("%1.1f, ",VERSION);
  textcolor(11); cprintf("(c) Grupo J&J. Agosto 97                                   ");
  textbackground(4);
  textcolor(15); cprintf ("CT-TOOLS\n\r");
  textbackground(0);
  textcolor(9);
  cprintf("\n\r");
  gotoxy(1,23);
  cprintf("\n\r");
  lineav(49,2,22,'','','');
  lineah(49,10,32,'','','');
}

main()
{
  char *caderror;
  char error;

  int tp;
  int ov;


  presenta();

  /* ---- ABRIR EL FICHERO S19 ----- */
  for (;;) {

    do {
      textcolor(7);
      lineah(1,24,80,' ',' ',' ');
      gotoxy(2,24);
      textcolor(11);
      cprintf ("Nombre fichero: ");
      textcolor(7);
      input(fich,20);
      if (fich[0]==0) {
	textcolor(7);
	clrscr();
	return;
      }
      error=abrir_s19(fich,&fs19,0);
      if (error!=1) {
	caderror=(char *)geterrors19();
	gotoxy(2,24); textcolor(12);
	cprintf ("Error: %s",caderror);
	getch();
      }
    } while (error!=1);

    nbytes=getnbytes19(fs19);
    nreg=getnregs19(fs19);
    tp=tipoprograma(fs19,&ov);
    switch(tp) {
      case 1: ram_interna(ov);
	      break;
      case 2: veeprom(ov);
	      break;
      case 3: ram_externa();
	      break;
    }
    cerrar_s19(fs19); /* Cerrar programa S19                         */

  }
}
