/*
 ͻ
  SERIE.C.    (c) GRUPO J&J. Abril 96.                                     
 ͹
                                                                           
  Rutinas de comunicaciones serie mediante interrupciones.                 
  Las rutinas estn adaptadas para el programa MCBOOT version 2.0          
                                                                           
 ͼ
*/

#define BUFFER_SERIE 512

#define TIMEOUT 10           /* En ordenadores ms rpido poner un valor  */
			     /* mayor                                     */

/*
 ͻ
                                      
    I M P L E M E N T A C I O N       
                                      
 ͼ
*/


#define COM1  0x3f8   /* Direccin base de la Uart para COM1  */
#define COM2  0x2f8   /* Direccin base de la Uart para COM2  */
#define COM3  0x3e8   /* Direccin base de la Uart para COM3  */
#define COM4  0x2e8   /* Direccin base de la Uart para COM4  */


/***************************************************************************/
/*                                                                         */
/*      Breve descripcion de los registros de la UART                      */
/*   Para mas informacion:                                                 */
/*                                                                         */
/*       - Pag 256, "COMUNICACIONES SERIE". Joe Campbell. Ed. Anaya        */
/*                                                                         */
/***************************************************************************/
/*                                                                         */
/*    1.- Registro de DATOS: Utilizado para Leer-mandar BYTES              */
/*         (Offset 0) (Lectura-escritura)                                  */
/*                                                                         */
/*    2.- Registro de ACTIVACION DE INTERRUPCIONES (Offset 1)              */
/*        * Se produce interrupcin cuando se activen los bits:            */
/*            -0 : Dato recibido.                                          */
/*            -1 : Buffer transmision vacio. (listo para enviar)           */
/*            -2 : Seal de BREAK detectada.                               */
/*            -3 : Entrada RS-232-> se genera una interrupcin cuando      */
/*                 cambia el estado de cualquiera de los estados del RS-232*/
/*            -4-7: Siempre a cero.                                        */
/*                                                                         */
/*    3.- IDENTIFICACION DE INTERRUPCION: Indican la interrupcin que est */
/*         pendiente: (Offset 2)                                           */
/*             Bit 2    Bit 1   Bit 0                                      */
/*               0        0       1    => No hay interrupcion pendiente    */
/*               0        1       0    => Buffer transmision vacio         */
/*               1        0       0    => Dato recibido                    */
/*               1        1       0    => BREAK                            */
/*               0        0       0    => Entrada RS-232                   */
/*                                                                         */
/*                                                                         */
/*    4.- Registro CONTROL DE LINEA: Formato de datos: (offset 3)          */
/*                                                                         */
/*          Numero de bits de datos:                                       */
/*           Bits 1  Bit 0                                                 */
/*             0       0     ==> 5 bits de datos                           */
/*             0       1     ==> 6  "       "                              */
/*             1       0     ==> 7  "       "                              */
/*             1       1     ==> 8  "       "                              */
/*                                                                         */
/*          Numero de Bits de STOP:                                        */
/*           Bit 2                                                         */
/*            0              ==> 1 Bit de STOP                             */
/*            1              ==> 2 Bits de STOP                            */
/*                                                                         */
/*          Paridad:                                                       */
/*            Bit 5   Bit 4   Bit 3                                        */
/*              0       0       0   ===> NINGUNA PARIDAD                   */
/*              0       0       1   ===> PARIDAD IMPAR                     */
/*              0       1       1   ===> PARIDAD PAR                       */
/*              1       0       1   ===> MARCA                             */
/*              1       1       1   ===> ESPACIO                           */
/*                                                                         */
/*          Control BREAK:                                                 */
/*            Bit 6                                                        */
/*              0        ==> BREAK Off                                     */
/*              1        ==> BREAK ON                                      */
/*                                                                         */
/*          DLAB  --> Es un truco para utilizar los registros 1 y 2 para   */
/*                    (Datos y activacion interrupciones) para seleccionar */
/*                    la velocidad, cuando este bit esta activo.           */
/*                                                                         */
/*                                                                         */
/*    5.- Registro CONTROL DEL MODEM: Control salida RS-232  (offset 4)    */
/*                                                                         */
/*          Bit 0: Al activarse se activa Data Terminal Ready (DTR)        */
/*          Bit 1: Se activa Request To Send (RTS)                         */
/*          Bit 2: Definible por el usuario                                */
/*          Bit 3: Definible por el usuario                                */
/*          Bit 4: Test local.                                             */
/*          Bits 5-7: Siempre a cero.                                      */
/*                                                                         */
/*    6.- Registro ESTADO DE LINEA: Control estado Serializacin (offset 5)*/
/*                                                                         */
/*          Bit 0: Dato listo. (esperando a ser leido)                     */
/*          Bit 1: Error de sobreescritura.                                */
/*          Bit 2: Error de Paridad                                        */
/*          Bit 3: Error de Trama                                          */
/*          Bit 4: Deteccin de BREAK                                      */
/*          Bit 5: Buffer transmisin vacio                                */
/*          Bit 6: Transmisor vacio                                        */
/*          Bit 7: Siempre a cero                                          */
/*                                                                         */
/*    7.- Registro ESTADO DEL MODEM: (entrada RS-232)                      */
/*                                                                         */
/*          Bit 0: Delta CTS: Clear To Send.                               */
/*          Bit 1: Delta DSR: Data Set Ready                               */
/*          Bit 2: Delta RI : Ring Indicator.                              */
/*          Bit 3: Delta DCD: Data Carrier Detect.                         */
/*                                                                         */
/*          Bit 4: CTS                                                     */
/*          Bit 5: DSR                                                     */
/*          Bit 6: RI                                                      */
/*          Bit 7: DCD                                                     */
/*                                                                         */
/*          Los bits donde pone delta indican que se ha producido un       */
/*        desde la ultima vez que se leyo el registro. (0-3). Los bits 4-7 */
/*        indican el estado "absoluto" de las lineas RS-232.               */
/*                                                                         */
/***************************************************************************/

/*   OFFSET de los registros de la UART:  */

#define datos            0   /* Registro de datos                        */
#define act_interrup     1   /* Registro activacion interrupciones       */
#define ident_interrup   2   /* Registro indentificacin interrupciones  */
#define control_linea    3   /* Registro Control de linea                */
#define control_modem    4   /* Registro Control de modem                */
#define estado_linea     5   /* Registro Estado de Linea                 */
#define estado_modem     6   /* Registro Estado del Modem                */
#define N81     0x03     /* Mscara para configurar la UART con el       */
			 /* formato: 8bits de datos, 1 STOP y no paridad */



/*
Ŀ
  VARIABLES GLOBALES   

*/


int   puerto_actual=COM1;  /* Puerto Actual. Por defecto COM1 */
char  hwint;               /* Estado de las interrupciones HW */

/* -- Buffer circular donde almacenar los datos recibidos -- */
char buffer[BUFFER_SERIE];
int  cabeza=0;		 	/* Cabeza del buffer */
int  cola=0;                    /* Cola del buffer   */

int  ncar=0;   /* Indica el nmero de caracteres que hay en el buffer */


char far *punt = (char far *) 0xb8000000;
void interrupt serie();  /* Rutina de servicio interrupcin de las   */
			 /* interrupciones de la UART                */


void interrupt serie()
/*
Ŀ
  Rutina de servicio de interrupcin de la UART. La nica interrupcin que 
  se tiene en cuenta es la de dato recibido. Cada vez que se recibe un     
  dato, se activa esta interrupcin y se mete el dato en un buffer.        
*/
{
  static char fase[4] = {'-','\\','||','/'};
  static char pf1 = 0;
  static char pf2 = 0;
  static char tf  = 0;
  char c;

  c=inportb(puerto_actual+datos);

/* -------- Escribir chorradita en la pantalla ------------- */
  punt = (char far *) 0xb800009A;
  if (ncar<BUFFER_SERIE) {
    *punt=fase[pf1];
    *(punt+4)=fase[pf2];
    tf = (tf +1 ) % 20;
    if (tf==0) pf1= (pf1 + 1) % 4;
    pf2 = (pf2 + 1) % 4;

    /* ------- Introducir dato recibo en la cola del buffer ---- */
    buffer[cola]=c;
    cola=(cola + 1) % BUFFER_SERIE;
    ncar++;
  }
  else {
    *punt=1;      /* Accin cuando buffer lleno */
  }

  outportb(0x20,0x20);   /* Mandar orden EOI al 8259 */
}


void baudios(int baud)
/*
Ŀ
  Establecer la velocidad de transmisin de los datos. 
  Las velocidades que se pueden seleccionar son:       
                                                       
    1200, 7680 y 9600                                  
                                                       
  En caso de que baud no sea ningn valor de los       
  anteriores se toma el valor por defecto de 7680.     
  */
{
  unsigned char ba=0,bb=0x60;  /*  Byte alto y byte bajo  */
  unsigned char control;

  switch(baud){
    case 1200 : ba=0x00; bb=0x60; break;
    case 7680 : ba=0x00; bb=0x0f; break;
    case 9600 : ba=0x00; bb=0x0c; break;

    default   : ba=0x00; bb=0x0c;
  }

  /* Activar bit 7 del registro de control de linea  */
  outportb(puerto_actual+control_linea,0x80);

  /*  Situar los divisores de velocidad en los registros 0 y 1 de la Uart */
  outportb(puerto_actual+datos,bb);
  outportb(puerto_actual+act_interrup,ba);

  /* Establecer configuracin N81  */
  outportb(puerto_actual+control_linea,N81);

}


void configurar_puerto(int com)
/*
Ŀ
 Rutina para configurar el puerto serie para poder ser utilizado.          
 Se instala la rutina de interrupcin del puerto especificado.             
   La velocidad por defecto queda configurada a 9600 baudios. La           
 configuracin de la transmisin serie se configura por defecto a          
 8 bits de datos, 1 de stop y ningn bit de paridad.                       
                                                                           
   Para que funcionen las rutinas de comunicaciones serie es necesario     
 que se llame primero a esta rutina.                                       
                                                                           
                                                                           
   ENTRADAS:                                                               
                                                                           
        com --> Indica el n de puerto serie. El nmero puede ser:         
                1 para COM1, 2 para COM2, 3 COM3, 4 COM4. Por defecto se   
                toma el COM1.                                              
                                                                           
                                                                           
   INFORMACION SOBRE LAS INTERRUPCIONES SERIE:                             
                                                                           
                                                                           
    - Las interrupciones del puerto serie son interrupciones hardware, por 
      tanto habr que habilitarlas en el registro de mscara de            
      interrupcin del controlador de interrupciones 8259.                 
                                                                           
      Este registro se encuentra en el puerto 0x21. Los 8 bits de este     
      puerto habilitan o deshabilitan distintas interrupciones.            
      Un 1 indica que la interrupcin est DESHABILITADA. Un 0 indica que  
      la interrupcin est HABILITADA. El contenido del registro es el     
      siguiente:                                                           
                                                                           
                                                                           
    N de bit:     7       6       5      4      3     2     1        0    
                                                                           
                 LPT1   Disketera LPT2  COM1   COM2  ----  TECLADO  TIMER  
                                                                           
      Por tanto, para permitir interrupciones del COM1 hay que poner a     
      cero el bit 4. Para el COM2 se pone a cero el bit 3.                 
                                                                           
    - En la UART inicialmente no se permiten interrupciones. Las interrup- 
      ciones se activan a travs del registro de activacin de interrup-   
      cin. Hay 4 causas de interrupcin, cada una asociada a un bit del   
      registro citado. Para permitir interrupciones cuando ocurra alguna   
      de las 4 posibles causas de interrupcin hay que poner a 1 el bit    
      correspondiente.                                                     
                                                                           
    - Finalmente, para que las interrupciones salgan de la UART, hay que   
      poner a 1 el bit 3 del registro de control del modem. En             
      encontrar este puto bit he tardado mucho tiempo, porque la informa-  
      cin no se encuentra en ningn lado. As que considerate agraciado   
      de saberlo.                                                          
                                                                           
*/
{
  char mask;
  char vect;
  char c1,c2;

  ncar=0;     /* Inicializar variables de la rutina de interrupcin */
  cola=0;
  cabeza=0;

  switch(com) {
    case 2 : puerto_actual=COM2;
	     mask=0xF7;
	     vect=0x0b;
	     break;
    case 3 : puerto_actual=COM3;
	     mask=0xEF;
	     vect=0x0c;
	     break;
    case 4 : puerto_actual=COM4;
	     mask=0xF7;
	     vect=0x0b;
	     break;
    default:
	puerto_actual=COM1;
	mask=0xEF;
	vect=0x0c;
  }


  /* Configuracin para N81 */
  outportb(puerto_actual+3,0x03);

  setvect(vect,serie);  /* Cambiar vector de interrupcin */

  hwint=inportb(0x21);   /* Obtener el estado de las interrupcines hw */
  c2=hwint & mask;
  outportb(0x21,c2);     /* Habilitar la interrupcin correspondiente */

  /* --- Slo se permite la interrupcin dato recibido ---- */
  outportb(puerto_actual+act_interrup,0x01);

  /* --- Activar GPO2 --- */
  outportb(puerto_actual+control_modem,0x08);
  inportb(puerto_actual+datos);
}


void activar_dtr()
{
  char estado;
  estado=inportb(puerto_actual+control_modem) | 0x1;
  outportb(puerto_actual+control_modem,estado);
}

void desactivar_dtr()
{
  char estado;
  estado=inportb(puerto_actual+control_modem) & 0xfe;
  outportb(puerto_actual+control_modem,estado);
}

void cerrar_puerto_serie()
/*Ŀ
    Antes de terminar el programa es necesario llamar    
    a este procedimiento para desactivar las rutinas de  
    interrupcin.                                        
   */
{
  /* --- Desactivar interrupcin de Dato recibido --- */
  outportb(puerto_actual+act_interrup,0x00);

  /* --- Desactivar  DTR y GPO2 --- */
  outportb(puerto_actual+control_modem,0x00);

  /* --- Dejar las interrupciones HW como al principio --- */
  outportb(0x21,hwint);
}


int listo_enviar()
/*Ŀ
    Devuelve TRUE cuando est listo para enviar datos.   
    Para ello se comprueba si el bit 5 del registro de   
    estado de lnea est activado.                       
   */
{
  return inportb(puerto_actual+estado_linea) & 0x20;
}


int car_waiting()
/*Ŀ
    Devuelve TRUE si hay un carcter esperando para ser  
    ledo. Para ello se comprueba el bit 0 del registro  
    de estado de lnea de la UART.                       
   */
{
  return (ncar<BUFFER_SERIE && cabeza==cola) ? 0 : 1;
}


char leer_car()
/*
Ŀ
  Leer un carcter por el puerto serie. Si no hay      
  ningn carcter esperando se espera hata que se      
  introduzca alguno.                                   
 */
{
  char c;

  while (!car_waiting()) { /*  Esperar hasta que se reciba un byte  */
  }

  c=buffer[cabeza];
  cabeza= (cabeza+1) % BUFFER_SERIE;
  ncar--;

  return c;
}


void enviar(car)
char car;
/*
Ŀ
  Enviar un carcter por el puerto serie.    
 */
{
  while (!listo_enviar()) /* Esperar hasta que el registro de transmisin  */
  ;                       /*   est vacio                                  */

  outportb(puerto_actual+datos,car);
}


void enviar_cad(cad,nbytes,punto)
unsigned short int *cad;
char nbytes;
int punto;
/*
Ŀ
  Enviar nbytes de la cadena cad por el puerto serie       
  Si punto=0, no se escribe nada en pantalla.              
  Si punto=1 se escribe un carcter por cada byte enviado  
 */
{
  char i=0;

  while (nbytes) {
    enviar(cad[i]);

    if (punto) {
      textcolor(9);
      cprintf (">");
      textcolor(7);
    }

    i++;
    nbytes--;
  }
}

int okbreak()
/*
Ŀ
  Devuelve TRUE si se detecta la llegada del carcter BREAK
 */
{
  return inportb(puerto_actual+estado_linea) & 0x10;
}


int wait_break()
/*
Ŀ
  Esperar hasta que llegue el carcter BREAK o hasta que   
  se pulse una tecla. Se devuelve TRUE si ha llegado un    
  BREAK y FALSE en caso contrario.                         
 */
{
  char c;

  while (!okbreak())   /* Si se pulsa una tecla se termina */
    if (kbhit()) {
      getch();
      return 0;
    }
  return 1;
}


void vaciar_buffer()
/*
Ŀ
  Vaciar el buffer de datos recibidos.                     
 */
{
  ncar=0;
  cabeza=cola;
}


int eco(b)
unsigned char b;
/*
Ŀ
  Comprobar si se recibe el byte b por la lnea serie.     
  Tanto si se recibe un byte distinto de b como si pasa    
  un tiempo y no se recibe nada se produce un error.       
  SALIDAS:                                                 
           0 --> Se ha recibido un byte distinto del       
                 esperado o se ha producido un timeout y no
                 se ha recibido nada.                      
           1 --> Se ha recibido el byte esperado.          
                                                           
 */
{
  unsigned int i=0;
  unsigned char c;

  i=TIMEOUT;

  while (!car_waiting()) {
    if (i==0x00) {
       return 0;   /* Error de timeout: no se ha recibido nada */
    }
    delay(10);
    i--;
  }

  c=leer_car();       /* Leer carcter proveniente del eco               */
  if (c!=b) {         /* Si caracter enviado es distinto del recibido:   */
     return 0;
  }
  return 1;
}

void enviar_cad_eco(cad,nbytes,punto)
unsigned short int *cad;
char nbytes;
int punto;
/*
Ŀ
  Enviar nbytes de la cadena cad por el puerto serie.      
  se espera un "eco" por el puerto serie.                  
  Si punto=0, no se escribe nada en pantalla.              
  Si punto=1 se escribe un carcter por cada byte enviado. 
 */
{
  char i=0;

  while (nbytes) {
    enviar(cad[i]);
    eco(cad[i]);

    if (punto) {
      textcolor(9);
      cprintf (">");
      textcolor(7);
    }

    /*if (hay_error()) return;    Si hay error se aborta */
    i++;
    nbytes--;
  }
}



















