/*
 ͻ
  DASM.C.     (c) GRUPO J&J. Diciembre 1996.                               
 ͹
                                                                           
  Modulo del programa CTDIALOG encargado de desensamblar codigo del 68HC11 
                                                                           
 ͼ
*/

/*
Ŀ
       INFORMACION SOBRE EL CODIGO MAQUINA DEL 68HC11                     
Ĵ
                                                                          
  Para codificar el cdigo de instruccin se utiliza 1  2 bytes. Lo      
  normal es que se utilice 1 byte. Si se utilizan 2 bytes, al segundo     
  se le denomica cdigo extendido.                                        
                                                                          
    Todas las instrucciones que comienzan por los cdigos 0x18,0x1A y     
  0xcd tienen cdigo extendido.                                           
                                                                          

*/

#define NIEXT 74     /* Numero de instrucciones con cdigo extendido */

/*
Ŀ
                  ESTRUCTURAS DE DATOS                                    
Ĵ
                                                                          
  Para representar una instruccin mquina se utiliza un registro con los 
  siguientes campos:                                                      
                                                                          
    - Nombre del nemnico                                                 
    - Modo de direccionamiento                                            
    - Cdigo de la instruccin                                            
    - Cdigo extendido (Si lo tiene).                                     
                                                                          
 */

typedef unsigned short int byte;
enum tmodo {inh,imm,indx,indy,rel,dir,ext}; /* Modos direccionamiento */

struct tinstruccion {    /* Estructura de las instrucciones       */
  char nemonico[8];      /* Nemnico                              */
  enum tmodo modo;       /* Tipo de modo de direccionamiento      */
  byte codigo;           /* Codigo instruccion                    */
  byte codext;           /* Codigo extendido                      */
};

struct tnemonico {
  byte codigo;          /* Codigo instruccion */
  byte codext;          /* Codigo extendido   */
};

/*            Ŀ
  Ĵ VARIABLES GLOBALES  
	                   */


/* Conjunto de instrucciones sin cdigo extendido */

struct tinstruccion inst[256] = {
{"TEST",inh,0x00,0}, {"NOP " ,inh,0x01,0},{"IDIV",inh,0x02,0},   {"FDIV",inh,0x03,0},
{"LSRD",inh,0x04,0}, {"ASLD",inh,0x05,0}, {"TAP ", inh,0x06,0},  {"TPA ",inh,0x07,0},
{"INX ",inh,0x08,0}, {"DEX ", inh,0x09,0},{"CLV ", inh,0x0A,0},  {"SEV ",inh,0x0B,0},
{"CLC ",inh,0x0C,0}, {"SEC ", inh,0x0D,0},{"CLI ", inh,0x0E,0},  {"SEI ",inh,0x0F,0},
{"SBA ",inh,0x10,0}, {"CBA ", inh,0x11,0},{"BRSET",dir,0x12,0},  {"BRCLR",dir,0x13,0},
{"BSET",dir,0x14,0}, {"BCLR",dir,0x15,0}, {"TAB ",inh,0x16,0,},  {"TBA ",inh,0x17,0},
{"EXP1",dir,0x18,0}, {"DAA ",inh,0x19,0}, {"EXP2",dir,0x1A,0},   {"ABA ",inh,0x1B,0},
{"BSET",indx,0x1C,0},{"BCLR",indx,0x1D,0},{"BRSET",indx,0x1E,0}, {"BRCLR",indx,0x1F,0},
{"BRA ",rel,0x20,0}, {"BRN ",rel,0x21,0}, {"BHI ",rel,0x22,0}   ,{"BLS ",rel,0x23,0},
{"BCC ",rel,0x24,0}, {"BCS ",rel,0x25,0}, {"BNE ",rel,0x26,0},   {"BEQ ",rel,0x27,0},
{"BVC ",rel,0x28,0}, {"BVS ",rel,0x29,0}, {"BPL ",rel,0x2A,0},   {"BMI ",rel,0x2B,0},
{"BGE ",rel,0x2C,0}, {"BLT ",rel,0x2D,0}, {"BGT ",rel,0x2E,0},   {"BLE ",rel,0x2F,0},
{"TSX ",inh,0x30,0}, {"INS ",inh,0x31,0}, {"PULA",inh,0x32,0},   {"PULB",inh,0x33,0},
{"DES ",inh,0x34,0}, {"TXS ",inh,0x35,0}, {"PSHA",inh,0x36,0},   {"PSHB",inh,0x37,0},
{"PULX",inh,0x38,0}, {"RTS ",inh,0x39,0}, {"ABX ",inh,0x3A,0},   {"RTI ",inh,0x3B,0},
{"PSHX",inh,0x3C,0}, {"MUL ",inh,0x3D,0}, {"WAI ",inh,0x3E,0},   {"SWI ",inh,0x3F,0},
{"NEGA",inh,0x40,0}, {"C41 ",inh,0x41,0}, {"C42 ",inh,0x42,0},   {"COMA",inh,0x43,0},
{"LSRA",inh,0x44,0}, {"C45 ",inh,0x45,0}, {"RORA",inh,0x46,0},
{"ASRA",inh,0x47,0}, {"ASLA",inh,0x48,0}, {"ROLA",inh,0x49,0},   {"DECA",inh,0x4A,0},
{"C4B ",inh,0x4B,0},
{"INCA",inh,0x4C,0}, {"TSTA",inh,0x4D,0}, {"C4E ",inh,0x4E,0},   {"CLRA",inh,0x4F,0},  {"NEGB",inh,0x50,0},
{"C51 ",inh,0x51,0}, {"C52 ",inh,0x52,0},
{"COMB",inh,0x53,0}, {"LSRB",inh,0x54,0},  {"C55 ",inh,0x55,0},  {"RORB",inh,0x56,0},  {"ASRB",inh,0x57,0},
{"LSLB",inh,0x58,0}, {"ROLB",inh,0x59,0},  {"DECB",inh,0x5A,0},  {"C5B ",inh,0x5B,0},  {"INCB",inh,0x5C,0},
{"TSTB",inh,0x5D,0}, {"C5E ",inh,0x5E,0},  {"CLRB",inh,0x5F,0},  {"NEG ",indx,0x60,0}, {"C61 ",inh,0x61,0},{"C62",inh,0x62,0},{"COM ",inh,0x61,0},
{"LSR ",indx,0x64,0},{"C65 ",inh,0x65,0},  {"ROR ",indx,0x66,0}, {"ASR ",indx,0x67,0}, {"ASL ",indx,0x68,0},
{"ROL ",indx,0x69,0},{"DEC ",indx,0x6A,0}, {"C6B ",inh,0x6B,0},  {"INC ",indx,0x6C,0}, {"TST ",indx,0x6D,0},
{"JMP ",indx,0x6E,0},{"CLR ",indx,0x6F,0}, {"NEG ",ext,0x70,0},  {"C71 ",inh,0x71,0},  {"C72 ",inh,0x72,0}, {"COM ",ext,0x73,0},
{"LSR ",ext,0x74,0}, {"C75 ",inh,0x75,0},  {"ROR ",ext,0x76,0},  {"ASR ",ext,0x77,0},  {"ASL ",inh,0x78,0},
{"ROL ",ext,0x79,0}, {"DEC ",ext,0x7A,0},  {"C7B ",inh,0x7B,0},  {"INC ",ext,0x7C,0},  {"TST ",ext,0x7D,0},
{"JMP ",ext,0x7E,0}, {"CLR ",ext,0x7F,0},  {"SUBA",imm,0x80,0},  {"CMPA",imm,0x81,0},
{"SBCA",imm,0x82,0}, {"SUBD",imm,0x83,0},  {"ANDA",imm,0x84,0},  {"BITA",imm,0x85,0},
{"LDAA",imm,0x86,0},  {"C87 ",inh,0x87,0}, {"EORA",imm,0x88,0},  {"ADCA",imm,0x89,0},  {"ORAA",imm,0x8A,0},
{"ADDA",imm,0x8B,0},  {"CPX ",imm,0x8C,0}, {"BSR ",rel,0x8D,0},  {"LDS",imm,0x8E,0},
{"XGDX",inh,0x8F,0},  {"SUBA",dir,0x90,0}, {"CMPA",dir,0x91,0},  {"SBCA",dir,0x92,0},
{"SUBD",dir,0x93,0},  {"ANDA",dir,0x94,0}, {"BITA",dir,0x95,0},  {"LDAA",dir,0x96,0},
{"STAA",dir,0x97,0},  {"EORA",dir,0x98,0}, {"ADCA",dir,0x99,0},  {"ORAA",dir,0x9A,0},
{"ADDA",dir,0x9B,0},  {"CPX ",dir,0x9C,0}, {"JSR ",dir,0x9D,0},  {"LDS ",dir,0x9E,0},
{"STS ",dir,0x9F,0},  {"SUBA",indx,0xA0,0},{"CMPA",indx,0xA1,0}, {"SBCA",indx,0xA2,0},
{"SUBD",indx,0xA3,0}, {"ANDA",indx,0xA4,0},{"BITA",indx,0xA5,0}, {"LDAA",indx,0xA6,0},
{"STAA",indx,0xA7,0}, {"EORA",indx,0xA8,0},{"ADCA",indx,0xA9,0}, {"ORAA",indx,0xAA,0},
{"ADDA",indx,0xAB,0}, {"CPX ",indx,0xAC,0},{"JSR ",indx,0xAD,0}, {"LDS ",indx,0xAE,0},
{"STS ",indx,0xAF,0}, {"SUBA",ext,0xB0,0}, {"CMPA",ext,0xB1,0},  {"SBCA",ext,0xB2,0},
{"SUBD",ext,0xB3,0},  {"ANDA",ext,0xB4,0}, {"BITA",ext,0xB5,0},  {"LDAA",ext,0xB6,0},
{"STAA",ext,0xB7,0},  {"EORA",ext,0xB8,0}, {"ADCA",ext,0xB9,0},  {"ORAA",ext,0xBA,0},
{"ADDA",ext,0xBB,0},  {"CPX ",ext,0xBC,0}, {"JSR ",ext,0xBD,0},  {"LDS ",ext,0xBE,0},
{"STS ",ext,0xBF,0},  {"SUBB",imm,0xC0,0}, {"CMPB",imm,0xC1,0},  {"SBCB",imm,0xC2,0},
{"ADDD",imm,0xc3,0},  {"ANDB",imm,0xc4,0}, {"BITB",imm,0xc5,0},  {"LDAB",imm,0xc6,0},
{"CC7 ",inh,0xc7,0},  {"EORB",imm,0xc8,0}, {"ADCB",imm,0xc9,0},  {"ORAB",imm,0xcA,0},  {"ADDB",imm,0xcB,0},
{"LDD ",imm,0xcc,0},  {"EXT3",inh,0xcd,0}, {"LDX ",imm,0xcE,0},  {"STOP",inh,0xcF,0},
{"SUBB",dir,0xd0,0},  {"CMPB",dir,0xd1,0}, {"SBCB",dir,0xd2,0},  {"ADDD",dir,0xd3,0},
{"ANDB",dir,0xd4,0},  {"BITB",dir,0xd5,0}, {"LDAB",dir,0xd6,0},  {"STAB",dir,0xd7,0},
{"EORB",dir,0xd8,0},  {"ADCB",dir,0xd9,0}, {"ORAB",dir,0xda,0},  {"ADDB",dir,0xdb,0},
{"LDD ",dir,0xdc,0},  {"STD ", dir,0xdd,0},{"LDX ",dir,0xde,0},  {"STX ",dir,0xdf,0},
{"SUBB",indx,0xe0,0}, {"CMPB",indx,0xE1,0},{"SBCB",indx,0xe2,0}, {"ADDD",indx,0xe3,0},
{"ANDB",indx,0xe4,0}, {"BITB",indx,0xe5,0},{"LDAB",indx,0xe6,0}, {"STAB",indx,0xe7,0},
{"EORB",indx,0xe8,0}, {"ADCB",indx,0xe9,0},{"ORAB",indx,0xea,0}, {"ADDB",indx,0xeb,0},
{"LDD ",indx,0xec,0}, {"STD ",indx,0xed,0},{"LDX ",indx,0xee,0}, {"STX ",indx,0xef,0},
{"SUBB",ext,0xf0,0},  {"CMPB",ext,0xf1,0}, {"SBCB",ext,0xf2,0},  {"ADDD",indx,0xf3,0},
{"ANDB",ext,0xf4,0},  {"BITB",ext,0xf5,0}, {"LDAB",ext,0xf6,0},  {"STAB",ext,0xf7,0},
{"EORB",ext,0xf8,0},  {"ADCB",ext,0xf9,0}, {"ORAB",ext,0xfa,0},  {"ADDB",ext,0xfb,0},
{"LDD ",ext,0xfc,0},  {"STD ",ext,0xfd,0}, {"LDX ",ext,0xfe,0},  {"STX ",ext,0xff,0}
};


/* Conjunto de instrucciones con cdigo extendido */

struct tinstruccion instext[256] = {
{"INY ",inh, 0x18,0x08}, {"DEY ",inh, 0x18,0x09}, {"BSET",indy,0x18,0x1C}, {"BCLR",indy, 0x18,0x1D},
{"TSY ",inh, 0x18,0x30}, {"TYS ",inh, 0x18,0x35}, {"PULY",inh, 0x18,0x38}, {"ABY ",inh,  0x18,0x3A},
{"PSHY",inh, 0x18,0x3C}, {"NEG ",indy,0x18,0x60}, {"COM ",indy,0x18,0x63}, {"LSR ",indy, 0x18,0x64},
{"ROR ",indy,0x18,0x66}, {"ASR ",indy,0x18,0x67}, {"ASL ",indy,0x18,0x68}, {"ROL ",indy, 0x18,0x69},
{"DEC ",indy,0x18,0x6A}, {"INC ",indy,0x18,0x6C}, {"TST ",indy,0x18,0x6D}, {"JMP ",indy, 0x18,0x6E},
{"CLR ",indy,0x18,0x6F}, {"CPY ",imm, 0x18,0x8C}, {"XGDY",inh, 0x18,0x8F}, {"CPY ",dir,  0x18,0x9C},
{"SUBA",indy,0x18,0xA0}, {"CMPA",indy,0x18,0xA1}, {"SBCA",indy,0x18,0xA2}, {"SUBD",indy, 0x18,0xA3},
{"ANDA",indy,0x18,0xA4}, {"BITA",indy,0x18,0xA5}, {"LDAA",indy,0x18,0xA6}, {"STAA",indy, 0x18,0xA7},
{"EORA",indy,0x18,0xA8}, {"ADCA",indy,0x18,0xA9}, {"ORAA",indy,0x18,0xAA}, {"ADDA",indy, 0x18,0xAB},
{"CPY ",indy,0x18,0xAC}, {"JSR ",indy,0x18,0xAD}, {"LDS ",indy,0x18,0xAE}, {"STS ",indy, 0x18,0xAF},
{"CPY ",ext, 0x18,0xBC},  {"LDY ",imm,0x18,0xCE},  {"LDY ",dir,0x18,0xDE},  {"STY ",dir, 0x18,0xDF},
{"SUBB",indy,0x18,0xE0}, {"CMPB",indy,0x18,0xE1}, {"SBCB",indy,0x18,0xE2}, {"ADDD",indy, 0x18,0xE3},
{"ANDB",indy,0x18,0xE4}, {"BITB",indy,0x18,0xE5}, {"LDAB",indy,0x18,0xE6}, {"STAB",indy, 0x18,0xE7},
{"EORB",indy,0x18,0xE8}, {"ADCB",indy,0x18,0xE9}, {"ORAB",indy,0x18,0xEA}, {"ADDB",indy, 0x18,0xEB},
{"LDD ",indy,0x18,0xEC}, {"STD ",indy,0x18,0xED}, {"LDY ",indy,0x18,0xEE}, {"STY ",indy, 0x18,0xEF},
{"LDY ",ext, 0x18,0xFE},  {"STY ",ext,0x18,0xFF},  {"CPD ",imm,0x1A,0x83},  {"CPD ",dir, 0x1A,0x93},
{"CPD ",indx,0x1A,0xA3}, {"CPY ",indx,0x1A,0xAC}, {"CPD ",ext, 0x1A,0xBE},  {"LDY ",indx,0x1A,0xEE},
{"STY ",indx,0x1A,0xFF}, {"CPD ",indy,0xCD,0xA3}, {"CPX ",indy,0xCD,0xAC}, {"LDX ",indy, 0xCD,0xEE},
{"STX ",indy,0xCD,0xEF}, {"NC  ",inh, 0x00,0x00},
};


/* Conjunto de instrucciones con direccionamiento inmediato de 2 bytes */

struct tnemonico imm2b[10] = {
{0x83,0}, {0x8C,0}, {0x8E,0}, {0xC3,0}, {0xCC,0}, {0xCE,0},
{0x18,0x8C}, {0x18,0xCE},{0x1A,0x83},{0,0},
};

/* Instrucciones con direccionamiento directo y 2 operandos */
struct tnemonico dir2b[3] = {
  {0x14,0}, {0x15,0} ,{0,0}
};

/* Instrucciones con direccionamiento directo y 3 operandos */
struct tnemonico dir3b[3] = {
  {0x12,0}, {0x13,0}, {0,0}
};

/* Instrucciones con direccionamiento indexado x con 2 operandos  */
struct tnemonico indx2b[3] = {
 {0x1c,0},{0x1d,0}, {0,0},
};

/* Instrucciones con direccionamiento indexado x con 3 operandos */
struct tnemonico indx3b[3] = {
 {0x1e,0},{0x1f,0}, {0,0},
};

/* Instrucciones con direccionamiento indexado Y con 2 operandos  */
struct tnemonico indy2b[3] = {
 {0x18,0x1c},{0x18,0x1d}, {0,0},
};

/* Instrucciones con direccionamiento indexado Y con 3 operandos */
struct tnemonico indy3b[3] = {
 {0x18,0x1e},{0x18,0x1f}, {0,0},
};


unsigned int pb=0;         /* Puntero bloque de memoria */
unsigned int direccion;    /* Direccin actual          */


unsigned short int *bloque;

int localiza_ext(cod,codext)
unsigned int codext,cod;
/* Ŀ
     Se busca la instruccion con codigo cod y cdigo extendico ext en   
    la tabla de instrucciones extendidas.                               
                                                                        
     ENTRADAS:   cod    : Codigo instruccin a buscar                   
                 codext : Codigo extendido instruccin a buscar         
                                                                        
     SALIDAS:    Se devuelve el ndice a la tabla de instrucciones      
                 extendidas. Si se ha especificado un cdigo incorrec-  
                 to y la instruccion no existe se devuelve el indice    
                 a la instruccin NC ("No Conocida")                    
                                                                        
    */
{
  byte i;
  for (i=0; i<NIEXT; i++) {
    if (instext[i].codigo==cod && instext[i].codext==codext)
      return i;
  }
  return 73;   /* Indice de la instruccin NC */
}

int es_imm2b(pcod,extend,pcodext)
byte pcod;
byte extend;
byte pcodext;
/* Ŀ
     Determinar si la instruccin especificada es una instruccin que   
    tiene un valor inmediato de 2 bytes.                                
                                                                        
     ENTRADAS:   pcod    : Indice a tabla instrucciones                 
                 pcodext : Indice a tabla instrucciones extendidas      
                 extend  : 1 = Instruccin extendida                    
                           0 = Instruccin normal (no extendida)        
                                                                        
     SALIDAS:    Se devuelve 0 si la instruccin no tiene un valor      
                 inmediato de 2 bytes. 1 en caso contrario.             
                                                                        
    */
{
  byte codigo,codext;
  int i=0;

  if (extend) {                     /* Si es una instruccin extendida       */
    codigo=instext[pcodext].codigo; /* Leer cdigos de tabla de instruciones */
    codext=instext[pcodext].codext; /* extendidas                            */
  }
  else {
    codigo=inst[pcod].codigo;  /* Leer cdigos de instruciones normales */
    codext=0;
  }

  /* Recorrer la tabla imm2b */

  while(imm2b[i].codigo!=0) {
    if(codigo==imm2b[i].codigo &&
       codext==imm2b[i].codext)  return 1;
    i++;
  }
  return 0;
}

int es_dir2b(pcod,extend,pcodext)
byte pcod;
byte extend;
byte pcodext;
/* Ŀ
     Determinar si la instruccin especificada es una instruccin que   
    tiene direccionamiento directo y 2 operandos                        
                                                                        
     ENTRADAS:   pcod    : Indice a tabla instrucciones                 
                 pcodext : Indice a tabla instrucciones extendidas      
                 extend  : 1 = Instruccin extendida                    
                           0 = Instruccin normal (no extendida)        
                                                                        
     SALIDAS:    Se devuelve 0 si la instruccin no tiene direcciona-   
                 miento directo y 2 operandos.                          
                                                                        
    */
{
  byte codigo,codext;
  int i=0;

  if (extend) {                     /* Si es una instruccin extendida       */
    codigo=instext[pcodext].codigo; /* Leer cdigos de tabla de instruciones */
    codext=instext[pcodext].codext; /* extendidas                            */
  }
  else {
    codigo=inst[pcod].codigo;  /* Leer cdigos de instruciones normales */
    codext=0;
  }

  /* Recorrer la tabla dir2b */

  while(dir2b[i].codigo!=0) {
    if(codigo==dir2b[i].codigo &&
       codext==dir2b[i].codext)  return 1;
    i++;
  }
  return 0;
}

int es_dir3b(pcod,extend,pcodext)
byte pcod;
byte extend;
byte pcodext;
/* Ŀ
     Determinar si la instruccin especificada es una instruccin que   
    tiene direccionamiento directo y 3 operandos                        
                                                                        
     ENTRADAS:   pcod    : Indice a tabla instrucciones                 
                 pcodext : Indice a tabla instrucciones extendidas      
                 extend  : 1 = Instruccin extendida                    
                           0 = Instruccin normal (no extendida)        
                                                                        
     SALIDAS:    Se devuelve 0 si la instruccin no tiene direcciona-   
                 miento directo y 3 operandos.                          
                                                                        
    */
{
  byte codigo,codext;
  int i=0;

  if (extend) {                     /* Si es una instruccin extendida       */
    codigo=instext[pcodext].codigo; /* Leer cdigos de tabla de instruciones */
    codext=instext[pcodext].codext; /* extendidas                            */
  }
  else {
    codigo=inst[pcod].codigo;  /* Leer cdigos de instruciones normales */
    codext=0;
  }

  /* Recorrer la tabla dir3b */

  while(dir3b[i].codigo!=0) {
    if(codigo==dir3b[i].codigo &&
       codext==dir3b[i].codext)  return 1;
    i++;
  }
  return 0;
}

int es_indx2b(pcod,extend,pcodext)
byte pcod;
byte extend;
byte pcodext;
/* Ŀ
     Determinar si la instruccin especificada es una instruccin que   
    tiene direccionamiento indexado X y 2 operandos                     
                                                                        
     ENTRADAS:   pcod    : Indice a tabla instrucciones                 
                 pcodext : Indice a tabla instrucciones extendidas      
                 extend  : 1 = Instruccin extendida                    
                           0 = Instruccin normal (no extendida)        
                                                                        
     SALIDAS:    Se devuelve 0 si la instruccin no tiene direcciona-   
                 miento indexado X y 2 operandos.                       
                                                                        
    */
{
  byte codigo,codext;
  int i=0;

  if (extend) {                     /* Si es una instruccin extendida       */
    codigo=instext[pcodext].codigo; /* Leer cdigos de tabla de instruciones */
    codext=instext[pcodext].codext; /* extendidas                            */
  }
  else {
    codigo=inst[pcod].codigo;  /* Leer cdigos de instruciones normales */
    codext=0;
  }

  /* Recorrer la tabla indx2b */

  while(dir2b[i].codigo!=0) {
    if(codigo==indx2b[i].codigo &&
       codext==indx2b[i].codext)  return 1;
    i++;
  }
  return 0;
}

int es_indx3b(pcod,extend,pcodext)
byte pcod;
byte extend;
byte pcodext;
/* Ŀ
     Determinar si la instruccin especificada es una instruccin que   
    tiene direccionamiento indexado X y 3 operandos                     
                                                                        
     ENTRADAS:   pcod    : Indice a tabla instrucciones                 
                 pcodext : Indice a tabla instrucciones extendidas      
                 extend  : 1 = Instruccin extendida                    
                           0 = Instruccin normal (no extendida)        
                                                                        
     SALIDAS:    Se devuelve 0 si la instruccin no tiene direcciona-   
                 miento indexado X y 3 operandos.                       
                                                                        
    */
{
  byte codigo,codext;
  int i=0;

  if (extend) {                     /* Si es una instruccin extendida       */
    codigo=instext[pcodext].codigo; /* Leer cdigos de tabla de instruciones */
    codext=instext[pcodext].codext; /* extendidas                            */
  }
  else {
    codigo=inst[pcod].codigo;  /* Leer cdigos de instruciones normales */
    codext=0;
  }

  /* Recorrer la tabla indx3b */

  while(indx3b[i].codigo!=0) {
    if(codigo==indx3b[i].codigo &&
       codext==indx3b[i].codext)  return 1;
    i++;
  }
  return 0;
}

int es_indy2b(pcod,extend,pcodext)
byte pcod;
byte extend;
byte pcodext;
/* Ŀ
     Determinar si la instruccin especificada es una instruccin que   
    tiene direccionamiento indexado Y y 2 operandos                     
                                                                        
     ENTRADAS:   pcod    : Indice a tabla instrucciones                 
                 pcodext : Indice a tabla instrucciones extendidas      
                 extend  : 1 = Instruccin extendida                    
                           0 = Instruccin normal (no extendida)        
                                                                        
     SALIDAS:    Se devuelve 0 si la instruccin no tiene direcciona-   
                 miento indexado Y y 2 operandos.                       
                                                                        
    */
{
  byte codigo,codext;
  int i=0;

  if (extend) {                     /* Si es una instruccin extendida       */
    codigo=instext[pcodext].codigo; /* Leer cdigos de tabla de instruciones */
    codext=instext[pcodext].codext; /* extendidas                            */
  }
  else {
    codigo=inst[pcod].codigo;  /* Leer cdigos de instruciones normales */
    codext=0;
  }

  /* Recorrer la tabla indy2b */

  while(indy2b[i].codigo!=0) {
    if(codigo==indy2b[i].codigo &&
       codext==indy2b[i].codext)  return 1;
    i++;
  }
  return 0;
}

int es_indy3b(pcod,extend,pcodext)
byte pcod;
byte extend;
byte pcodext;
/* Ŀ
     Determinar si la instruccin especificada es una instruccin que   
    tiene direccionamiento indexado Y y 3 operandos                     
                                                                        
     ENTRADAS:   pcod    : Indice a tabla instrucciones                 
                 pcodext : Indice a tabla instrucciones extendidas      
                 extend  : 1 = Instruccin extendida                    
                           0 = Instruccin normal (no extendida)        
                                                                        
     SALIDAS:    Se devuelve 0 si la instruccin no tiene direcciona-   
                 miento indexado Y y 3 operandos.                       
                                                                        
    */
{
  byte codigo,codext;
  int i=0;

  if (extend) {                     /* Si es una instruccin extendida       */
    codigo=instext[pcodext].codigo; /* Leer cdigos de tabla de instruciones */
    codext=instext[pcodext].codext; /* extendidas                            */
  }
  else {
    codigo=inst[pcod].codigo;  /* Leer cdigos de instruciones normales */
    codext=0;
  }

  /* Recorrer la tabla indy3b */

  while(indy3b[i].codigo!=0) {
    if(codigo==indy3b[i].codigo &&
       codext==indy3b[i].codext)  return 1;
    i++;
  }
  return 0;
}


void sacar_direccion(dir)
unsigned int dir;
/* Ŀ
     Imprimir la direccin especificada en hexadecimal  
    */
{
  textcolor(9);
  printhex(dir/256);
  printhex(dir%256);
  textcolor(7);
  cprintf("  ");
}

byte sacar_nemonico(cod,codext)
byte cod;
byte *codext;
/* Ŀ
     Imprimir el nemnico correspondiente a la instruccin con cdigo   
    cod y cdigo extendido codext.                                      
                                                                        
     ENTRADAS:   cod    : Cdigo de instruccin.                        
                                                                        
     SALIDAS:    codext : Si la instruccin es extendida se devuelve    
                 el cdigo extendido.                                   
                                                                        
     La funcin retorna 1 si es extendida, 0 en caso contrario.         
                                                                        
    */
{
  byte i;

  textcolor(7);
  if (cod==0x18 || cod==0x1a || cod==0xcd) {  /* Si instruccin extendida */
    i=localiza_ext(cod,bloque[pb+1]);
    cprintf ("%s ",instext[i].nemonico);
    *codext=i;
    return 1;
    
  }
  else {                                      /* Instruccin no extendida */
    cprintf ("%s ",inst[cod].nemonico);
    *codext=0;
    return 0;
  }
}


void sacar_direc(pcod,extend,pcodext)
byte pcod;
byte extend;   /* extend indica si es una instruccin extendida */
byte pcodext;   /* Apunta al array de instrucciones extendidas   */
/* Ŀ
     Imprimir el segundo argumento de las instrucciones. Este argumento 
    depende del modo de direccionamiento.                               
                                                                        
     ENTRADAS:   pcod   : Indice a tabla instrucciones normales         
                 pcodext: Indice a tabla instrucciones extendidas       
                 extend : 1 = instruccion extendida                     
                          0 = Instruccin no extendida                  
                                                                        
     SALIDAS:    Ninguna                                                
                                                                        
    */
{
  unsigned int addr;
  unsigned int ba,bb;
  signed char dr;
  enum tmodo modo;       /* Modo direccionamiento */

  addr=direccion;

  if (extend) {          /* Instruccin extendida ... */
    pb++;
    direccion++;
    modo=instext[pcodext].modo;
  }
  else {                 /* Instruccin no extendida */
    modo=inst[pcod].modo;
  }

  switch(modo) {
    case inh : pb++;
	       direccion+=1;
	       break;
    case imm : cprintf ("#");
	       printhex(bloque[++pb]);
	       if (es_imm2b(pcod,extend,pcodext)) {
		 printhex(bloque[++pb]);
		 direccion++;
	       }
	       pb++;
	       direccion+=2;
	       break;
    case indx: printhex(bloque[++pb]);
	       cprintf(",X");
	       if (es_indx2b(pcod,extend,pcodext)) {
		 cprintf (" ");
		 printhex(bloque[++pb]);
		 direccion++;
	       }
	       if (es_indx3b(pcod,extend,pcodext)) {
		 cprintf (" ");
		 printhex(bloque[++pb]);
		 cprintf (" ");

		 /* El tercer operando es una direccion relativa */

		 dr=(signed)bloque[++pb];
		 if (dr>0) addr=addr+4+dr;   /* @ */
		 else addr=addr+dr+4;
		 ba=addr/256;
		 bb=addr % 256;
		 printhex(ba); printhex(bb);
		 direccion+=2;
	       }
	       pb++;
	       direccion+=2;
	       break;
    case indy: printhex(bloque[++pb]);
	       cprintf(",Y");
	       if (es_indy2b(pcod,extend,pcodext)) {
		 cprintf (" ");
		 printhex(bloque[++pb]);
		 direccion++;
	       }
	       if (es_indy3b(pcod,extend,pcodext)) {
		 cprintf (" ");
		 printhex(bloque[++pb]);
		 cprintf (" ");

		 /* El tercer operando es una direccion relativa */

		 dr=(signed)bloque[++pb];
		 if (dr>0) addr=addr+5+dr;   /* @ */
		 else addr=addr+dr+5;
		 ba=addr/256;
		 bb=addr % 256;
		 printhex(ba); printhex(bb);
		 direccion+=2;
	       }
	       pb++;
	       direccion+=2;
	       break;
    case rel:  dr=(signed)bloque[++pb];
	       if (dr>0) addr=addr+2+dr;   /* @ */
	       else addr=addr+dr+2;
	       ba=addr/256;
	       bb=addr % 256;
	       printhex(ba); printhex(bb);
	       pb++;
	       direccion+=2;
	       break;
    case dir:  printhex(bloque[++pb]);
	       if (es_dir2b(pcod,extend,pcodext)) {
		 cprintf (",");
		 printhex(bloque[++pb]);
		 direccion++;
	       }
	       if (es_dir3b(pcod,extend,pcodext)) {
		 cprintf (" ");
		 printhex(bloque[++pb]);
		 cprintf (" ");

		 /* El tercer parmetro es una direccin relativa */
		 dr=(signed)bloque[++pb];
		 if (dr>0) addr=addr+4+dr;   /* @ */
		 else addr=addr+dr+4;
		 ba=addr/256;
		 bb=addr % 256;
		 printhex(ba); printhex(bb);
		 direccion+=2;
	       }
	       pb++;
	       direccion+=2;
	       break;
    case ext:  printhex(bloque[++pb]);
	       printhex(bloque[++pb]);
	       pb++;
	       direccion+=3;
	       break;
  }
  
}

void dasm(b,tam,dir)
unsigned short int *b;
unsigned int tam;
unsigned int dir;
{
  byte ext,codext;
  byte ni;

  pb=0;
  direccion=dir;


  bloque=b;

  cprintf ("\n\n\r");
  ni=0;
  while (ni<23 && pb<=tam) {
    sacar_direccion(direccion);
    ext=sacar_nemonico(bloque[pb],&codext);
    sacar_direc(bloque[pb],ext,codext);
    textcolor(7);
    cprintf("\n\r");
    ni++;
  }
}