/*
   ͻ
                                                                           
    CTDIALOG. (C) GRUPO J&J. Diciembre 1996   (modificado por ANDRES)      
                                                                           
   ͹
                                                                           
     Procesamiento de los comandos del programa CTDIALOG.                  
                                                                           
   ͼ
									   */

#define MAXINST 16    /* Nmero de instrucciones */  /* ANDRES -> 11 */

/*            Ŀ
  Ĵ TIPOS DEFINIDOS  
			                */

typedef unsigned short int byte;
enum ttoken {tcomando,tidentif,tnumero,tfin};

struct token {           /* Estructura de las "tokens" */
  enum ttoken tipo;      /* Tipo de token              */
  byte dato1;            /* Campo con infor. adicional */
  byte dato2;
} t;

/*            Ŀ
  Ĵ VARIABLES GLOBALES  
			                */


char cadcom[30];     /* Cadena que contiene los comandos introducidos  */
					 /* por el usuario                                 */
char identif[30];    /* Para almacenar identificadores                 */

char carsig=' ';     /*  Siguiente carcter al que se ha leido         */
byte ind=0;          /*  Indice a la cadena cadcom                     */


char error[20][255] = {
 {"Comando incorrrecto"},
 {"Direccin de memoria incorrecta"},
 {"Demasiados parmetros"},
 {"Dato incorrecto"},
 {"Slo se pueden almacenar valores de 1 byte"},
 {"Nombre de registro incorrecto"},
 {"Numero decimal demasiado grande"},
 {"Valor incorrecto"},
 {"Nombre de fichero incorrecto"},
 {"Comando desconocido. No hay HELP"},
};


char instruccion[MAXINST][10]={     /* Instrucciones disponibles */
  {"MD"},
  {"MS"},
  {"QUIT"},
  {"CLS"},
  {"LOAD"},
  {"CKC"},
  {"HELP"},
  {"G"},
  {"DASM"},
  {"EEPROM"},
  {"LOAD"},
  {"INFO"},      /* ANDRES  */
  {"BULK"},      /* ANDRES  */
  {"CONFIG"},    /* ANDRES  */
  {"MSE"},       /* ANDRES  */
  {"PA"},        /* ANDRES !!!!!!!! */
};


char upper(car)
char car;
/* Ŀ
    Pasar el caracter especificado a maysculas  
   */
{
  return (car>='a' && car<='z') ? car-'a'+'A' : car;
}

void tomar_dir(cad,dir)
char *cad;
byte *dir;
/* Ŀ
    Tomar la direccin que se encuentra en cad. Se introduce en dir[0]   
    el byte de menor peso y en dir[1] el de mayor peso.                  
   */
{
  cadtoint(cad,&(dir[1]));
  cadtoint(&(cad[2]),&(dir[0]));
}

char digito_hex(num)
unsigned int;
/* Ŀ
    Tomar un nmero entre 0-15 y convertirlo en un dgito hexadecimal.   
   */
{
  if (num<10 && num>=0)   return (char)num+'0';
  if (num<=15 && num>=10) return (char)(num-10)+'A';

  return 'H';   /* Si se retorna esto es que ha habido un error */
}

void printhex(num)
unsigned short int num;
/* Ŀ
    Imprimir un nmero de 1 byte en hexadecimal  
   */
{
  char hex1,hex2;

  hex1=digito_hex(div(num,16));
  hex2=digito_hex(num % 16);
  cprintf ("%c%c",hex1,hex2);
}

void printchar(num)
unsigned short int num;
/* Ŀ
    Imprimir un carcter. Si no es imprimible se saca un .   
   */
{
  if (num<32 || num>126) cprintf (".");
  else cprintf ("%c",(char)num);
}


void print_error(num)
int num;
/* Ŀ
    Sacar el mensaje de error correspondiente    
   */
{
  cprintf ("\n\r");
  textcolor(9);
  cprintf ("        ---> %s",error[num-1]);
  textcolor(7);
}


char leer_caracter()
/* Ŀ
    Leer el siguiente carcter de la cadena que contiene el comando 
   */
{
  char c;

  c=carsig;
  carsig=upper(cadcom[ind++]);

  return c;
}

byte es_instruccion(cad)
char *cad;
/* Ŀ
    Comprobar si la cadena introducida es un comando de CTDIALOG.        
                                                                         
    SALIDAS:                                                             
              0 --> La cadena no es un comando                           
              En caso contrario se devuelve el offset + 1 del comando    
              en la tabla de comandos.                                   
   */
{
  byte i;

  for (i=0; i<MAXINST; i++)
     if (strcmp(cad,instruccion[i])==0) return i+1;

  return 0;  /* cad no es una instruccion */
}

byte es_numero(car)
char car;
/* Ŀ
    Se devuelve 1 si el carcter introducido es un dgito decimal 
   */
{
  return (car<='9' && car>='0') ? 1 : 0;
}

byte es_numero_hex(car)
char car;
/* Ŀ
    Se devuelve 1 si el carcter introducido es un dgito hexadecimal 
   */
{
  return (es_numero(car) || (car>='A' && car<='F')) ? 1 : 0;
}


void leer_identificador(cad)
char *cad;
/* Ŀ
    Se lee un identificador de la cadena cadcom y se introduce en la     
    variable cad.                                                        
   */
{
  char i=0;

  while (carsig!=' ' && carsig!=0) {
    cad[i++]=leer_caracter();
  }
  cad[i]=0;
}

byte leer_binario()
/***********************************************************************/
/*  Leer un nmero en binario. El nmero no puede ser de ms de 8 bits */
/*  Se devuelve 0 si ha habido un error.                               */
/***********************************************************************/
{
  return 0;
}

byte leer_hexadecimal()
/* Ŀ
    Leer un nmero en hexadecimal. El nmero no puede ser de ms de 4    
    dgitos hexadecimales                                                
   */
{
  char numero[30];
  char i=0;
  byte num[30];
  byte iold;     /* Para almacenar la variable ind */
  char carsigold;

  iold=ind;             /* @ antes pona iold=ind-1 */
  carsigold=carsig;

  leer_identificador(numero);

  /* Comprobar que en la cadena todo son dgitos en hexadecimal */
  while (numero[i]!=0)
  {
    if (!hextoint(numero[i],&num[i])) {
      ind=iold;
      carsig=carsigold;
      strcpy(identif,numero);
      return 0;
      }
      i++;
  }

  if (i>4) {                /* Nmero hexadecimal demasiado grande!! */
    /* Mensaje de error */
    return 0;
  }

  t.tipo=tnumero;

  switch (i) {
    case 1: t.dato1=num[0];
	    t.dato2=0;
	    break;
    case 2: t.dato1=num[0]*16 + num[1];
	    t.dato2=0;
	    break;
    case 3: t.dato1=num[1]*16 + num[2];
	    t.dato2=num[0];
	    break;
    case 4: t.dato1=num[2]*16  + num[3];
	    t.dato2=num[0]*16 + num[1];
	    break;
  }
  return 1;
}

byte leer_numero()
/* Ŀ
    Leer un nmero de la cadena cadcom e introducirlo en la variable de  
    tipo token. Si se produce algn error se devuelve 0.                 
    Si no hay errores se devuelve 1.                                     
   */
{
  char numero[30];
  int  n;



  if (carsig=='%') {
    leer_caracter();
    return leer_binario();
  }

  if (carsig=='$') {
    leer_caracter();
    return leer_hexadecimal();
  }

  /* Por defecto se leen nmero en hexadecimal */

  return leer_hexadecimal();
}


byte leer_token()
/* Ŀ
    Leer el siguiente token de la cadena cadcom. Se actualiza la variable
    t, que es de tipo token.                                             
                                                                         
    Se devuelve 0 si ha habido un error en el token leido, 1 en caso     
    contrario.                                                           
   */
{
  byte codigo;
  char car;

  t.dato1=0;
  t.dato2=0;

  while ( carsig==' ')
     leer_caracter();         /* Eliminar espacios */

  if (carsig==0) {    /* Si final de la cadena ... */
    t.tipo=tfin;
    ind=0;
    carsig=' ';
    return 1;
  }

  if (carsig=='$' || carsig=='%' || es_numero(carsig) || es_numero_hex(carsig)) {
    if (leer_numero()) return 1;
    else leer_identificador(identif);
  }
  else leer_identificador(identif);

  codigo=es_instruccion(identif);
  if ( codigo!=0 ) {  /* Si es una instruccion.. */
    t.tipo=tcomando;
    t.dato1=codigo;
    return 1;
  }

  /* Es un identificador */

  t.tipo=tidentif;
  return 1;
}

void input(cad,max)
char *cad;
unsigned short int max;
/* Ŀ
    Leer una cadena desde el teclado. Max indica el nmero mximo de     
    caracteres que se pueden leer.                                       
   */
{
  char c;
  char i=0;

  do {
    c=getch();
    switch(c) {
      case 8 : if (i>0) {  /* TECLA DEL */
		 i--;
		 cprintf ("\b \b");
	       }
	       break;
      case 13: cad[i]=0;  /* ENTER = fin */
	       return;
      case 0:  getch();    /* cargarse las "teclas" especiales */
	       break;
      case 27: break;      /* El ESC no hace nada */

      default : if (i<max) {
		  cprintf ("%c",c);
		  cad[i]=c;
		  i++;
		}
    }
  }while (1);
}

byte fin_comando()
/* Ŀ
    Comprobar que el siguiente token es el de fin de comando.            
   */
{

  leer_token();
  if (t.tipo!=tfin) {
    print_error(3);
    return 0;
  }
  else return 1;
}

void comando_md()
/* Ŀ
    COMANDO MD   
   */
{
  byte dir[2];
  unsigned int nbloq;

  leer_token();

  if (t.tipo!=tnumero) {
    print_error(2);
    return;              /* Direccin de memoria incorrecta */
  }

  dir[0]=t.dato1;
  dir[1]=t.dato2;

  leer_token();
  if (t.tipo==tfin) {
    nbloq=16;
    ejecuta_md(dir,nbloq);
    return;
  }

  if (t.tipo!=tnumero) {
    print_error(4);      /* Se esperaba un nmero */
    return;
  }

  nbloq=t.dato2*256+t.dato1;

  if (fin_comando()) {
    ejecuta_md(dir,nbloq);
    return;
  }

}

void comando_ms()
/* Ŀ
    COMANDO MS   
   */
{
  byte dir[2];
  byte dato;

  leer_token();

  if (t.tipo!=tnumero) {
    print_error(2);
    return;
  }
  dir[0]=t.dato1;
  dir[1]=t.dato2;

  leer_token();

  if (t.tipo!=tnumero) {
    print_error(4);
    return;
  }

  dato=t.dato1;
  if (t.dato2>0) {
    print_error(5);
    return;
  }

  if (fin_comando())
    ejecutar_ms(dato,dir);

}



void comando_mse()
/* Ŀ
    COMANDO MSE  
   */
{
  byte dir[2];
  byte dato;

  leer_token();

  if (t.tipo!=tnumero) {
    print_error(2);
    return;
  }
  dir[0]=t.dato1;
  dir[1]=t.dato2;

  leer_token();

  if (t.tipo!=tnumero) {
    print_error(4);
    return;
  }

  dato=t.dato1;
  if (t.dato2>0) {
    print_error(5);
    return;
  }

  if (fin_comando())
	ejecutar_mse(dato,dir);
}


void comando_A()
/* Ŀ
    COMANDO A    
   */
{
  byte dir[2];
  byte dato;

  dir[0]=0x00;
  dir[1]=0x10;

  leer_token();

  if (t.tipo!=tnumero) {
    print_error(4);
    return;
  }

  dato=t.dato1;
  if (t.dato2>0) {
    print_error(5);
    return;
  }

  if (fin_comando())
	ejecutar_ms(dato,dir);
}



void comando_cls()
/* Ŀ
    COMANDO CLS  
   */
{
  if (fin_comando()) {
    textcolor(7);
    clrscr();
  }
}

void comando_ckc()
/* Ŀ
    COMANDO CKC  
   */
{
  if (!fin_comando()) return;
  ejecutar_ckc();
}

void comando_go()
/* Ŀ
    COMANDO GO   
   */
{
  byte dir[2];

  leer_token();

  if (t.tipo!=tnumero) {
    print_error(2);
    return;              /* Direccin de memoria incorrecta */
  }

  dir[0]=t.dato1;
  dir[1]=t.dato2;

  if (fin_comando()) {
    ejecuta_go(dir);
    return;
  }
}

void comando_dasm()
/* Ŀ
    COMANDO DASM 
   */
{
  byte dir[2];

  leer_token();

  if (t.tipo!=tnumero) {
    print_error(2);
    return;              /* Direccin de memoria incorrecta */
  }

  dir[0]=t.dato1;
  dir[1]=t.dato2;

  if (fin_comando()) {
    ejecuta_dasm(dir);
    return;
  }
}


void comando_info()        /* ANDRES  */
/* Ŀ
    COMANDO INFO   
   */
{
  if (!fin_comando()) return;
  ejecutar_info();
}



void comando_bulk()        /* ANDRES  */
/* Ŀ
    COMANDO BULK   
   */
{
  if (!fin_comando()) return;
  ejecutar_bulk();
}


void comando_config()	  /* ANDRES  */
/* Ŀ
    COMANDO CONFIG 
   */
{
  byte dato;

  leer_token();

  if (t.tipo!=tnumero) {
    print_error(4);
    return;
  }

  dato=t.dato1;
  if (t.dato2>0) {
    print_error(5);
    return;
  }
  if (fin_comando()) {
	ejecutar_config(dato);
  }
}


void comando_eeprom()
/* Ŀ
    COMANDO EEPROM 
   */
{
  leer_token();

  if (t.tipo!=tidentif && t.tipo!=tcomando) {
    print_error(9);
    return;
  }

  if (fin_comando()) {
    ejecutar_eeprom(identif);
  }
}



void comando_load()
/* Ŀ
    COMANDO LOAD   
   */
{
  leer_token();

  if (t.tipo!=tidentif && t.tipo!=tcomando) {
    print_error(9);
    return;
  }

  if (fin_comando()) {
    ejecutar_load(identif);
  }
}


void ayuda_md()
/* Ŀ
    Imprimir la ayuda general del comando md 
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("   ");
  textcolor(14); cprintf ("COMANDO MD");
  textcolor(7);  cprintf ("         Volcar bloques de memoria                          \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("MD direccin [n de bloques]\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Volcar el nmero de bloques especificados a partir de la direccin\r\n");
		 cprintf ("             indicada. Si no se especifica el nmero de bloques a volcar, por\n\r");
		 cprintf ("             defecto se vuelcan 16 bloques. Cada bloque est constituido\r\n");
		 cprintf ("             por 16 bytes de memoria\n\r");
  textcolor(15); cprintf ("EJEMPLOS:\r\n");
  textcolor(9);  cprintf ("  MD b600");
  textcolor(7);  cprintf ("    Visualizar 16 bloques de memoria a partir de la direccion b600\r\n");
  textcolor(9);  cprintf ("  MD 1000 1");
  textcolor(7);  cprintf ("  Visualizar 1 bloque de memoria a partir de la direccin $1000\r\n");
  textcolor(9);  cprintf ("  MD 8000 ff");
  textcolor(7);  cprintf (" Visualizar 256 bloques ($ff) a partir de la direccin $8000\r\n");

  cprintf ("\r\n");
}

void ayuda_ms()
/* Ŀ
    Imprimir la ayuda del comando ms    
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("   ");
  textcolor(14); cprintf ("COMANDO MS");
  textcolor(7);  cprintf ("         Almacenar un byte en una direccin de memoria      \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("MS direccin valor\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Almacenar en la direccin de memoria especificada el valor de     \r\n");
		 cprintf ("             8 bits indicado.\n\r");
  textcolor(15); cprintf ("EJEMPLOS:\r\n");
  textcolor(9);  cprintf ("  MS 1000 40");
  textcolor(7);  cprintf ("  Almacenar el valor $40 en la direccin 1000. Como esta\r\n");
		 cprintf ("              direccin corresponde al puerto A del 6811, se activa el\r\n");
		 cprintf ("              bit 6 del puerto A y se enciende el LED de la tarjeta CT6811\r\n");
  textcolor(9);  cprintf ("  MS 8000 ff");
  textcolor(7);  cprintf ("  Almacenar el valor $ff en la direccin 8000 (Esta direccin\r\n");
		 cprintf ("              debe ser memoria RAM)\r\n");

  cprintf ("\r\n");
}



void ayuda_mse()
/* Ŀ
    Imprimir la ayuda del comando mse   
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("   ");
  textcolor(14); cprintf ("COMANDO MSE");
  textcolor(7);  cprintf ("         Almacenar un byte en una direccin de la EEPROM   \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("MSE direccin valor\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Almacenar en la direccin de memoria EEPROM especificada   \r\n");
		 cprintf ("             el valor de 8 bits indicado.\n\r");
  textcolor(15); cprintf ("EJEMPLOS:\r\n");
  textcolor(9);  cprintf ("  MSE B600 40");
  textcolor(7);  cprintf ("  Almacenar el valor $40 en la direccin B600. Suponiendo\r\n");
		 cprintf ("              que dicha posicin sea de EEPROM. ( Por ejemplo en el \r\n");
		 cprintf ("              modelo 68HC11A1 esta en la $B600-$B7FF.)\r\n");
		 cprintf ("               Tambin hay que tener cuidado con no intentar programar\r\n");
		 cprintf ("              zonas de EEPROM protegidas,pues la escritura sobre ellas\r\n");
		 cprintf ("              no tendra efecto.\r\n");
  cprintf ("\r\n");
}


void ayuda_dasm()
/* Ŀ
    Imprimir la ayuda del comando DASM  
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("   ");
  textcolor(14); cprintf ("COMANDO DASM");
  textcolor(7);  cprintf ("         Desensamblar bytes de memoria                    \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("DASM direccin\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Desensamblar a partir de la direccin indicada.\r\n");
  textcolor(15); cprintf ("EJEMPLOS:\r\n");
  textcolor(9);  cprintf ("  DASM 0");
  textcolor(7);  cprintf ("     Desensamblar el contenido de la RAM interna del 6811\r\n");
  textcolor(9);  cprintf ("  DASM B600");
  textcolor(7);  cprintf ("  Desensamblar el contenido de la memoria EEPROM del 6811\r\n");

  cprintf ("\r\n");
}

void ayuda_eeprom()
/* Ŀ
    Imprimir la ayuda del comando EEPROM 
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("  ");
  textcolor(14); cprintf ("COMANDO EEPROM");
  textcolor(7);  cprintf ("  Grabar un programa .s19 en la memoria eeprom del 6811  \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("EEPROM archivo\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Grabar en la memoria EEPROM del 6811 el archivo .S19 indicado.\r\n");
		 cprintf ("             Para que el programa se grabe correctamente debe haberse definido\r\n");
		 cprintf ("             para estar comprendido en los lmites de la memoria EEPROM,\r\n");
		 cprintf ("             mediante directivas ORG en el programa fuente.\r\n");
  textcolor(15); cprintf ("EJEMPLOS:\r\n");
  textcolor(9);  cprintf ("  EEPROM prueba");
  textcolor(7);  cprintf ("  Grabar el programa prueba.s19 en la EEPROM. El programa\r\n");
		 cprintf ("                 prueba.asm debe tener al comienzo una directiva ORG con un\r\n");
		 cprintf ("                 valor de direccin comprendido entre los valores $B600 y\r\n");
		 cprintf ("                 $B7FF que son los lmites de la memoria EEPROM.\r\n");
  textcolor(9);  cprintf ("  EEPROM led.s19");
  textcolor(7);  cprintf ("  Grabar el programa led.s19 en la memoria EEPROM\r\n");

  cprintf ("\r\n");
}

void ayuda_g()
/* Ŀ
    Imprimir la ayuda del comando G      
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("  ");
  textcolor(14); cprintf ("COMANDO G     ");
  textcolor(7);  cprintf ("  Saltar a un programa y ejecutarlo.                     \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("G direccion\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Saltar a la direccin especificada y empezar a ejecutar el\r\n");
		 cprintf ("             programa que all se encuentre. Una vez ejecutado este comando\r\n");
		 cprintf ("             la conexin con la tarjeta se pierde, puesto que el 6811\r\n");
		 cprintf ("             ya no estar ejecutando el programa que mantiene la conexin.\r\n");
  textcolor(15); cprintf ("EJEMPLOS:\r\n");
  textcolor(9);  cprintf ("  G b600");
  textcolor(7);  cprintf ("  Ejecutar el programa que se encuentra en la memoria EEPROM\r\n");
  textcolor(9);  cprintf ("  G 8000");
  textcolor(7);  cprintf ("  Ejecutar un programa que se encuentra direccin $8000 de la RAM\r\n");

  cprintf ("\r\n");
}

void ayuda_ckc()
/* Ŀ
    Imprimir la ayuda del comando CKC    
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("  ");
  textcolor(14); cprintf ("COMANDO CKC   ");
  textcolor(7);  cprintf ("  Comprobar el estado de la conexin con la tarjeta      \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("CKC\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Se muestra el puerto actual de comunicaciones y el estado\r\n");
		 cprintf ("             de la conexin con la tarjeta. La conexin con la tarjeta\r\n");
		 cprintf ("             deja de existir por alguno de los siguientes motivos:\r\n");
		 cprintf ("             Se ha realizado un reset de la tarjeta, se ha desconectado\r\n");
		 cprintf ("             el cable que va al PC, la tarjeta no est alimentada o \r\n");
		 cprintf ("             el 6811 est ejecutando un programa que no es el CTSERVER\r\n");

  cprintf ("\r\n");}

void ayuda_cls()
/* Ŀ
    Imprimir la ayuda del comando CLS    
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("  ");
  textcolor(14); cprintf ("COMANDO CLS   ");
  textcolor(7);  cprintf ("  Borrar la pantalla.                                    \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("CLS\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Borrar la pantalla y situar el prompt en la parte superior\r\n");
		 cprintf ("             izquierda de la pantalla.\r\n");

  cprintf ("\r\n");
}

void ayuda_info()             /* ANDRES  */
/* Ŀ
    Imprimir la ayuda del comando INFO   
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("  ");
  textcolor(14); cprintf ("COMANDO INFO  ");
  textcolor(7);  cprintf ("  Muestra informacin sobre el microcontrolador.         \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("INFO\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Informa sobre la configuracin del microcontrolador.\r\n");
		 cprintf ("             Da la situacin de la EEPROM y muestra el CONFIG.\r\n");

  cprintf ("\r\n");
}

void ayuda_bulk()             /* ANDRES  */
/* Ŀ
    Imprimir la ayuda del comando BULK   
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("  ");
  textcolor(14); cprintf ("COMANDO BULK  ");
  textcolor(7);  cprintf ("  Borra toda la EEPROM interna del microcontrolador.     \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("BULK\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Borra la EEPROM interna del microcontrolador. El registro CONFIG\r\n");
		 cprintf ("             no se ve afectado.\r\n");

  cprintf ("\r\n");
}



void ayuda_config()
/* Ŀ
    Imprimir la ayuda del comando CONFIG 
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("  ");
  textcolor(14); cprintf ("COMANDO GONFIG");
  textcolor(7);  cprintf ("  Programa el registro CONFIG.                           \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("CONFIG byte \r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Escribe el valor indicado en el registro CONFIG, para hacer\r\n");
		 cprintf ("             efectivo el cambio tendremos que hacer un RESET.\r\n");
  cprintf ("\r\n");
}


void ayuda_quit()
/* Ŀ
    Imprimir la ayuda del comando QUIT   
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("  ");
  textcolor(14); cprintf ("COMANDO QUIT  ");
  textcolor(7);  cprintf ("  Salir de CTDIALOG.                                     \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("QUIT\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Salir del programa CTDIALOG y devolver el control al DOS.\r\n");
		 cprintf ("             La conexin con la tarjeta no se pierde. Si se vuelve a ejecutar\r\n");
		 cprintf ("             el programa CTDIALOG la conexin se retomar.\r\n");

  cprintf ("\r\n");
}


void ayuda_load()
/* Ŀ
    Imprimir la ayuda del comando LOAD   
   */
{
  presenta();
  textcolor(7);
  cprintf ("ͻ\r\n");
  cprintf ("  ");
  textcolor(14); cprintf ("COMANDO LOAD  ");
  textcolor(7);  cprintf ("  Cargar un programa en la memoria RAM.                  \r\n");
  cprintf ("ͼ\r\n\n");
  textcolor(15); cprintf ("SINTAXIS:    ");
  textcolor(7);  cprintf ("LOAD archivo\r\n");
  textcolor(15); cprintf ("DESCRIPCION: ");
  textcolor(7);  cprintf ("Cargar en la memoria RAM el archivo .s19 indicado. Este comando\r\n");
		 cprintf ("             no comprueba si el sistema tiene RAM o no.El programa especificado\r\n");
		 cprintf ("             simplemente se transfiere. Que exista o no memoria RAM es problema\r\n");
		 cprintf ("             del usuario. No se permite cargar programas en la RAM interna del\r\n");
		 cprintf ("             6811 para no machacar el programa CTSERVER y perder la conexin\r\n");
  textcolor(15); cprintf ("EJEMPLOS:\r\n");
  textcolor(9);  cprintf ("  LOAD prueba");
  textcolor(7);  cprintf ("   Cargar el programa prueba.s19 en la RAM. El programa\r\n");
		 cprintf ("                se carga en la direccin indicada por la directiva ORG\r\n");
		 cprintf ("                del programa fuente (.ASM).\r\n");
  textcolor(9);  cprintf ("  LOAD led.s19");
  textcolor(7);  cprintf ("  Cargar el programa led.s19 en la memoria RAM\r\n");

  cprintf ("\r\n");
}

void ayuda_comando(comando)
char *comando;
/* Ŀ
    Imprimir la ayuda del comando indicado   
   */
{

  if (strcmp(comando,"MD")==0) ayuda_md();
  else if (strcmp(comando,"MS")==0) ayuda_ms();
    else if (strcmp(comando,"DASM")==0) ayuda_dasm();
      if (strcmp(comando,"EEPROM")==0) ayuda_eeprom();
      else if (strcmp(comando,"G")==0) ayuda_g();
	if (strcmp(comando,"CKC")==0) ayuda_ckc();
	else if (strcmp(comando,"CLS")==0) ayuda_cls();
	  if (strcmp(comando,"QUIT")==0) ayuda_quit();
		else if (strcmp(comando,"LOAD")==0) ayuda_load();
		  if (strcmp(comando,"INFO")==0) ayuda_info();   	/* ANDRES  */
		  else if (strcmp(comando,"BULK")==0) ayuda_bulk();   	/* ANDRES  */
			if (strcmp(comando,"CONFIG")==0) ayuda_config();   	/* ANDRES  */
			else if (strcmp(comando,"MSE")==0) ayuda_mse();   	/* ANDRES  */
}

void comando_help()
/* Ŀ
    Imprimir la ayuda general  
   */
{
  leer_token();


  if (t.tipo==tfin) {
    presenta();
    textcolor(7);
    cprintf ("Todos los valores se deben introducir en hexadecimal\n\n\r");
		   cprintf ("ͻ\r\n");
		   cprintf ("   ");
    textcolor(14); cprintf ("COMANDOS                         DESCRIPCION                          ");
    textcolor(7);  cprintf ("\r\n");
		   cprintf ("ͼ\r\n");
    textcolor(11); cprintf ("  MD     dir bloques  ");
    textcolor(9);  cprintf ("-Mostrar un n de bloques de memoria\r\n");
    textcolor(11); cprintf ("  MS     dir byte     ");
    textcolor(9);  cprintf ("-Introducir un byte en una direccin de memoria\r\n");
	textcolor(11); cprintf ("  MSE    dir byte     ");
	textcolor(9);  cprintf ("-Introducir un byte en una direccin de la eeprom\r\n");  /* ANDRES */
	textcolor(11); cprintf ("  CONFIG byte         ");
	textcolor(9);  cprintf ("-Programar el registro CONFIG.\r\n");                  /* ANDRES !!!!!! */
	textcolor(11); cprintf ("  DASM   dir          ");
	textcolor(9);  cprintf ("-Desensamblar a partir de la direccin especificada\r\n");
	textcolor(11); cprintf ("  EEPROM fichero      ");
	textcolor(9);  cprintf ("-Grabar un programa en la memoria EEPROM\r\n");
	textcolor(11); cprintf ("  LOAD   fichero      ");
	textcolor(9);  cprintf ("-Cargar un programa en memoria RAM\r\n");
	textcolor(11); cprintf ("  G      dir          ");
	textcolor(9);  cprintf ("-Saltar a la direccin especificada\r\n");
	textcolor(11); cprintf ("  CKC                 ");
	textcolor(9);  cprintf ("-Comprobar estado de la conexin\r\n");
	textcolor(11); cprintf ("  CLS                 ");
	textcolor(9);  cprintf ("-Borrar la pantalla\r\n");
	textcolor(11); cprintf ("  INFO                ");
	textcolor(9);  cprintf ("-Informacin sobre el microcontrolador\r\n");          /* ANDRES !!!!!! */
	textcolor(11); cprintf ("  BULK                ");
	textcolor(9);  cprintf ("-Borrar la EEPROM interna del microcontrolador\r\n");  /* ANDRES !!!!!! */
	textcolor(11); cprintf ("  QUIT                ");
	textcolor(9);  cprintf ("-Salir de CTDIALOG\r\n");
    textcolor(7);  cprintf ("ͻ\r\n");
		   cprintf ("   ");
    textcolor(12); cprintf ("  HELP COMANDO ----> Obtener ms informacin sobre un comando         ");
    textcolor(7);  cprintf ("\r\n");
		   cprintf ("ͼ\r\n");
    return;
  }

  if (t.tipo!=tcomando) {
    print_error(10);
    return;
  }

  if (fin_comando()) {
    ayuda_comando(identif);
    return;
  }

}


int procesar_comando()
/* Ŀ
    Esperar un comando y procesarlo. Si el comando es QUIT se retorna 0  
   */
{
  input(cadcom,20);   /* Leer una cadena del teclado */
  ind=0;
  carsig=' ';
  leer_token();
  if (t.tipo==tfin) return 1;  /* Instruccin NULA */
  if (t.tipo!=tcomando) {
    print_error(1);
  }
  switch (t.dato1) {      /* Segn el comando introducido */
    case 1: comando_md();
	    break;
    case 2: comando_ms();
	    break;
    case 3: return 0;
    case 4: comando_cls();
	    break;
    case 5: comando_load();
	    break;
    case 6: comando_ckc();
	    break;
    case 7: comando_help();
	    break;
    case 8: comando_go();
	    break;
    case 9: comando_dasm();
	    break;
    case 10: comando_eeprom();
	     break;
    case 11: comando_load();
		 break;
	case 12: comando_info();      /* ANDRES   */
		 break;
	case 13: comando_bulk();      /* ANDRES   */
		 break;
	case 14: comando_config();    /* ANDRES   */
		 break;
	case 15: comando_mse();    /* ANDRES   */
		 break;
	case 16: comando_A();    /* ANDRES   */
		 break;

  }
  return 1;
}