/*********************************************************************/
/*  J&J  Soft-Hard Company.  Noviembre 1995.  ETSI Telecomunicacion  */
/*********************************************************************/
/*                                                                   */
/*  CADENAS.C  -->  Libreras para el manejo de cadenas              */
/*                                                                   */
/*********************************************************************/

#include<stdio.h>
#include<conio.h>
#include<ctype.h>
#include<stdlib.h>

#define CR  13
#define DEL 8
#define ESC 27


void input_cad(char cad[],int maxcar)
/***********************************************************************/
/*  Pedir una cadena por el teclado. La cadena se devuelve en "cad".   */
/*  Slo se pueden introducir como mximo "maxcar" caracteres.         */
/*  Si se pulsa la tecla ESC se aborta y se devuelve un 0 en cad[0].   */
/*  Si se pulsa ENTER y no hay cadena introducida tambin se devuelve  */
/*  un 0 en cad[0]                                                     */
/***********************************************************************/
{
  char c;
  int i=0;

  cad[0]=0;
  if (maxcar==0) return;

  do {
    c=getch();
    if (c==CR) {     /* Si se pulsa enter               */
      cad[i]=0;      /* Delimitar la cadena y retornar  */
      return;
    }
    if (c==ESC) {    /* Si se pulsa ESC se aborta */
      cad[0]=0;
      return;
    }
    if (c==DEL) {
      if (i>0) {
	i--;
	printf ("\b \b");
      }
    }
    else {
      if (i<maxcar) {
	cad[i]=c;
	i++;
	printf ("%c",c);
      }
    }
  } while (1);
}


int input_numero(void)
/***********************************************************************/
/*  Pedir un entero por el teclado.                                    */
/*  Si se pulsa la tecla ESC se aborta                                 */
/***********************************************************************/
{
  char c,cad[4];
  int i=0;

  do {
    c=getch();
	switch (c) {
		case CR : cad[i]='.'; break;
		case ESC: return 0;
		case DEL: if (i>0) {
					  i-- ;
					  printf ("\b \b");
					  }; break;
		default : if (isdigit(c)!=0 && i<4) {
					 cad[i]=c;
					 i++;
					 printf("%c",c);
                     };
        }
  } while (cad[i]!='.');

  if (cad[0]=='.') { return 0;}
	else if (cad[1]=='.') { return cad[0]-48;}
	 else if (cad[2]=='.') { return (cad[1]+cad[0]*10-528);}
	  else if (cad[3]=='.') {return (cad[2]+cad[1]*10+cad[0]*100-5328);}
	   else if (cad[4]=='.') {
		 return (cad[3]+cad[2]*10+cad[1]*100+cad[0]*1000-53328);
		 }
		 else return 0;
}

