/*
 ͻ
  S19.H       (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
    Fichero con definicin de tipos y estructuras necesarios para todos    
  los programas que trabajan con la libreria S19.C                         
                                                                           
 ͼ
*/

struct registros1 {  /* Estructura registros del tipo 1 */

	  unsigned short int tam;        /* Tamao codigo/datos  */
	  unsigned int dir;              /* Direccion            */
	  unsigned short int codigo[37]; /* Codigo/datos         */
	  struct registros1 *sig;        /* Siguiente registro   */

};

struct sfichs19 {   /* Estructura ficheros S19 */

	 unsigned int nbytes;        /* N bytes total de codigo fich. S19 */
	 unsigned int nreg;          /* N registros del tipo 1            */
	 struct registros1 *cabeza;  /* Lista de registros del tipo 1      */

};

typedef struct sfichs19 S19;  /* TIPO S19 */

#define NULL 0

/* TIPO S19

    Este tipo representa a un fichero en formato S19. Las librerias de
    interfaz lo que hacen es crear y manipular variables del tipo S19.
    Este tipo se puede considerar como un tipo abstracto de datos. No
    importa cmo es la estructura interna. Slo hay que saber cmo se
    opera con este tipo.
								       */

int abrir_s19(char *fich,S19 *ss19,int modo);
/*
Ŀ
  Abrir un fichero .S19 y crear una variable de tipo S19. Para trabajar   
  con cualquier fichero .S19 habr que abrirlo primero.                   
                                                                          
   PARAMETROS ENTRADA:                                                    
                                                                          
      - Fich: Nombre del fichero .S19 a abrir. Si se especifica sin       
              extension por defecto se toma extensin.S19. Se puede       
              especificar la ruta completa del fichero.                   
                                                                          
      - Modo: Indica el modo de apertura del fichero. Existen dos modos   
                                                                          
              - Modo 1: Se comprueba el Checksum de todos los registros   
              - Modo 0: No se comprueba el checksum.                      
                                                                          
   PARAMETROS DE SALIDA:                                                  
                                                                          
      - ss19: Se devuelve una variable del tipo S19 que sera necesaria    
              para trabajar con el fichero abierto.                       
                                                                          
   La funcin devuelve 0 si no ha podido abrir el fichero porque se ha    
   producido algn error.                                                 
                                                                          
                                                                          
   Si el fichero ha sido abierto correctamente se devuelve un 1           
                                                                          
*/


void cerrar_s19(S19 ss19);
/*
Ŀ
  Dejar de trabajar con el archivo S19 especificado. Se libera toda la
  memoria que se habia tomado.                                        
*/


int leerdir_s19(S19 ss19,int nreg, unsigned int *dir);
/*
Ŀ
  Leer el campo direccion del fichero S19 especificado.               
                                                                      
                                                                      
  ENTRADAS:                                                           
                                                                      
       - ss19: Fichero S19 abierto con el que trabajar                
       - nreg: Numero del registro al que se quiere acceder           
                                                                      
  SALIDAS:                                                            
                                                                      
       - dir : Campo direccion del registro especificado              
                                                                      
      Se devuelve 0 en caso de que no exista el registro pedido.      
      Se devuelve 1 en caso de exito.                                 
*/


int leercod_s19(S19 ss19,int nreg, unsigned short int *cod, unsigned short int *tam);
/*
Ŀ
  Leer el campo codigo/datos del registro especificado.               
                                                                      
  ENTRADAS:                                                           
                                                                      
     - ss19 : Fichero S19 abierto con el que trabajar                 
     - nreg : Numero del registro al que se quiere acceder            
                                                                      
  SALIDAS:                                                            
                                                                      
     - cod : Campo cdigo/datos del registro especificado             
     - tam : tamao del campo codigo/datos                            
                                                                      
      Se devuelve 0 en caso de que no exista el registro pedido.      
      Se devuelve 1 en caso de exito.                                 
*/


unsigned int getnbytes19(S19 ss19);
/*
Ŀ
  Devolver el numero de bytes de todo el codigo del fichero S19       
  especificado.                                                       
*/

unsigned int getnregs19(S19 ss19);
/*
Ŀ
  Devolver el numero de registros del tipo 1 del fichero S19  
  especificado.                                               
*/


char *geterrors19();
/*
Ŀ
  Devolver la cadena del error producido en la ultima apertura del        
  fichero .S19                                                            
*/


