/*
 ͻ
  CTSERVER.C  (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Versin 2.0.  Rutinas para realizar llamadas remotas a los servicios     
  del servidor de propsito general CTSERVER.                              
                                                                           
    Esta libreria se utiliza para implementar CLIENTES para el servidor    
  CTSERVER.                                                                
                                                                           
 ͼ
*/


/*                       ͻ
                                                 
ĺ   I N T E R F A Z      
                                                 
                         ͼ                      */

int ctalive();
/* Ŀ
    Comprobar si existe conexin con el servidor CTSERVER.               
                                                                         
    Se devuelve:                                                         
              0 --> Servidor no responde                                 
              1 --> El servidor ha respondido                            
   */

void ctsend_block(uint dir, uint tam, byte *buff, void (*sendcar)());
/*Ŀ
   Enviar un bloque de datos desde el PC al 68HC11. El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento sendcar pasado
   como argumento.                                                      
                                                                        
  */

int ctreceive_block(uint dir, uint tam, byte *buff, void (*reccar)());
/*Ŀ
   Recibir un bloque de datos desde el 68HC11. El bloque tiene un       
   tamao tam y comienza a partir de la direccin dir. El bloque reci-  
   bido se sita en el buffer buff. Cada vez que se recibe un byte se   
   llama al procedimiento reccar pasado como parametro.                 
                                                                        
     La funcin devuelve un 0 si el CTSERVER no responde. Se enva un   
   1 si la operacin se ha realizado con xito.                         
                                                                        
  */

int ctsave_eeprom(uint dir,uint tam,byte *buff, void (*eeprcar)());
/*Ŀ
   Grabar un bloque de datos en la memoria EEPROM.  El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento eepromcar     
   pasado como argumento.                                               
                                                                        
     La funcin devuelve 0 si ha ocurido algn error. Devuelve 1 en     
   caso de exito.                                                       
                                                                        
  */

void ctexecute(uint dir);
/* Ŀ
    Llamar al servicio de salto y ejecucin del servidor CTSERVER.       
   */

void ctsend_byte(uint dir, byte valor);
/*Ŀ
   Enviar el byte especificado en la direccin indicada. 
  */

int ctreceive_byte(uint dir,byte *valor);
/*Ŀ
   Leer un byte de la direccin de memoria especificada. La funcin     
   devuelve 0 si el CTSERVER no responde. 1 en caso contrario.          
  */



