/*
 ͻ
  ASCBIN.H    (c) GRUPO J&J. Julio 1997.                                   
 ͹
                                                                           
  Versin 1.0.                                                             
                                                                           
    Rutinas para la conversin de digitos ASCII a numeros binarios y       
  viceversa.                                                               
                                                                           
                                                                           
 ͼ
*/


/*

                         ͻ
                                                 
ĺ   I N T E R F A Z      
                                                 
                         ͼ                       */


int char1tobyte(char car,unsigned short int *dec);
/*
Ŀ
  Se toma una carcter hexadecimal en ASCII y se convierte a un nmero   
  entero.                                                                
                                                                         
    EJ: char1tobyte('A',&x);  Se convertira el digito ASCII 'A' en el   
                              numero 10 que se devolvera en x.          
                                                                         
    Se devuelve 0 si el carcter no es un digito en hexadecimal          
    Se devuelve 1 en caso contrario.                                     
                                                                         
*/


int char2tobyte(char *cad,unsigned short int *dec);
/*
Ŀ
  Se toma una cadena con dos dgitos hexadecimales ASCII y los convierte 
  en un nmero entero de 8 bits                                          
                                                                         
  Ej: char2tobyte("FF",&x);  Se convierte la cadena "FF" en el nmero    
                             255 que se devuelve en x.                   
                                                                         
    Se devuelve 0 si algn digito no est en hexadecimal.                
    Se devuelve 1 en caso contrario.                                     
                                                                         
*/

int char4toint(char *cad,unsigned int *dec);
/*
Ŀ
  Se toma una cadena con 4 dgitos hexadecimales ASCII y los convierte   
  en un nmero entero de 16bits                                          
                                                                         
  Ej. char4toint("123C",&x); Se convierte la cadena "123C" en el nmero  
                             4668 que se devuelve en x.                  
                                                                         
    Se devuelve 0 si algn digito no est en hexadecimal.                
    Se devuelve 1 en caso contrario.                                     
                                                                         
*/

int bytetochar1(unsigned short int byte, char *car);
/*
Ŀ
  Convertir un nmero entre 0-15 a caracteres hexadecimales en ASCII     
                                                                         
  Ej. bytetochar1(12,cad);  Se convierte el nmero 12 a la cadena "C"    
                            que se devuelve en cad                       
                                                                         
  Se devuelve un 1 si se ha realizado correctamente la conversin.       
  Se devuelve un 0 en caso contrario.                                    
                                                                         
*/


int bytetochar2(short num, char *cad);
/*Ŀ
   Convertir un nmero entre 0-255 a 2 caracters ASCII hexadecimales.    
                                                                         
   Ej. bytetochar2(127,cad); Se convierte el nmero 127 en la cadena "7F"
                             que se devuelve en cad                      
                                                                         
   Se devuelve un 1 si se ha realizado correctamente la conversin.      
   Se devuelve un 0 en caso contrario.                                   
                                                                         
  */


int inttochar4(long num, char *cad);
/*Ŀ
   Convertir un nmero entre 0-65535 a 4 caracters ASCII hexadecimales.  
                                                                         
   Ej. inttochar4(14563,cad); Se convierte el numero 14563 en la cadena  
                              "38E3" que se devuelve en cad              
                                                                         
   Se devuelve un 1 si se ha realizado correctamente la conversin.      
   Se devuelve un 0 en caso contrario.                                   
                                                                         
  */



