/*
 ͻ
  SERIE.C.    (c) GRUPO J&J. Julio 1997.                                   
 ͹
                                                                           
  Versin 2.0.  Rutinas de comunicaciones serie mediante interrupciones.   
  Estas rutinas no son de propsito general sino que estn adaptadas para  
  trabajar con la tarjeta CT6811.                                          
                                                                           
 ͼ
*/


/*

                         ͻ
                                                 
ĺ   I N T E R F A Z      
                                                 
                         ͼ
*/

/*
 ͻ
                              
  APERTURA DEL PUERTO SERIE   
                              
 ͼ
*/


void abrir_puerto_serie(int puerto);
/*
Ŀ
  Antes de comenzar a trabajar con el puerto serie hay que llamar a   
  esta funcin. En el argumento se le pasa el nmero de COM con el    
  que se quiere trabajar. Asi por ejemplo para abrir el COM1 habr    
  que llamar a la funcin:                                            
                                                                      
  abrir_puerto_serie(1);                                              
                                                                      
                                                                      
  Los puertos soportados son COM1, COM2, COM3 y COM4. Si se especifi- 
  ca como argumento un nmero distinto de 1,2,3  4 se abrir el      
  COM1                                                                
                                                                      
    Despus de llamar a esta rutina el puerto especificado queda con- 
 figurado para trabajar con 8 bits de datos, 1 bit de Stop y ninguno  
 de paridad. La velocidad es el 9600 baudios.                         
                                                                      
                                                                      
*/


/*
 ͻ
                              
  RUTINAS DE CONFIGURACION    
                              
 ͼ
*/


void baudios(int velocidad);
/*
Ŀ
  Establecer la velocidad en baudios especificada. Slo se permiten   
  tres velocidades: 1200, 7680 y 9600 baudios. Si se especifica otra  
  velocidad diferente se tomaran 9600 baudios.                        
  que llamar a la funcin:                                            
                                                                      
  Ejemplo de utilizacin:  baudios(1200);                             
                                                                      
*/


void vaciar_buffer(void);
/*
Ŀ
  Vaciar el buffer de recepcin. Si existan caracteres se desechan   
*/

/*
 ͻ
                                
  RUTINAS DE LECTURA/ESCRITURA  
                                
 ͼ
*/


void enviar_car(char car);
/*
Ŀ
  Enviar un carcter por el puerto serie abierto.    
*/


int car_waiting(void);
/*
Ŀ
  Esta funcin devuelve un valor 0 si no existe ningn carcter pen-  
  diente de ser ledo en el buffer de recepcin. Se devuelve un valor 
  distinto de 0 si existe algn carcter pendiente de ser ledo.      
*/

char leer_car(void);
/*
Ŀ
  Leer un carcter del buffer de recepcin. Si no hay ningn carcter 
  pendiente de ser ledo se espera indefinidamente hasta que llegue   
  algn carcter.                                                     
*/


char leer_car_plazo(int plazo,int *timeout);
/*
Ŀ
  Leer un carcter del buffer de recepcin. Si el carcter no se ha   
  recibido dentro del plazo establecido se devuelve un valor distin-  
  to de 0 en timeout. En caso de llegar un carcter dentro del plazo  
  indicado se devuelve el carcter y se devuelve 0 en timeout.        
                                                                      
    El valor del plazo se especifica en tics de reloj. Cada tic equi- 
  vale aproximadamente a 55ms.                                        
                                                                      
  Ejemplo:  c=leer_car_plazo(5,&timeout);  Leer un caracter. Si el    
            caracter no llega en un plazo de 5 tics de reloj se       
            devuelve un 1 en timeout.                                 
                                                                      
*/


/*
 ͻ
                        
    OTRAS RUTINAS       
                        
 ͼ
*/

void dtr_on(void);
/*
Ŀ
  Activar la seal DTR     
*/

void dtr_off(void);
/*
Ŀ
 Desactivar la seal DTR   
*/

int ok_break(void);
/*
Ŀ
  Se devuelve un valor 0 si no se ha recibido ninguna seal de BREAK  
  Se devuelve un valor distinto de 0 si se ha recibo un BREAK         
*/

int wait_break(int plazo);
/*
Ŀ
  Esperar a que venga una seal de BREAK en el plazo indicado.        
  Si es as se devuelve un valor distinto de 0. Si transcurre el plazo
  y no se ha recibido un BREAK se devuelve 0.                         
    El plazo se especifica en TICS de reloj. Cada Tic equivale aprox. 
  a 55ms.                                                             
*/


/*
 ͻ
                               
  TERMINAR CON EL PUERTO SERIE 
                               
 ͼ
*/

void cerrar_puerto_serie();
/*Ŀ
    Antes de terminar el programa es necesario llamar    
    a este procedimiento para desactivar las rutinas de  
    interrupcin.                                        
   */




