/*
 ͻ
  CT293+ TEST. GRUPO J&J.                   Microbtica       Versin 2.0  
 ͹
                                                                           
  Programa de prueba para la tarjeta de potencia CT293+.                   
                                                                           
 ͼ
*/

/*
Ŀ
       INFORMACION SOBRE LA TARJETAS CT293+                               
Ĵ
                                                                          
   La  tarjeta permite realizar las siguientes funciones:                 
                                                                          
        - mover dos motores de continua o uno paso_paso (PUERTO A)        
        - leer el estado de cuatro sensores de ifrarrojos (PUERTO A)     
        - leer ocho entradas digitales o analogicas . (Puerto E)          
                                                                          
   Tambin tiene otras funciones que amplian la versatibilidad de la      
  misma.                                                                  
         - Alimentacion externa o interna.                                
         - Desconexion de los infrarrojos no utilizados.                  
         - Conexion con clemas                                            
                                                                          
                                                                          
                                                                          
   La CT293+ se ha desarrollado para unirse a la CT6811, aunque se puede  
  conectar a cualquier sistema digital. Este programa supone que esta     
  conectada a la CT293+. Cargaremos en el servidor CTSERVER y a travs de 
  l actuaremos sobre la CT293+.                                          
                                                                          
   La actuacin con dicho servidor se realiza por medio de la librera    
 CTSERVER.LIB que ofrece servicios de alto nivel para la programacin.    
                                                                          
                                                                          
   Por ltimo destacamos que este programa mantiene la compatibilidad con 
 la tarjeta CT293 ( antecesora de la que ahora nos trata ).               
                                                                          

*/

#include<iostream.h>
#include<dos.h>
#include<stdio.h>
#include<conio.h>
#include<ctype.h>
#include<string.h>
#include<stdlib.h>
#include "ct294.h"



/*
Ŀ
                                                                          
   Variables del sistema y estructura de datos                            
                                                                          

*/


#define PA 1
#define PE 0

#define TIMEOUT_BREAK 4;

byte puertoE,puertoA;
int  bit_activo_A=0, bit_activo_E=0 ;
byte conversores[8];

enum reset {on,off} reset_manual=off;
enum puerto_serie {com1,com2} puerto=com2 ;



/*
 ͻ
                                                                           
    SUBRUTINAS DE CONTROL DEL PROGRAMA                                     
                                                                           
 ͼ
*/


void accion_rxcar()
{
}



void accion_break()
{
}


void nada()
{
}


int parametros_entrada(int na,char *arg[])
/* Ŀ
    Analizar los parmetros de la lnea de argumentos. Si se encuentran  
    errores se aborta el programa. Se actualizan las siguientes varia-   
    bles:                                                                
                                                                         
   */
{

  char *apun_cadena;


  if (na>3) {
	printf ("Demasiados parmetros\n");
	exit(1);
  }

  if (na==1) {   /* no hay parametros se toma por defecto perto 2 */
	puerto=com2;
	return 0 ;
  }

  while (--na >0 && (*++arg)[0]=='-') {
	for (apun_cadena=arg[0]+1;*apun_cadena !='\0'; apun_cadena++) {
		switch (*apun_cadena) {
	   case '1' : puerto=com1 ; break;
	   case '2' : puerto=com2 ; break;
//	   case 'm' : reset_manual=on; break;
	   default:
		cout << "Argumento desconocido " << *apun_cadena << "\n\n" ;
		cout << " -1 : Utilizar el COM1" << "\n";
		cout << " -2 : Utilizar el COM2 (valor por defecto)" << "\n";
//		cout << " -m    : Activar el reset manual" << "\n";
		exit(1);
	   }
	}
  }
  return 0;
}


void barra()
/* Ŀ
    Presenta la evolucion de la carga del programa.                      
   */
{
  static int i=0,n=0;

  if (n==16 || i==255) {
    n=0;
	textcolor(AMARILLO);
	cprintf ("");
  }

  i++;
  n++;
}






/*
 ͻ
                                                                           
    SUBRUTINAS DE PRESENTACION DEL PROGRAMA                                
                                                                           
 ͼ
*/


void color(int f,int b)
/*
Ŀ
 Cambiar colores. Parmetros:
     - color letra           
     - color fondo           

*/
{
  textbackground(b);
  textcolor(f);
}




void lineav(int x,int y,int longi,char carini,char carfin,char carlin)
/*
Ŀ
 Dibujar una linea vertical a partir de la coordenada x,y, comenzando 
 con el carcter carini, finalizando con el caracter carfin y la lnea
 formada por caracteres del tipo carlin.                              

*/
{
  int i;


  if (longi<3) return;
  gotoxy(x,y);
  cprintf ("%c",carini);
  for (i=y+1; i<y+longi-1; i++) {
    gotoxy(x,i);
    cprintf ("%c",carlin);
  }
  gotoxy(x,y+longi-1); cprintf ("%c",carfin);
}



void lineah(int x,int y,int longi,char carini,char carfin,char carlin)
/*
Ŀ
 Dibujar una linea horizontal a partir de la coordenada x,y, comenzando 
 con el carcter carini, finalizando con el caracter carfin y la lnea  
 formada por caracteres del tipo carlin.                                

*/
{
  int i;


  if (longi<3) return;
  gotoxy(x,y);
  cprintf ("%c",carini);
  for (i=x+1; i<x+longi-1; i++) {
    gotoxy(i,y);
    cprintf ("%c",carlin);
  }
  gotoxy(x+longi-1,y); cprintf ("%c",carfin);
}





void ventanas(int x,int y,int alt,int anch)
/*
Ŀ
 Dibujar una ventana simple  

*/
{
  int i;

  lineah(x,y,anch,'','','');
  lineah(x,y+alt-1,anch,'','','');

  lineav(x,y,alt,'','','');
  lineav(x+anch-1,y,alt,'','','');
}



void menu(int puerto)
/*
Ŀ
                                                                          
   Dibuja el marco de trabajo.                                            
                                                                          

*/
{
  int i;

  clrscr();
  color(AMARILLO,AZUL);
  cprintf(" CT293+ TEST   ");
  color(ROJOB,AZUL);
  cprintf("Versin 2.0 ");
  color(VERDEB,AZUL);
  cprintf("   GRUPO J&J.             MICROBOTICA");
  color(BLANCO,AZUL);
  cprintf("       COM%i     ", puerto);

  color(CELESTEB,NEGRO);
  ventanas(1,3,6,52);
  ventanas(1,11,6,52);
  ventanas(1,19,3,80);
  ventanas(1,19,3,9);
  ventanas(9,19,3,7);
  ventanas(54,3,6,7);
  ventanas(54,11,6,7);
  ventanas(54,8,3,7);
  ventanas(54,16,3,7);
  ventanas(62,4,4,19);
  ventanas(62,7,4,19);
  ventanas(62,13,3,19);
  ventanas(62,15,3,19);
  for (i=0 ; i<=7 ; i++) {
	ventanas(1+i*10,22,3,10);
	gotoxy(3+i*10,25); cprintf("CANAL %i",i);
  }
  gotoxy(9,19);cprintf("");gotoxy(15,19);cprintf("");
  gotoxy(9,21);cprintf("");gotoxy(15,21);cprintf("");
  gotoxy(54,8);cprintf("");gotoxy(54,16);cprintf("");
  gotoxy(60,8);cprintf("");gotoxy(60,16);cprintf("");
  gotoxy(62,7);cprintf("");gotoxy(62,15);cprintf("");
  gotoxy(80,7);cprintf("");gotoxy(80,15);cprintf("");
  gotoxy(64,3);cprintf("ESTADO MOTORES");
  gotoxy(64,12);cprintf("ESTADO CONEXION");

  color(AMARILLO,NEGRO);
  gotoxy(64,16);cprintf("");
  gotoxy(68,14);cprintf("Activa");
  for (i=0 ; i<=7 ; i++) {
	ventanas(3+i*5,4,3,5);
	ventanas(3+i*5,12,3,5);
	gotoxy(4+i*5,7); cprintf("PA%i",7-i);
	gotoxy(4+i*5,15); cprintf("PE%i",7-i);
  }

  color(BLANCO,NEGRO);
  for (i=0 ; i<=3; i++) {
	ventanas(8+i*5,4,3,5);
	gotoxy(9+i*5,7); cprintf("PA%i",6-i);
  }
  gotoxy(4,9); cprintf("Avanzar        Derecha          Activar bits");
  gotoxy(4,10);cprintf("Retroceder     Izquierda        Parar");
  gotoxy(9,17); cprintf("Seleccionar canal analgico");
  gotoxy(9,18); cprintf("Cambiar Puerto activo");
  gotoxy(64,5); cprintf("Motor 1");
  gotoxy(73,6); cprintf("  I");
  gotoxy(64,8); cprintf("Motor 2");
  gotoxy(73,9); cprintf("  D");
  gotoxy(44,13); cprintf("Puerto E");


  color(GRISB,NEGRO);
  gotoxy(64,9); cprintf("");
  gotoxy(64,6); cprintf("");


  color(ROJOB,NEGRO);
  gotoxy(44,5);  cprintf("Puerto A");

  gotoxy(2,9) ;  cprintf("Q"); gotoxy(17,9)  ; cprintf("P");
  gotoxy(2,10);  cprintf("A"); gotoxy(17,10) ; cprintf("O");
  gotoxy(2,9) ;  cprintf("Q"); gotoxy(31,10) ; cprintf("SPC");
  gotoxy(31,9);  cprintf("1..8");
  gotoxy(2,17);  cprintf("1..8");
  gotoxy(2,18);  cprintf("C");
}


void refresca_puertoA()
{
  int i;

  load(&puertoA,PORTA);  // leemos el PUERTA
  for(i=0; i<=7; i++) {
	color(AMARILLO,NEGRO);
	gotoxy(40-i*5,5);
	if ( (i>=3) && (i<=6) ) color(BLANCO,NEGRO);
	cprintf("%i", (puertoA>>i)&0x01);
  }
  color(BLANCO,NEGRO);gotoxy(45,6); cprintf("0x%X ",puertoA&0xFF);
}


void refresca_puertoE()
{
  int i,error;

  load(&puertoE,PORTE);  // leemos el PUERTO A
  color(AMARILLO,NEGRO);
  for(i=0; i<=7; i++) {
	gotoxy(40-i*5,13);
	cprintf("%i", (puertoE>>i)&0x01);
  }
  color(BLANCO,NEGRO);gotoxy(45,14); cprintf("0x%X ",puertoE&0xFF);
}



void dib_motor()
{
  if ( (puertoA&0x08)==0x08 ) {
	 color(BLANCO,NEGRO);
	 gotoxy(64,6); cprintf("");
  }
  else {
	 color(GRISB,NEGRO);
	 gotoxy(64,6); cprintf("");
  }

  if ( (puertoA&0x10)==0x10 ) {
	 color(BLANCO,NEGRO);
	 gotoxy(64,9); cprintf("");
  }
  else {
	 color(GRISB,NEGRO);
	 gotoxy(64,9); cprintf("");
  }

  if ( (puertoA&0x20)==0x20 ) {
	 color(BLANCO,NEGRO);
	 gotoxy(73,6); cprintf("  D");
  }
  else {
	 color(BLANCO,NEGRO);
	 gotoxy(73,6); cprintf("  I");
  }

  if ( (puertoA&0x40)==0x40 ) {
	 color(BLANCO,NEGRO);
	 gotoxy(73,9); cprintf("  I");
  }
  else {
	 color(BLANCO,NEGRO);
	 gotoxy(73,9); cprintf("  D");
  }
}


void dib_bit(int bit,int tipo)
/*
Ŀ
 Dibuja el bit seleccionado en grande   								   
   bit -> numero del bit que queremos.                                    
   tipo-> se refiere si el bit es del puerto A (tipo=1) o del E (tipo=0). 

*/
{
  int valor;
  if (tipo==1) {
	valor=(puertoA>>bit)&0x01;
  }
  else {
	valor=(puertoE>>bit)&0x01;
  }
  color(BLANCO,NEGRO);
  if (valor) {
	gotoxy(57,12-tipo*8); cprintf( " ");
	gotoxy(56,13-tipo*8); cprintf(" ");
	gotoxy(56,14-tipo*8); cprintf("  ");
	gotoxy(56,15-tipo*8); cprintf("");
	gotoxy(56,17-tipo*8); cprintf("P%c%i",'E'-tipo*('E'-'A'),bit);
  }
  else {
	gotoxy(57,12-tipo*8); cprintf( " ");
	gotoxy(56,13-tipo*8); cprintf(" ");
	gotoxy(56,14-tipo*8); cprintf(" ");
	gotoxy(56,15-tipo*8); cprintf("");
	gotoxy(56,17-tipo*8); cprintf("P%c%i",'E'-tipo*('E'-'A'),bit);
  }
}



void dib_ana_uno(int bit)
/*
Ŀ
 Dibuja el canal analogico seleccionado en grande   					   
   bit -> numero del canal que queremos.                                  

*/

{
	int j,tope;

	color(BLANCO,NEGRO);
	gotoxy(2,20); cprintf("Canal %i",bit);
	gotoxy(10,20); cprintf("0x%X ",conversores[bit]&0xff);
	tope=((conversores[bit]&0xff)>>2);
	color(ROJOB,NEGRO);
	gotoxy(16,20);
	for (j=1; j<=64-tope; j++) {
	 gotoxy(80-j,20);cprintf(" ");
	}
	for (j=0; j<=tope; j++) {
	  gotoxy(16+j,20);
	  if (j<=15) cprintf("");
	  if ((j>=16) && (j<=31) ) cprintf("");
	  if ((j>=32) && (j<=47) ) cprintf("");
	  if ( j>=48 ) cprintf("");
	}
}


void dib_ana_todos()
/*
Ŀ
 Dibuja los canales analogicos en pequeo     					           
 Despues de leer un grupo activa la siguiente la conversion del grupo     
 siguiente.                                                               

*/
{
  byte temp,error=1;
  int  tope,i,j,fin=0;

  do {
   error=load(&temp,ADCTL);
   if ( (temp&0x80)==0x80) {
	 error=load_block(conversores,4,ADR1,nada);
	 store(0x14,ADCTL);
	 fin=1;
   }
  } while ( (!fin)&(error) );

  color(VERDEB,NEGRO);
  for (i=0 ; i<=3 ; i++ ) {
   tope=((conversores[i]&0xff)>>5);
   for (j=0; j<=7-tope; j++) {
	gotoxy(9+i*10-j,23); cprintf(" ");
   }
   for (j=0; j<=tope; j++) {
	gotoxy(2+j+i*10,23);
	if (j<=3) cprintf("");
	if ((j>=4) && (j<=5) ) cprintf("");
	if ( j>=6 ) cprintf("");
   }
  }

  do {
   error=load(&temp,ADCTL);
   if ( (temp&0x80)==0x80) {
	 error=load_block(&conversores[4],4,ADR1,nada);
	 store(0x10,ADCTL);
	 fin=0;
   }
  } while ( fin&error);

  color(VERDEB,NEGRO);
  for (i=4 ; i<=7 ; i++ ) {
   tope=((conversores[i]&0xff)>>5);
   for (j=0; j<=7-tope; j++) {
	gotoxy(9+i*10-j,23); cprintf(" ");
   }
   for (j=0; j<=tope; j++) {
	gotoxy(2+j+i*10,23);
	if (j<=3) cprintf("");
	if ((j>=4) && (j<=5) ) cprintf("");
	if ( j>=6 ) cprintf("");

   }
  }

}



/*
 ͻ
                                                                           
    SUBRUTINAS DE DIALOGO CON EL SERVIDOR                                  
                                                                           
 ͼ
*/


void activar_conversores()
{
	store(0x80,OPTION);    // Activamos conversor
	store(0x10,ADCTL);     // Conversion multiple 4 primeros canales sin SCAN
}


void comprueba_conexion()
{
  static int x=0;

  if ( !hay_conexion()) {
	 color(ROJOB,NEGRO);
	 gotoxy(68,14);cprintf("Perdida");
	 resetct6811();
	 }
  else {
	 color(AMARILLO,NEGRO);
	 gotoxy(68,14); cprintf("Activa");
	 gotoxy(71-x,16);cprintf("");
	 gotoxy(71+x++,16);cprintf("");
	   if (x>=9) x=0;
	 color(VERDEB,NEGRO);
	 gotoxy(71+x,16);cprintf(">");
	 gotoxy(71-x,16);cprintf("<");
  }

}



/*
 ͻ
                                                                           
    SUBRUTINA DE PROCESAMIENTO DE COMANDOS                                 
                                                                           
 ͼ
*/

int procesar_comando()
{
  char c;
  int  tiempo;
  static int turno=0;  // 0 -> puerto A ,, 1 -> puerto E

  if (kbhit()) {
	c=toupper(getch());
    switch(c) {
	  case '0': if (turno) bit_activo_E=0;
				else bit_activo_A=0;
				break;
	  case '1': if (turno) bit_activo_E=1;
				else bit_activo_A=1;
				break;
	  case '2': if (turno) bit_activo_E=2;
				else bit_activo_A=2;
				break;
	  case '3': if (turno)  bit_activo_E=3;
				else {
				 puertoA=puertoA^0x08; dib_motor();store(puertoA,PORTA);
				}
				break;
	  case '4': if (turno) bit_activo_E=4;
				else {
				 puertoA=puertoA^0x10; dib_motor();store(puertoA,PORTA);
				}
				break;
	  case '5': if (turno) bit_activo_E=5;
				else {
				 puertoA=puertoA^0x20; dib_motor();store(puertoA,PORTA);
				}
				break;
	  case '6': if (turno) bit_activo_E=6;
				else {
				 puertoA=puertoA^0x40; dib_motor();store(puertoA,PORTA);
				}
				break;
	  case '7': if (turno) bit_activo_E=7;
				else bit_activo_A=7;
				break;
	  case ' ': puertoA=0x00; dib_motor();store(puertoA,PORTA); break;
	  case 'Q': puertoA=0x18; dib_motor();store(puertoA,PORTA); break;
	  case 'A': puertoA=0x78; dib_motor();store(puertoA,PORTA); break;
	  case 'P': puertoA=0x58; dib_motor();store(puertoA,PORTA); break;
	  case 'O': puertoA=0x38; dib_motor();store(puertoA,PORTA); break;
	  case 'W': store(0xf0,PORTB);  break;
	  case 'S': store(0x20,PORTB);  break;
	  case 'X': store(0x00,PORTB);  break;

	  case 'C': if (turno) {
				   turno=0;
				   color(BLANCO,NEGRO);
				   gotoxy(44,13); cprintf("Puerto E");
				   color(ROJOB,NEGRO);
				   gotoxy(44,5);  cprintf("Puerto A");}
				else  {
				   turno=1;
				   color(BLANCO,NEGRO);
				   gotoxy(44,5);  cprintf("Puerto A");
				   color(ROJOB,NEGRO);
				   gotoxy(44,13); cprintf("Puerto E");  }
				break;
	  case 27 : return 0;
	}
  }
  return 1;
}









/*
 ͻ
                                                                           
       PROCEDIMIENTO PRINCIPAL. PRINCIPIO DEL PROGRAMA.                    
                                                                           
 ͼ
*/



int wait_reset()
/*********************************************************************/
/*  Esperar a que se pulse el boton de RESET en la placa con el MCU. */
/*  SALIDAS:                                                         */
/*             Se devuelve TRUE si se ha pulsado reset.              */
/*             Se devuelve FALSE si se ha abortado.                  */
/*********************************************************************/
{
  textcolor(10);
  cprintf ("\r\nPulse RESET en el microcontrolador....");
  if (!wait_break(10)) {
    textcolor(12);
    cprintf("\n\r   ---> ABORTADO <---\n\r");
    textcolor(7);
    return 0;
  }
  return 1;
}



void main(int argc,char *argv[])
/*
Ŀ
                                                                          
  Procedimiento principal.                                                
                                                                          

*/
{
	static int turno=0;

	char cad[80];
	char *caderror;
	S19  fs19;
	int  valor_puerto;


	// Guardamos el CTSERVER en el propio programa

	unsigned short int programint[256]={
					 0x20 , 0x05 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0xCE ,
					 0x10 , 0x00 , 0x1F , 0x2E , 0x40 , 0xFC , 0x86 , 0x30 ,
					 0xA7 , 0x2B , 0xCE , 0x10 , 0x00 , 0x8D , 0x66 , 0x97 ,
					 0x06 , 0x81 , 0x44 , 0x27 , 0x13 , 0x81 , 0x43 , 0x27 ,
					 0x54 , 0x81 , 0x41 , 0x27 , 0x17 , 0x81 , 0x42 , 0x27 ,
					 0x0E , 0x81 , 0x45 , 0x27 , 0x6A , 0x7E , 0x00 , 0x12 ,
					 0x86 , 0x4A , 0x8D , 0x50 , 0x7E , 0x00 , 0x12 , 0x7C ,
					 0x00 , 0x06 , 0x20 , 0x03 , 0x7F , 0x00 , 0x06 , 0x8D ,
					 0x4A , 0x18 , 0xDF , 0x02 , 0x8D , 0x45 , 0x18 , 0xDF ,
					 0x04 , 0x18 , 0x8C , 0x00 , 0x00 , 0x27 , 0x23 , 0x18 ,
					 0xDE , 0x02 , 0x96 , 0x06 , 0x4D , 0x26 , 0x07 , 0x18 ,
					 0xA6 , 0x00 , 0x8D , 0x28 , 0x20 , 0x05 , 0x8D , 0x1D ,
					 0x18 , 0xA7 , 0x00 , 0x18 , 0x08 , 0x18 , 0xDF , 0x02 ,
					 0x18 , 0xDE , 0x04 , 0x18 , 0x09 , 0x18 , 0xDF , 0x04 ,
					 0x20 , 0xD7 , 0x7E , 0x00 , 0x12 , 0x8D , 0x14 , 0x18 ,
					 0xDF , 0x02 , 0x18 , 0x6E , 0x00 , 0x1F , 0x2E , 0x20 ,
					 0xFC , 0xA6 , 0x2F , 0x39 , 0x1F , 0x2E , 0x80 , 0xFC ,
					 0xA7 , 0x2F , 0x39 , 0x36 , 0x37 , 0x8D , 0xEE , 0x16 ,
					 0x8D , 0xEB , 0x18 , 0x8F , 0x33 , 0x32 , 0x39 , 0x8D ,
					 0xF2 , 0x18 , 0xDF , 0x02 , 0x8D , 0xED , 0x18 , 0xDF ,
					 0x04 , 0x18 , 0x8C , 0x00 , 0x00 , 0x27 , 0x34 , 0x18 ,
					 0xDE , 0x02 , 0xC6 , 0x16 , 0xF7 , 0x10 , 0x3B , 0x18 ,
					 0xE7 , 0x00 , 0xC6 , 0x17 , 0xF7 , 0x10 , 0x3B , 0x8D ,
					 0x28 , 0xC6 , 0x02 , 0xF7 , 0x10 , 0x3B , 0x8D , 0xBD ,
					 0x8D , 0xC2 , 0x18 , 0xA7 , 0x00 , 0xC6 , 0x03 , 0xF7 ,
					 0x10 , 0x3B , 0x8D , 0x15 , 0x18 , 0x08 , 0x18 , 0xDF ,
					 0x02 , 0x18 , 0xDE , 0x04 , 0x18 , 0x09 , 0x18 , 0xDF ,
					 0x04 , 0x20 , 0xC6 , 0x7F , 0x10 , 0x3B , 0x7E , 0x00 ,
					 0x12 , 0x18 , 0x3C , 0x18 , 0xCE , 0x0D , 0x10 , 0x18 ,
					 0x09 , 0x18 , 0x8C , 0x00 , 0x00 , 0x26 , 0xF8 , 0x18 ,
					 0x38 , 0x39 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,
					 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,} ;


	parametros_entrada(argc,argv);

	clrscr();

	valor_puerto=(puerto==com2)*2+(puerto==com1)*1;

	abrir_puerto_serie(valor_puerto);

	baudios(9600);
	jump_ram();
	delay(1000);

	gotoxy(1,1);
	textcolor(AMARILLO);
	cprintf(" CT293+ TEST ");
	textcolor(ROJOB);
	cprintf(" Versin 2.0 ");
	textcolor(VERDEB);
	cprintf(" Grupo J&J            MICROBOTICA");


	gotoxy(10,5);
	textcolor(BLANCO);
	cprintf (" Cargando servidor: \b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");


	if ( !check_conexion() ) {
	  if ( reset_manual==off ) {  /* reset_automatico */
		  resetct6811();

		  if (cargar_ramint(programint,barra)==0) {
			 printf ("\nError: %s",getloaderror());
			 cerrar_puerto_serie();
		  }

		  else {
			 delay(1000);
			 baudios(9600);
			 printf (" OK!!\n\n");
		  }

		  if ( !check_conexion() ) {
			 cout << "Conexin perdida\n";
			 cerrar_puerto_serie();
		  }
	  }
	  else {  /* hay que hacer reset_manual */
		  if (!wait_reset()) {
			cout << "No se detecta el reset manual\n";
			cerrar_puerto_serie();
			exit(1);
		  }

		  if (cargar_ramint(programint,barra)==0) {
			 printf ("\nError: %s",getloaderror());
			 cerrar_puerto_serie();
		  }

		  else {
			 delay(1000);
			 baudios(9600);
			 printf (" OK!!\n\n");
		  }

		  if ( !check_conexion() ) {
			 cout << "Conexin perdida\n";
			 cerrar_puerto_serie();
		  }
	  }

	}
	activar_conversores();
	menu(valor_puerto);

	do {
	  if (turno==0) {
		refresca_puertoA();
		dib_bit(bit_activo_A,PA);
		refresca_puertoE();
		dib_bit(bit_activo_E,PE);
		turno=1;
	  }
	  else {
		dib_ana_todos();
		dib_ana_uno(bit_activo_E);
		comprueba_conexion();
		turno=0;
	  }
	} while (procesar_comando());

	color(BLANCO,NEGRO);
	clrscr();
	store(0x0,PORTA);
	cout << "\nFin de programa" << "\n" ;
	cout << "\nMicrobtica (microbot@arrakis.es)" << "\n" ;
	cerrar_puerto_serie();

}


