/*
 ͻ
  BOOTSTRP.H  (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Versin 2.0.                                                             
                                                                           
    Rutinas para la carga de programas en la ram interna del 68HC11 cuando 
  arranca en modo bootstrap. Esta libreria necesita de las librerias:      
  S19.C, S19UTIL.C y SERIE.C.                                              
                                                                           
 ͼ
*/


/*                       ͻ
                                                 
ĺ   I N T E R F A Z      
                                                 
                         ͼ                      */


void resetct6811();
/*
Ŀ
  Realizar un reset de la CT6811.   
*/

void jump_eeprom();
/*
Ŀ
  Saltar a la memoria EEPROM   
*/

void jump_ram();
/*
Ŀ
  Saltar a la direccin $0000 de la memoria.  
*/


int cargar_ramint(byte *ramint, void (*car)());
/*
Ŀ
  Enviar el programa especificado por la matriz ramint a la tarjeta   
  CT6811. Cada vez que se ha enviado un byte de cdigo se llama a la  
  funcin car.                                                        
                                                                      
    La funcin devuelve 1 si no se ha producido ningn error. Se      
  devuelve 0 en caso de error. Si se ha producido un error con la     
  funcin getloaderror se devuelve la cadena que indica el error.     
                                                                      
    ES NECESARIO QUE SE HAYA ABIERTO EL PUERTO SERIE ANTES DE ENVIAR  
  CUALQUIER PROGRAMA.                                                 
                                                                      
*/

int cargars19_ramint(S19 fs19, void (*car)());
/*
Ŀ
  Enviar el fichero .S19 especificado a la tarjeta CT6811. El         
  fichero debe estar preparado para la ram interna. Cada vez que se   
  enva un carcter se llama a la funcin car.                        
                                                                      
    La funcin devuelve 1 si no se ha producido ningn error. Se      
  devuelve 0 en caso de error. Si se ha producido un error con la     
  funcin getloaderror se devuelve la cadena que indica el error.     
                                                                      
    ES NECESARIO QUE SE HAYA ABIERTO EL PUERTO SERIE ANTES DE ENVIAR  
  CUALQUIER PROGRAMA.                                                 
                                                                      
*/


char *getloaderror();
/*
Ŀ
  Devolver la cadena del error producido en la ultima carga de programas  
  en la RAM interna                                                       
*/


