/*
   ͻ
                                                                           
    CTDIALOG. (C) GRUPO J&J. Diciembre 1996                                
                                                                           
   ͹
                                                                           
     Aplicacin para 'dialogar' con la tarjeta entrenadora CT6811 del      
    grupo J&J. En la CT6811 se debe haber cargado en la ram interna el     
    programa CTSERVER.                                                     
                                                                           
       Es posible utilizar el programa CTDIALOG con otras tarjetas entrena-
    doras que tengan cargado en CTSERVER.                                  
                                                                           
                                                                           
     Versin 1.0. (Dic-96). Los servicios de dialogo ofrecidos son:        
                                                                           
     1.- Volcado de memoria (comando MD)                                   
     2.- Acceso a posiciones de memoria (Comando MS)                       
     3.- Comprobacin de la conexin (Comando CKC)                         
     4.- Ayuda ON-LINE (Comando HELP)                                      
     5.- Comando de finalizacin (QUIT)                                    
     6.- Desensamblador (Comando DASM)                                     
     7.- Grabacin de programas en memoria EEPROM (Comando EEPROM)         
     8.- Carga de programas en memoria RAM (Comando LOAD)                  
     9.- Ejecutar un programa (Comando G)                                  
                                                                           
                                                                           
   ͼ
									   */

const float version = 1.0;

#include "fcntl.h"


/* Ŀ
    Constantes para el dilogo con el servidor CTSERVER   
    */

#define TMPC  65    /* Transferencia de bloques del micro al PC */
#define TPCM  66    /* Transferencia de bloques del PC al micro */
#define JEXE  67    /* Servicio JUMP & EXECUTE                  */
#define ALIVE 68    /* Servicio de supervivencia                */
#define GBEE  69    /* Servicio de grabacion de EEPROM          */
#define OKALIVE 'J'


void sacar_puerto();

/*            Ŀ
  Ĵ TIPOS DEFINIDOS  
	                    */

typedef unsigned short int byte;

enum tconex {noconex,perdida, establecida};
/* La conexin entre CTDIALOG y CTSERVER se puede encontrar en 3  */
/* estados diferentes: No conexin, conexin perdida y conexin   */
/* establecida.                                                   */


/*            Ŀ
  Ĵ VARIABLES GLOBALES  
	                    */

enum tconex estconex = noconex;   /* Estado de la conexin        */
				  /* Inicialmente no hay conexin */
int puerto;
int xa,ya;
int outa;      /* Valor de salida del puerto a  */
int ina;       /* Valor de entrada del puerto a  */
int bitact=4;  /* Bit de entrada activo          */

/*
   ͻ
                                                                           
             Rutinas de dilogo con el servidor CTSERVER.                  
                                                                           
   ͼ
									   */

int checkalive()
/* Ŀ
    Utilizar el servicio ALIVE proporcionado por el CTSERVER para        
    comprobar si existe comunicacin con el micro.                       
                                                                         
    SALIDAS:                                                             
              0 --> Servidor no responde                                 
              1 --> El servidor ha respondido                            
   */
{
  int intentos=3;  /* Realizar 3 intentos de conexin con el CTSERVER */

  while (intentos>0) {
    delay(10); enviar(ALIVE);
    if (eco(OKALIVE)) return 1;
    intentos--;
  }
  return 0;
}

int volcar(tam,dato,dir)
unsigned short int *tam;
unsigned short int *dato;
unsigned short int *dir;
/* Ŀ
    Utilizar el servicio TMPC del ctserver para volvar un bloque de      
    datos desde el micro al PC.                                          
                                                                         
    ENTRADAS:  tam: Tamao del bloque a volcar                           
               dir: Direccin del bloque a volcar                        
                                                                         
    SALIDAS:   dato: Buffer donde almacenar los datos recibidos          
   		La funcin devuelve 0 si se ha producido un timeout       
   */
{
  unsigned char i=0;
  unsigned int tamano;
  int timeout;

  delay(10); enviar(TMPC);	              /* Enviar cdigo de servicio solicitado  */
  delay(10); enviar(dir[0]);  /* Enviar byte bajo direccin   */
  delay(10); enviar(dir[1]);  /* Enviar byte alto direccin   */

  delay(10); enviar(tam[0]);   /* Byte bajo long. del bloque */
  delay(10); enviar(tam[1]);   /* Byte alto long. del bloque */

  tamano = 256*tam[1] + tam[0];

  /* Leer el bloque enviado desde el MCU */
  while (tamano>0) {
    dato[i]=(unsigned short int)leer_car_time(timeout);
    if (timeout) return 0;
    i++;
    tamano--;
  }
  return 1;
}

void load_block(tam,dato,dir)
unsigned short int *tam;
unsigned short int *dato;
unsigned short int *dir;
/* Ŀ
    Utilizar el servicio TPCM del ctserver para cargar un bloque de      
    datos del PC en la memoria del micro.                                
                                                                         
    ENTRADAS:  tam: Tamao del bloque a cargar                           
               dir: Direccin del bloque a cargar                        
               dato: Buffer de datos a cargar en la memoria del micro    
   */
{
  unsigned char i=0;
  unsigned int tamano;

  delay(10); enviar(TPCM);
  delay(10); enviar(dir[0]);   /* Byte bajo direccin */
  delay(10); enviar(dir[1]);   /* Byte alto direccin */

  delay(10); enviar(tam[0]);   /* Byte bajo long. del bloque */
  delay(10); enviar(tam[1]);   /* Byte alto long. del bloque */

  tamano=tam[1]*256 + tam[0];
  while (tamano>0) {           /* Enviar bloque */
    delay(10);
    enviar(dato[i]);
    i++;
    tamano--;
  }
}

/*
   ͻ
                                                                           
            RUTINAS DE DIBUJO DE VENTANAS Y LINEAS                         
                                                                           
   ͼ
									   */

void lineav(x,y,longi,carini,carfin,carlin)
int x,y,longi;
char carini,carfin,carlin;
/* Ŀ
    Dibujar una linea vertical a partir de la coordenada x,y, comenzando 
    con el carcter carini, finalizando con el caracter carfin y la lnea
    formada por caracteres del tipo carlin.                              
   */
{
  int i;


  if (longi<3) return;
  gotoxy(x,y);
  cprintf ("%c",carini);
  for (i=y+1; i<y+longi-1; i++) {
    gotoxy(x,i);
    cprintf ("%c",carlin);
  }
  gotoxy(x,y+longi-1); cprintf ("%c",carfin);
}

void lineah(x,y,longi,carini,carfin,carlin)
int x,y,longi;
char carini,carfin,carlin;
/* Ŀ
    Dibujar una linea horizontal a partir de la coordenada x,y, comenzando 
    con el carcter carini, finalizando con el caracter carfin y la lnea  
    formada por caracteres del tipo carlin.                                
   */
{
  int i;


  if (longi<3) return;
  gotoxy(x,y);
  cprintf ("%c",carini);
  for (i=x+1; i<x+longi-1; i++) {
    gotoxy(i,y);
    cprintf ("%c",carlin);
  }
  gotoxy(x+longi-1,y); cprintf ("%c",carfin);
}

void ventanas(x,y,alt,anch)
int x,y,alt,anch;
/* Ŀ
    Dibujar una ventana simple  
   */
{
  int i;

  lineah(x,y,anch,'','','');
  lineah(x,y+alt-1,anch,'','','');

  lineav(x,y,alt,'','','');
  lineav(x+anch-1,y,alt,'','','');
}

void print_grande(x,y,valor)
byte x,y;
byte valor;
/* Ŀ
    Imprimir en GRANDE el valor binario indicado. Slo se imprime 1  0.   
    Si no se indica un valor correcto entre 0 y 1 no se imprime nada.      
   */
{
  switch(valor) {
    case 0: gotoxy(x,y);   cprintf ("Ŀ");
	    gotoxy(x,y+1); cprintf ("    /");
	    gotoxy(x,y+2); cprintf ("   / ");
	    gotoxy(x,y+3); cprintf ("  /  ");
	    gotoxy(x,y+4); cprintf (" /   ");
	    gotoxy(x,y+5); cprintf ("");
	    break;
    case 1: gotoxy(x,y);   cprintf ("       ");
	    gotoxy(x,y+1); cprintf ("  /   ");
	    gotoxy(x,y+2); cprintf (" /    ");
	    gotoxy(x,y+3); cprintf ("      ");
	    gotoxy(x,y+4); cprintf ("      ");
	    gotoxy(x,y+5); cprintf ("  ");
	    break;
  }
}

void display_activo()
/* Ŀ
    Imprimir el bit activo de entrada en grande. Si el bit activo no es de 
    entrada no se imprime nada.                                            
   */
{
  byte temp;

  if (bitact!=0 && bitact!=1 && bitact!=2 && bitact!=7) return;

  temp=(ina >> bitact) & 0x01;
  textcolor(15);
  gotoxy(58,4); cprintf ("Bit activo: %u",bitact);
  textcolor(14);
  print_grande(58,5,temp);
}

void display_motores()
/* Ŀ
    Imprimir en pantalla el estado de los motores.                         
   */
{
  byte temp;


  gotoxy(39,14);
  if ( (outa & 0x08) ) {
    textcolor(10);
    cprintf ("");
    textcolor(12);
    cprintf ("");
  }
  else {
    textcolor(2);
    cprintf ("");
    textcolor(4);
    cprintf ("");
  }

  gotoxy(39,16);
  if ( (outa & 0x10) ) {
    textcolor(10);
    cprintf ("");
    textcolor(12);
    cprintf ("");
  }
  else {
    textcolor(2);
    cprintf ("");
    textcolor(4);
    cprintf ("");
  }

  gotoxy(50,14);
  textcolor(12);
  if ( (outa & 0x20) ) {
    cprintf ("-");
  }
  else cprintf ("-");

  gotoxy(50,16);
  if ( (outa & 0x40) ) {
    cprintf ("-");
  }
  else cprintf ("-");

}

void chorrada()
{
  static byte x=56,y=15;
  static byte dir=0;

  textcolor(10);

  if (dir==0) {
    x++;
    if (x>71) {
      dir=1;
    }
    else {
      gotoxy(x,y);
      cprintf ("į");
    }
  }
  else {
    x--;
    if (x<56) {
      dir=0;
    }
    else {
      gotoxy(x,y);
      cprintf ("");
    }
  }
}

/*
   ͻ
                                                                           
            RUTINAS DE MANEJO DE DIGITOS EN HEXADECIMAL                    
                                                                           
   ͼ
									   */

char digito_hex(num)
unsigned int;
/* Ŀ
    Tomar un nmero entre 0-15 y convertirlo en un dgito hexadecimal.   
   */
{
  if (num<10 && num>=0)   return (char)num+'0';
  if (num<=15 && num>=10) return (char)(num-10)+'A';

  return 'H';   /* Si se retorna esto es que ha habido un error */
}

void printhex(num)
unsigned short int num;
/* Ŀ
    Imprimir un nmero de 1 byte en hexadecimal  
   */
{
  char hex1,hex2;

  hex1=digito_hex(div(num,16));
  hex2=digito_hex(num % 16);
  cprintf ("%c%c",hex1,hex2);
}

/*
   ͻ
                                                                           
              RUTINAS DE CONTROL DEL PUERTO A                              
                                                                           
   ͼ
									   */
byte in_puertoa()
  /* Ŀ
      Leer el estado del puerto A  
     */
{


  byte tam[2]={1,0};
  byte dir[2]={0x00,0x10};
  byte dato;
  byte temp;

  volcar(tam,&dato,dir);
  ina=dato & 0x87;

  return dato;
}

void out_puertoa(valor)
byte valor;
/* Ŀ
    Enviar el valor especificado al puerto A   
   */
{
  byte tamano[2]={1,0};
  byte dir[2]={0x00,0x10};
  byte temp;

  outa=valor & 0x78;
  load_block(tamano,&outa,dir);
}

void activar_bit(num)
byte num;
/* Ŀ
    Activar el bit num del puerto A. Si no es bit de salida no afecta.     
    Los bits van numerados desde 0 hasta 7. Cualquier otro valor es ignorad
   */
{
  byte temp=0;
  byte i;

  if (num>7) return;

  for (i=1; i<=num; i++)
    temp=temp*2;

  temp=1;

  outa=outa | temp;  /* Activar bit indicado          */
  outa=outa & 0x78;  /* 'Filtrar' los bits de entrada */

  out_puertoa(outa);

}

void desactivar_bit(num)
byte num;
/* Ŀ
    desactivar el bit num del puerto A. Si no es bit de salida no afecta.  
    Los bits van numerados desde 0 hasta 7. Cualquier otro valor es ignorad
   */
{
  byte temp=0;
  byte i;

  if (num>7) return;

  for (i=1; i<=num; i++)
    temp=temp*2;

  temp=1;

  outa=outa & ~temp;  /* Desactivar bit indicado          */
  outa=outa & 0x78;   /* 'Filtrar' los bits de entrada */
  out_puertoa(outa);
}

void cambiar_bit(num)
byte num;
/* Ŀ
    Cambiar de estado el bit indicado del puerto A. Si el bit es de entra- 
    da no afecta. Los bits se numeran de 0 a 7.                            
   */
{
  byte temp=0;
  byte i;

  if (num>7) return;

  temp=1;

  for (i=1; i<=num; i++)
    temp=temp*2;


  outa=outa ^ temp;  /* Cambiar de estado bit indicado   */
  outa=outa & 0x78;  /* 'Filtrar' los bits de entrada */
  out_puertoa(outa);
}

void dibuja_puertoa(x,y)
int x,y;
/* Ŀ
    Dibujar el puerto A. Solo se dibuja el contorno y no los valores       
   */
{
  gotoxy(x+1,y);
  textcolor(7);
  cprintf ("PA7  PA6  PA5  PA4  PA3  PA2  PA1  PA0");
  y++;

  textcolor(11);
  ventanas(x,y,3,5);
  textcolor(9);
  ventanas(x+5,y,3,5);
  ventanas(x+10,y,3,5);
  ventanas(x+15,y,3,5);
  ventanas(x+20,y,3,5);
  textcolor(11);
  ventanas(x+25,y,3,5);
  ventanas(x+30,y,3,5);
  ventanas(x+35,y,3,5);

  textcolor(4);
  gotoxy(x+2,y+3); cprintf ("7    6    5    4    3    2    1    0");
}



void actualiza_puertoa()
/* Ŀ
    Dibujar en la pantalla el estado del puerto A determinado por las    
    variables ina y outa                                                 
   */
{
  byte valor;
  byte temp;
  int i;

  valor = ina | outa;  /* Valor actual del puerto A */
  textcolor(15);


  temp=valor & 0x01;
  gotoxy(xa+37,ya+2); cprintf ("%u",temp);

  for (i=1; i<=7; i++) {
    temp = (valor >> i) & 0x1;
    gotoxy(xa+37-5*i,ya+2); cprintf ("%u",temp);
  }

  gotoxy(xa+42, ya+2); cprintf ("$");
  printhex(valor);

}

void abrir_puertoa(x,y)
int x,y;
/* Ŀ
    Dibujar el puerto a e inicializar los bits de salida a cero          
   */
{
  xa=x+2;
  ya=y+2;

  textcolor(9);
  ventanas(x,y,8,50);
  dibuja_puertoa(xa,ya);
  out_puertoa(0x40);
}

/*
   ͻ
                                                                           
                             OTRAS RUTINAS                                 
                                                                           
   ͼ */

char upper(car)
char car;
/* Ŀ
    Pasar el caracter especificado a maysculas  
   */
{
  return (car>='a' && car<='z') ? car-'a'+'A' : car;
}

void presenta()
{
  
  textcolor(12); cprintf ("(P)CT293 TEST ");
  textcolor(11); cprintf ("Versin %0.1f ",version);
  textcolor(10);
  cprintf ("(C) GRUPO J&J. Diciembre 1996\n\n\r");
}

void establecer_conexion()
/* Ŀ
    Establecer la conexin con el servidor CTSERVER que debe estar eje-  
    cutndose en la entrenadora. Segn que exista o no conexin se       
    informa al usuario y se modifica la variable global estconex, que    
    indica el estado de la conexin actual.                              
   */
{
  textcolor(7);
  cprintf ("Estableciendo conexin con tarjeta..... ");
  delay(300);
  if (checkalive()) {
    cprintf("conexin establecida\n\r");
    estconex=establecida;
  }
  else {
    cprintf("CONEXION NO ESTABLECIDA\n\r");
    estconex=noconex;
  }
}

int comprobar_conexion()
/* Ŀ
    Comprobar si existe conexin. Se actualiza la variable global        
    estconex.                                                            
    Se devuelve 0 si no hay conexin. 1 si la hay.                       
   */
{
  int alive;

  alive=checkalive();
  if (estconex==establecida && !alive) {
    estconex=perdida;
    textcolor(12);
    gotoxy(59,14); cprintf ("  Perdida  ");
    return 0;
  }
  if (estconex!=establecida && alive) {
    estconex=establecida;
    textcolor(14);
    gotoxy(59,14); cprintf ("Establecida");
  }
  if (alive) return 1;
  else return 0;
}

void analiza_parametros(na,arg)
int na;
char *arg[];
/* Ŀ
    Analizar los parmetros de la lnea de argumentos. Si se encuentran  
    errores se aborta el programa. Se actualizan las siguientes varia-   
    bles:                                                                
                                                                         
    puerto --> Numero del puerto especificado.                           
   */
{
  int i;
  char temp[10];

  if (na==1) return;  /* No hay parmetros. Se toma un puerto por defecto */

  if (na>2) {
    printf ("Demasiados parmetros\n");
    exit(1);
  }

  if (strcmp(arg[1],"-com1")==0) {  /* COM 1 */
    puerto=1;
    return;
  }

  if (strcmp(arg[1],"-com2")==0) {  /* COM 2 */
    puerto=2;
    return;
  }

  printf ("Parmetro incorrecto. Los parmetros permitidos son: \n");
  printf (" -com1 : Utilizar el COM1 (valor por defecto)\n");
  printf (" -com2 : Utilizar el COM2\n");
  exit(0);
}

void sacar_puerto()
/* Ŀ
    Sacar el puerto actual en uso.  
   */
{
  textcolor(7);
  cprintf ("Puerto actual: COM%u\r\n",puerto);
}

int procesar_comando()
{
  char c;

  if (kbhit()) {
    c=upper(getch());
    switch(c) {
      case '0': bitact=0; break;
      case '1': bitact=1; break;
      case '2': bitact=2; break;
      case '3': cambiar_bit(3); break;
      case '4': cambiar_bit(4); break;
      case '5': cambiar_bit(5); break;
      case '6': cambiar_bit(6); break;
      case '7': bitact=7; break;
      case ' ': out_puertoa(0x00);  break;
      case 'Q': out_puertoa(0x18);  break;
      case 'A': out_puertoa(0x78);  break;
      case 'P': out_puertoa(0x58);  break;
      case 'O': out_puertoa(0x38);  break;
      case 'I': out_puertoa(0x48);  break;
      case 'U': out_puertoa(0x10);  break;
      case 27 : return 0;
    }
  }
  return 1;
}

void menu()
{
  textcolor(9);
  ventanas(1,11,8,26);
  textcolor(11);
  ventanas(3,12,3,5);
  textcolor(7);
  gotoxy(9,13); cprintf ("Bits de entrada");
  textcolor(9);
  ventanas(3,15,3,5);
  textcolor(7);
  gotoxy(9,16); cprintf ("Bits de salida");

  textcolor(9);
  ventanas(29,11,8,25);

  textcolor(15);
  gotoxy(34,12); cprintf ("ESTADO MOTORES");

  textcolor(10);
  gotoxy(31,14); cprintf ("Motor 1 ");
  textcolor(2);  cprintf ("");
  textcolor(4);  cprintf ("");

  textcolor(10);
  gotoxy(31,16); cprintf ("Motor 2 ");
  textcolor(2);  cprintf ("");
  textcolor(4);  cprintf ("");

  textcolor(11);
  ventanas(1,19,6,79);

  gotoxy(3,20); textcolor(7);
  cprintf ("0,1,2,7 -> Seleccionar bit activo");
  gotoxy(3,21); cprintf ("3,4,5,6 -> Cambiar bit de estado");
  gotoxy(3,23); cprintf ("ESC     -> TERMINAR");

  gotoxy(38,20); cprintf ("Q -> Adelante");
  gotoxy(38,21); cprintf ("A -> Atrs");
  gotoxy(38,22); cprintf ("P -> Giro derecha");
  gotoxy(38,23); cprintf ("O -> Giro izquierda");

  gotoxy(58,20); cprintf ("I -> Arco derecha");
  gotoxy(58,21); cprintf ("U -> Arco izquierda");
  gotoxy(58,22); cprintf ("ESPACIO -> STOP");

  textcolor(11);
  ventanas(55,17,3,20);
  gotoxy(55,19); cprintf ("");
  gotoxy(74,19); cprintf ("");
  textcolor(15);
  gotoxy(56,18);
  cprintf ("TECLAS DE CONTROL");

  textcolor(9);
  ventanas(55,12,5,20);
  textcolor(15);
  gotoxy(57,13); cprintf ("ESTADO CONEXION");
  textcolor(14);
  gotoxy(59,14); cprintf ("Establecida");
}

/*            Ŀ
  Ĵ Programa PRINCIPAL  
	                   */

main(argc,argv)
int argc;
char *argv[];
{
  char d;
  int alive;

  /* Inicializar parmetros por defecto */

  puerto =1;   /* Por defecto COM1 */

  analiza_parametros(argc,argv);

  configurar_puerto(puerto);
  baudios(9600);

  cprintf ("\r\n\n");
  presenta();
  vaciar_buffer();
  sacar_puerto();
  establecer_conexion();

  if (estconex==noconex) {   /* Si no hay conexin se aborta */
    cerrar_puerto_serie();
    textcolor(7);
    cprintf("\r\nPrograma abortado\r\n");
    exit(1);
  }

  /* ---- Se ha establecido conexin con la tarjeta --- */

  textcolor(7);
  clrscr();
  textcolor(14); cprintf ("(P)CT293 TEST ");
  textcolor(12); cprintf ("Versin %0.1f ",version);
  textcolor(10);
  cprintf ("(C) GRUPO J&J. Diciembre 1996     ");
  textcolor(15);
  cprintf ("COM%u\r\n",puerto);
  abrir_puertoa(1,3);
  textcolor(9);
  lineah(1,2,79,'','','');
  ventanas(55,3,9,20);
  menu();


  gotoxy(1,10);

  do {
    vaciar_buffer();
    if (comprobar_conexion()) {  /* Si hay conexin */
      in_puertoa();
      actualiza_puertoa();
      display_activo();
      display_motores();
      chorrada();
      gotoxy(80,24);
    }
  } while(procesar_comando());

  cerrar_puerto_serie();
  textcolor(7);
  gotoxy(1,25);
  cprintf("\r\n");
  if (estconex!=establecida) {
    cprintf ("Programa terminado\r\n");
  }
  else cprintf ("Conexin terminada\r\n");
  return;
}
