// DownloaderDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Downloader.h"
#include "DownloaderDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDownloaderDlg dialog

CDownloaderDlg::CDownloaderDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDownloaderDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDownloaderDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDownloaderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDownloaderDlg)
	DDX_Control(pDX, IDC_EDIT1, m_editRange);
	DDX_Control(pDX, IDC_DOWNLOAD, m_btnDownload);
	DDX_Control(pDX, IDC_RADIO_COM1, m_RadioPort1);
	DDX_Control(pDX, IDC_RADIO_COM2, m_RadioPort2);
	DDX_Control(pDX, IDC_PROGRESS1, m_Progress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDownloaderDlg, CDialog)
	//{{AFX_MSG_MAP(CDownloaderDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_DOWNLOAD, OnDownload)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDownloaderDlg message handlers

BOOL CDownloaderDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

    CTime  theTime;
    CString csFileName;

    theTime = CTime::GetCurrentTime();
    csFileName = theTime.Format("%d_%m_%Y-%H_%M_%S");
    csFileName += ".txt";

    m_fileDump = new CDumpFile(csFileName);

    m_nRange = 0;

    m_Progress.SetRange(0,m_nRange);
    m_Progress.SetPos(0);

    m_RadioPort1.SetCheck(BST_CHECKED);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDownloaderDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDownloaderDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDownloaderDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDownloaderDlg::OnDownload() 
{
    bool        bReturn;
    bool        bOk;
    int         nIndex;
    CString     csLine;
    CString     csPort;
    CString     csRange;
    BYTE        byteCar;

    if (m_RadioPort1.GetCheck() == 1)
    {
        csPort = "COM1";
    }
    else if (m_RadioPort2.GetCheck() == 1)
    {
        csPort = "COM2";
    }
    else
    {
        csPort = "ERROR";
        AfxMessageBox("ERROR");
    }

    m_editRange.GetWindowText(csRange);

    if (csRange != "")
    {
        bOk = ((atoi(csRange) > 0) && (atoi(csRange) <= 256));
    }
    else
    {
        bOk = false;
    }

    if (bOk == true)
    {
        m_nRange = atoi(csRange);
        m_Progress.SetRange(0, m_nRange);
        m_Progress.SetPos(0);
        // Open port
        bReturn = m_Serial.OpenPort(csPort);
        
        if (bReturn == true)
        {
            bReturn = m_Serial.SetupPort(false);
            
            if (bReturn == true)
            {
                char chCar[1];
                chCar[0] = ACK_CHAR;
                
                // Begin protocol -> send ACK_CHAR
                m_Serial.Write(chCar, 1);
                
                // Protocol -> receive 10 data
                nIndex = 0;
                while (nIndex < m_nRange)
                {
                    m_Serial.Read(chCar, 1);
                    byteCar = chCar[0];
                    m_Progress.SetPos(nIndex + 1);
                    csLine.Format("Data %d: %d\n", nIndex, byteCar);
                    m_fileDump->AddLine(csLine);
                    nIndex++;
                }
                AfxMessageBox("Download complete", MB_ICONINFORMATION);
            }
            else
            {
                // Do nothing
            }
            m_Serial.ClosePort();
        }
        else
        {
            // Do nothing
        }
    }
    else
    {
        // Do nothing
    }
}

void CDownloaderDlg::OnOK() 
{
	// TODO: Add extra validation here
    delete m_fileDump;
	
	CDialog::OnOK();
}
