// CSerial.cpp: implementation of the CSerial class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Downloader.h"
#include "CSerial.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSerial::CSerial()
{
    m_hCommFile = NULL;
}

CSerial::~CSerial()
{

}

bool CSerial::OpenPort(CString csPort)
{
    bool        bReturn;

    bReturn = true;

    if (m_hCommFile != NULL)
    {
        AfxMessageBox("ERROR: Port already open");
        bReturn = false;
    }
    else
    {
        // Open port
        
        m_hCommFile = ::CreateFile(csPort, 
                                  GENERIC_READ|GENERIC_WRITE, 
                                  0,
                                  0,
                                  OPEN_EXISTING,
                                  0,        //FILE_FLAG_OVERLAPPED,
                                  0);
        if (m_hCommFile == NULL)
        {
            // Error when openning port
            AfxMessageBox("ERROR: Error when openning port");
            bReturn = false;
        }
        else
        {
            bReturn = true;
        }
    }

    return bReturn;
}

bool CSerial::ClosePort()
{
    bool        bReturn;

    bReturn = true;

    // Check if port open
    if (m_hCommFile == NULL)
    {
        // Port already closed
        AfxMessageBox("ERROR: Port already closed");
        bReturn = false;
    }
    else
    {
        CloseHandle(m_hCommFile);
        m_hCommFile = NULL;
        bReturn = true;
    }

    return bReturn;
}

bool CSerial::SetupPort(bool bDTR)
{
    bool        bReturn;
    BOOL        bStateReturn;
    DCB         dcb;

    bReturn = true;

    bStateReturn = GetCommState(m_hCommFile, &dcb);

    if (bStateReturn == FALSE)
    {
        // Error in getting com state
        AfxMessageBox("ERROR: GetCommState failed");
        bReturn = false;
    }
    else
    {
        dcb.BaudRate = CBR_9600;                // set baud rate
        dcb.ByteSize = 8;                       // data size
        dcb.Parity = NOPARITY;                  // no parity bit
        dcb.StopBits = ONESTOPBIT;              // one stop bit
        if (bDTR == true)
        {
            dcb.fDtrControl = DTR_CONTROL_ENABLE;   // enable DTR
        }
        else
        {
            dcb.fDtrControl = DTR_CONTROL_DISABLE;  // disable DTR
        }

        bStateReturn = SetCommState(m_hCommFile, &dcb);

        if (bStateReturn == FALSE)
        {
            // Error when setting port
            AfxMessageBox("ERROR: SetCommState failed");
            bReturn = false;
        }
        else
        {

            // Purge comm port
            bStateReturn = PurgeComm(m_hCommFile, PURGE_TXCLEAR | PURGE_RXCLEAR);
            
            if (bStateReturn == FALSE)
            {
                // Error in purging port
                AfxMessageBox("ERROR: PurgeComm failed");
                bReturn = false;
            }
            else
            {
                bReturn = true;
            }

            /*
            bStateReturn = SetCommMask(m_hCommFile, EV_RXCHAR);

            if (bStateReturn == FALSE)
            {
                // Error when setting mask
                AfxMessageBox("ERROR: SetCommMask failed");
                bReturn = false;
            }
            */
        }
    }

    return bReturn;
}

bool CSerial::Read(char *pRead, int nLen)
{
    bool            bReturn;
    BOOL            bReadResult;
    DWORD           dwRead;
    LPOVERLAPPED    lpOverlapped;

    bReturn = true;

    // Check if port open
    if (m_hCommFile == NULL)
    {
        // Error, port is not open
        AfxMessageBox("ERROR: Read with no port open");
        bReturn = false;
    }
    else
    {
        //pData = new char;
        //memset(pData, 0, iLen);
        //pData = "";
        lpOverlapped = 0;
        bReadResult = ReadFile(m_hCommFile, pRead, nLen, &dwRead, 0);

        // Check for errors
        if (bReadResult == FALSE)
        {
            // Error in ReadFile
            AfxMessageBox("ERROR: ReadFile failed");
            bReturn = false;
        }
        else
        {
            //CString csRead;
            //csRead.Format("Caracter leido = %c", cData);
            //AfxMessageBox(csRead, MB_ICONINFORMATION);
            //*chRead = cData;
        }
    }

    return bReturn;
}

bool CSerial::Write(char *pWrite, int nLen)
{
    bool            bReturn;
    BOOL            bWriteResult;
    DWORD           dwWrite;
    LPOVERLAPPED    lpOverlapped;

    bReturn = true;

    // Check if port open
    if (m_hCommFile == NULL)
    {
        // Error, port is not open
        AfxMessageBox("ERROR: Write with no port open");
        bReturn = false;
    }
    else
    {
        //pData = new char;
        //memset(pData, 0, iLen);
        //pData = "";
        lpOverlapped = 0;
        bWriteResult = WriteFile(m_hCommFile,pWrite, nLen,&dwWrite, 0);

        // Check for errors
        if (bWriteResult == FALSE)
        {
            // Error in ReadFile
            AfxMessageBox("ERROR: WriteFile failed");
            bReturn = false;
        }
        else
        {
            //CString csRead;
            //csRead.Format("Caracter leido = %c", cData);
            //AfxMessageBox(csRead, MB_ICONINFORMATION);
            //*chCar = cData;
            bReturn = true;
        }
    }

    return bReturn;
}
