// CDumpFile.cpp: implementation of the CDumpFile class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "downloader.h"
#include "CDumpFile.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDumpFile::CDumpFile(CString csName)
{
    m_csFileName = csName;
    m_arrcsLines.RemoveAll();
}

CDumpFile::~CDumpFile()
{
    CStdioFile  hFile;
    CString     csLine;
    int         nIndex;
    int         nSize;

    // Check if file has data
    if (m_arrcsLines.GetSize() > 0)
    {
        // Open the file
        hFile.Open(m_csFileName,CFile::modeCreate | CFile::modeWrite);
        
        // Write data
        nSize = m_arrcsLines.GetSize();
        
        for (nIndex = 0;nIndex < nSize;nIndex++)
        {
            csLine = m_arrcsLines.GetAt(nIndex);
            hFile.WriteString(csLine);
        }
        
        hFile.Close();
    }
}

void CDumpFile::AddLine(CString csLine)
{
    m_arrcsLines.Add(csLine);
}
