Attribute VB_Name = "Module"
' Variables pblicas
Public Echo As Boolean        ' indicador de echo Encendido/Apagado.
Public CancelSend As Integer  ' indicador para parar el envo de un archivo de texto.
Public fichini As String      ' Fichero ini

'Declare Sub SetWindowPos Lib "user32" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long)
' Leer una clave de un fichero INI
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" _
    (ByVal lpApplicationName As String, ByVal lpKeyName As Any, _
     ByVal lpDefault As String, ByVal lpReturnedString As String, _
     ByVal nSize As Long, ByVal lpFileName As String) As Long

' Escribir una clave de un fichero INI (tambin para borrar claves y secciones)
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" _
    (ByVal lpApplicationName As String, ByVal lpKeyName As Any, _
     ByVal lpString As Any, ByVal lpFileName As String) As Long


Public Sub IniDeleteKey(ByVal sIniFile As String, ByVal sSection As String, _
                        Optional ByVal sKey As String = "")
    '--------------------------------------------------------------------------
    ' Borrar una clave o entrada de un fichero INI                  (16/Feb/99)
    ' Si no se indica sKey, se borrar la seccin indicada en sSection
    ' En otro caso, se supone que es la entrada (clave) lo que se quiere borrar
    '
    ' Para borrar una seccin se debera usar IniDeleteSection
    '
    If Len(sKey) = 0 Then
        ' Borrar una seccin
        Call WritePrivateProfileString(sSection, 0&, 0&, sIniFile)
    Else
        ' Borrar una entrada
        Call WritePrivateProfileString(sSection, sKey, 0&, sIniFile)
    End If
End Sub

Public Function IniGet(ByVal sFileName As String, ByVal sSection As String, _
                       ByVal sKeyName As String, _
                       Optional ByVal sDefault As String = "") As String
    '--------------------------------------------------------------------------
    ' Devuelve el valor de una clave de un fichero INI
    ' Los parmetros son:
    '   sFileName   El fichero INI
    '   sSection    La seccin de la que se quiere leer
    '   sKeyName    Clave
    '   sDefault    Valor opcional que devolver si no se encuentra la clave
    '--------------------------------------------------------------------------
    Dim ret As Long
    Dim sRetVal As String
    '
    sRetVal = String$(255, 0)
    '
    ret = GetPrivateProfileString(sSection, sKeyName, sDefault, sRetVal, Len(sRetVal), sFileName)
    If ret = 0 Then
        IniGet = sDefault
    Else
        IniGet = Left$(sRetVal, ret)
    End If
End Function

Public Sub IniWrite(ByVal sFileName As String, ByVal sSection As String, _
                    ByVal sKeyName As String, ByVal sValue As String)
    '--------------------------------------------------------------------------
    ' Guarda los datos de configuracin
    ' Los parmetros son los mismos que en LeerIni
    ' Siendo sValue el valor a guardar
    '
    Call WritePrivateProfileString(sSection, sKeyName, sValue, sFileName)
End Sub



