-----------------------------------------------------
-- pwm_unit.vhdl  Juan Gonzalez. Febrero-2002      --
-- Licencia GPL.                                   --
-----------------------------------------------------
-- PROYECTO LABOBOT                                --
-----------------------------------------------------
-- UNIDAD DE PWM:                                  --
--                                                 --
-- ENTRADAS:                                       --
--     -pwm_clk  : Seal de reloj                  --
--     -pwm_pos  : Posicion del servo (8 bits)     --
--     -pwm_reset: Reset                           --
-- SALIDAS:                                        --
--     -pwm_o: Seal PWM                           --
-----------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;

entity pwm_unit is
  port (pwm_pos  : in std_logic_vector (7 downto 0);  -- Posicion
        pwm_clk  : in std_logic;                      -- Reloj
	pwm_reset: in std_logic;                      -- Reset.
	pwm_o    : out std_logic);                    -- Seal PWM
end pwm_unit;

architecture beh of pwm_unit is 

  component contador is 
    port (clk     : in std_logic; -- Reloj
	  reset   : in std_logic;
	  q       : out std_logic_vector (10 downto 0)); --Salida    
  end component;
  
  component comparador is
    port (opa : in std_logic_vector(7 downto 0);   -- Operador A
          opb : in std_logic_vector(7 downto 0);   -- Operador B
	  G   : out std_logic);         
  end component;

  signal ntic   : std_logic_vector (10 downto 0); -- Numero de tics de reloj
  signal ntic_ms: std_logic_vector (7 downto 0);  -- 8 bits menos peso de ntic 
  signal sg     : std_logic; -- Seal G

begin
  
  CONT1: contador   port map (clk=>pwm_clk, q=>ntic, reset=>pwm_reset);
  COMP1: comparador port map (opa=>ntic_ms, opb=>pwm_pos, G=>sg);
  
  -- Obtener los 8 bits menos significativos del contador
  ntic_ms<=ntic(7 downto 0);
  
  -- Seal PWM de salida
  pwm_o<= (not ntic(8)) and (not ntic(9)) and (not ntic(10)) 
           and (not sg);
    
end beh;


