------------------------------------------------------------
-- prescaler.vhd.  Juan Gonzalez. Feb-2002                --
-- Licencia GPL.                                          --
------------------------------------------------------------
-- PROYECTO LABOBOT                                       --
-----------------------------------------------------------------
-- Prescaler de 2 bits (Divide por 4)                          --
--                                                             --
-- Entradas: pres_clk   : Reloj                                --
--           pres_reset : Puesta a cero asncrona (Nivel Alto) --
-- Salidas:                                                    --
--           pres_q : Salida                                   --
-----------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity prescaler is
  port (pres_clk  : in std_logic;
        pres_reset: in std_logic;
        pres_q    : out std_logic);  
end prescaler;

architecture beh of prescaler is

begin
  output: process(pres_clk,pres_reset)
  variable cuenta : std_logic_vector(1 downto 0);
  begin
    -- Actualizar la cuenta
    if (pres_reset='1') then
      cuenta:=(others=>'0');
      pres_q<='0';
    elsif (pres_clk'event and pres_clk='1') then
      cuenta:=(cuenta+1);
      pres_q<=cuenta(1);
    end if;
  end process;
end beh;

