------------------------------------------------------------
-- contador.vhd.  Juan Gonzalez. Feb-2002                 --
-- Licencia GPL.                                          --
------------------------------------------------------------
-- PROYECTO LABOBOT                                       --
------------------------------------------------------------
-- Contador de 11 bits                                    --
--                                                        --
-- Entradas: clk   : Reloj                                --
--           reset : Puesta a cero asncrona (Nivel Alto) --
-- Salidas:                                               --
--      -q  : Datos de salida                             --
------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity contador is
  port (clk   : in std_logic; -- Reloj
	reset : in std_logic;
	q     : out std_logic_vector (10 downto 0)); --Salida         
end contador;

architecture beh of contador is

begin
  output: process(clk,reset)
  variable cuenta : std_logic_vector(10 downto 0);
  begin
    -- Actualizar la cuenta
    if (reset='1') then        -- Reset asncrono
      cuenta:=(others=>'0');   -- Inicializar contador
      q<=cuenta;
    elsif (clk'event and clk='1') then  -- Flanco de subida en reloj
      cuenta:=(cuenta+1);      -- Incrementar contador
      q<=cuenta;
    end if; 
  end process;
end beh;

