/****************************************************************************/
/* SERIE.H  (c) Microbotica, S.L. Enero 2000.                               */
/*------------------------------------------------------------------------- */
/* Definiciones y prototipos para el MODULO serie de la libreria CTS        */
/*--------------------------------------------------------------------------*/
/* web: www.microbotica.es                                                  */
/* mail: info@microbotica.es                                                */
/****************************************************************************/

#ifndef SERIE_H
#define SERIE_H

#define COM1 0
#define COM2 1

#ifndef BYTE
  #define BYTE
  typedef unsigned char byte;
#endif

/*-------------- PROTOTIPOS ------------------------ */

   int abrir_puerto_serie(int puerto);                                    
   int baudios(int vel);                                                  
   int vaciar_buffer_tx();                                                
   int vaciar_buffer_rx();                                                
   int enviar_bloque(char *cad, int tam);                                 
   int enviar_car(char car);                                              
   int enviar_break();                                                    
   int car_waiting();                                                     
   int wait_break(int plazo);                                             
   int bufftx_waiting();                                                  
   char leer_car();                                                       
   char leer_car_plazo(int plazo, int *timeout);                          
   int getdtr();                                                          
   int dtr_on();                                                          
   int dtr_off();                                                         
   int getserial_fd();                                                    
   char *getserial_error();                                               
   void cerrar_puerto_serie();                                            
   
/* --------------- DESCRIPCION DE LAS FUNCIONES DE INTERFAZ ------------ */

/*
   * int abrir_puerto_serie(int puerto); 
       Abrir el puerto serie. El parametro de entrada especifica el
      puerto a utilizar: COM1 o COM2. La funcion devuelve 0 en caso de
      producirse algun error.
      
   * int baudios(int vel);
      Cambiar la velocidad. Las velocidades que se pueden especificar son
     1200, 7680 y 9600 baudios. La funcion devuelve 0 en caso de error
     
   * int vaciar_buffer_tx(); ---> Vaciar el buffer de transmision
   * int vaciar_buffer_rx(); ---> Vaciar el buffer de recepcion
   * int enviar_bloque(char *cad, int tam);
      Enviar un bloque de datos por el puerto serie. El parametro tam indica
      la longitud del bloque a enviar.
   
   * enviar_car(char car); ---> Enviar un caracter.
   * enviar_break(); ---------> Enviar una seal de break;
   * car_waiting();  ---------> Devolver el numero de caracteres esperando
     en el buffer de recepcion
     
   * wait_break(int plazo); --> Esperar que se reciba una seal de BREAK 
     dentro del plazo establecido. El parametro plazo esta en microsegundos.
     La funcion devuelve 0 si ha transcurrido el plazo y no se ha recibido
     ninguna seal de BREAK;
     
   * bufftx_waiting(); ----> Devolver el numero de caracteres en el buffer
     de transmision pendientes de ser enviados.
     
   * char leer_car()(); ---> Leer un caracter del buffer de recepcion. La
     funcion se queda esperando hasta que haya algun caracter.
     
   * char leer_car_plazo(int plazo, int *timeout); ---> Leer un caracter del
     buffer de recepcion. Si no llega ningun caracter durante el plazo de
     tiempo especificado, el parametro timeout toma el valor 1.
     
   * int getdtr(); ----> Leer el estado del DTR. Se devuelve 0 en caso de
     error.
     
   * int dtr_on(); ---> Activar el DTR. Se devuelve 0 en caso de error.
   * int dtr_off(); --> Desactivar el DTR. Se devuelve 0 en caso de error.
   * int getserial_error(); --> Devolver el ultimo mensaje de error 
     producido.
     
   * void cerrar_puerto_serie() --> Dejar de utilizar el puerto serie.
   
*/
      
#endif  /* Del define SERIE_H */
   
                 


