**************************************************************
* Programa para el mdulo maestro                            *
**************************************************************
* Tiene dos funciones principales seleccionables por el SW3  *
* de la CT6811:                                              *
*                                                            *
* SW3 abajo: El programa hace que la tarjeta maestra enve   *
*         por el puerto SPI todo lo que recibe por el puerto *
*         serie.                                             *
*                                                            *
* SW3 arriba: El programa enva por la red las tramas nece-  *
*            sarias para hacer que el robot avance           *
*                                                            *
**************************************************************


* --- Puertos de entrada y salida

PORTA   EQU $0
PORTB   EQU $04
PORTC   EQU $03
DDRC    EQU $07

* --- Registros del SCI

BAUD	EQU $2B
SCCR1	EQU $2C
SCCR2	EQU $2D
SCSR	EQU $2E
SCDR	EQU $2F

* --- Registros del SPI

PORTD   EQU $08
DDRD	EQU $09
SPCR	EQU $28
SPDR	EQU $2A
SPSR	EQU $29
 

	ORG $F800  * Direccin de comienzo del programa

inicio	LDS   #$FF
	LDX   #$1000     * Para acceder a los registros de control


* ---- Configuracin del SCI ----

wait    BRCLR SCSR,X $40 wait  * espero a que se estabilice el SCI

	LDAA  #$30	 * Poner 22 para velocidad de 7812 baudios
	STAA  BAUD,X	 * Poner 30 para velocidad de 9600 baudios
	LDAA  #$0
	STAA  SCCR1,X	 * 8 bits de datos
	LDAA  #$0C       * No usar interrupciones del SCI
	STAA  SCCR2,X    * Activar receptor y transmisor

* ---- Configuracin del SPI (como maestro) ----

	LDAA  #$3C
	STAA  DDRD,X     * El SPI configura las salidas automticamente

* El maestro lo ponemos con colector cerrado.

	LDAA  #$50       * Colector cerrado
	STAA  SPCR,X     * Activa en modo maestro el SPI

* El puerto C tienen que ser de entrada
	CLRA
	STAA DDRC,X      * Puerto C de entrada	

*************************************
* Seleccin del programa a ejecutar *
*************************************	

seleccion
	LDAA PORTC,X     * Leo el puerto C
	ANDA #$01        * Mscara
	CMPA #$01        *  Switch 3 Arriba ?
	BEQ  prog_dos    * SI -> salta al programa 2
	JMP  prog_uno    * NO -> salta al programa 1
	

*******************************
* ------- PROGRAMA 1 -------  *
*******************************

prog_uno
	JSR  leer_car    * leo carcter por el puerto serie
	JSR  enviar_spi  * mando la orden a la BT6811
	BRA  prog_uno

	
*******************************
* ------ PROGRAMA 2 --------- *
*******************************

prog_dos
	JSR  esperar
	JSR  enable_c
	JSR  enable_a
	JSR  enable_b

secuencia
	LDY  #movi0
bucle   JSR  dar_paso
	JSR  esperar
	CPY  #fin_movi
	BNE  bucle
	BRA  secuencia
	
**********************************
* Subrutinas utilizadas por los  *
* bucles principales uno y dos   *
**********************************

*.................................
*. Rutina que recibe un caracter .
*. por el puerto serie           .
*.................................

leer_car
	BRCLR SCSR,X $20 leer_car
        LDAA  SCDR,X
        RTS

*.................................
*.  Rutina que envia un caracter .
*.  por el puerto serie          .
*.................................

enviar_car
	BRCLR SCSR,X $80 enviar_car
        STAA SCDR,X
        RTS


*.......................................
*. Rutina que enva un dato por el SPI .
*.......................................
*. Si se quiere pausa entre datos      .
*. enviados llamar a: enviar_spi_pausa .
*.                                     .
*. Si no se quiere pausa entre datos   .
*. envados llamar a: enviar_spi        .
*.......................................

enviar_spi_pausa
	PSHY                    * pausa entre datos
	LDY   #$18              * valor de 150 microseg
pausa   DEY
	CPY #$0
	BNE pausa
	PULY

enviar_spi
	LDAB  PORTD,X
	ANDB  #$DF
	STAB  PORTD,X            * Mandamos activarse al esclavo

	STAA  SPDR,X             * introduzco el dato a mandar
espera  BRCLR SPSR,X $80 espera  * transmisin efectuada? 

	LDAB  PORTD,X
	ORB   #$20
	STAB  PORTD,X            * Desactivamos al esclavo

	RTS
	
*.........................
*. Rutina de pausa       .
*.........................

esperar
	PSHY
	LDY  #$C400
sigue   DEY
	CPY  #$0
	BNE  sigue
	PULY
	RTS


*....................................
*. Rutinas para activar los mdulos .
*....................................
enable_c
	LDAA #'c'
	BRA  fin_enable
enable_b
	LDAA #'b'
	BRA  fin_enable
enable_a
  	LDAA #'a'
fin_enable
	JSR  enviar_spi_pausa
	LDAA #'e'
	JSR  enviar_spi_pausa
	LDAA #$0F
	JSR  enviar_spi_pausa
	JSR  enviar_spi_pausa	
	RTS


*.................................
*.  Rutina que enva un paso de  .
*.  la secuencia                 .
*.................................

dar_paso
	LDAA #'a'             * a1
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$01
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY

	LDAA #'a'             * a2
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$02
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY

	LDAA #'a'             * a3
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$03
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY

	LDAA #'a'             * a4
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$04
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY
	
	LDAA #'b'             * b1
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$01
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY
	
	LDAA #'b'             * b2
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$02
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY
	
	LDAA #'b'             * b3
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$03
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY
	
	LDAA #'b'             * b4
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$04
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY
	
	LDAA #'c'             * c1
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$01
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY
	
	LDAA #'c'             * c2
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$02
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY
	
	LDAA #'c'             * c3
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$03
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY
	
	LDAA #'c'             * c4
	JSR  enviar_spi_pausa
	LDAA #'p'
	JSR  enviar_spi_pausa
	LDAA #$04
	JSR  enviar_spi_pausa
	LDAA $0,Y
	JSR  enviar_spi_pausa
        INY
        INY
        RTS


*****************************************************
*           SECUENCIAS DE MOVIMIENTOS               *
*****************************************************
* A1,A2,A3,A4,B1,B2,B3,B4,C1,C2,C3,C4,ojo1,ojo2,ret *
*****************************************************

*.......................
*. RECTO               .
*.......................

movi0   FCB 193,151, 94,151, 23,103,126, 76,211,108,103, 37,$0 ,$0 ,3
movi1   FCB 193,126, 53,151, 23,103,126, 76,211, 99,147, 37,$0 ,$0 ,3
movi2   FCB 193,126, 53,179, 23, 87,106,103,211, 99,147, 37,$0 ,$0 ,3
movi3   FCB 193,131, 65,209, 23,131, 78,103,211, 83,131, 37,$0 ,$0 ,3
movi4   FCB 193,154,103,209, 23,158,170,103,211,119, 88, 37,$0 ,$0 ,3
movi5   FCB 193,190,140, 92, 23,163,197, 28,211,138, 60, 37,$0 ,$0 ,3
movi6   FCB 193,151, 94,151, 23,103,126, 76,211,108,103, 37,$0 ,$0 ,3
fin_movi FCB $0



*********************************
* Vectores de interrupcin      *
*********************************

	ORG $FFFE
v_reset FDB #inicio

	END	
	
