/* 
	Programa de ejemplo utilizacin del TIMER 1
	Hace parpadear el LED cada segundo.
	Utiliza el bit de overflow pero sin interrupciones

	Autor: Andrs Prieto-Moreno Torres
*/

#include <p18f452.h>
#include <timers.h>


void main(void) {
	int result;
	
	TRISB=0;
	PORTB=0x01;
	
	OpenTimer1( TIMER_INT_OFF &
				T1_16BIT_RW   &
				T1_SOURCE_EXT &
				T1_PS_1_1     &
				T1_OSC1EN_ON  &
				T1_SYNC_EXT_ON );
	
	/*
		segunda forma ->  usamos el bit de overflow
		usamos el reloj de 32,768 Khz
		configuramos el pre-escaler a 1:1

		En un segundo cuento 32768 pulsos, que en hexadecimal
		es 0x8000. Como quiero que el LED parpadee cada segundo
		divido por dos el cambio de estado.
		Es decir he de contar hasta 0x4000 
		El bit de overflow se activa cuando pasamos de 0xFFFF a 0x0000
		por lo tanto tengo que cargar el valor:
		
			0xFFFF - 0x3FFF = 0xC000
	*/
	
	while (1) {
		WriteTimer1(0xC000);
		while ( !PIR1bits.TMR1IF );  // espero al flag de overflow
		PORTB = PORTB ^ 0x01;
		PIR1bits.TMR1IF=0;  // borro el flag de interrupcin
	}
	CloseTimer1();
}
