/* 
	Programa de ejemplo utilizacin del TIMER 1
	Hace parpadear el LED cada segundo.
	Utiliza el timer de una forma sencilla, sin interrupciones y sin overflow

	Autor: Andrs Prieto-Moreno Torres
*/

#include <p18f452.h>
#include <timers.h>


void main(void) {
	int result;
	
	TRISB=0;
	PORTB=0x01;
	
	OpenTimer1( TIMER_INT_OFF &
				T1_16BIT_RW   &
				T1_SOURCE_EXT &
				T1_PS_1_1     &
				T1_OSC1EN_ON  &
				T1_SYNC_EXT_ON );

	// primera forma -> sin usar overflow
	// usamos el reloj de 32,768 Khz
	// configuramos el pre-escaler a 1:1

	// En un segundo cuento 32768 pulsos, que en hexadecimal
	// es 0x8000. Como quiero que el LED parpadee cada segundo
	// divido por dos el cambio de estado.
	// Es decir he de contar hasta 0x4000.

	while (1) {
		result=ReadTimer1();	
		if (result >= 0x4000 ) {
			WriteTimer1(0);
			PORTB = PORTB ^ 0x01;
		}
	}
	CloseTimer1();
}

	
