/* 
Programa ejemplo de utilizacin del conversor
Mostramos los 4 bits ms significativos de la conversin en los leds

Empresa: Ifara Tecnologas S.L.
Autor  : Andrs Prieto-Moreno Torres
*/

#include <p18f452.h>
#include <adc.h>

void main(void) {
	unsigned int dato;

	// Puerto B de salida
	TRISB = 0x0;

	// configuramos el conversor
	OpenADC(ADC_FOSC_32 & ADC_LEFT_JUST & ADC_1ANA_0REF,
			ADC_CH0 & ADC_INT_OFF);
		
	while (1) {
		ConvertADC();
		// esperamos a que termine la conversin en curso
		while ( BusyADC() );
		// activamos los LEDS
		dato=ReadADC();
		dato=dato>>12;  // paso de 16 bits a los 4 que me interesa 
		PORTB= (unsigned char) dato;   // el puerto es de 8 bits
	}
}
