/*
	Ejemplo 2: 	Mostramos datos en los LEDS
	Autor: Andrs Prieto-Moreno
	Fecha: 3-jun-2003

	En la memoria de programa hay una tabla de datos que vamos a mostrar
	por los LEDS conectados al Puerto B. 

	Problema a resolver: Tenemos que leer datos de la memoria de programa y
	moverlos a la RAM para poder trabajar con ellos de forma normal. Hay que
	utilizar la funcin STRCPYPGM2RAM
*/


#include <string.h>   /* 'strcpypgm2ram'     */
#include <stdlib.h>   /* 'atoi'              */
#include <delays.h>   /* 'Delay10KTCYx'      */
#include <p18f452.h>  /* 'PORTB' and 'TRISB' */


/* 
	MPLAB C18 coloca en la memoria de programa la siguiente cadena 
	Para ello es necesario poner el indicador ROM, en otro caso se 
	coloca en RAM

	CONST no hace falta ya que los datos estn en memoria de programa y 
	por lo tanto no se pueden cambiar.
*/


#define STRING_TABLE_SIZE 8

const rom char *string_table[STRING_TABLE_SIZE] =
{ "0", "1", "3", "7", 
  "15", "14", "12", "8"
};

void main (void)
{
   int index;
   int integer;
   int string[3];
   
   PORTB = 0;
   TRISB = 0;   /* configure all PORTB pins for output */
   
   for (index = 0; index < STRING_TABLE_SIZE; index++) 
   {
      /* copiamos la cadena de la memoria de programa a la de datos */
      strcpypgm2ram (string, string_table[index]);

      /* convertimos el caracter ASCII a entero */
      integer = atoi (string);
      
	  /* mostramos el valor leido en el puerto B */
      PORTB = integer;      

	  /* 
	     Realizamos una pausa de " valor * 10000 ciclos 
	  */
      Delay10KTCYx (10);   
   }
}
