/*
Programa 3 : Efecto ptico y zumbador
Ejemplo de programa que hace un efecto luminoso con los LEDS a la
vez que hace sonar el zumbador al apretar el pulsador.

Zumbador -> RC2
LED      -> RB3:RB0
Pulsador -> RA4

Autor: Andrs Prieto-Moreno
*/

#include <p18f452.h>

#define DELAY 50


void sonido() {
	int i,j;

	/* sin optimizar */
/*
	for (i=0; i<=50; i++) {
		PORTC = 0x0;
		for ( j=0; j<=DELAY; j++) {}
		PORTC = 0xFF;
		for ( j=0; j<=DELAY; j++) {}
	}
*/
	/* optimizacin  */
	for (i=0; i<=100; i++) {   
		PORTC = PORTC ^ 0x04;
		for ( j=0; j<=DELAY; j++) {}
	}
	
}


void main(void) {

	// configuramos los puertos
	TRISB = 0;    // puerto B configurado como salida
	TRISA = 0xFF; // puerto A configurado como entrada
	TRISC = 0;    // puerto C configurado como salida

	// valor inicial puertos
	PORTA=0;
	PORTB=0;
	
	// bucle principal
	
	while (1) {  // comentar lo del bucle infinito
		if ( PORTA != 0x10 ) {
			PORTB = ( PORTB + 1 ) % 16; 
			sonido();  // comentar el tema del zumbador
		}
	}
}
