/*****************************************************************************/
/* skybot.h         Junio-2010                                               */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/* Definiciones y funciones para trabajar con el robot Skybot                */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Javier Valiente <jvaliente@ifara.com>                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/
#ifndef SKYBOT_H
#define SKYBOT_H

//-- Definiciones para los motores. Estos valores define
//-- los movimientos del robot
#define   AVANZA     0x1C  //-- Binario: 0001 1100
#define   ATRAS      0x16  //-- Binario: 0001 0110
#define   IZQUIERDA  0x1E  //-- Binario: 0001 1110
#define   DERECHA    0x14  //-- Binario: 0001 0100
#define   STOP       0x00  //-- Binario: 0000 0000

//-- Controlaremos el Skybot usando la constante SKYBOT
#define SKYBOT PORTB

//-- Valor para configurar el puerto B para trabajar con el Skybot:
//-- Bits RB0, RB5, RB6 y RB7 como entradas (sensores)
//-- Bits RB1, RB2, RB3 y RB4 como salidas
#define CONF_SKYBOT 0xE1  //-- Binario: 1110 0001

//-- Colocacion de los sensores
#define   SENSOR1  RB0
#define   SENSOR2  RB5
#define   SENSOR3  RB6
#define   SENSOR4  RB7

//-- Situacion de los bumpers
#define BUMPER1 RA1
#define BUMPER2 RA2

//-- Estado del pulsador
#define PULSADO    0
#define NO_PULSADO 1

//-- Colores leidos por los sensores
#define NEGRO  1
#define BLANCO 0

//-- Pulsador y led de la Skypic
#define PULSADOR RB0
#define LED      RB1

//-- Estados para el led y los bumpers
#define ON  1
#define OFF 0


void configurar_skybot()
{
  TRISB=CONF_SKYBOT;

  //-- Configuracion del conversor analogico digital
  //-- Configurar RA0 como entrada analogica. El resto del puerto A
  //-- como digital
  ADCON1 = 0x0E;

  //-- Configurar puerto A como entrada
  TRISA = 0xFF;

  //-- configurar el conversor analogico-digital para leer el sensor de luz
    //-- Leer los 8 bits mas significativos por ADRESH
    ADFM = 0;  
  
    //-- Seleccionar el canal analogico (RA0)
    ADCON0 = 0x00;

    //-- Encender conversor
    ADON=1;
}

#endif  //-- SKYBOT_H
