/*****************************************************************************/
/* sensores.c      Junio-2005                                                */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/*  Se lee el estado de los 4 sensores y se envia por el puerto A. Si se     */
/*  conectan 4 leds a los bits RA0, RA1, RA2 y RA3 se veran respectivamente  */
/*  los sensores 1, 2 , 3 y 4                                                */
/*  Este programa es muy util para comprobar el correcto funcionamiento      */
/*  de todos los sensores, pero es necesario la conexion de leds externos.   */
/*  Este ejemplo funciona perfectamente con la placa FREELEDS, que tiene 8   */
/*  leds                                                                     */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Modificado por: Javier Valiente <jvaliente@ifara.com>                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Colocacion de los sensores
#define   SENSOR1  RB0
#define   SENSOR2  RB5
#define   SENSOR3  RB6
#define   SENSOR4  RB7

//-- Valor para configurar el puerto B para trabajar con el Skybot:
//-- Bits RB0, RB5, RB6 y RB7 como entradas (sensores)
//-- Bits RB1, RB2, RB3 y RB4 como salidas
#define CONF_SKYBOT 0xE1  //-- Binario: 1110 0001

//-- Pin del led de la Skypic
#define LED       RB1


//----------------------------
//- Comienzo del programa  
//----------------------------

void main(void)
{
  //-- Configurar puerto A para salida
  TRISA=0;
    
  //-- Configurar puerto A como puerto Digital
  ADCON1=0x06;

  //-- configurar Skybot
  TRISB=CONF_SKYBOT;

  //-- Apagar todos los leds
  PORTA=0;
    
 //-- Bucle principal
  while(1) {
    RA0 = SENSOR1;
    RA1 = SENSOR2;
    RA2 = SENSOR3;
    RA3 = SENSOR4;
  }
}







