/*****************************************************************************/
/* sensor4.c      Junio-2005                                                 */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/* Prueba del sensor 4. Cuando este sensor lee negro se enciende el led y    */
/* lo apaga en caso contrario. Es muy util para comprobar si los sensores    */
/* se han construido correctamente                                           */
/*---------------------------------------------------------------------------*/
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Modificado por: Javier Valiente <jvaliente@ifara.com>                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Colocacion de los sensores
#define   SENSOR1  RB0
#define   SENSOR2  RB5
#define   SENSOR3  RB6
#define   SENSOR4  RB7

//-- Valor para configurar el puerto B para trabajar con el Skybot:
//-- Bits RB0, RB5, RB6 y RB7 como entradas (sensores)
//-- Bits RB1, RB2, RB3 y RB4 como salidas
#define CONF_SKYBOT 0xE1  //-- Binario: 1110 0001

//-- Pin del led de la Skypic
#define LED       RB1

//-- Indicar el sensor a comprobar: Sensor1,2,3 o 4 
#define   SENSOR SENSOR4

#define SALIDA  0

//----------------------------
//- Comienzo del programa  
//----------------------------
unsigned char sensor;
void main(void)
{
  //-- configurar Skybot
  TRISB=CONF_SKYBOT;

  //-- Bucle principal
  while(1) {
    LED = SENSOR;
  }
}



