/*****************************************************************************/
/* secuencia.c      Julio-2005                                               */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/*  Ejemplo de una secuencia pregrabada. El robot ejecuta movimientos        */
/*  con unas determinadas duraciones.                                        */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Javier Valiente <jvaliente@ifara.com>                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Usar las rutinas de pausa del temporizador 0
#include "timer0-delay.h"

//-- Definiciones para los motores. Estos valores define
//-- los movimientos del robot
#define   AVANZA     0x1C  //-- Binario: 0001 1100
#define   ATRAS      0x16  //-- Binario: 0001 0110
#define   IZQUIERDA  0x1E  //-- Binario: 0001 1110
#define   DERECHA    0x14  //-- Binario: 0001 0100
#define   STOP       0x00  //-- Binario: 0000 0000

//-- Controlaremos el Skybot usando la constante SKYBOT
#define SKYBOT PORTB

//-- Valor para configurar el puerto B para trabajar con el Skybot:
//-- Bits RB0, RB5, RB6 y RB7 como entradas (sensores)
//-- Bits RB1, RB2, RB3 y RB4 como salidas
#define CONF_SKYBOT 0xE1  //-- Binario: 1110 0001

//----------------------------
//- Comienzo del programa  
//----------------------------

void main(void)
{
  //-- configurar Skybot
  TRISB=CONF_SKYBOT;

  //-- Configurar el temporizador 0
  timer0_configurar();

  //-- Comienzo de la secuencia
  SKYBOT=AVANZA;
  timer0_delay(100);
  SKYBOT=DERECHA;
  timer0_delay(130);
  SKYBOT=AVANZA;
  timer0_delay(100);
  SKYBOT=DERECHA;
  timer0_delay(40);
  SKYBOT=AVANZA;
  timer0_delay(100);
  SKYBOT=IZQUIERDA;
  timer0_delay(200);
   
  //-- Fin
  SKYBOT=STOP;

  //-- Bucle infinito
  while(1);
}

