/*****************************************************************************/
/* sci-skybot-test.c      Junio-2010                                         */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/* Mover el robot desde un terminal serie. Utilizar las teclas o,p,q y a     */
/* en minusculas. Configurarlo a 9600 baudios, 8,n,1                         */
/*---------------------------------------------------------------------------*/
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Javier Valiente <jvaliente@ifara.com>                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Se usa la libreria de comunicaciones serie
#include "sci.h"

//-- Utilizar las constantes definidas para el Skybot
#include "skybot.h"


/******************************/
/* Sacar el menu de opciones  */
/******************************/
void menu(void)
{
  sci_cad("Menu\n\r");
  sci_cad("----\n\r");
  sci_cad("Teclas q,a,o,p,ESPACIO.- Mover Skybot\n\r");
  sci_cad("Teclas 1,2,3,4.- Leer sensores 3,4 y bumpers\n\r");
}

/*********************************/
/* Programa principal            */
/*********************************/
void main(void)
{
  unsigned char c;
    
  //-- configurar Skybot
  configurar_skybot();

  //-- Configurar las comunicaciones serie
  sci_conf();
  
  //-- Parar los motores del robot
  SKYBOT=STOP;

  //-- Sacar el menu
  menu();
  
  //-- Bucle principal
  while(1) {
    //-- Esperar a que llegue opcion del usuario
    c=sci_read();

    //-- Segun la tecla recibida...
    switch(c) {
      case 'q':       //-- Adelante
        SKYBOT=AVANZA;
        break;
      case 'a':
        SKYBOT=ATRAS;  //-- Atras
        break;
      case 'o':
        SKYBOT=IZQUIERDA; //-- Izquierda
        break;
      case 'p':
        SKYBOT=DERECHA;   //-- Derecha
        break;
      case ' ':         //-- stop
        SKYBOT=STOP;
        break;
      case '1': //-- Leer sensor 3
        sci_write(SENSOR3 + '0');
        sci_write(' ');
        break;
      case '2': //-- Leer sensor 4
        sci_write(SENSOR4 + '0');
        sci_write(' ');
        break;
      case '3': //-- Leer Bumper 1
        sci_write(BUMPER1 + '0');
        sci_write(' ');
        break;
      case '4': //-- Leer Bumper 2
        sci_write(BUMPER2 + '0');
        sci_write(' ');
        break;
    }
  }
}

